/*
 * Decompiled with CFR 0.152.
 */
package com.fasten.permission;

import android.app.Activity;
import android.content.Context;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.ContextCompat;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class PermissionUtils {
    public static final int DEFAULT_REQUEST_CODE = 1603324;

    public static boolean hasPermission(Context context, String ... permissions) {
        for (String permission : permissions) {
            if (PermissionUtils.hasSelfPermission(context, permission)) continue;
            return false;
        }
        return true;
    }

    private static boolean hasSelfPermission(Context context, String permission) {
        try {
            return ContextCompat.checkSelfPermission((Context)context, (String)permission) == 0;
        }
        catch (RuntimeException t) {
            return false;
        }
    }

    public static boolean verifyPermission(Context context, int ... gantedResults) {
        if (gantedResults == null || gantedResults.length == 0) {
            return false;
        }
        for (int granted : gantedResults) {
            if (granted == 0) continue;
            return false;
        }
        return true;
    }

    public static boolean shouldShowRequestPermissionRationale(Activity activity, String ... permissions) {
        for (String permission : permissions) {
            if (!ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity, (String)permission)) continue;
            return true;
        }
        return false;
    }

    public static void invokeAnnotationMethod(Object object, Class annotationClass) {
        Class<?> clz = object.getClass();
        Method[] methods = clz.getDeclaredMethods();
        if (methods == null) {
            return;
        }
        for (Method method : methods) {
            boolean isHasAnnotation = method.isAnnotationPresent(annotationClass);
            if (!isHasAnnotation) continue;
            method.setAccessible(true);
            try {
                method.invoke(object, new Object[0]);
                object = null;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }
}

