/*
 * Decompiled with CFR 0.152.
 */
package com.fanap.podasync;

import com.fanap.podasync.AsyncListener;
import java.util.ArrayList;
import java.util.List;

class AsyncListenerManager {
    private final List<AsyncListener> mListeners = new ArrayList<AsyncListener>();
    private boolean mSyncNeeded = true;
    private List<AsyncListener> mCopiedListeners;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(AsyncListener listener, boolean log) {
        if (listener == null) {
            return;
        }
        List<AsyncListener> list = this.mListeners;
        synchronized (list) {
            this.mListeners.add(listener);
            this.mSyncNeeded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListeners(List<AsyncListener> listeners) {
        if (listeners == null) {
            return;
        }
        List<AsyncListener> list = this.mListeners;
        synchronized (list) {
            for (AsyncListener listener : listeners) {
                if (listener == null) continue;
                this.mListeners.add(listener);
                this.mSyncNeeded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(AsyncListener listener) {
        if (listener == null) {
            return;
        }
        List<AsyncListener> list = this.mListeners;
        synchronized (list) {
            if (this.mListeners.remove(listener)) {
                this.mSyncNeeded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListeners(List<AsyncListener> listeners) {
        if (listeners == null) {
            return;
        }
        List<AsyncListener> list = this.mListeners;
        synchronized (list) {
            for (AsyncListener listener : listeners) {
                if (listener == null || !this.mListeners.remove(listener)) continue;
                this.mSyncNeeded = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearListeners() {
        List<AsyncListener> list = this.mListeners;
        synchronized (list) {
            if (this.mListeners.size() == 0) {
                return;
            }
            this.mListeners.clear();
            this.mSyncNeeded = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AsyncListener> getSynchronizedListeners() {
        List<AsyncListener> list = this.mListeners;
        synchronized (list) {
            if (!this.mSyncNeeded) {
                return this.mCopiedListeners;
            }
            ArrayList<AsyncListener> copiedListeners = new ArrayList<AsyncListener>(this.mListeners.size());
            for (AsyncListener listener : this.mListeners) {
                copiedListeners.add(listener);
            }
            this.mCopiedListeners = copiedListeners;
            this.mSyncNeeded = false;
            return copiedListeners;
        }
    }

    public void callOnTextMessage(String message) {
        for (AsyncListener listener : this.getSynchronizedListeners()) {
            try {
                listener.onReceivedMessage(message);
            }
            catch (Throwable t) {
                this.callHandleCallbackError(listener, t);
            }
        }
    }

    private void callHandleCallbackError(AsyncListener listener, Throwable cause) {
        try {
            listener.handleCallbackError(cause);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void callOnStateChanged(String message) {
        for (AsyncListener listener : this.getSynchronizedListeners()) {
            try {
                listener.onStateChanged(message);
            }
            catch (Throwable throwable) {
                this.callHandleCallbackError(listener, throwable);
            }
        }
    }

    public void callOnDisconnected(String message) {
        for (AsyncListener listener : this.getSynchronizedListeners()) {
            try {
                listener.onDisconnected(message);
            }
            catch (Throwable throwable) {
                this.callHandleCallbackError(listener, throwable);
            }
        }
    }

    public void callOnError(String message) {
        for (AsyncListener listener : this.getSynchronizedListeners()) {
            try {
                listener.onError(message);
            }
            catch (Throwable throwable) {
                this.callHandleCallbackError(listener, throwable);
            }
        }
    }
}

