/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.metadata.ThriftInjection;
import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftFieldInjection
implements ThriftInjection {
    private final short id;
    private final String name;
    private final Field field;

    public ThriftFieldInjection(short id, String name, Field field) {
        Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"fieldId is negative");
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkNotNull((Object)field, (Object)"field is null");
        this.id = id;
        this.name = name;
        this.field = field;
    }

    @Override
    public short getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Field getField() {
        return this.field;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ThriftFieldInjection");
        sb.append("{fieldId=").append(this.id);
        sb.append(", name=").append(this.name);
        sb.append(", field=").append(this.field.getDeclaringClass().getSimpleName()).append(".").append(this.field.getName());
        sb.append('}');
        return sb.toString();
    }
}

