/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.reflection;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.codec.internal.TProtocolReader;
import com.facebook.swift.codec.internal.TProtocolWriter;
import com.facebook.swift.codec.metadata.ThriftConstructorInjection;
import com.facebook.swift.codec.metadata.ThriftExtraction;
import com.facebook.swift.codec.metadata.ThriftFieldExtractor;
import com.facebook.swift.codec.metadata.ThriftFieldInjection;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftInjection;
import com.facebook.swift.codec.metadata.ThriftMethodExtractor;
import com.facebook.swift.codec.metadata.ThriftMethodInjection;
import com.facebook.swift.codec.metadata.ThriftParameterInjection;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftType;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSortedMap;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedMap;
import javax.annotation.concurrent.Immutable;
import org.apache.thrift.protocol.TProtocol;

@Immutable
public class ReflectionThriftCodec<T>
implements ThriftCodec<T> {
    private final ThriftStructMetadata<T> metadata;
    private final SortedMap<Short, ThriftCodec<?>> fields;

    public ReflectionThriftCodec(ThriftCodecManager manager, ThriftStructMetadata<T> metadata) {
        this.metadata = metadata;
        ImmutableSortedMap.Builder fields = ImmutableSortedMap.naturalOrder();
        for (ThriftFieldMetadata fieldMetadata : metadata.getFields()) {
            fields.put((Object)fieldMetadata.getId(), manager.getCodec(fieldMetadata.getType()));
        }
        this.fields = fields.build();
    }

    @Override
    public ThriftType getType() {
        return ThriftType.struct(this.metadata);
    }

    @Override
    public T read(TProtocol protocol) throws Exception {
        TProtocolReader reader = new TProtocolReader(protocol);
        reader.readStructBegin();
        HashMap<Short, Object> data = new HashMap<Short, Object>(this.metadata.getFields().size());
        while (reader.nextField()) {
            short fieldId = reader.getFieldId();
            ThriftCodec codec = (ThriftCodec)this.fields.get(fieldId);
            if (codec == null) {
                reader.skipFieldData();
                continue;
            }
            ThriftFieldMetadata field = this.metadata.getField(fieldId);
            if (field.isWriteOnly()) {
                reader.skipFieldData();
                continue;
            }
            Object value = reader.readField(codec);
            if (value == null) continue;
            data.put(fieldId, value);
        }
        reader.readStructEnd();
        return this.constructStruct(data);
    }

    @Override
    public void write(T instance, TProtocol protocol) throws Exception {
        TProtocolWriter writer = new TProtocolWriter(protocol);
        writer.writeStructBegin(this.metadata.getStructName());
        for (ThriftFieldMetadata fieldMetadata : this.metadata.getFields()) {
            Object fieldValue;
            if (fieldMetadata.isReadOnly() || (fieldValue = this.getFieldValue(instance, fieldMetadata)) == null) continue;
            ThriftCodec codec = (ThriftCodec)this.fields.get(fieldMetadata.getId());
            writer.writeField(fieldMetadata.getName(), fieldMetadata.getId(), codec, fieldValue);
        }
        writer.writeStructEnd();
    }

    private T constructStruct(Map<Short, Object> data) throws Exception {
        Object instance;
        Object value;
        ThriftConstructorInjection constructor = this.metadata.getConstructor();
        Object[] parametersValues = new Object[constructor.getParameters().size()];
        for (ThriftParameterInjection parameter : constructor.getParameters()) {
            parametersValues[parameter.getParameterIndex()] = value = data.get(parameter.getId());
        }
        try {
            instance = constructor.getConstructor().newInstance(parametersValues);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                Throwables.propagateIfInstanceOf((Throwable)e.getTargetException(), Exception.class);
            }
            throw e;
        }
        for (ThriftFieldMetadata fieldMetadata : this.metadata.getFields()) {
            for (ThriftInjection injection : fieldMetadata.getInjections()) {
                ThriftFieldInjection fieldInjection;
                Object value2;
                if (!(injection instanceof ThriftFieldInjection) || (value2 = data.get((fieldInjection = (ThriftFieldInjection)injection).getId())) == null) continue;
                fieldInjection.getField().set(instance, value2);
            }
        }
        for (ThriftMethodInjection methodInjection : this.metadata.getMethodInjections()) {
            boolean shouldInvoke = false;
            Object[] parametersValues2 = new Object[methodInjection.getParameters().size()];
            for (ThriftParameterInjection parameter : methodInjection.getParameters()) {
                Object value3 = data.get(parameter.getId());
                if (value3 == null) continue;
                parametersValues2[parameter.getParameterIndex()] = value3;
                shouldInvoke = true;
            }
            if (!shouldInvoke) continue;
            try {
                methodInjection.getMethod().invoke(instance, parametersValues2);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    Throwables.propagateIfInstanceOf((Throwable)e.getTargetException(), Exception.class);
                }
                throw e;
            }
        }
        if (this.metadata.getBuilderMethod() != null) {
            ThriftMethodInjection builderMethod = this.metadata.getBuilderMethod();
            parametersValues = new Object[builderMethod.getParameters().size()];
            for (ThriftParameterInjection parameter : builderMethod.getParameters()) {
                parametersValues[parameter.getParameterIndex()] = value = data.get(parameter.getId());
            }
            try {
                instance = builderMethod.getMethod().invoke(instance, parametersValues);
                if (instance == null) {
                    throw new IllegalArgumentException("Builder method returned a null instance");
                }
                if (!this.metadata.getStructClass().isInstance(instance)) {
                    throw new IllegalArgumentException(String.format("Builder method returned instance of type %s, but an instance of %s is required", instance.getClass().getName(), this.metadata.getStructClass().getName()));
                }
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    Throwables.propagateIfInstanceOf((Throwable)e.getTargetException(), Exception.class);
                }
                throw e;
            }
        }
        return (T)instance;
    }

    private Object getFieldValue(Object instance, ThriftFieldMetadata field) throws Exception {
        try {
            Object value;
            ThriftExtraction extraction = field.getExtraction();
            if (extraction instanceof ThriftFieldExtractor) {
                ThriftFieldExtractor thriftFieldExtractor = (ThriftFieldExtractor)extraction;
                value = thriftFieldExtractor.getField().get(instance);
            } else if (extraction instanceof ThriftMethodExtractor) {
                ThriftMethodExtractor thriftMethodExtractor = (ThriftMethodExtractor)extraction;
                value = thriftMethodExtractor.getMethod().invoke(instance, new Object[0]);
            } else {
                throw new IllegalAccessException("Unsupported field extractor type " + extraction.getClass().getName());
            }
            return value;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                Throwables.propagateIfInstanceOf((Throwable)e.getTargetException(), Exception.class);
            }
            throw e;
        }
    }
}

