/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.compiler;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.codec.ThriftProtocolType;
import com.facebook.swift.codec.internal.TProtocolReader;
import com.facebook.swift.codec.internal.TProtocolWriter;
import com.facebook.swift.codec.internal.compiler.DynamicClassLoader;
import com.facebook.swift.codec.internal.compiler.byteCode.Access;
import com.facebook.swift.codec.internal.compiler.byteCode.CaseStatement;
import com.facebook.swift.codec.internal.compiler.byteCode.ClassDefinition;
import com.facebook.swift.codec.internal.compiler.byteCode.FieldDefinition;
import com.facebook.swift.codec.internal.compiler.byteCode.LocalVariableDefinition;
import com.facebook.swift.codec.internal.compiler.byteCode.MethodDefinition;
import com.facebook.swift.codec.internal.compiler.byteCode.NamedParameterDefinition;
import com.facebook.swift.codec.internal.compiler.byteCode.ParameterizedType;
import com.facebook.swift.codec.metadata.ThriftConstructorInjection;
import com.facebook.swift.codec.metadata.ThriftExtraction;
import com.facebook.swift.codec.metadata.ThriftFieldExtractor;
import com.facebook.swift.codec.metadata.ThriftFieldInjection;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftInjection;
import com.facebook.swift.codec.metadata.ThriftMethodExtractor;
import com.facebook.swift.codec.metadata.ThriftMethodInjection;
import com.facebook.swift.codec.metadata.ThriftParameterInjection;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftType;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.protocol.TProtocol;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.util.CheckClassAdapter;

@NotThreadSafe
public class ThriftCodecByteCodeGenerator<T> {
    private static final String PACKAGE = "$wift";
    private static final Map<ThriftProtocolType, Method> READ_METHODS;
    private static final Map<ThriftProtocolType, Method> WRITE_METHODS;
    private final ThriftCodecManager codecManager;
    private final ThriftStructMetadata<T> metadata;
    private final ParameterizedType structType;
    private final ParameterizedType codecType;
    private final ClassDefinition classDefinition;
    private final ConstructorParameters parameters = new ConstructorParameters();
    private final FieldDefinition typeField;
    private final Map<Short, FieldDefinition> codecFields;
    private final ThriftCodec<T> thriftCodec;

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public ThriftCodecByteCodeGenerator(ThriftCodecManager codecManager, ThriftStructMetadata<T> metadata, DynamicClassLoader classLoader, boolean debug) {
        this.codecManager = codecManager;
        this.metadata = metadata;
        this.structType = ParameterizedType.type(metadata.getStructClass());
        this.codecType = this.toCodecType(metadata);
        this.classDefinition = new ClassDefinition(Access.a(Access.PUBLIC, Access.SUPER), this.codecType.getClassName(), ParameterizedType.type(Object.class), ParameterizedType.type(ThriftCodec.class, this.structType));
        this.typeField = this.declareTypeField();
        this.codecFields = this.declareCodecFields();
        this.defineConstructor();
        this.defineGetTypeMethod();
        this.defineReadMethod();
        this.defineWriteMethod();
        this.defineReadBridgeMethod();
        this.defineWriteBridgeMethod();
        ClassWriter cw = new ClassWriter(2);
        this.classDefinition.getClassNode().accept((ClassVisitor)cw);
        byte[] byteCode = cw.toByteArray();
        if (debug) {
            ClassReader reader = new ClassReader(byteCode);
            CheckClassAdapter.verify((ClassReader)reader, (ClassLoader)classLoader, (boolean)true, (PrintWriter)new PrintWriter(System.out));
        }
        Class<?> codecClass = classLoader.defineClass(this.codecType.getClassName().replace('/', '.'), byteCode);
        try {
            Class<?>[] types = this.parameters.getTypes();
            Constructor<?> constructor = codecClass.getConstructor(types);
            this.thriftCodec = (ThriftCodec)constructor.newInstance(this.parameters.getValues());
        }
        catch (Exception e) {
            throw new IllegalStateException("Generated class is invalid", e);
        }
    }

    public ThriftCodec<T> getThriftCodec() {
        return this.thriftCodec;
    }

    private FieldDefinition declareTypeField() {
        FieldDefinition typeField = new FieldDefinition(Access.a(Access.PRIVATE, Access.FINAL), "type", ParameterizedType.type(ThriftType.class));
        this.classDefinition.addField(typeField);
        this.parameters.add(typeField, ThriftType.struct(this.metadata));
        return typeField;
    }

    private Map<Short, FieldDefinition> declareCodecFields() {
        TreeMap<Short, FieldDefinition> codecFields = new TreeMap<Short, FieldDefinition>();
        for (ThriftFieldMetadata fieldMetadata : this.metadata.getFields()) {
            if (!this.needsCodec(fieldMetadata)) continue;
            ThriftCodec<?> codec = this.codecManager.getCodec(fieldMetadata.getType());
            String fieldName = fieldMetadata.getName() + "Codec";
            FieldDefinition codecField = new FieldDefinition(Access.a(Access.PRIVATE, Access.FINAL), fieldName, ParameterizedType.type(codec.getClass()));
            this.classDefinition.addField(codecField);
            codecFields.put(fieldMetadata.getId(), codecField);
            this.parameters.add(codecField, codec);
        }
        return codecFields;
    }

    private void defineConstructor() {
        MethodDefinition constructor = new MethodDefinition(Access.a(Access.PUBLIC), "<init>", ParameterizedType.type(Void.TYPE), this.parameters.getParameters());
        constructor.loadThis().invokeConstructor(ParameterizedType.type(Object.class), new ParameterizedType[0]);
        for (FieldDefinition fieldDefinition : this.parameters.getFields()) {
            constructor.loadThis().loadVariable(fieldDefinition.getName()).putField(this.codecType, fieldDefinition);
        }
        constructor.ret();
        this.classDefinition.addMethod(constructor);
    }

    private void defineGetTypeMethod() {
        this.classDefinition.addMethod(new MethodDefinition(Access.a(Access.PUBLIC), "getType", ParameterizedType.type(ThriftType.class), new NamedParameterDefinition[0]).loadThis().getField(this.codecType, this.typeField).retObject());
    }

    private void defineReadMethod() {
        MethodDefinition read = new MethodDefinition(Access.a(Access.PUBLIC), "read", this.structType, NamedParameterDefinition.arg("protocol", TProtocol.class)).addException(Exception.class);
        read.addLocalVariable(ParameterizedType.type(TProtocolReader.class), "reader");
        read.newObject(TProtocolReader.class);
        read.dup();
        read.loadVariable("protocol");
        read.invokeConstructor(ParameterizedType.type(TProtocolReader.class), ParameterizedType.type(TProtocol.class));
        read.storeVariable("reader");
        Map<Short, LocalVariableDefinition> structData = this.readFieldValues(read);
        this.buildStruct(read, structData);
    }

    private Map<Short, LocalVariableDefinition> readFieldValues(MethodDefinition read) {
        LocalVariableDefinition protocol = read.getLocalVariable("reader");
        TreeMap<Short, LocalVariableDefinition> structData = new TreeMap<Short, LocalVariableDefinition>();
        for (ThriftFieldMetadata field : this.metadata.getFields()) {
            LocalVariableDefinition variable = read.addInitializedLocalVariable(ThriftCodecByteCodeGenerator.toParameterizedType(field.getType()), "f_" + field.getName());
            structData.put(field.getId(), variable);
        }
        read.loadVariable(protocol).invokeVirtual(TProtocolReader.class, "readStructBegin", Void.TYPE, new Class[0]);
        read.visitLabel("while-begin");
        read.loadVariable(protocol).invokeVirtual(TProtocolReader.class, "nextField", Boolean.TYPE, new Class[0]);
        read.ifZeroGoto("while-end");
        read.loadVariable(protocol).invokeVirtual(TProtocolReader.class, "getFieldId", Short.TYPE, new Class[0]);
        ArrayList<CaseStatement> cases = new ArrayList<CaseStatement>();
        for (ThriftFieldMetadata field : this.metadata.getFields()) {
            cases.add(CaseStatement.caseStatement(field.getId(), field.getName() + "-field"));
        }
        read.switchStatement("default", cases);
        for (ThriftFieldMetadata field : this.metadata.getFields()) {
            Method readMethod;
            read.visitLabel(field.getName() + "-field");
            read.loadVariable(protocol);
            FieldDefinition codecField = this.codecFields.get(field.getId());
            if (codecField != null) {
                read.loadThis().getField(this.codecType, codecField);
            }
            if ((readMethod = READ_METHODS.get((Object)field.getType().getProtocolType())) == null) {
                throw new IllegalArgumentException("Unsupported field type " + (Object)((Object)field.getType().getProtocolType()));
            }
            read.invokeVirtual(readMethod);
            if (ThriftCodecByteCodeGenerator.needsCastAfterRead(field, readMethod)) {
                read.checkCast(ThriftCodecByteCodeGenerator.toParameterizedType(field.getType()));
            }
            if (field.getCoercion() != null) {
                read.invokeStatic(field.getCoercion().getFromThrift());
            }
            read.storeVariable((LocalVariableDefinition)structData.get(field.getId()));
            read.gotoLabel("while-begin");
        }
        read.visitLabel("default").loadVariable(protocol).invokeVirtual(TProtocolReader.class, "skipFieldData", Void.TYPE, new Class[0]).gotoLabel("while-begin");
        read.visitLabel("while-end");
        read.loadVariable(protocol).invokeVirtual(TProtocolReader.class, "readStructEnd", Void.TYPE, new Class[0]);
        return structData;
    }

    private void buildStruct(MethodDefinition read, Map<Short, LocalVariableDefinition> structData) {
        LocalVariableDefinition instance = this.constructInstance(read, structData);
        this.injectFields(read, instance, structData);
        this.injectMethods(read, instance, structData);
        this.invokeFactoryMethod(read, structData, instance);
        read.loadVariable(instance).retObject();
        this.classDefinition.addMethod(read);
    }

    private LocalVariableDefinition constructInstance(MethodDefinition read, Map<Short, LocalVariableDefinition> structData) {
        LocalVariableDefinition instance = read.addLocalVariable(this.structType, "instance");
        if (this.metadata.getBuilderClass() == null) {
            read.newObject(this.structType).dup();
        } else {
            read.newObject(this.metadata.getBuilderClass()).dup();
        }
        ThriftConstructorInjection constructor = this.metadata.getConstructor();
        for (ThriftParameterInjection parameter : constructor.getParameters()) {
            read.loadVariable(structData.get(parameter.getId()));
        }
        read.invokeConstructor(constructor.getConstructor()).storeVariable(instance);
        return instance;
    }

    private void injectFields(MethodDefinition read, LocalVariableDefinition instance, Map<Short, LocalVariableDefinition> structData) {
        for (ThriftFieldMetadata field : this.metadata.getFields()) {
            for (ThriftInjection injection : field.getInjections()) {
                if (!(injection instanceof ThriftFieldInjection)) continue;
                ThriftFieldInjection fieldInjection = (ThriftFieldInjection)injection;
                if (!this.isProtocolTypeJavaPrimitive(field)) {
                    read.loadVariable(structData.get(field.getId())).ifNullGoto("field_is_null_" + field.getName());
                }
                read.loadVariable(instance).loadVariable(structData.get(field.getId())).putField(fieldInjection.getField());
                if (this.isProtocolTypeJavaPrimitive(field)) continue;
                read.visitLabel("field_is_null_" + field.getName());
            }
        }
    }

    private void injectMethods(MethodDefinition read, LocalVariableDefinition instance, Map<Short, LocalVariableDefinition> structData) {
        for (ThriftMethodInjection methodInjection : this.metadata.getMethodInjections()) {
            for (ThriftParameterInjection parameter : methodInjection.getParameters()) {
                if (!this.isParameterTypeJavaPrimitive(parameter)) {
                    read.loadVariable(structData.get(parameter.getId()));
                    read.ifNotNullGoto("invoke_" + methodInjection.getMethod().toGenericString());
                    continue;
                }
                read.gotoLabel("invoke_" + methodInjection.getMethod().toGenericString());
            }
            read.gotoLabel("skip_invoke_" + methodInjection.getMethod().toGenericString());
            read.visitLabel("invoke_" + methodInjection.getMethod().toGenericString());
            read.loadVariable(instance);
            for (ThriftParameterInjection parameter : methodInjection.getParameters()) {
                read.loadVariable(structData.get(parameter.getId()));
            }
            read.invokeVirtual(methodInjection.getMethod());
            if (methodInjection.getMethod().getReturnType() != Void.TYPE) {
                read.pop();
            }
            read.visitLabel("skip_invoke_" + methodInjection.getMethod().toGenericString());
        }
    }

    private void invokeFactoryMethod(MethodDefinition read, Map<Short, LocalVariableDefinition> structData, LocalVariableDefinition instance) {
        ThriftMethodInjection builderMethod = this.metadata.getBuilderMethod();
        if (builderMethod != null) {
            read.loadVariable(instance);
            for (ThriftParameterInjection parameter : builderMethod.getParameters()) {
                read.loadVariable(structData.get(parameter.getId()));
            }
            read.invokeVirtual(builderMethod.getMethod()).storeVariable(instance);
        }
    }

    private void defineWriteMethod() {
        MethodDefinition write = new MethodDefinition(Access.a(Access.PUBLIC), "write", null, NamedParameterDefinition.arg("struct", this.structType), NamedParameterDefinition.arg("protocol", TProtocol.class));
        this.classDefinition.addMethod(write);
        write.addLocalVariable(ParameterizedType.type(TProtocolWriter.class), "writer");
        write.newObject(TProtocolWriter.class);
        write.dup();
        write.loadVariable("protocol");
        write.invokeConstructor(ParameterizedType.type(TProtocolWriter.class), ParameterizedType.type(TProtocol.class));
        write.storeVariable("writer");
        LocalVariableDefinition protocol = write.getLocalVariable("writer");
        write.loadVariable(protocol).loadConstant(this.metadata.getStructName()).invokeVirtual(TProtocolWriter.class, "writeStructBegin", Void.TYPE, String.class);
        for (ThriftFieldMetadata field : this.metadata.getFields()) {
            Method writeMethod;
            write.loadVariable(protocol);
            write.loadConstant(field.getName());
            write.loadConstant(field.getId());
            FieldDefinition codecField = this.codecFields.get(field.getId());
            if (codecField != null) {
                write.loadThis().getField(this.codecType, codecField);
            }
            this.loadFieldValue(write, field);
            if (!this.isFieldTypeJavaPrimitive(field)) {
                write.dup();
                write.ifNullGoto("field_is_null_" + field.getName());
            }
            if (field.getCoercion() != null) {
                write.invokeStatic(field.getCoercion().getToThrift());
                if (!this.isProtocolTypeJavaPrimitive(field)) {
                    write.dup();
                    write.ifNullGoto("field_is_null_" + field.getName());
                }
            }
            if ((writeMethod = WRITE_METHODS.get((Object)field.getType().getProtocolType())) == null) {
                throw new IllegalArgumentException("Unsupported field type " + (Object)((Object)field.getType().getProtocolType()));
            }
            write.invokeVirtual(writeMethod);
            if (this.isProtocolTypeJavaPrimitive(field) && this.isFieldTypeJavaPrimitive(field)) continue;
            write.gotoLabel("field_end_" + field.getName());
            write.visitLabel("field_is_null_" + field.getName());
            write.pop();
            if (codecField != null) {
                write.pop();
            }
            write.pop();
            write.pop();
            write.pop();
            write.visitLabel("field_end_" + field.getName());
        }
        write.loadVariable(protocol).invokeVirtual(TProtocolWriter.class, "writeStructEnd", Void.TYPE, new Class[0]);
        write.ret();
    }

    private void loadFieldValue(MethodDefinition write, ThriftFieldMetadata field) {
        write.loadVariable("struct");
        ThriftExtraction extraction = field.getExtraction();
        if (extraction instanceof ThriftFieldExtractor) {
            ThriftFieldExtractor fieldExtractor = (ThriftFieldExtractor)extraction;
            write.getField(fieldExtractor.getField());
        } else if (extraction instanceof ThriftMethodExtractor) {
            ThriftMethodExtractor methodExtractor = (ThriftMethodExtractor)extraction;
            write.invokeVirtual(methodExtractor.getMethod());
        }
    }

    private void defineReadBridgeMethod() {
        this.classDefinition.addMethod(new MethodDefinition(Access.a(Access.PUBLIC, Access.BRIDGE, Access.SYNTHETIC), "read", ParameterizedType.type(Object.class), NamedParameterDefinition.arg("protocol", TProtocol.class)).addException(Exception.class).loadThis().loadVariable("protocol").invokeVirtual(this.codecType, "read", this.structType, ParameterizedType.type(TProtocol.class)).retObject());
    }

    private void defineWriteBridgeMethod() {
        this.classDefinition.addMethod(new MethodDefinition(Access.a(Access.PUBLIC, Access.BRIDGE, Access.SYNTHETIC), "write", null, NamedParameterDefinition.arg("struct", Object.class), NamedParameterDefinition.arg("protocol", TProtocol.class)).addException(Exception.class).loadThis().loadVariable("struct", this.structType).loadVariable("protocol").invokeVirtual(this.codecType, "write", ParameterizedType.type(Void.TYPE), this.structType, ParameterizedType.type(TProtocol.class)).ret());
    }

    private boolean isParameterTypeJavaPrimitive(ThriftParameterInjection parameter) {
        return this.isJavaPrimitive(TypeToken.of((Type)parameter.getJavaType()));
    }

    private boolean isFieldTypeJavaPrimitive(ThriftFieldMetadata field) {
        return this.isJavaPrimitive(TypeToken.of((Type)field.getType().getJavaType()));
    }

    private boolean isProtocolTypeJavaPrimitive(ThriftFieldMetadata field) {
        if (field.getType().isCoerced()) {
            return this.isJavaPrimitive(TypeToken.of((Type)field.getType().getUncoercedType().getJavaType()));
        }
        return this.isJavaPrimitive(TypeToken.of((Type)field.getType().getJavaType()));
    }

    private boolean isJavaPrimitive(TypeToken<?> typeToken) {
        return typeToken.getRawType().isPrimitive();
    }

    private static boolean needsCastAfterRead(ThriftFieldMetadata field, Method readMethod) {
        Class<?> methodReturn = readMethod.getReturnType();
        Class<?> fieldType = field.getCoercion() != null ? field.getCoercion().getFromThrift().getParameterTypes()[0] : TypeToken.of((Type)field.getType().getJavaType()).getRawType();
        boolean needsCast = !fieldType.isAssignableFrom(methodReturn);
        return needsCast;
    }

    private boolean needsCodec(ThriftFieldMetadata fieldMetadata) {
        ThriftProtocolType protocolType = fieldMetadata.getType().getProtocolType();
        return protocolType == ThriftProtocolType.ENUM || protocolType == ThriftProtocolType.STRUCT || protocolType == ThriftProtocolType.SET || protocolType == ThriftProtocolType.LIST || protocolType == ThriftProtocolType.MAP;
    }

    private ParameterizedType toCodecType(ThriftStructMetadata<?> metadata) {
        return ParameterizedType.type("$wift/" + ParameterizedType.type(metadata.getStructClass()).getClassName() + "Codec");
    }

    public static ParameterizedType toParameterizedType(ThriftType type) {
        switch (type.getProtocolType()) {
            case BOOL: 
            case BYTE: 
            case DOUBLE: 
            case I16: 
            case I32: 
            case I64: 
            case STRING: 
            case STRUCT: 
            case ENUM: {
                return ParameterizedType.type((Class)type.getJavaType());
            }
            case MAP: {
                return ParameterizedType.type(Map.class, ThriftCodecByteCodeGenerator.toParameterizedType(type.getKeyType()), ThriftCodecByteCodeGenerator.toParameterizedType(type.getValueType()));
            }
            case SET: {
                return ParameterizedType.type(Set.class, ThriftCodecByteCodeGenerator.toParameterizedType(type.getValueType()));
            }
            case LIST: {
                return ParameterizedType.type(List.class, ThriftCodecByteCodeGenerator.toParameterizedType(type.getValueType()));
            }
        }
        throw new IllegalArgumentException("Unsupported thrift field type " + type);
    }

    static {
        ImmutableMap.Builder writeBuilder = ImmutableMap.builder();
        ImmutableMap.Builder readBuilder = ImmutableMap.builder();
        try {
            writeBuilder.put((Object)ThriftProtocolType.BOOL, (Object)TProtocolWriter.class.getMethod("writeBoolField", String.class, Short.TYPE, Boolean.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.BYTE, (Object)TProtocolWriter.class.getMethod("writeByteField", String.class, Short.TYPE, Byte.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.DOUBLE, (Object)TProtocolWriter.class.getMethod("writeDoubleField", String.class, Short.TYPE, Double.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.I16, (Object)TProtocolWriter.class.getMethod("writeI16Field", String.class, Short.TYPE, Short.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.I32, (Object)TProtocolWriter.class.getMethod("writeI32Field", String.class, Short.TYPE, Integer.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.I64, (Object)TProtocolWriter.class.getMethod("writeI64Field", String.class, Short.TYPE, Long.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.STRING, (Object)TProtocolWriter.class.getMethod("writeBinaryField", String.class, Short.TYPE, ByteBuffer.class));
            writeBuilder.put((Object)ThriftProtocolType.STRUCT, (Object)TProtocolWriter.class.getMethod("writeStructField", String.class, Short.TYPE, ThriftCodec.class, Object.class));
            writeBuilder.put((Object)ThriftProtocolType.MAP, (Object)TProtocolWriter.class.getMethod("writeMapField", String.class, Short.TYPE, ThriftCodec.class, Map.class));
            writeBuilder.put((Object)ThriftProtocolType.SET, (Object)TProtocolWriter.class.getMethod("writeSetField", String.class, Short.TYPE, ThriftCodec.class, Set.class));
            writeBuilder.put((Object)ThriftProtocolType.LIST, (Object)TProtocolWriter.class.getMethod("writeListField", String.class, Short.TYPE, ThriftCodec.class, List.class));
            writeBuilder.put((Object)ThriftProtocolType.ENUM, (Object)TProtocolWriter.class.getMethod("writeEnumField", String.class, Short.TYPE, ThriftCodec.class, Enum.class));
            readBuilder.put((Object)ThriftProtocolType.BOOL, (Object)TProtocolReader.class.getMethod("readBoolField", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.BYTE, (Object)TProtocolReader.class.getMethod("readByteField", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.DOUBLE, (Object)TProtocolReader.class.getMethod("readDoubleField", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.I16, (Object)TProtocolReader.class.getMethod("readI16Field", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.I32, (Object)TProtocolReader.class.getMethod("readI32Field", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.I64, (Object)TProtocolReader.class.getMethod("readI64Field", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.STRING, (Object)TProtocolReader.class.getMethod("readBinaryField", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.STRUCT, (Object)TProtocolReader.class.getMethod("readStructField", ThriftCodec.class));
            readBuilder.put((Object)ThriftProtocolType.MAP, (Object)TProtocolReader.class.getMethod("readMapField", ThriftCodec.class));
            readBuilder.put((Object)ThriftProtocolType.SET, (Object)TProtocolReader.class.getMethod("readSetField", ThriftCodec.class));
            readBuilder.put((Object)ThriftProtocolType.LIST, (Object)TProtocolReader.class.getMethod("readListField", ThriftCodec.class));
            readBuilder.put((Object)ThriftProtocolType.ENUM, (Object)TProtocolReader.class.getMethod("readEnumField", ThriftCodec.class));
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
        WRITE_METHODS = writeBuilder.build();
        READ_METHODS = readBuilder.build();
    }

    private static class ConstructorParameters {
        private final List<FieldDefinition> fields = new ArrayList<FieldDefinition>();
        private final List<Object> values = new ArrayList<Object>();

        private ConstructorParameters() {
        }

        private void add(FieldDefinition field, Object value) {
            this.fields.add(field);
            this.values.add(value);
        }

        public List<FieldDefinition> getFields() {
            return this.fields;
        }

        public Object[] getValues() {
            return this.values.toArray(new Object[this.values.size()]);
        }

        public List<NamedParameterDefinition> getParameters() {
            return Lists.transform(this.fields, (Function)new Function<FieldDefinition, NamedParameterDefinition>(){

                public NamedParameterDefinition apply(FieldDefinition field) {
                    return NamedParameterDefinition.arg(field.getName(), field.getType());
                }
            });
        }

        public Class<?>[] getTypes() {
            List types = Lists.transform(this.values, (Function)new Function<Object, Class<?>>(){

                public Class<?> apply(Object value) {
                    return value.getClass();
                }
            });
            return types.toArray(new Class[types.size()]);
        }
    }
}

