/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.coercion;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.codec.metadata.TypeCoercion;
import javax.annotation.concurrent.Immutable;
import org.apache.thrift.protocol.TProtocol;

@Immutable
public class CoercionThriftCodec<T>
implements ThriftCodec<T> {
    private final ThriftCodec<Object> codec;
    private final TypeCoercion typeCoercion;
    private final ThriftType thriftType;

    public CoercionThriftCodec(ThriftCodec<?> codec, TypeCoercion typeCoercion) {
        this.codec = codec;
        this.typeCoercion = typeCoercion;
        this.thriftType = typeCoercion.getThriftType();
    }

    @Override
    public ThriftType getType() {
        return this.thriftType;
    }

    @Override
    public T read(TProtocol protocol) throws Exception {
        Object thriftValue = this.codec.read(protocol);
        Object javaValue = this.typeCoercion.getFromThrift().invoke(null, thriftValue);
        return (T)javaValue;
    }

    @Override
    public void write(T javaValue, TProtocol protocol) throws Exception {
        Object thriftValue = this.typeCoercion.getToThrift().invoke(null, javaValue);
        this.codec.write(thriftValue, protocol);
    }
}

