/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftStruct;
import com.facebook.swift.codec.internal.coercion.DefaultJavaCoercions;
import com.facebook.swift.codec.internal.coercion.FromThrift;
import com.facebook.swift.codec.internal.coercion.ToThrift;
import com.facebook.swift.codec.metadata.MetadataErrors;
import com.facebook.swift.codec.metadata.ReflectionHelper;
import com.facebook.swift.codec.metadata.ThriftEnumMetadata;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftStructMetadataBuilder;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.codec.metadata.TypeCoercion;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.ListenableFuture;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class ThriftCatalog {
    private final MetadataErrors.Monitor monitor;
    private final ConcurrentMap<Class<?>, ThriftStructMetadata<?>> structs = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, ThriftEnumMetadata<?>> enums = new ConcurrentHashMap();
    private final ConcurrentMap<Type, TypeCoercion> coercions = new ConcurrentHashMap<Type, TypeCoercion>();
    private final ConcurrentMap<Class<?>, ThriftType> manualTypes = new ConcurrentHashMap();
    private final ThreadLocal<Deque<Class<?>>> stack = new ThreadLocal<Deque<Class<?>>>(){

        @Override
        protected Deque<Class<?>> initialValue() {
            return new ArrayDeque();
        }
    };

    public ThriftCatalog() {
        this(MetadataErrors.NULL_MONITOR);
    }

    @VisibleForTesting
    public ThriftCatalog(MetadataErrors.Monitor monitor) {
        this.monitor = monitor;
        this.addDefaultCoercions(DefaultJavaCoercions.class);
    }

    @VisibleForTesting
    MetadataErrors.Monitor getMonitor() {
        return this.monitor;
    }

    public void addThriftType(ThriftType thriftType) {
        this.manualTypes.put(TypeToken.of((Type)thriftType.getJavaType()).getRawType(), thriftType);
    }

    public void addDefaultCoercions(Class<?> coercionsClass) {
        Preconditions.checkNotNull(coercionsClass, (Object)"coercionsClass is null");
        HashMap<ThriftType, Method> toThriftCoercions = new HashMap<ThriftType, Method>();
        HashMap<ThriftType, Method> fromThriftCoercions = new HashMap<ThriftType, Method>();
        for (Method method : coercionsClass.getDeclaredMethods()) {
            Method oldValue;
            ThriftType coercedType;
            ThriftType thriftType;
            if (method.isAnnotationPresent(ToThrift.class)) {
                this.verifyCoercionMethod(method);
                thriftType = this.getThriftType(method.getGenericReturnType());
                coercedType = thriftType.coerceTo(method.getGenericParameterTypes()[0]);
                oldValue = toThriftCoercions.put(coercedType, method);
                Preconditions.checkArgument((oldValue == null ? 1 : 0) != 0, (String)"Coercion class two @ToThrift methods (%s and %s) for type %s", (Object[])new Object[]{coercionsClass.getName(), method, oldValue, coercedType});
                continue;
            }
            if (!method.isAnnotationPresent(FromThrift.class)) continue;
            this.verifyCoercionMethod(method);
            thriftType = this.getThriftType(method.getGenericParameterTypes()[0]);
            coercedType = thriftType.coerceTo(method.getGenericReturnType());
            oldValue = fromThriftCoercions.put(coercedType, method);
            Preconditions.checkArgument((oldValue == null ? 1 : 0) != 0, (String)"Coercion class two @FromThrift methods (%s and %s) for type %s", (Object[])new Object[]{coercionsClass.getName(), method, oldValue, coercedType});
        }
        Sets.SetView difference = Sets.symmetricDifference(toThriftCoercions.keySet(), fromThriftCoercions.keySet());
        Preconditions.checkArgument((boolean)difference.isEmpty(), (String)"Coercion class %s does not have matched @ToThrift and @FromThrift methods for types %s", (Object[])new Object[]{coercionsClass.getName(), difference});
        HashMap<Type, TypeCoercion> coercions = new HashMap<Type, TypeCoercion>();
        for (Map.Entry entry : toThriftCoercions.entrySet()) {
            ThriftType type = (ThriftType)entry.getKey();
            Method toThriftMethod = (Method)entry.getValue();
            Method fromThriftMethod = (Method)fromThriftCoercions.get(type);
            Preconditions.checkState((fromThriftMethod != null ? 1 : 0) != 0, (String)"Coercion class %s does not have matched @ToThrift and @FromThrift methods for type %s", (Object[])new Object[]{coercionsClass.getName(), type});
            TypeCoercion coercion = new TypeCoercion(type, toThriftMethod, fromThriftMethod);
            coercions.put(type.getJavaType(), coercion);
        }
        this.coercions.putAll(coercions);
    }

    private void verifyCoercionMethod(Method method) {
        Preconditions.checkArgument((boolean)Modifier.isStatic(method.getModifiers()), (String)"Method %s is not static", (Object[])new Object[]{method.toGenericString()});
        Preconditions.checkArgument((method.getParameterTypes().length == 1 ? 1 : 0) != 0, (String)"Method %s must have exactly one parameter", (Object[])new Object[]{method.toGenericString()});
        Preconditions.checkArgument((method.getReturnType() != Void.TYPE ? 1 : 0) != 0, (String)"Method %s must have a return value", (Object[])new Object[]{method.toGenericString()});
    }

    public TypeCoercion getDefaultCoercion(Type type) {
        return (TypeCoercion)this.coercions.get(type);
    }

    public ThriftType getThriftType(Type javaType) throws IllegalArgumentException {
        Class rawType = TypeToken.of((Type)javaType).getRawType();
        ThriftType manualType = (ThriftType)this.manualTypes.get(rawType);
        if (manualType != null) {
            return manualType;
        }
        if (Boolean.TYPE == rawType) {
            return ThriftType.BOOL;
        }
        if (Byte.TYPE == rawType) {
            return ThriftType.BYTE;
        }
        if (Short.TYPE == rawType) {
            return ThriftType.I16;
        }
        if (Integer.TYPE == rawType) {
            return ThriftType.I32;
        }
        if (Long.TYPE == rawType) {
            return ThriftType.I64;
        }
        if (Double.TYPE == rawType) {
            return ThriftType.DOUBLE;
        }
        if (ByteBuffer.class.isAssignableFrom(rawType)) {
            return ThriftType.STRING;
        }
        if (Enum.class.isAssignableFrom(rawType)) {
            Class enumClass = TypeToken.of((Type)javaType).getRawType();
            ThriftEnumMetadata<?> thriftEnumMetadata = this.getThriftEnumMetadata(enumClass);
            return ThriftType.enumType(thriftEnumMetadata);
        }
        if (Map.class.isAssignableFrom(rawType)) {
            Type mapKeyType = ReflectionHelper.getMapKeyType(javaType);
            Type mapValueType = ReflectionHelper.getMapValueType(javaType);
            return ThriftType.map(this.getThriftType(mapKeyType), this.getThriftType(mapValueType));
        }
        if (Set.class.isAssignableFrom(rawType)) {
            Type elementType = ReflectionHelper.getIterableType(javaType);
            return ThriftType.set(this.getThriftType(elementType));
        }
        if (Iterable.class.isAssignableFrom(rawType)) {
            Type elementType = ReflectionHelper.getIterableType(javaType);
            return ThriftType.list(this.getThriftType(elementType));
        }
        if (Void.TYPE.isAssignableFrom(rawType) || Void.class.isAssignableFrom(rawType)) {
            return ThriftType.VOID;
        }
        if (rawType.isAnnotationPresent(ThriftStruct.class)) {
            ThriftStructMetadata structMetadata = this.getThriftStructMetadata(rawType);
            return ThriftType.struct(structMetadata);
        }
        if (ListenableFuture.class.isAssignableFrom(rawType)) {
            Type returnType = ReflectionHelper.getFutureReturnType(javaType);
            return this.getThriftType(returnType);
        }
        TypeCoercion coercion = (TypeCoercion)this.coercions.get(javaType);
        if (coercion != null) {
            return coercion.getThriftType();
        }
        throw new IllegalArgumentException("Type can not be coerced to a Thrift type: " + javaType);
    }

    public boolean isSupportedStructFieldType(Type javaType) {
        Class rawType = TypeToken.of((Type)javaType).getRawType();
        if (Boolean.TYPE == rawType) {
            return true;
        }
        if (Byte.TYPE == rawType) {
            return true;
        }
        if (Short.TYPE == rawType) {
            return true;
        }
        if (Integer.TYPE == rawType) {
            return true;
        }
        if (Long.TYPE == rawType) {
            return true;
        }
        if (Double.TYPE == rawType) {
            return true;
        }
        if (ByteBuffer.class.isAssignableFrom(rawType)) {
            return true;
        }
        if (Enum.class.isAssignableFrom(rawType)) {
            return true;
        }
        if (Map.class.isAssignableFrom(rawType)) {
            Type mapKeyType = ReflectionHelper.getMapKeyType(javaType);
            Type mapValueType = ReflectionHelper.getMapValueType(javaType);
            return this.isSupportedStructFieldType(mapKeyType) && this.isSupportedStructFieldType(mapValueType);
        }
        if (Set.class.isAssignableFrom(rawType)) {
            Type elementType = ReflectionHelper.getIterableType(javaType);
            return this.isSupportedStructFieldType(elementType);
        }
        if (Iterable.class.isAssignableFrom(rawType)) {
            Type elementType = ReflectionHelper.getIterableType(javaType);
            return this.isSupportedStructFieldType(elementType);
        }
        if (rawType.isAnnotationPresent(ThriftStruct.class)) {
            return true;
        }
        TypeCoercion coercion = (TypeCoercion)this.coercions.get(javaType);
        return coercion != null;
    }

    public <T extends Enum<T>> ThriftEnumMetadata<?> getThriftEnumMetadata(Class<?> enumClass) {
        ThriftEnumMetadata<?> current;
        ThriftEnumMetadata enumMetadata = (ThriftEnumMetadata)this.enums.get(enumClass);
        if (enumMetadata == null && (current = this.enums.putIfAbsent(enumClass, enumMetadata = new ThriftEnumMetadata(enumClass))) != null) {
            enumMetadata = current;
        }
        return enumMetadata;
    }

    public <T> ThriftStructMetadata<T> getThriftStructMetadata(Class<T> structClass) {
        ThriftStructMetadata<T> current;
        ThriftStructMetadata<T> structMetadata = (ThriftStructMetadata<T>)this.structs.get(structClass);
        if (structMetadata == null && (current = this.structs.putIfAbsent(structClass, structMetadata = this.extractThriftStructMetadata(structClass))) != null) {
            structMetadata = current;
        }
        return structMetadata;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> ThriftStructMetadata<T> extractThriftStructMetadata(Class<T> structClass) {
        Class<?> top;
        ThriftStructMetadata<T> thriftStructMetadata;
        Preconditions.checkNotNull(structClass, (Object)"structClass is null");
        Deque<Class<?>> stack = this.stack.get();
        if (stack.contains(structClass)) {
            String path = Joiner.on((String)"->").join(Iterables.transform((Iterable)Iterables.concat(stack, (Iterable)ImmutableList.of(structClass)), (Function)new Function<Class<?>, Object>(){

                public Object apply(Class<?> input) {
                    return input.getName();
                }
            }));
            throw new IllegalArgumentException("Circular references are not allowed: " + path);
        }
        stack.push(structClass);
        try {
            ThriftStructMetadata<T> structMetadata;
            ThriftStructMetadataBuilder<T> builder = new ThriftStructMetadataBuilder<T>(this, structClass);
            thriftStructMetadata = structMetadata = builder.build();
            top = stack.pop();
        }
        catch (Throwable throwable) {
            Class<?> top2 = stack.pop();
            Preconditions.checkState((boolean)structClass.equals(top2), (String)"ThriftCatalog circularity detection stack is corrupt: expected %s, but got %s", (Object[])new Object[]{structClass, top2});
            throw throwable;
        }
        Preconditions.checkState((boolean)structClass.equals(top), (String)"ThriftCatalog circularity detection stack is corrupt: expected %s, but got %s", (Object[])new Object[]{structClass, top});
        return thriftStructMetadata;
    }
}

