/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.compiler.byteCode;

import com.facebook.swift.codec.internal.compiler.byteCode.Access;
import com.facebook.swift.codec.internal.compiler.byteCode.FieldDefinition;
import com.facebook.swift.codec.internal.compiler.byteCode.MethodDefinition;
import com.facebook.swift.codec.internal.compiler.byteCode.ParameterizedType;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import org.objectweb.asm.tree.ClassNode;

@NotThreadSafe
public class ClassDefinition {
    private final int access;
    private final String name;
    private final ParameterizedType superClass;
    private final List<ParameterizedType> interfaces = new ArrayList<ParameterizedType>();
    private final List<FieldDefinition> fields = new ArrayList<FieldDefinition>();
    private final List<MethodDefinition> methods = new ArrayList<MethodDefinition>();

    public ClassDefinition(EnumSet<Access> access, String name, ParameterizedType superClass, ParameterizedType ... interfaces) {
        this.access = Access.toAccessModifier(access);
        this.name = name;
        this.superClass = superClass;
        this.interfaces.addAll((Collection<ParameterizedType>)ImmutableList.copyOf((Object[])interfaces));
    }

    public ClassNode getClassNode() {
        ClassNode classNode = new ClassNode();
        classNode.version = 50;
        classNode.access = this.access;
        classNode.name = this.name;
        classNode.superName = this.superClass.getClassName();
        for (ParameterizedType interfaceType : this.interfaces) {
            classNode.interfaces.add(interfaceType.getClassName());
        }
        if (this.superClass.isGeneric() || Iterables.any(this.interfaces, ParameterizedType.isGenericType())) {
            classNode.signature = ClassDefinition.genericClassSignature(this.superClass, this.interfaces);
        }
        for (FieldDefinition field : this.fields) {
            classNode.fields.add(field.getFieldNode());
        }
        for (MethodDefinition method : this.methods) {
            classNode.methods.add(method.getMethodNode());
        }
        return classNode;
    }

    public ClassDefinition addField(EnumSet<Access> access, String name, ParameterizedType type) {
        this.fields.add(new FieldDefinition(access, name, type));
        return this;
    }

    public ClassDefinition addField(FieldDefinition field) {
        this.fields.add(field);
        return this;
    }

    public ClassDefinition addMethod(MethodDefinition method) {
        this.methods.add(method);
        return this;
    }

    public static String genericClassSignature(ParameterizedType classType, ParameterizedType ... interfaceTypes) {
        return Joiner.on((String)"").join(Iterables.concat((Iterable)ImmutableList.of((Object)classType), (Iterable)ImmutableList.copyOf((Object[])interfaceTypes)));
    }

    public static String genericClassSignature(ParameterizedType classType, List<ParameterizedType> interfaceTypes) {
        return Joiner.on((String)"").join(Iterables.concat((Iterable)ImmutableList.of((Object)classType), interfaceTypes));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ClassDefinition");
        sb.append("{access=").append(this.access);
        sb.append(", name='").append(this.name).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

