/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.ThriftIdlAnnotation;
import com.facebook.swift.codec.ThriftUnion;
import com.facebook.swift.codec.ThriftUnionId;
import com.facebook.swift.codec.metadata.AbstractThriftMetadataBuilder;
import com.facebook.swift.codec.metadata.ConstructorInjection;
import com.facebook.swift.codec.metadata.FieldExtractor;
import com.facebook.swift.codec.metadata.FieldInjection;
import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.FieldMetadata;
import com.facebook.swift.codec.metadata.MethodExtractor;
import com.facebook.swift.codec.metadata.MethodInjection;
import com.facebook.swift.codec.metadata.ParameterInjection;
import com.facebook.swift.codec.metadata.ReflectionHelper;
import com.facebook.swift.codec.metadata.ThriftCatalog;
import com.facebook.swift.codec.metadata.ThriftConstructorInjection;
import com.facebook.swift.codec.metadata.ThriftExtraction;
import com.facebook.swift.codec.metadata.ThriftFieldExtractor;
import com.facebook.swift.codec.metadata.ThriftFieldInjection;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftInjection;
import com.facebook.swift.codec.metadata.ThriftMethodExtractor;
import com.facebook.swift.codec.metadata.ThriftMethodInjection;
import com.facebook.swift.codec.metadata.ThriftParameterInjection;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftTypeReference;
import com.facebook.swift.codec.metadata.TypeCoercion;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class ThriftUnionMetadataBuilder
extends AbstractThriftMetadataBuilder {
    public ThriftUnionMetadataBuilder(ThriftCatalog catalog, Type structType) {
        super(catalog, structType);
        this.verifyClass(ThriftUnion.class);
        this.extractThriftUnionId();
        this.normalizeThriftFields(catalog);
    }

    @Override
    protected String extractName() {
        ThriftUnion annotation = this.getStructClass().getAnnotation(ThriftUnion.class);
        if (annotation == null) {
            return this.getStructClass().getSimpleName();
        }
        if (!annotation.value().isEmpty()) {
            return annotation.value();
        }
        return this.getStructClass().getSimpleName();
    }

    @Override
    protected Map<String, String> extractStructIdlAnnotations() {
        ThriftUnion annotation = this.getStructClass().getAnnotation(ThriftUnion.class);
        if (annotation == null) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ThriftIdlAnnotation idlAnnotation : annotation.idlAnnotations()) {
            builder.put((Object)idlAnnotation.key(), (Object)idlAnnotation.value());
        }
        return builder.build();
    }

    @Override
    protected Class<?> extractBuilderClass() {
        ThriftUnion annotation = this.getStructClass().getAnnotation(ThriftUnion.class);
        if (annotation != null && !annotation.builder().equals(Void.TYPE)) {
            return annotation.builder();
        }
        return null;
    }

    private void extractThriftUnionId() {
        Collection<Field> idFields = ReflectionHelper.findAnnotatedFields(this.getStructClass(), ThriftUnionId.class);
        Collection<Method> idMethods = ReflectionHelper.findAnnotatedMethods(this.getStructClass(), ThriftUnionId.class);
        if (idFields.size() + idMethods.size() != 1) {
            if (idFields.size() + idMethods.size() == 0) {
                this.metadataErrors.addError("Neither a field nor a method is annotated with @ThriftUnionId", new Object[0]);
            } else if (idFields.size() > 1) {
                this.metadataErrors.addError("More than one @ThriftUnionId field present", new Object[0]);
            } else if (idMethods.size() > 1) {
                this.metadataErrors.addError("More than one @ThriftUnionId method present", new Object[0]);
            } else {
                this.metadataErrors.addError("Both fields and methods annotated with @ThriftUnionId", new Object[0]);
            }
            return;
        }
        for (Field idField : idFields) {
            FieldExtractor fieldExtractor = new FieldExtractor(this.structType, idField, null, FieldKind.THRIFT_UNION_ID);
            this.fields.add(fieldExtractor);
            this.extractors.add(fieldExtractor);
            FieldInjection fieldInjection = new FieldInjection(this.structType, idField, null, FieldKind.THRIFT_UNION_ID);
            this.fields.add(fieldInjection);
            this.fieldInjections.add(fieldInjection);
        }
        for (Method idMethod : idMethods) {
            if (!Modifier.isPublic(idMethod.getModifiers())) {
                this.metadataErrors.addError("@ThriftUnionId method [%s] is not public", idMethod.toGenericString());
                continue;
            }
            if (Modifier.isStatic(idMethod.getModifiers())) {
                this.metadataErrors.addError("@ThriftUnionId method [%s] is static", idMethod.toGenericString());
                continue;
            }
            if (!this.isValidateGetter(idMethod)) continue;
            MethodExtractor methodExtractor = new MethodExtractor(this.structType, idMethod, null, FieldKind.THRIFT_UNION_ID);
            this.fields.add(methodExtractor);
            this.extractors.add(methodExtractor);
        }
    }

    @Override
    protected void validateConstructors() {
        for (ConstructorInjection constructorInjection : this.constructorInjections) {
            if (constructorInjection.getParameters().size() <= 1) continue;
            this.metadataErrors.addError("@ThriftConstructor [%s] takes %d arguments, this is illegal for an union", constructorInjection.getConstructor().toGenericString(), constructorInjection.getParameters().size());
        }
    }

    @Override
    protected boolean isValidateSetter(Method method) {
        return method.getParameterTypes().length == 1;
    }

    @Override
    public ThriftStructMetadata build() {
        this.metadataErrors.throwIfHasErrors();
        ThriftMethodInjection builderMethodInjection = this.buildBuilderConstructorInjections();
        ThriftConstructorInjection constructorInjection = this.buildConstructorInjection();
        Iterable<ThriftFieldMetadata> fieldsMetadata = this.buildFieldInjections();
        List<ThriftMethodInjection> methodInjections = this.buildMethodInjections();
        return new ThriftStructMetadata(this.structName, this.extractStructIdlAnnotations(), this.structType, this.builderType, ThriftStructMetadata.MetadataType.UNION, (Optional<ThriftMethodInjection>)Optional.fromNullable((Object)builderMethodInjection), (List<String>)ImmutableList.copyOf((Collection)this.documentation), (List<ThriftFieldMetadata>)ImmutableList.copyOf(fieldsMetadata), (Optional<ThriftConstructorInjection>)Optional.fromNullable((Object)constructorInjection), methodInjections);
    }

    private ThriftConstructorInjection buildConstructorInjection() {
        for (ConstructorInjection constructorInjection : this.constructorInjections) {
            if (constructorInjection.getParameters().size() != 0) continue;
            return new ThriftConstructorInjection(constructorInjection.getConstructor(), this.buildParameterInjections(constructorInjection.getParameters()));
        }
        return null;
    }

    @Override
    protected ThriftFieldMetadata buildField(Collection<FieldMetadata> input) {
        short id = -1;
        boolean isLegacyId = false;
        String name = null;
        boolean recursiveness = false;
        ThriftField.Requiredness requiredness = ThriftField.Requiredness.UNSPECIFIED;
        Map<String, String> idlAnnotations = null;
        FieldKind fieldType = FieldKind.THRIFT_FIELD;
        ThriftTypeReference thriftTypeReference = null;
        ThriftConstructorInjection thriftConstructorInjection = null;
        ThriftMethodInjection thriftMethodInjection = null;
        ImmutableList.Builder injections = ImmutableList.builder();
        ThriftExtraction extraction = null;
        for (FieldMetadata fieldMetadata : input) {
            id = fieldMetadata.getId();
            isLegacyId = fieldMetadata.isLegacyId();
            name = fieldMetadata.getName();
            recursiveness = fieldMetadata.isRecursiveReference();
            requiredness = fieldMetadata.getRequiredness();
            idlAnnotations = fieldMetadata.getIdlAnnotations();
            fieldType = fieldMetadata.getType();
            thriftTypeReference = this.catalog.getFieldThriftTypeReference(fieldMetadata);
            switch (requiredness) {
                case REQUIRED: 
                case OPTIONAL: {
                    this.metadataErrors.addError("Thrift union '%s' field '%s(%s)' should not be marked required or optional", this.structName, name, id);
                    break;
                }
            }
            if (fieldMetadata instanceof FieldInjection) {
                FieldInjection fieldInjection = (FieldInjection)fieldMetadata;
                injections.add((Object)new ThriftFieldInjection(fieldInjection.getId(), fieldInjection.getName(), fieldInjection.getField(), fieldInjection.getType()));
                continue;
            }
            if (fieldMetadata instanceof ParameterInjection) {
                ParameterInjection parameterInjection = (ParameterInjection)fieldMetadata;
                ThriftParameterInjection thriftParameterInjection = new ThriftParameterInjection(parameterInjection.getId(), parameterInjection.getName(), parameterInjection.getParameterIndex(), fieldMetadata.getJavaType());
                injections.add((Object)thriftParameterInjection);
                for (ConstructorInjection constructorInjection : this.constructorInjections) {
                    if (constructorInjection.getParameters().size() != 1 || !constructorInjection.getParameters().get(0).equals(parameterInjection)) continue;
                    thriftConstructorInjection = new ThriftConstructorInjection(constructorInjection.getConstructor(), thriftParameterInjection);
                    break;
                }
                for (MethodInjection methodInjection : this.methodInjections) {
                    if (methodInjection.getParameters().size() != 1 || !methodInjection.getParameters().get(0).equals(parameterInjection)) continue;
                    thriftMethodInjection = new ThriftMethodInjection(methodInjection.getMethod(), thriftParameterInjection);
                }
                continue;
            }
            if (fieldMetadata instanceof FieldExtractor) {
                FieldExtractor fieldExtractor = (FieldExtractor)fieldMetadata;
                extraction = new ThriftFieldExtractor(fieldExtractor.getId(), fieldExtractor.getName(), fieldExtractor.getType(), fieldExtractor.getField(), fieldExtractor.getJavaType());
                continue;
            }
            if (!(fieldMetadata instanceof MethodExtractor)) continue;
            MethodExtractor methodExtractor = (MethodExtractor)fieldMetadata;
            extraction = new ThriftMethodExtractor(methodExtractor.getId(), methodExtractor.getName(), methodExtractor.getType(), methodExtractor.getMethod(), methodExtractor.getJavaType());
        }
        TypeCoercion coercion = null;
        if (!thriftTypeReference.isRecursive() && thriftTypeReference.get().isCoerced()) {
            coercion = this.catalog.getDefaultCoercion(thriftTypeReference.get().getJavaType());
        }
        ThriftFieldMetadata thriftFieldMetadata = new ThriftFieldMetadata(id, isLegacyId, recursiveness, requiredness, idlAnnotations, thriftTypeReference, name, fieldType, (List<ThriftInjection>)injections.build(), (Optional<ThriftConstructorInjection>)Optional.fromNullable(thriftConstructorInjection), (Optional<ThriftMethodInjection>)Optional.fromNullable(thriftMethodInjection), (Optional<ThriftExtraction>)Optional.fromNullable(extraction), (Optional<TypeCoercion>)Optional.fromNullable((Object)coercion));
        return thriftFieldMetadata;
    }
}

