/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal;

import com.facebook.swift.codec.ThriftCodec;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TSet;
import org.apache.thrift.protocol.TStruct;

@NotThreadSafe
public class TProtocolWriter {
    private final TProtocol protocol;

    public TProtocolWriter(TProtocol protocol) {
        this.protocol = protocol;
    }

    public void writeStructBegin(String name) throws TException {
        this.protocol.writeStructBegin(new TStruct(name));
    }

    public void writeStructEnd() throws TException {
        this.protocol.writeFieldStop();
        this.protocol.writeStructEnd();
    }

    public <T> void writeField(String name, short id, ThriftCodec<T> codec, T value) throws Exception {
        if (value == null) {
            return;
        }
        this.protocol.writeFieldBegin(new TField(name, codec.getType().getProtocolType().getType(), id));
        codec.write(value, this.protocol);
        this.protocol.writeFieldEnd();
    }

    public void writeBinaryField(String name, short id, ByteBuffer buf) throws TException {
        if (buf == null) {
            return;
        }
        this.protocol.writeFieldBegin(new TField(name, 11, id));
        this.protocol.writeBinary(buf);
        this.protocol.writeFieldEnd();
    }

    public void writeBoolField(String name, short id, boolean b) throws TException {
        this.protocol.writeFieldBegin(new TField(name, 2, id));
        this.protocol.writeBool(b);
        this.protocol.writeFieldEnd();
    }

    public void writeByteField(String name, short id, byte b) throws TException {
        this.protocol.writeFieldBegin(new TField(name, 3, id));
        this.protocol.writeByte(b);
        this.protocol.writeFieldEnd();
    }

    public void writeDoubleField(String name, short id, double dub) throws TException {
        this.protocol.writeFieldBegin(new TField(name, 4, id));
        this.protocol.writeDouble(dub);
        this.protocol.writeFieldEnd();
    }

    public void writeI16Field(String name, short id, short i16) throws TException {
        this.protocol.writeFieldBegin(new TField(name, 6, id));
        this.protocol.writeI16(i16);
        this.protocol.writeFieldEnd();
    }

    public void writeI32Field(String name, short id, int i32) throws TException {
        this.protocol.writeFieldBegin(new TField(name, 8, id));
        this.protocol.writeI32(i32);
        this.protocol.writeFieldEnd();
    }

    public void writeI64Field(String name, short id, long i64) throws TException {
        this.protocol.writeFieldBegin(new TField(name, 10, id));
        this.protocol.writeI64(i64);
        this.protocol.writeFieldEnd();
    }

    public void writeStringField(String name, short id, String string) throws TException {
        if (string == null) {
            return;
        }
        this.protocol.writeFieldBegin(new TField(name, 11, id));
        this.protocol.writeString(string);
        this.protocol.writeFieldEnd();
    }

    public <T> void writeStructField(String name, short id, ThriftCodec<T> codec, T struct) throws Exception {
        if (struct == null) {
            return;
        }
        this.protocol.writeFieldBegin(new TField(name, 12, id));
        codec.write(struct, this.protocol);
        this.protocol.writeFieldEnd();
    }

    public void writeBoolArrayField(String name, short id, boolean[] array) throws Exception {
        if (array == null) {
            return;
        }
        this.protocol.writeFieldBegin(new TField(name, 15, id));
        this.writeBoolArray(array);
        this.protocol.writeFieldEnd();
    }

    public void writeI16ArrayField(String name, short id, short[] array) throws Exception {
        if (array == null) {
            return;
        }
        this.protocol.writeFieldBegin(new TField(name, 15, id));
        this.writeI16Array(array);
        this.protocol.writeFieldEnd();
    }

    public void writeI32ArrayField(String name, short id, int[] array) throws Exception {
        if (array == null) {
            return;
        }
        this.protocol.writeFieldBegin(new TField(name, 15, id));
        this.writeI32Array(array);
        this.protocol.writeFieldEnd();
    }

    public void writeI64ArrayField(String name, short id, long[] array) throws Exception {
        if (array == null) {
            return;
        }
        this.protocol.writeFieldBegin(new TField(name, 15, id));
        this.writeI64Array(array);
        this.protocol.writeFieldEnd();
    }

    public void writeDoubleArrayField(String name, short id, double[] array) throws Exception {
        if (array == null) {
            return;
        }
        this.protocol.writeFieldBegin(new TField(name, 15, id));
        this.writeDoubleArray(array);
        this.protocol.writeFieldEnd();
    }

    public <E> void writeSetField(String name, short id, ThriftCodec<Set<E>> codec, Set<E> set) throws Exception {
        if (set == null) {
            return;
        }
        this.protocol.writeFieldBegin(new TField(name, 14, id));
        codec.write(set, this.protocol);
        this.protocol.writeFieldEnd();
    }

    public <E> void writeListField(String name, short id, ThriftCodec<List<E>> codec, List<E> list) throws Exception {
        if (list == null) {
            return;
        }
        this.protocol.writeFieldBegin(new TField(name, 15, id));
        codec.write(list, this.protocol);
        this.protocol.writeFieldEnd();
    }

    public <K, V> void writeMapField(String name, short id, ThriftCodec<Map<K, V>> codec, Map<K, V> map) throws Exception {
        if (map == null) {
            return;
        }
        this.protocol.writeFieldBegin(new TField(name, 13, id));
        codec.write(map, this.protocol);
        this.protocol.writeFieldEnd();
    }

    public <T extends Enum<T>> void writeEnumField(String name, short id, ThriftCodec<T> codec, T enumValue) throws Exception {
        if (enumValue == null) {
            return;
        }
        this.protocol.writeFieldBegin(new TField(name, 8, id));
        codec.write(enumValue, this.protocol);
        this.protocol.writeFieldEnd();
    }

    public void writeBinary(ByteBuffer buf) throws TException {
        if (buf == null) {
            return;
        }
        this.protocol.writeBinary(buf);
    }

    public void writeBool(boolean b) throws TException {
        this.protocol.writeBool(b);
    }

    public void writeByte(byte b) throws TException {
        this.protocol.writeByte(b);
    }

    public void writeI16(short i16) throws TException {
        this.protocol.writeI16(i16);
    }

    public void writeI32(int i32) throws TException {
        this.protocol.writeI32(i32);
    }

    public void writeI64(long i64) throws TException {
        this.protocol.writeI64(i64);
    }

    public void writeDouble(double dub) throws TException {
        this.protocol.writeDouble(dub);
    }

    public void writeString(String string) throws TException {
        if (string == null) {
            return;
        }
        this.protocol.writeString(string);
    }

    public void writeBoolArray(boolean[] array) throws TException {
        this.protocol.writeListBegin(new TList(2, array.length));
        for (boolean booleanValue : array) {
            this.writeBool(booleanValue);
        }
        this.protocol.writeListEnd();
    }

    public void writeI16Array(short[] array) throws TException {
        this.protocol.writeListBegin(new TList(6, array.length));
        for (short i16 : array) {
            this.writeI32(i16);
        }
        this.protocol.writeListEnd();
    }

    public void writeI32Array(int[] array) throws TException {
        this.protocol.writeListBegin(new TList(8, array.length));
        for (int i32 : array) {
            this.writeI32(i32);
        }
        this.protocol.writeListEnd();
    }

    public void writeI64Array(long[] array) throws TException {
        this.protocol.writeListBegin(new TList(10, array.length));
        for (long i64 : array) {
            this.writeI64(i64);
        }
        this.protocol.writeListEnd();
    }

    public void writeDoubleArray(double[] array) throws TException {
        this.protocol.writeListBegin(new TList(4, array.length));
        for (double doubleValue : array) {
            this.writeDouble(doubleValue);
        }
        this.protocol.writeListEnd();
    }

    public <T> void writeSet(ThriftCodec<T> elementCodec, Set<T> set) throws Exception {
        if (set == null) {
            return;
        }
        this.protocol.writeSetBegin(new TSet(elementCodec.getType().getProtocolType().getType(), set.size()));
        for (T element : set) {
            elementCodec.write(element, this.protocol);
        }
        this.protocol.writeSetEnd();
    }

    public <T> void writeList(ThriftCodec<T> elementCodec, List<T> list) throws Exception {
        if (list == null) {
            return;
        }
        this.protocol.writeListBegin(new TList(elementCodec.getType().getProtocolType().getType(), list.size()));
        for (T element : list) {
            elementCodec.write(element, this.protocol);
        }
        this.protocol.writeListEnd();
    }

    public <K, V> void writeMap(ThriftCodec<K> keyCodec, ThriftCodec<V> valueCodec, Map<K, V> map) throws Exception {
        if (map == null) {
            return;
        }
        this.protocol.writeMapBegin(new TMap(keyCodec.getType().getProtocolType().getType(), valueCodec.getType().getProtocolType().getType(), map.size()));
        for (Map.Entry<K, V> entry : map.entrySet()) {
            keyCodec.write(entry.getKey(), this.protocol);
            valueCodec.write(entry.getValue(), this.protocol);
        }
        this.protocol.writeMapEnd();
    }
}

