/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.virtualview;

import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import androidx.annotation.VisibleForTesting;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.uimanager.ReactRoot;
import com.facebook.react.views.scroll.ReactHorizontalScrollView;
import com.facebook.react.views.scroll.ReactScrollView;
import com.facebook.react.views.scroll.ReactScrollViewHelper;
import com.facebook.react.views.scroll.ScrollEventType;
import com.facebook.react.views.view.ReactViewGroup;
import com.facebook.react.views.virtualview.ModeChangeEmitter;
import com.facebook.react.views.virtualview.ReactVirtualView;
import com.facebook.react.views.virtualview.ReactVirtualViewKt;
import com.facebook.react.views.virtualview.VirtualViewMode;
import com.facebook.react.views.virtualview.VirtualViewRenderState;
import com.facebook.systrace.Systrace;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u00107\u001a\u000208H\u0010\u00a2\u0006\u0002\b9J\b\u0010:\u001a\u000208H\u0014J\r\u0010;\u001a\u000208H\u0001\u00a2\u0006\u0002\b<J\b\u0010=\u001a\u000208H\u0014J0\u0010>\u001a\u0002082\u0006\u0010?\u001a\u00020\"2\u0006\u0010@\u001a\u0002002\u0006\u0010A\u001a\u0002002\u0006\u0010B\u001a\u0002002\u0006\u0010C\u001a\u000200H\u0014JR\u0010D\u001a\u0002082\b\u0010E\u001a\u0004\u0018\u00010*2\u0006\u0010@\u001a\u0002002\u0006\u0010A\u001a\u0002002\u0006\u0010B\u001a\u0002002\u0006\u0010C\u001a\u0002002\u0006\u0010F\u001a\u0002002\u0006\u0010G\u001a\u0002002\u0006\u0010H\u001a\u0002002\u0006\u0010I\u001a\u000200H\u0016J,\u0010J\u001a\u0002082\b\u0010K\u001a\u0004\u0018\u00010L2\b\u0010M\u001a\u0004\u0018\u00010N2\u0006\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020PH\u0016J\u0012\u0010>\u001a\u0002082\b\u0010K\u001a\u0004\u0018\u00010LH\u0016J\u0010\u0010D\u001a\u0002082\u0006\u0010K\u001a\u00020LH\u0016J\u0010\u0010R\u001a\u0002082\u0006\u0010S\u001a\u00020\"H\u0002J\u0018\u0010T\u001a\u00020\"2\u0006\u0010U\u001a\u00020,2\u0006\u0010V\u001a\u00020,H\u0002J\u001a\u0010W\u001a\u0002082\b\u0010X\u001a\u0004\u0018\u00010\n2\u0006\u0010Y\u001a\u00020\nH\u0002J\u0010\u0010Z\u001a\u0002082\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010[\u001a\u0002082\u0006\u0010\t\u001a\u00020\nH\u0002J\n\u0010\\\u001a\u0004\u0018\u00010LH\u0002J\b\u0010]\u001a\u000208H\u0002J\u0012\u0010^\u001a\u0004\u0018\u00010L2\u0006\u0010_\u001a\u00020\"H\u0002J\b\u0010`\u001a\u000208H\u0002J)\u0010a\u001a\u0002082\u0006\u0010b\u001a\u0002042\u000e\b\u0002\u0010c\u001a\b\u0012\u0004\u0012\u0002040dH\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\beR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\"X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0014\u0010%\u001a\u00020\"X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010$R\u000e\u0010'\u001a\u00020(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010)\u001a\u0004\u0018\u00010*X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010+\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010.\u001a\u00020,X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010/\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00101\u001a\u000200X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00102\u001a\u00020\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u00103\u001a\u0004\u0018\u0001048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u00106\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006f"}, d2={"Lcom/facebook/react/views/virtualview/ReactVirtualView;", "Lcom/facebook/react/views/view/ReactViewGroup;", "Lcom/facebook/react/views/scroll/ReactScrollViewHelper$ScrollListener;", "Lcom/facebook/react/views/scroll/ReactScrollViewHelper$LayoutChangeListener;", "Landroid/view/View$OnLayoutChangeListener;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "mode", "Lcom/facebook/react/views/virtualview/VirtualViewMode;", "getMode$ReactAndroid_release", "()Lcom/facebook/react/views/virtualview/VirtualViewMode;", "setMode$ReactAndroid_release", "(Lcom/facebook/react/views/virtualview/VirtualViewMode;)V", "renderState", "Lcom/facebook/react/views/virtualview/VirtualViewRenderState;", "getRenderState$ReactAndroid_release", "()Lcom/facebook/react/views/virtualview/VirtualViewRenderState;", "setRenderState$ReactAndroid_release", "(Lcom/facebook/react/views/virtualview/VirtualViewRenderState;)V", "modeChangeEmitter", "Lcom/facebook/react/views/virtualview/ModeChangeEmitter;", "getModeChangeEmitter$ReactAndroid_release", "()Lcom/facebook/react/views/virtualview/ModeChangeEmitter;", "setModeChangeEmitter$ReactAndroid_release", "(Lcom/facebook/react/views/virtualview/ModeChangeEmitter;)V", "prerenderRatio", "", "getPrerenderRatio$ReactAndroid_release", "()D", "setPrerenderRatio$ReactAndroid_release", "(D)V", "debugLogEnabled", "", "getDebugLogEnabled$ReactAndroid_release", "()Z", "detectWindowFocus", "getDetectWindowFocus$ReactAndroid_release", "onWindowFocusChangeListener", "Landroid/view/ViewTreeObserver$OnWindowFocusChangeListener;", "parentScrollView", "Landroid/view/View;", "lastRect", "Landroid/graphics/Rect;", "targetRect", "thresholdRect", "offsetX", "", "offsetY", "offsetChanged", "nativeId", "", "getNativeId$ReactAndroid_release", "()Ljava/lang/String;", "recycleView", "", "recycleView$ReactAndroid_release", "onAttachedToWindow", "doAttachedToWindow", "doAttachedToWindow$ReactAndroid_release", "onDetachedFromWindow", "onLayout", "changed", "left", "top", "right", "bottom", "onLayoutChange", "v", "oldLeft", "oldTop", "oldRight", "oldBottom", "onScroll", "scrollView", "Landroid/view/ViewGroup;", "scrollEventType", "Lcom/facebook/react/views/scroll/ScrollEventType;", "xVelocity", "", "yVelocity", "dispatchOnModeChangeIfNeeded", "checkRectChange", "rectsOverlap", "rect1", "rect2", "maybeEmitModeChanges", "oldMode", "newMode", "emitAsyncModeChange", "emitSyncModeChange", "getParentScrollView", "cleanupLayoutListeners", "traverseParentStack", "addListeners", "updateParentOffset", "debugLog", "subtag", "block", "Lkotlin/Function0;", "debugLog$ReactAndroid_release", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nReactVirtualView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactVirtualView.kt\ncom/facebook/react/views/virtualview/ReactVirtualView\n+ 2 ReactVirtualView.kt\ncom/facebook/react/views/virtualview/ReactVirtualView$debugLog$1\n*L\n1#1,383:1\n358#1,4:384\n364#1,4:389\n359#1,9:393\n359#1,9:402\n359#1,9:411\n359#1,9:420\n358#2:388\n*S KotlinDebug\n*F\n+ 1 ReactVirtualView.kt\ncom/facebook/react/views/virtualview/ReactVirtualView\n*L\n89#1:384,4\n89#1:389,4\n187#1:393,9\n194#1:402,9\n226#1:411,9\n265#1:420,9\n89#1:388\n*E\n"})
public final class ReactVirtualView
extends ReactViewGroup
implements ReactScrollViewHelper.ScrollListener,
ReactScrollViewHelper.LayoutChangeListener,
View.OnLayoutChangeListener {
    @Nullable
    private VirtualViewMode mode;
    @NotNull
    private VirtualViewRenderState renderState;
    @Nullable
    private ModeChangeEmitter modeChangeEmitter;
    private double prerenderRatio;
    private final boolean debugLogEnabled;
    private final boolean detectWindowFocus;
    @NotNull
    private final ViewTreeObserver.OnWindowFocusChangeListener onWindowFocusChangeListener;
    @Nullable
    private View parentScrollView;
    @NotNull
    private final Rect lastRect;
    @NotNull
    private final Rect targetRect;
    @NotNull
    private final Rect thresholdRect;
    private int offsetX;
    private int offsetY;
    private boolean offsetChanged;

    public ReactVirtualView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.renderState = VirtualViewRenderState.Unknown;
        this.prerenderRatio = ReactNativeFeatureFlags.virtualViewPrerenderRatio();
        this.debugLogEnabled = ReactNativeFeatureFlags.enableVirtualViewDebugFeatures();
        this.detectWindowFocus = ReactNativeFeatureFlags.enableVirtualViewWindowFocusDetection();
        this.onWindowFocusChangeListener = arg_0 -> ReactVirtualView.onWindowFocusChangeListener$lambda$0(this, arg_0);
        this.lastRect = new Rect();
        this.targetRect = new Rect();
        this.thresholdRect = new Rect();
    }

    @Nullable
    public final VirtualViewMode getMode$ReactAndroid_release() {
        return this.mode;
    }

    public final void setMode$ReactAndroid_release(@Nullable VirtualViewMode virtualViewMode) {
        this.mode = virtualViewMode;
    }

    @NotNull
    public final VirtualViewRenderState getRenderState$ReactAndroid_release() {
        return this.renderState;
    }

    public final void setRenderState$ReactAndroid_release(@NotNull VirtualViewRenderState virtualViewRenderState) {
        Intrinsics.checkNotNullParameter((Object)((Object)virtualViewRenderState), (String)"<set-?>");
        this.renderState = virtualViewRenderState;
    }

    @Nullable
    public final ModeChangeEmitter getModeChangeEmitter$ReactAndroid_release() {
        return this.modeChangeEmitter;
    }

    public final void setModeChangeEmitter$ReactAndroid_release(@Nullable ModeChangeEmitter modeChangeEmitter) {
        this.modeChangeEmitter = modeChangeEmitter;
    }

    public final double getPrerenderRatio$ReactAndroid_release() {
        return this.prerenderRatio;
    }

    public final void setPrerenderRatio$ReactAndroid_release(double d) {
        this.prerenderRatio = d;
    }

    public final boolean getDebugLogEnabled$ReactAndroid_release() {
        return this.debugLogEnabled;
    }

    public final boolean getDetectWindowFocus$ReactAndroid_release() {
        return this.detectWindowFocus;
    }

    @Nullable
    public final String getNativeId$ReactAndroid_release() {
        Object object = this.getTag(R.id.view_tag_native_id);
        return object instanceof String ? (String)object : null;
    }

    @Override
    public void recycleView$ReactAndroid_release() {
        ReactScrollViewHelper.removeScrollListener(this);
        ReactScrollViewHelper.removeLayoutChangeListener(this);
        this.cleanupLayoutListeners();
        this.mode = null;
        this.modeChangeEmitter = null;
        this.lastRect.setEmpty();
        this.parentScrollView = null;
        this.offsetX = 0;
        this.offsetY = 0;
        this.offsetChanged = false;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.doAttachedToWindow$ReactAndroid_release();
    }

    @VisibleForTesting
    public final void doAttachedToWindow$ReactAndroid_release() {
        ViewGroup viewGroup;
        Object object;
        Object object2 = this;
        ViewGroup viewGroup2 = this.getParentScrollView();
        if (viewGroup2 != null) {
            ViewGroup viewGroup3;
            ViewGroup viewGroup4 = viewGroup3 = viewGroup2;
            object = object2;
            boolean bl = false;
            this.offsetChanged = true;
            ReactScrollViewHelper.addScrollListener(this);
            ReactScrollViewHelper.addLayoutChangeListener(this);
            object2 = object;
            viewGroup = viewGroup3;
        } else {
            viewGroup = null;
        }
        ((ReactVirtualView)object2).parentScrollView = (View)viewGroup;
        String subtag$iv = "onAttachedToWindow";
        boolean $i$f$debugLog$ReactAndroid_release = false;
        if (this.getDebugLogEnabled$ReactAndroid_release()) {
            if (ReactVirtualViewKt.access$getIS_DEBUG_BUILD$p()) {
                object = "ReactVirtualView:" + subtag$iv;
                $i$a$-debugLog$ReactAndroid_release-ReactVirtualView$debugLog$1 = false;
                FLog.d((String)object, (String)("" + " [" + this.getId() + "][" + this.getNativeId$ReactAndroid_release() + "]"));
            } else {
                object = "ReactVirtualView:" + subtag$iv;
                $i$a$-debugLog$ReactAndroid_release-ReactVirtualView$debugLog$1 = false;
                FLog.w((String)object, (String)("" + " [" + this.getId() + "][" + this.getNativeId$ReactAndroid_release() + "]"));
            }
        }
        if (this.detectWindowFocus) {
            this.getViewTreeObserver().addOnWindowFocusChangeListener(this.onWindowFocusChangeListener);
        }
        this.dispatchOnModeChangeIfNeeded(false);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        ReactScrollViewHelper.removeScrollListener(this);
        ReactScrollViewHelper.removeLayoutChangeListener(this);
        if (this.detectWindowFocus) {
            this.getViewTreeObserver().addOnWindowFocusChangeListener(this.onWindowFocusChangeListener);
        }
        this.cleanupLayoutListeners();
    }

    @Override
    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        if (changed) {
            this.offsetChanged = true;
            this.dispatchOnModeChangeIfNeeded(false);
        }
    }

    public void onLayoutChange(@Nullable View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        this.offsetChanged = this.offsetChanged || oldLeft != left || oldTop != top;
        this.dispatchOnModeChangeIfNeeded(true);
    }

    @Override
    public void onScroll(@Nullable ViewGroup scrollView, @Nullable ScrollEventType scrollEventType, float xVelocity, float yVelocity) {
        if (Intrinsics.areEqual((Object)scrollView, (Object)this.parentScrollView)) {
            this.dispatchOnModeChangeIfNeeded(false);
        }
    }

    @Override
    public void onLayout(@Nullable ViewGroup scrollView) {
        if (Intrinsics.areEqual((Object)scrollView, (Object)this.parentScrollView)) {
            this.dispatchOnModeChangeIfNeeded(false);
        }
    }

    @Override
    public void onLayoutChange(@NotNull ViewGroup scrollView) {
        Intrinsics.checkNotNullParameter((Object)scrollView, (String)"scrollView");
        if (Intrinsics.areEqual((Object)scrollView, (Object)this.parentScrollView)) {
            this.offsetChanged = true;
            this.dispatchOnModeChangeIfNeeded(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void dispatchOnModeChangeIfNeeded(boolean checkRectChange) {
        void this_$iv;
        if (this.modeChangeEmitter == null) {
            return;
        }
        View view = this.parentScrollView;
        if (view == null) {
            return;
        }
        View scrollView = view;
        if (this.offsetChanged) {
            this.updateParentOffset();
        }
        this.targetRect.set(this.getLeft() + this.offsetX, this.getTop() + this.offsetY, this.getRight() + this.offsetX, this.getBottom() + this.offsetY);
        scrollView.getDrawingRect(this.thresholdRect);
        if (this.targetRect.width() == 0 && this.targetRect.height() == 0 || this.thresholdRect.isEmpty()) {
            void this_$iv2;
            ReactVirtualView reactVirtualView = this;
            String subtag$iv = "dispatchOnModeChangeIfNeeded";
            boolean $i$f$debugLog$ReactAndroid_release = false;
            if (this_$iv2.getDebugLogEnabled$ReactAndroid_release()) {
                if (ReactVirtualViewKt.access$getIS_DEBUG_BUILD$p()) {
                    String string2 = "ReactVirtualView:" + subtag$iv;
                    boolean bl = false;
                    FLog.d((String)string2, (String)("empty rects target=" + this.targetRect.toShortString() + " threshold=" + this.thresholdRect.toShortString() + " [" + this_$iv2.getId() + "][" + this_$iv2.getNativeId$ReactAndroid_release() + "]"));
                } else {
                    String string3 = "ReactVirtualView:" + subtag$iv;
                    boolean bl = false;
                    FLog.w((String)string3, (String)("empty rects target=" + this.targetRect.toShortString() + " threshold=" + this.thresholdRect.toShortString() + " [" + this_$iv2.getId() + "][" + this_$iv2.getNativeId$ReactAndroid_release() + "]"));
                }
            }
            return;
        }
        if (checkRectChange) {
            if (!this.lastRect.isEmpty() && Intrinsics.areEqual((Object)this.lastRect, (Object)this.targetRect)) {
                ReactVirtualView this_$iv2 = this;
                String subtag$iv = "dispatchOnModeChangeIfNeeded";
                boolean $i$f$debugLog$ReactAndroid_release = false;
                if (this_$iv2.getDebugLogEnabled$ReactAndroid_release()) {
                    if (ReactVirtualViewKt.access$getIS_DEBUG_BUILD$p()) {
                        String string4 = "ReactVirtualView:" + subtag$iv;
                        boolean bl = false;
                        FLog.d((String)string4, (String)("no rect change" + " [" + this_$iv2.getId() + "][" + this_$iv2.getNativeId$ReactAndroid_release() + "]"));
                    } else {
                        String string5 = "ReactVirtualView:" + subtag$iv;
                        boolean bl = false;
                        FLog.w((String)string5, (String)("no rect change" + " [" + this_$iv2.getId() + "][" + this_$iv2.getNativeId$ReactAndroid_release() + "]"));
                    }
                }
                return;
            }
            this.lastRect.set(this.targetRect);
        }
        VirtualViewMode newMode = null;
        if (this.rectsOverlap(this.targetRect, this.thresholdRect)) {
            newMode = this.detectWindowFocus ? (this.hasWindowFocus() ? VirtualViewMode.Visible : VirtualViewMode.Prerender) : VirtualViewMode.Visible;
        } else {
            boolean prerender = false;
            if (this.prerenderRatio > 0.0) {
                this.thresholdRect.inset((int)((double)(-this.thresholdRect.width()) * this.prerenderRatio), (int)((double)(-this.thresholdRect.height()) * this.prerenderRatio));
                prerender = this.rectsOverlap(this.targetRect, this.thresholdRect);
            }
            if (prerender) {
                newMode = VirtualViewMode.Prerender;
            } else {
                newMode = VirtualViewMode.Hidden;
                this.thresholdRect.setEmpty();
            }
        }
        ReactVirtualView prerender = this;
        String subtag$iv = "dispatchOnModeChangeIfNeeded";
        boolean $i$f$debugLog$ReactAndroid_release = false;
        if (this_$iv.getDebugLogEnabled$ReactAndroid_release()) {
            if (ReactVirtualViewKt.access$getIS_DEBUG_BUILD$p()) {
                String string6 = "ReactVirtualView:" + subtag$iv;
                boolean bl = false;
                FLog.d((String)string6, (String)("mode=" + this.mode + " target=" + this.targetRect.toShortString() + " threshold=" + this.thresholdRect.toShortString() + " [" + this_$iv.getId() + "][" + this_$iv.getNativeId$ReactAndroid_release() + "]"));
            } else {
                String string7 = "ReactVirtualView:" + subtag$iv;
                boolean bl = false;
                FLog.w((String)string7, (String)("mode=" + this.mode + " target=" + this.targetRect.toShortString() + " threshold=" + this.thresholdRect.toShortString() + " [" + this_$iv.getId() + "][" + this_$iv.getNativeId$ReactAndroid_release() + "]"));
            }
        }
        if (newMode == this.mode) {
            return;
        }
        VirtualViewMode oldMode = this.mode;
        this.mode = newMode;
        this.maybeEmitModeChanges(oldMode, newMode);
    }

    private final boolean rectsOverlap(Rect rect1, Rect rect2) {
        if (rect1.top >= rect2.bottom || rect2.top >= rect1.bottom) {
            return false;
        }
        return rect1.left < rect2.right && rect2.left < rect1.right;
    }

    /*
     * WARNING - void declaration
     */
    private final void maybeEmitModeChanges(VirtualViewMode oldMode, VirtualViewMode newMode) {
        void this_$iv;
        ReactVirtualView reactVirtualView = this;
        String subtag$iv = "Mode change";
        boolean $i$f$debugLog$ReactAndroid_release = false;
        if (this_$iv.getDebugLogEnabled$ReactAndroid_release()) {
            if (ReactVirtualViewKt.access$getIS_DEBUG_BUILD$p()) {
                String string2 = "ReactVirtualView:" + subtag$iv;
                boolean bl = false;
                FLog.d((String)string2, (String)(oldMode + "->" + newMode + " [" + this_$iv.getId() + "][" + this_$iv.getNativeId$ReactAndroid_release() + "]"));
            } else {
                String string3 = "ReactVirtualView:" + subtag$iv;
                boolean bl = false;
                FLog.w((String)string3, (String)(oldMode + "->" + newMode + " [" + this_$iv.getId() + "][" + this_$iv.getNativeId$ReactAndroid_release() + "]"));
            }
        }
        Systrace.beginSection(0L, "VirtualView::mode change " + oldMode + " -> " + newMode + ", nativeID=" + this.getNativeId$ReactAndroid_release());
        switch (WhenMappings.$EnumSwitchMapping$0[newMode.ordinal()]) {
            case 1: {
                boolean wasPrerenderCommitted;
                if (this.renderState == VirtualViewRenderState.Unknown) {
                    this.emitSyncModeChange(VirtualViewMode.Visible);
                    break;
                }
                boolean bl = wasPrerenderCommitted = oldMode == VirtualViewMode.Prerender && this.renderState == VirtualViewRenderState.Rendered;
                if (wasPrerenderCommitted) break;
                this.emitSyncModeChange(VirtualViewMode.Visible);
                break;
            }
            case 2: {
                if (oldMode == VirtualViewMode.Visible) break;
                this.emitAsyncModeChange(VirtualViewMode.Prerender);
                break;
            }
            case 3: {
                this.emitAsyncModeChange(VirtualViewMode.Hidden);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        Systrace.endSection(0L);
    }

    private final void emitAsyncModeChange(VirtualViewMode mode) {
        block0: {
            ModeChangeEmitter modeChangeEmitter = this.modeChangeEmitter;
            if (modeChangeEmitter == null) break block0;
            modeChangeEmitter.emitModeChange(mode, this.targetRect, this.thresholdRect, false);
        }
    }

    private final void emitSyncModeChange(VirtualViewMode mode) {
        block0: {
            ModeChangeEmitter modeChangeEmitter = this.modeChangeEmitter;
            if (modeChangeEmitter == null) break block0;
            modeChangeEmitter.emitModeChange(mode, this.targetRect, this.thresholdRect, true);
        }
    }

    private final ViewGroup getParentScrollView() {
        return this.traverseParentStack(true);
    }

    private final void cleanupLayoutListeners() {
        this.traverseParentStack(false);
    }

    private final ViewGroup traverseParentStack(boolean addListeners) {
        for (ViewParent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent instanceof ReactScrollView) {
                return (ViewGroup)parent;
            }
            if (parent instanceof ReactHorizontalScrollView) {
                return (ViewGroup)parent;
            }
            if (parent instanceof ReactRoot) {
                return null;
            }
            if (!(parent instanceof View)) continue;
            ((View)parent).removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
            if (!addListeners) continue;
            ((View)parent).addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
        }
        return null;
    }

    private final void updateParentOffset() {
        View view = this.parentScrollView;
        if (view == null) {
            return;
        }
        View scrollView = view;
        this.offsetX = 0;
        this.offsetY = 0;
        this.offsetChanged = false;
        for (ViewParent parent = this.getParent(); parent != null && !Intrinsics.areEqual((Object)parent, (Object)scrollView); parent = parent.getParent()) {
            if (!(parent instanceof View)) continue;
            this.offsetX += ((View)parent).getLeft();
            this.offsetY += ((View)parent).getTop();
        }
    }

    public final void debugLog$ReactAndroid_release(@NotNull String subtag, @NotNull Function0<String> block) {
        Intrinsics.checkNotNullParameter((Object)subtag, (String)"subtag");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        boolean $i$f$debugLog$ReactAndroid_release = false;
        if (this.getDebugLogEnabled$ReactAndroid_release()) {
            if (ReactVirtualViewKt.access$getIS_DEBUG_BUILD$p()) {
                FLog.d((String)("ReactVirtualView:" + subtag), (String)(block.invoke() + " [" + this.getId() + "][" + this.getNativeId$ReactAndroid_release() + "]"));
            } else {
                FLog.w((String)("ReactVirtualView:" + subtag), (String)(block.invoke() + " [" + this.getId() + "][" + this.getNativeId$ReactAndroid_release() + "]"));
            }
        }
    }

    public static /* synthetic */ void debugLog$ReactAndroid_release$default(ReactVirtualView $this, String subtag, Function0 block, int n, Object object) {
        if ((n & 2) != 0) {
            block = debugLog.1.INSTANCE;
        }
        Intrinsics.checkNotNullParameter((Object)subtag, (String)"subtag");
        Intrinsics.checkNotNullParameter((Object)block, (String)"block");
        boolean $i$f$debugLog$ReactAndroid_release = false;
        if ($this.getDebugLogEnabled$ReactAndroid_release()) {
            if (ReactVirtualViewKt.access$getIS_DEBUG_BUILD$p()) {
                FLog.d((String)("ReactVirtualView:" + subtag), (String)(block.invoke() + " [" + $this.getId() + "][" + $this.getNativeId$ReactAndroid_release() + "]"));
            } else {
                FLog.w((String)("ReactVirtualView:" + subtag), (String)(block.invoke() + " [" + $this.getId() + "][" + $this.getNativeId$ReactAndroid_release() + "]"));
            }
        }
    }

    private static final void onWindowFocusChangeListener$lambda$0(ReactVirtualView this$0, boolean it) {
        this$0.dispatchOnModeChangeIfNeeded(false);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[VirtualViewMode.values().length];
            try {
                nArray[VirtualViewMode.Visible.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VirtualViewMode.Prerender.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[VirtualViewMode.Hidden.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

