/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.content.Context;
import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import com.facebook.react.views.common.UiModeUtils;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u001a\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\f\u001a\u00020\u000b*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\u000f\u001a\u00020\u000b*\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0007H\u0000\u001a\f\u0010\u0011\u001a\u00020\u000b*\u00020\rH\u0002\u001a\f\u0010\u0012\u001a\u00020\u000b*\u00020\rH\u0002\u001a\f\u0010\u0013\u001a\u00020\u000b*\u00020\rH\u0000\u001a\f\u0010\u0014\u001a\u00020\u000b*\u00020\rH\u0000\"\u0014\u0010\u0000\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\"\u0014\u0010\u0004\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0003\"\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0015"}, d2={"LightNavigationBarColor", "", "getLightNavigationBarColor", "()I", "DarkNavigationBarColor", "getDarkNavigationBarColor", "value", "", "isEdgeToEdgeFeatureFlagOn", "()Z", "setEdgeToEdgeFeatureFlagOn", "", "setStatusBarTranslucency", "Landroid/view/Window;", "isTranslucent", "setStatusBarVisibility", "isHidden", "statusBarHide", "statusBarShow", "enableEdgeToEdge", "disableEdgeToEdge", "ReactAndroid_release"})
public final class WindowUtilKt {
    private static final int LightNavigationBarColor = Color.argb((int)230, (int)255, (int)255, (int)255);
    private static final int DarkNavigationBarColor = Color.argb((int)128, (int)27, (int)27, (int)27);
    private static boolean isEdgeToEdgeFeatureFlagOn;

    public static final int getLightNavigationBarColor() {
        return LightNavigationBarColor;
    }

    public static final int getDarkNavigationBarColor() {
        return DarkNavigationBarColor;
    }

    public static final boolean isEdgeToEdgeFeatureFlagOn() {
        return isEdgeToEdgeFeatureFlagOn;
    }

    public static final void setEdgeToEdgeFeatureFlagOn() {
        isEdgeToEdgeFeatureFlagOn = true;
    }

    public static final void setStatusBarTranslucency(@NotNull Window $this$setStatusBarTranslucency, boolean isTranslucent) {
        Intrinsics.checkNotNullParameter((Object)$this$setStatusBarTranslucency, (String)"<this>");
        if (isTranslucent) {
            $this$setStatusBarTranslucency.getDecorView().setOnApplyWindowInsetsListener(WindowUtilKt::setStatusBarTranslucency$lambda$0);
        } else {
            $this$setStatusBarTranslucency.getDecorView().setOnApplyWindowInsetsListener(null);
        }
        ViewCompat.requestApplyInsets((View)$this$setStatusBarTranslucency.getDecorView());
    }

    public static final void setStatusBarVisibility(@NotNull Window $this$setStatusBarVisibility, boolean isHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$setStatusBarVisibility, (String)"<this>");
        if (isHidden) {
            WindowUtilKt.statusBarHide($this$setStatusBarVisibility);
        } else {
            WindowUtilKt.statusBarShow($this$setStatusBarVisibility);
        }
    }

    private static final void statusBarHide(Window $this$statusBarHide) {
        if (isEdgeToEdgeFeatureFlagOn) {
            WindowInsetsControllerCompat $this$statusBarHide_u24lambda_u241 = new WindowInsetsControllerCompat($this$statusBarHide, $this$statusBarHide.getDecorView());
            boolean bl = false;
            $this$statusBarHide_u24lambda_u241.setSystemBarsBehavior(2);
            $this$statusBarHide_u24lambda_u241.hide(WindowInsetsCompat.Type.statusBars());
        } else {
            if (Build.VERSION.SDK_INT >= 30) {
                $this$statusBarHide.getAttributes().layoutInDisplayCutoutMode = 1;
                $this$statusBarHide.setDecorFitsSystemWindows(false);
            }
            $this$statusBarHide.addFlags(1024);
            $this$statusBarHide.clearFlags(2048);
        }
    }

    private static final void statusBarShow(Window $this$statusBarShow) {
        if (isEdgeToEdgeFeatureFlagOn) {
            WindowInsetsControllerCompat $this$statusBarShow_u24lambda_u242 = new WindowInsetsControllerCompat($this$statusBarShow, $this$statusBarShow.getDecorView());
            boolean bl = false;
            $this$statusBarShow_u24lambda_u242.setSystemBarsBehavior(2);
            $this$statusBarShow_u24lambda_u242.show(WindowInsetsCompat.Type.statusBars());
        } else {
            if (Build.VERSION.SDK_INT >= 30) {
                $this$statusBarShow.getAttributes().layoutInDisplayCutoutMode = 0;
                $this$statusBarShow.setDecorFitsSystemWindows(true);
            }
            $this$statusBarShow.addFlags(2048);
            $this$statusBarShow.clearFlags(1024);
        }
    }

    public static final void enableEdgeToEdge(@NotNull Window $this$enableEdgeToEdge) {
        Intrinsics.checkNotNullParameter((Object)$this$enableEdgeToEdge, (String)"<this>");
        WindowCompat.setDecorFitsSystemWindows((Window)$this$enableEdgeToEdge, (boolean)false);
        Context context = $this$enableEdgeToEdge.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
        boolean isDarkMode = UiModeUtils.isDarkMode(context);
        if (Build.VERSION.SDK_INT >= 29) {
            $this$enableEdgeToEdge.setStatusBarContrastEnforced(false);
            $this$enableEdgeToEdge.setNavigationBarContrastEnforced(true);
        }
        $this$enableEdgeToEdge.setStatusBarColor(0);
        $this$enableEdgeToEdge.setNavigationBarColor(Build.VERSION.SDK_INT >= 29 ? 0 : (Build.VERSION.SDK_INT >= 26 && !isDarkMode ? LightNavigationBarColor : DarkNavigationBarColor));
        WindowInsetsControllerCompat $this$enableEdgeToEdge_u24lambda_u243 = new WindowInsetsControllerCompat($this$enableEdgeToEdge, $this$enableEdgeToEdge.getDecorView());
        boolean bl = false;
        $this$enableEdgeToEdge_u24lambda_u243.setAppearanceLightNavigationBars(!isDarkMode);
        if (Build.VERSION.SDK_INT >= 28) {
            $this$enableEdgeToEdge.getAttributes().layoutInDisplayCutoutMode = Build.VERSION.SDK_INT >= 30 ? 3 : 1;
        }
    }

    public static final void disableEdgeToEdge(@NotNull Window $this$disableEdgeToEdge) {
        Intrinsics.checkNotNullParameter((Object)$this$disableEdgeToEdge, (String)"<this>");
        WindowCompat.setDecorFitsSystemWindows((Window)$this$disableEdgeToEdge, (boolean)true);
    }

    private static final WindowInsets setStatusBarTranslucency$lambda$0(View v, WindowInsets insets) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        WindowInsets defaultInsets = v.onApplyWindowInsets(insets);
        return defaultInsets.replaceSystemWindowInsets(defaultInsets.getSystemWindowInsetLeft(), 0, defaultInsets.getSystemWindowInsetRight(), defaultInsets.getSystemWindowInsetBottom());
    }
}

