/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.imagehelper;

import android.content.Context;
import android.net.Uri;
import com.facebook.react.modules.fresco.ImageCacheControl;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0004\b\u0016\u0018\u0000 \"2\u00020\u0001:\u0001\"B9\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0013\u0010\u001c\u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010 \u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0010\u0010!\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u0015\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/facebook/react/views/imagehelper/ImageSource;", "", "context", "Landroid/content/Context;", "source", "", "width", "", "height", "cacheControl", "Lcom/facebook/react/modules/fresco/ImageCacheControl;", "<init>", "(Landroid/content/Context;Ljava/lang/String;DDLcom/facebook/react/modules/fresco/ImageCacheControl;)V", "getSource", "()Ljava/lang/String;", "getCacheControl", "()Lcom/facebook/react/modules/fresco/ImageCacheControl;", "uri", "Landroid/net/Uri;", "getUri", "()Landroid/net/Uri;", "size", "getSize", "()D", "isResource", "", "()Z", "_isResource", "equals", "other", "hashCode", "", "computeUri", "computeLocalUri", "Companion", "ReactAndroid_release"})
public class ImageSource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String source;
    @NotNull
    private final ImageCacheControl cacheControl;
    @NotNull
    private final Uri uri;
    private final double size;
    private boolean _isResource;
    @NotNull
    private static final String TRANSPARENT_BITMAP_URI = "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAAAEAAAABCAQAAAC1HAwCAAAAC0lEQVR42mNkYAAAAAYAAjCB0C8AAAAASUVORK5CYII=";

    @JvmOverloads
    public ImageSource(@NotNull Context context, @Nullable String source2, double width, double height, @NotNull ImageCacheControl cacheControl) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)((Object)cacheControl), (String)"cacheControl");
        this.source = source2;
        this.cacheControl = cacheControl;
        this.uri = this.computeUri(context);
        this.size = width * height;
    }

    public /* synthetic */ ImageSource(Context context, String string2, double d, double d2, ImageCacheControl imageCacheControl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            d = 0.0;
        }
        if ((n & 8) != 0) {
            d2 = 0.0;
        }
        if ((n & 0x10) != 0) {
            imageCacheControl = ImageCacheControl.DEFAULT;
        }
        this(context, string2, d, d2, imageCacheControl);
    }

    @Nullable
    public final String getSource() {
        return this.source;
    }

    @NotNull
    public final ImageCacheControl getCacheControl() {
        return this.cacheControl;
    }

    @NotNull
    public Uri getUri() {
        return this.uri;
    }

    public final double getSize() {
        return this.size;
    }

    public boolean isResource() {
        return this._isResource;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        ImageSource that = (ImageSource)other;
        return Double.compare(that.size, this.size) == 0 && this.isResource() == that.isResource() && Intrinsics.areEqual((Object)this.getUri(), (Object)that.getUri()) && Intrinsics.areEqual((Object)this.source, (Object)that.source) && this.cacheControl == that.cacheControl;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.getUri(), this.source, this.size, this.isResource(), this.cacheControl};
        return Objects.hash(objectArray);
    }

    private final Uri computeUri(Context context) {
        Uri uri;
        try {
            Uri uri2 = Uri.parse((String)this.source);
            uri = uri2.getScheme() == null ? this.computeLocalUri(context) : uri2;
            Intrinsics.checkNotNull((Object)uri);
        }
        catch (NullPointerException e) {
            uri = this.computeLocalUri(context);
        }
        return uri;
    }

    private final Uri computeLocalUri(Context context) {
        this._isResource = true;
        return ResourceDrawableIdHelper.getResourceDrawableUri(context, this.source);
    }

    @JvmOverloads
    public ImageSource(@NotNull Context context, @Nullable String source2, double width, double height) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, source2, width, height, null, 16, null);
    }

    @JvmOverloads
    public ImageSource(@NotNull Context context, @Nullable String source2, double width) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, source2, width, 0.0, null, 24, null);
    }

    @JvmOverloads
    public ImageSource(@NotNull Context context, @Nullable String source2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this(context, source2, 0.0, 0.0, null, 28, null);
    }

    @JvmStatic
    @NotNull
    public static final ImageSource getTransparentBitmapImageSource(@NotNull Context context) {
        return Companion.getTransparentBitmapImageSource(context);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/react/views/imagehelper/ImageSource$Companion;", "", "<init>", "()V", "TRANSPARENT_BITMAP_URI", "", "getTransparentBitmapImageSource", "Lcom/facebook/react/views/imagehelper/ImageSource;", "context", "Landroid/content/Context;", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ImageSource getTransparentBitmapImageSource(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return new ImageSource(context, ImageSource.TRANSPARENT_BITMAP_URI, 0.0, 0.0, ImageCacheControl.DEFAULT, 12, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

