/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.style;

import android.content.Context;
import android.graphics.Matrix;
import android.graphics.Shader;
import com.facebook.react.bridge.ColorPropConverter;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.uimanager.FloatUtil;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.style.ColorStop;
import com.facebook.react.uimanager.style.ColorStopUtils;
import com.facebook.react.uimanager.style.Gradient;
import com.facebook.react.uimanager.style.ProcessedColorStop;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 &2\u00020\u0001:\u0004&'()B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0016J<\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J,\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u001b2\u0006\u0010!\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u0018H\u0002J<\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J4\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00180\u001b2\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006*"}, d2={"Lcom/facebook/react/uimanager/style/RadialGradient;", "Lcom/facebook/react/uimanager/style/Gradient;", "shape", "Lcom/facebook/react/uimanager/style/RadialGradient$Shape;", "size", "Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize;", "position", "Lcom/facebook/react/uimanager/style/RadialGradient$Position;", "colorStops", "", "Lcom/facebook/react/uimanager/style/ColorStop;", "<init>", "(Lcom/facebook/react/uimanager/style/RadialGradient$Shape;Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize;Lcom/facebook/react/uimanager/style/RadialGradient$Position;Ljava/util/List;)V", "getShape", "()Lcom/facebook/react/uimanager/style/RadialGradient$Shape;", "getSize", "()Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize;", "getPosition", "()Lcom/facebook/react/uimanager/style/RadialGradient$Position;", "getColorStops", "()Ljava/util/List;", "getShader", "Landroid/graphics/Shader;", "width", "", "height", "radiusToSide", "Lkotlin/Pair;", "centerX", "centerY", "sizeKeyword", "Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize$KeywordType;", "calculateEllipseRadius", "offsetX", "offsetY", "aspectRatio", "radiusToCorner", "calculateRadius", "Companion", "Shape", "GradientSize", "Position", "ReactAndroid_release"})
@SourceDebugExtension(value={"SMAP\nRadialGradient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadialGradient.kt\ncom/facebook/react/uimanager/style/RadialGradient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,376:1\n1878#2,3:377\n*S KotlinDebug\n*F\n+ 1 RadialGradient.kt\ncom/facebook/react/uimanager/style/RadialGradient\n*L\n202#1:377,3\n*E\n"})
public final class RadialGradient
implements Gradient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Shape shape;
    @NotNull
    private final GradientSize size;
    @NotNull
    private final Position position;
    @NotNull
    private final List<ColorStop> colorStops;

    public RadialGradient(@NotNull Shape shape, @NotNull GradientSize size, @NotNull Position position, @NotNull List<ColorStop> colorStops) {
        Intrinsics.checkNotNullParameter((Object)((Object)shape), (String)"shape");
        Intrinsics.checkNotNullParameter((Object)size, (String)"size");
        Intrinsics.checkNotNullParameter((Object)position, (String)"position");
        Intrinsics.checkNotNullParameter(colorStops, (String)"colorStops");
        this.shape = shape;
        this.size = size;
        this.position = position;
        this.colorStops = colorStops;
    }

    @NotNull
    public final Shape getShape() {
        return this.shape;
    }

    @NotNull
    public final GradientSize getSize() {
        return this.size;
    }

    @NotNull
    public final Position getPosition() {
        return this.position;
    }

    @NotNull
    public final List<ColorStop> getColorStops() {
        return this.colorStops;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Shader getShader(float width, float height) {
        boolean isCircle;
        float centerX = width / 2.0f;
        float centerY = height / 2.0f;
        if (this.position.getTop() != null) {
            centerY = this.position.getTop().getType() == LengthPercentageType.PERCENT ? this.position.getTop().resolve(height) : PixelUtil.INSTANCE.dpToPx(this.position.getTop().resolve(height));
        } else if (this.position.getBottom() != null) {
            float f = centerY = this.position.getBottom().getType() == LengthPercentageType.PERCENT ? height - this.position.getBottom().resolve(height) : height - PixelUtil.INSTANCE.dpToPx(this.position.getBottom().resolve(height));
        }
        if (this.position.getLeft() != null) {
            centerX = this.position.getLeft().getType() == LengthPercentageType.PERCENT ? this.position.getLeft().resolve(width) : PixelUtil.INSTANCE.dpToPx(this.position.getLeft().resolve(width));
        } else if (this.position.getRight() != null) {
            centerX = this.position.getRight().getType() == LengthPercentageType.PERCENT ? width - this.position.getRight().resolve(width) : width - PixelUtil.INSTANCE.dpToPx(this.position.getRight().resolve(width));
        }
        Pair<Float, Float> pair = this.calculateRadius(centerX, centerY, width, height);
        float radiusX = ((Number)pair.component1()).floatValue();
        float radiusY = ((Number)pair.component2()).floatValue();
        List<ProcessedColorStop> finalStops = ColorStopUtils.INSTANCE.getFixedColorStops(this.colorStops, Math.max(radiusX, radiusY));
        int[] colors = new int[finalStops.size()];
        float[] positions = new float[finalStops.size()];
        Iterable $this$forEachIndexed$iv = finalStops;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void colorStop;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            ProcessedColorStop processedColorStop = (ProcessedColorStop)item$iv;
            int i = n;
            boolean bl = false;
            Integer color = colorStop.getColor();
            if (color == null || colorStop.getPosition() == null) continue;
            colors[i] = color;
            positions[i] = colorStop.getPosition().floatValue();
        }
        float radius = Math.max(radiusX, 1.0E-5f);
        android.graphics.RadialGradient shader = new android.graphics.RadialGradient(centerX, centerY, radius, colors, positions, Shader.TileMode.CLAMP);
        boolean bl = isCircle = this.shape == Shape.CIRCLE;
        if (!isCircle && !FloatUtil.floatsEqual(radiusX, radiusY)) {
            Matrix matrix = new Matrix();
            matrix.setScale(1.0f, radiusY / radiusX, centerX, centerY);
            shader.setLocalMatrix(matrix);
        }
        return (Shader)shader;
    }

    private final Pair<Float, Float> radiusToSide(float centerX, float centerY, float width, float height, GradientSize.KeywordType sizeKeyword) {
        boolean isCircle;
        float radiusXFromLeftSide = centerX;
        float radiusYFromTopSide = centerY;
        float radiusXFromRightSide = width - centerX;
        float radiusYFromBottomSide = height - centerY;
        float radiusX = 0.0f;
        float radiusY = 0.0f;
        if (sizeKeyword == GradientSize.KeywordType.CLOSEST_SIDE) {
            radiusX = Math.min(radiusXFromLeftSide, radiusXFromRightSide);
            radiusY = Math.min(radiusYFromTopSide, radiusYFromBottomSide);
        } else {
            radiusX = Math.max(radiusXFromLeftSide, radiusXFromRightSide);
            radiusY = Math.max(radiusYFromTopSide, radiusYFromBottomSide);
        }
        boolean bl = isCircle = this.shape == Shape.CIRCLE;
        if (isCircle) {
            float radius = sizeKeyword == GradientSize.KeywordType.CLOSEST_SIDE ? Math.min(radiusX, radiusY) : Math.max(radiusX, radiusY);
            return new Pair((Object)Float.valueOf(radius), (Object)Float.valueOf(radius));
        }
        return new Pair((Object)Float.valueOf(radiusX), (Object)Float.valueOf(radiusY));
    }

    private final Pair<Float, Float> calculateEllipseRadius(float offsetX, float offsetY, float aspectRatio) {
        if (aspectRatio == 0.0f || !(Math.abs(aspectRatio) <= Float.MAX_VALUE)) {
            return new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f));
        }
        float a = (float)Math.sqrt(offsetX * offsetX + offsetY * offsetY * aspectRatio * aspectRatio);
        return new Pair((Object)Float.valueOf(a), (Object)Float.valueOf(a / aspectRatio));
    }

    private final Pair<Float, Float> radiusToCorner(float centerX, float centerY, float width, float height, GradientSize.KeywordType sizeKeyword) {
        boolean isCircle;
        Pair[] pairArray = new Pair[]{new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(0.0f)), new Pair((Object)Float.valueOf(width), (Object)Float.valueOf(0.0f)), new Pair((Object)Float.valueOf(width), (Object)Float.valueOf(height)), new Pair((Object)Float.valueOf(0.0f), (Object)Float.valueOf(height))};
        Pair[] corners = pairArray;
        int cornerIndex = 0;
        float distance = (float)Math.sqrt((float)Math.pow(centerX - ((Number)corners[cornerIndex].getFirst()).floatValue(), 2) + (float)Math.pow(centerY - ((Number)corners[cornerIndex].getSecond()).floatValue(), 2));
        boolean isClosestCorner = sizeKeyword == GradientSize.KeywordType.CLOSEST_CORNER;
        int n = corners.length;
        for (int i = 1; i < n; ++i) {
            float newDistance = (float)Math.sqrt((float)Math.pow(centerX - ((Number)corners[i].getFirst()).floatValue(), 2) + (float)Math.pow(centerY - ((Number)corners[i].getSecond()).floatValue(), 2));
            if (isClosestCorner) {
                if (!(newDistance < distance)) continue;
                distance = newDistance;
                cornerIndex = i;
                continue;
            }
            if (!(newDistance > distance)) continue;
            distance = newDistance;
            cornerIndex = i;
        }
        boolean bl = isCircle = this.shape == Shape.CIRCLE;
        if (isCircle) {
            return new Pair((Object)Float.valueOf(distance), (Object)Float.valueOf(distance));
        }
        GradientSize.KeywordType sideKeyword = isClosestCorner ? GradientSize.KeywordType.CLOSEST_SIDE : GradientSize.KeywordType.FARTHEST_SIDE;
        Pair<Float, Float> sideRadius = this.radiusToSide(centerX, centerY, width, height, sideKeyword);
        return this.calculateEllipseRadius(((Number)corners[cornerIndex].getFirst()).floatValue() - centerX, ((Number)corners[cornerIndex].getSecond()).floatValue() - centerY, ((Number)sideRadius.getFirst()).floatValue() / ((Number)sideRadius.getSecond()).floatValue());
    }

    private final Pair<Float, Float> calculateRadius(float centerX, float centerY, float width, float height) {
        if (this.size instanceof GradientSize.Keyword) {
            GradientSize.KeywordType keyword = ((GradientSize.Keyword)this.size).getKeyword();
            return switch (WhenMappings.$EnumSwitchMapping$0[keyword.ordinal()]) {
                case 1, 2 -> this.radiusToSide(centerX, centerY, width, height, keyword);
                case 3, 4 -> this.radiusToCorner(centerX, centerY, width, height, keyword);
                default -> throw new NoWhenBranchMatchedException();
            };
        }
        if (this.size instanceof GradientSize.Dimensions) {
            Pair pair;
            boolean isCircle;
            float radiusX = ((GradientSize.Dimensions)this.size).getX().getType() == LengthPercentageType.PERCENT ? ((GradientSize.Dimensions)this.size).getX().resolve(width) : PixelUtil.INSTANCE.dpToPx(((GradientSize.Dimensions)this.size).getX().resolve(width));
            float radiusY = ((GradientSize.Dimensions)this.size).getY().getType() == LengthPercentageType.PERCENT ? ((GradientSize.Dimensions)this.size).getY().resolve(height) : PixelUtil.INSTANCE.dpToPx(((GradientSize.Dimensions)this.size).getY().resolve(height));
            boolean bl = isCircle = this.shape == Shape.CIRCLE;
            if (isCircle) {
                float radius = Math.max(radiusX, radiusY);
                pair = new Pair((Object)Float.valueOf(radius), (Object)Float.valueOf(radius));
            } else {
                pair = new Pair((Object)Float.valueOf(radiusX), (Object)Float.valueOf(radiusY));
            }
            return pair;
        }
        return this.radiusToCorner(centerX, centerY, width, height, GradientSize.KeywordType.FARTHEST_CORNER);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Lcom/facebook/react/uimanager/style/RadialGradient$Companion;", "", "<init>", "()V", "parse", "Lcom/facebook/react/uimanager/style/Gradient;", "gradientMap", "Lcom/facebook/react/bridge/ReadableMap;", "context", "Landroid/content/Context;", "ReactAndroid_release"})
    @SourceDebugExtension(value={"SMAP\nRadialGradient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadialGradient.kt\ncom/facebook/react/uimanager/style/RadialGradient$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,376:1\n1#2:377\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         */
        @Nullable
        public final Gradient parse(@NotNull ReadableMap gradientMap, @NotNull Context context) {
            block29: {
                block28: {
                    Intrinsics.checkNotNullParameter((Object)gradientMap, (String)"gradientMap");
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    it = var5_3 = gradientMap;
                    $i$a$-takeIf-RadialGradient$Companion$parse$shape$1 = false;
                    v0 = var4_7 = it.hasKey("shape") != false ? var5_3 : null;
                    if (var4_7 != null) {
                        map = var4_7;
                        $i$a$-let-RadialGradient$Companion$parse$shape$2 = false;
                        v1 = map.getString("shape");
                        if (v1 != null) {
                            shapeString = v1;
                            $i$a$-let-RadialGradient$Companion$parse$shape$2$1 = false;
                            v2 = Shape.Companion.fromString(shapeString);
                        } else {
                            v2 = null;
                        }
                    } else {
                        v2 = null;
                    }
                    shape = v2;
                    it = map = gradientMap;
                    $i$a$-takeIf-RadialGradient$Companion$parse$size$1 = false;
                    v3 = var5_3 = it.hasKey("size") != false ? map : null;
                    if (var5_3 == null) break block28;
                    map = var5_3;
                    $i$a$-let-RadialGradient$Companion$parse$size$2 = false;
                    switch (WhenMappings.$EnumSwitchMapping$0[map.getType("size").ordinal()]) {
                        case 1: {
                            v4 = GradientSize.KeywordType.Companion.fromString(map.getString("size"));
                            if (v4 != null) {
                                keywordType = v4;
                                $i$a$-let-RadialGradient$Companion$parse$size$2$1 = false;
                                v5 = new GradientSize.Keyword(keywordType);
                            } else {
                                v5 = null;
                            }
                            v6 = v5;
                            break;
                        }
                        case 2: {
                            var11_21 = map.getMap("size");
                            if (var11_21 == null) ** GOTO lbl-1000
                            it = keywordType = var11_21;
                            $i$a$-takeIf-RadialGradient$Companion$parse$size$2$2 = false;
                            v7 = var13_25 = (it.hasKey("x") != false && it.hasKey("y") != false) != false ? keywordType : null;
                            if (var13_25 != null) {
                                sizeMap = var13_25;
                                $i$a$-let-RadialGradient$Companion$parse$size$2$3 = false;
                                x = LengthPercentage.Companion.setFromDynamic(sizeMap.getDynamic("x"));
                                y = LengthPercentage.Companion.setFromDynamic(sizeMap.getDynamic("y"));
                                v8 = x != null && y != null ? new GradientSize.Dimensions(x, y) : null;
                            } else lbl-1000:
                            // 2 sources

                            {
                                v8 = null;
                            }
                            v6 = v8;
                            break;
                        }
                        default: {
                            v6 = null;
                        }
                    }
                    break block29;
                }
                v6 = null;
            }
            size = v6;
            it = var7_6 = gradientMap;
            $i$a$-takeIf-RadialGradient$Companion$parse$position$1 = false;
            v9 = map = it.hasKey("position") != false ? var7_6 : null;
            if (map != null) {
                map = map;
                $i$a$-let-RadialGradient$Companion$parse$position$2 = false;
                v10 = map.getMap("position");
                if (v10 == null) {
                    return null;
                }
                positionMap = v10;
                top = null;
                left = null;
                right = null;
                bottom = null;
                if (positionMap.hasKey("top")) {
                    rawTop = positionMap.getDynamic("top");
                    top = LengthPercentage.Companion.setFromDynamic(rawTop);
                } else if (positionMap.hasKey("bottom")) {
                    rawBottom = positionMap.getDynamic("bottom");
                    bottom = LengthPercentage.Companion.setFromDynamic(rawBottom);
                } else {
                    return null;
                }
                if (positionMap.hasKey("left")) {
                    rawLeft = positionMap.getDynamic("left");
                    left = LengthPercentage.Companion.setFromDynamic(rawLeft);
                } else if (positionMap.hasKey("right")) {
                    rawRight = positionMap.getDynamic("right");
                    right = LengthPercentage.Companion.setFromDynamic(rawRight);
                } else {
                    return null;
                }
                v11 = new Position(top, left, right, bottom);
            } else {
                v11 = null;
            }
            position = v11;
            it = var8_10 = gradientMap;
            $i$a$-takeIf-RadialGradient$Companion$parse$colorStops$1 = false;
            v12 = var7_6 = it.hasKey("colorStops") != false ? var8_10 : null;
            if (var7_6 != null) {
                map = var7_6;
                $i$a$-let-RadialGradient$Companion$parse$colorStops$2 = false;
                v13 = map.getArray("colorStops");
                if (v13 == null) {
                    return null;
                }
                colorStopsArray = v13;
                stops = new ArrayList<ColorStop>(colorStopsArray.size());
                var14_28 = colorStopsArray.size();
                for (i = 0; i < var14_28; ++i) {
                    if (colorStopsArray.getMap(i) == null) continue;
                    color = colorStop.hasKey("color") == false || colorStop.isNull("color") != false ? null : (colorStop.getType("color") == ReadableType.Map ? ColorPropConverter.getColor(colorStop.getMap("color"), context) : Integer.valueOf(colorStop.getInt("color")));
                    colorStopPosition = LengthPercentage.Companion.setFromDynamic(colorStop.getDynamic("position"));
                    stops.add(new ColorStop(color, colorStopPosition));
                }
                v14 = stops;
            } else {
                v14 = colorStops = null;
            }
            if (shape != null && size != null && position != null && colorStops != null) {
                return new RadialGradient(shape, size, position, (List<ColorStop>)colorStops);
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[ReadableType.values().length];
                try {
                    nArray[ReadableType.String.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[ReadableType.Map.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0004\u0005\u0006B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0007\b\u00a8\u0006\t"}, d2={"Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize;", "", "<init>", "()V", "Keyword", "Dimensions", "KeywordType", "Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize$Dimensions;", "Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize$Keyword;", "ReactAndroid_release"})
    public static abstract class GradientSize {
        private GradientSize() {
        }

        public /* synthetic */ GradientSize(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\n"}, d2={"Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize$Dimensions;", "Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize;", "x", "Lcom/facebook/react/uimanager/LengthPercentage;", "y", "<init>", "(Lcom/facebook/react/uimanager/LengthPercentage;Lcom/facebook/react/uimanager/LengthPercentage;)V", "getX", "()Lcom/facebook/react/uimanager/LengthPercentage;", "getY", "ReactAndroid_release"})
        public static final class Dimensions
        extends GradientSize {
            @NotNull
            private final LengthPercentage x;
            @NotNull
            private final LengthPercentage y;

            public Dimensions(@NotNull LengthPercentage x, @NotNull LengthPercentage y) {
                Intrinsics.checkNotNullParameter((Object)x, (String)"x");
                Intrinsics.checkNotNullParameter((Object)y, (String)"y");
                super(null);
                this.x = x;
                this.y = y;
            }

            @NotNull
            public final LengthPercentage getX() {
                return this.x;
            }

            @NotNull
            public final LengthPercentage getY() {
                return this.y;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize$Keyword;", "Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize;", "keyword", "Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize$KeywordType;", "<init>", "(Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize$KeywordType;)V", "getKeyword", "()Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize$KeywordType;", "ReactAndroid_release"})
        public static final class Keyword
        extends GradientSize {
            @NotNull
            private final KeywordType keyword;

            public Keyword(@NotNull KeywordType keyword) {
                Intrinsics.checkNotNullParameter((Object)((Object)keyword), (String)"keyword");
                super(null);
                this.keyword = keyword;
            }

            @NotNull
            public final KeywordType getKeyword() {
                return this.keyword;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u0000 \f2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\fB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\r"}, d2={"Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize$KeywordType;", "", "value", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getValue", "()Ljava/lang/String;", "CLOSEST_SIDE", "FARTHEST_SIDE", "CLOSEST_CORNER", "FARTHEST_CORNER", "Companion", "ReactAndroid_release"})
        public static final class KeywordType
        extends Enum<KeywordType> {
            @NotNull
            public static final Companion Companion;
            @NotNull
            private final String value;
            public static final /* enum */ KeywordType CLOSEST_SIDE;
            public static final /* enum */ KeywordType FARTHEST_SIDE;
            public static final /* enum */ KeywordType CLOSEST_CORNER;
            public static final /* enum */ KeywordType FARTHEST_CORNER;
            private static final /* synthetic */ KeywordType[] $VALUES;
            private static final /* synthetic */ EnumEntries $ENTRIES;

            private KeywordType(String value) {
                this.value = value;
            }

            @NotNull
            public final String getValue() {
                return this.value;
            }

            public static KeywordType[] values() {
                return (KeywordType[])$VALUES.clone();
            }

            public static KeywordType valueOf(String value) {
                return Enum.valueOf(KeywordType.class, value);
            }

            @NotNull
            public static EnumEntries<KeywordType> getEntries() {
                return $ENTRIES;
            }

            static {
                CLOSEST_SIDE = new KeywordType("closest-side");
                FARTHEST_SIDE = new KeywordType("farthest-side");
                CLOSEST_CORNER = new KeywordType("closest-corner");
                FARTHEST_CORNER = new KeywordType("farthest-corner");
                $VALUES = keywordTypeArray = new KeywordType[]{KeywordType.CLOSEST_SIDE, KeywordType.FARTHEST_SIDE, KeywordType.CLOSEST_CORNER, KeywordType.FARTHEST_CORNER};
                $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
                Companion = new Companion(null);
            }

            @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize$KeywordType$Companion;", "", "<init>", "()V", "fromString", "Lcom/facebook/react/uimanager/style/RadialGradient$GradientSize$KeywordType;", "value", "", "ReactAndroid_release"})
            @SourceDebugExtension(value={"SMAP\nRadialGradient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RadialGradient.kt\ncom/facebook/react/uimanager/style/RadialGradient$GradientSize$KeywordType$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,376:1\n1#2:377\n*E\n"})
            public static final class Companion {
                private Companion() {
                }

                @Nullable
                public final KeywordType fromString(@Nullable String value) {
                    KeywordType keywordType;
                    block1: {
                        KeywordType[] keywordTypeArray = KeywordType.values();
                        int n = keywordTypeArray.length;
                        for (int i = 0; i < n; ++i) {
                            KeywordType keywordType2;
                            KeywordType it = keywordType2 = keywordTypeArray[i];
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it.getValue(), (Object)value)) continue;
                            keywordType = keywordType2;
                            break block1;
                        }
                        keywordType = null;
                    }
                    return keywordType;
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u00002\u00020\u0001B7\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\n\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/uimanager/style/RadialGradient$Position;", "", "top", "Lcom/facebook/react/uimanager/LengthPercentage;", "left", "right", "bottom", "<init>", "(Lcom/facebook/react/uimanager/LengthPercentage;Lcom/facebook/react/uimanager/LengthPercentage;Lcom/facebook/react/uimanager/LengthPercentage;Lcom/facebook/react/uimanager/LengthPercentage;)V", "getTop", "()Lcom/facebook/react/uimanager/LengthPercentage;", "getLeft", "getRight", "getBottom", "ReactAndroid_release"})
    public static final class Position {
        @Nullable
        private final LengthPercentage top;
        @Nullable
        private final LengthPercentage left;
        @Nullable
        private final LengthPercentage right;
        @Nullable
        private final LengthPercentage bottom;

        public Position(@Nullable LengthPercentage top, @Nullable LengthPercentage left, @Nullable LengthPercentage right, @Nullable LengthPercentage bottom) {
            this.top = top;
            this.left = left;
            this.right = right;
            this.bottom = bottom;
        }

        public /* synthetic */ Position(LengthPercentage lengthPercentage, LengthPercentage lengthPercentage2, LengthPercentage lengthPercentage3, LengthPercentage lengthPercentage4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                lengthPercentage = null;
            }
            if ((n & 2) != 0) {
                lengthPercentage2 = null;
            }
            if ((n & 4) != 0) {
                lengthPercentage3 = null;
            }
            if ((n & 8) != 0) {
                lengthPercentage4 = null;
            }
            this(lengthPercentage, lengthPercentage2, lengthPercentage3, lengthPercentage4);
        }

        @Nullable
        public final LengthPercentage getTop() {
            return this.top;
        }

        @Nullable
        public final LengthPercentage getLeft() {
            return this.left;
        }

        @Nullable
        public final LengthPercentage getRight() {
            return this.right;
        }

        @Nullable
        public final LengthPercentage getBottom() {
            return this.bottom;
        }

        public Position() {
            this(null, null, null, null, 15, null);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0080\u0081\u0002\u0018\u0000 \u00062\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0006B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/uimanager/style/RadialGradient$Shape;", "", "<init>", "(Ljava/lang/String;I)V", "CIRCLE", "ELLIPSE", "Companion", "ReactAndroid_release"})
    public static final class Shape
    extends Enum<Shape> {
        @NotNull
        public static final Companion Companion;
        public static final /* enum */ Shape CIRCLE;
        public static final /* enum */ Shape ELLIPSE;
        private static final /* synthetic */ Shape[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Shape[] values() {
            return (Shape[])$VALUES.clone();
        }

        public static Shape valueOf(String value) {
            return Enum.valueOf(Shape.class, value);
        }

        @NotNull
        public static EnumEntries<Shape> getEntries() {
            return $ENTRIES;
        }

        static {
            CIRCLE = new Shape();
            ELLIPSE = new Shape();
            $VALUES = shapeArray = new Shape[]{Shape.CIRCLE, Shape.ELLIPSE};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
            Companion = new Companion(null);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/facebook/react/uimanager/style/RadialGradient$Shape$Companion;", "", "<init>", "()V", "fromString", "Lcom/facebook/react/uimanager/style/RadialGradient$Shape;", "value", "", "ReactAndroid_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Shape fromString(@NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                String string2 = value;
                return Intrinsics.areEqual((Object)string2, (Object)"circle") ? CIRCLE : (Intrinsics.areEqual((Object)string2, (Object)"ellipse") ? ELLIPSE : null);
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GradientSize.KeywordType.values().length];
            try {
                nArray[GradientSize.KeywordType.CLOSEST_SIDE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradientSize.KeywordType.FARTHEST_SIDE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradientSize.KeywordType.CLOSEST_CORNER.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[GradientSize.KeywordType.FARTHEST_CORNER.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

