/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.view.MotionEvent;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.RCTModernEventEmitter;
import com.facebook.react.uimanager.events.TouchEvent;
import com.facebook.react.uimanager.events.TouchEventType;
import com.facebook.systrace.Systrace;
import java.util.Iterator;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\u0010\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0014H\u0007J\u0018\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J%\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\u000e\u0010\"\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u0011H\u0002\u00a2\u0006\u0002\u0010#R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087D\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/facebook/react/uimanager/events/TouchesHelper;", "", "<init>", "()V", "TARGET_KEY", "", "getTARGET_KEY$annotations", "TARGET_SURFACE_KEY", "CHANGED_TOUCHES_KEY", "TOUCHES_KEY", "PAGE_X_KEY", "PAGE_Y_KEY", "TIMESTAMP_KEY", "POINTER_IDENTIFIER_KEY", "LOCATION_X_KEY", "LOCATION_Y_KEY", "createPointersArray", "", "Lcom/facebook/react/bridge/WritableMap;", "event", "Lcom/facebook/react/uimanager/events/TouchEvent;", "(Lcom/facebook/react/uimanager/events/TouchEvent;)[Lcom/facebook/react/bridge/WritableMap;", "sendTouchesLegacy", "", "rctEventEmitter", "Lcom/facebook/react/uimanager/events/RCTEventEmitter;", "touchEvent", "sendTouchEvent", "eventEmitter", "Lcom/facebook/react/uimanager/events/RCTModernEventEmitter;", "getWritableArray", "Lcom/facebook/react/bridge/WritableArray;", "copyObjects", "", "objects", "(Z[Lcom/facebook/react/bridge/WritableMap;)Lcom/facebook/react/bridge/WritableArray;", "ReactAndroid_release"})
public final class TouchesHelper {
    @NotNull
    public static final TouchesHelper INSTANCE = new TouchesHelper();
    @JvmField
    @NotNull
    public static final String TARGET_KEY = "target";
    @NotNull
    private static final String TARGET_SURFACE_KEY = "targetSurface";
    @NotNull
    private static final String CHANGED_TOUCHES_KEY = "changedTouches";
    @NotNull
    private static final String TOUCHES_KEY = "touches";
    @NotNull
    private static final String PAGE_X_KEY = "pageX";
    @NotNull
    private static final String PAGE_Y_KEY = "pageY";
    @NotNull
    private static final String TIMESTAMP_KEY = "timestamp";
    @NotNull
    private static final String POINTER_IDENTIFIER_KEY = "identifier";
    @NotNull
    private static final String LOCATION_X_KEY = "locationX";
    @NotNull
    private static final String LOCATION_Y_KEY = "locationY";

    private TouchesHelper() {
    }

    @Deprecated(message="Not used in New Architecture")
    public static /* synthetic */ void getTARGET_KEY$annotations() {
    }

    private final WritableMap[] createPointersArray(TouchEvent event) {
        MotionEvent motionEvent = event.getMotionEvent();
        WritableMap[] touches = new WritableMap[motionEvent.getPointerCount()];
        float targetViewCoordinateX = motionEvent.getX() - event.getViewX();
        float targetViewCoordinateY = motionEvent.getY() - event.getViewY();
        int n = motionEvent.getPointerCount();
        for (int index = 0; index < n; ++index) {
            WritableMap touch;
            Intrinsics.checkNotNullExpressionValue((Object)Arguments.createMap(), (String)"createMap(...)");
            touch.putDouble(PAGE_X_KEY, PixelUtil.INSTANCE.pxToDp(motionEvent.getX(index)));
            touch.putDouble(PAGE_Y_KEY, PixelUtil.INSTANCE.pxToDp(motionEvent.getY(index)));
            float locationX = motionEvent.getX(index) - targetViewCoordinateX;
            float locationY = motionEvent.getY(index) - targetViewCoordinateY;
            touch.putDouble(LOCATION_X_KEY, PixelUtil.INSTANCE.pxToDp(locationX));
            touch.putDouble(LOCATION_Y_KEY, PixelUtil.INSTANCE.pxToDp(locationY));
            touch.putInt(TARGET_SURFACE_KEY, event.getSurfaceId());
            touch.putInt(TARGET_KEY, event.getViewTag());
            touch.putDouble(TIMESTAMP_KEY, event.getTimestampMs());
            touch.putDouble(POINTER_IDENTIFIER_KEY, motionEvent.getPointerId(index));
            touches[index] = touch;
        }
        return touches;
    }

    @JvmStatic
    public static final void sendTouchesLegacy(@NotNull RCTEventEmitter rctEventEmitter, @NotNull TouchEvent touchEvent) {
        Intrinsics.checkNotNullParameter((Object)rctEventEmitter, (String)"rctEventEmitter");
        Intrinsics.checkNotNullParameter((Object)touchEvent, (String)"touchEvent");
        TouchEventType type = touchEvent.getTouchEventType();
        WritableArray pointers = INSTANCE.getWritableArray(false, INSTANCE.createPointersArray(touchEvent));
        MotionEvent motionEvent = touchEvent.getMotionEvent();
        WritableArray writableArray = Arguments.createArray();
        Intrinsics.checkNotNullExpressionValue((Object)writableArray, (String)"createArray(...)");
        WritableArray changedIndices = writableArray;
        if (type == TouchEventType.MOVE || type == TouchEventType.CANCEL) {
            int n = motionEvent.getPointerCount();
            for (int i = 0; i < n; ++i) {
                changedIndices.pushInt(i);
            }
        } else if (type == TouchEventType.START || type == TouchEventType.END) {
            changedIndices.pushInt(motionEvent.getActionIndex());
        } else {
            throw new RuntimeException("Unknown touch type: " + type);
        }
        rctEventEmitter.receiveTouches(TouchEventType.Companion.getJSEventName(type), pointers, changedIndices);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final void sendTouchEvent(@NotNull RCTModernEventEmitter eventEmitter, @NotNull TouchEvent event) {
        Intrinsics.checkNotNullParameter((Object)eventEmitter, (String)"eventEmitter");
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Systrace.beginSection(0L, "TouchesHelper.sentTouchEventModern(" + event.getEventName() + ")");
        try {
            TouchEventType type = event.getTouchEventType();
            MotionEvent motionEvent = event.getMotionEvent();
            WritableMap[] touches = null;
            touches = INSTANCE.createPointersArray(event);
            WritableMap[] changedTouches = null;
            switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                case 1: {
                    int newPointerIndex = motionEvent.getActionIndex();
                    WritableMap[] writableMapArray = new WritableMap[1];
                    WritableMap writableMap = touches[newPointerIndex];
                    writableMapArray[0] = writableMap != null ? writableMap.copy() : null;
                    changedTouches = writableMapArray;
                    break;
                }
                case 2: {
                    int finishedPointerIndex = motionEvent.getActionIndex();
                    WritableMap finishedPointer = touches[finishedPointerIndex];
                    touches[finishedPointerIndex] = null;
                    WritableMap[] writableMapArray = new WritableMap[]{finishedPointer};
                    changedTouches = writableMapArray;
                    break;
                }
                case 3: {
                    changedTouches = new WritableMap[((Object[])touches).length];
                    for (int i = 0; i < ((Object[])touches).length; ++i) {
                        WritableMap writableMap = touches[i];
                        changedTouches[i] = writableMap != null ? writableMap.copy() : null;
                    }
                    break;
                }
                case 4: {
                    changedTouches = touches;
                    touches = new WritableMap[]{};
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            Iterator iterator2 = ArrayIteratorKt.iterator((Object[])changedTouches);
            while (iterator2.hasNext()) {
                WritableMap writableMap;
                WritableMap touchData = (WritableMap)iterator2.next();
                if (touchData != null) {
                    WritableMap td;
                    boolean bl = false;
                    WritableMap ed = td.copy();
                    WritableArray changedTouchesArray = INSTANCE.getWritableArray(true, changedTouches);
                    WritableArray touchesArray = INSTANCE.getWritableArray(true, touches);
                    ed.putArray(CHANGED_TOUCHES_KEY, changedTouchesArray);
                    ed.putArray(TOUCHES_KEY, touchesArray);
                    writableMap = ed;
                } else {
                    writableMap = null;
                }
                WritableMap eventData = writableMap;
                eventEmitter.receiveEvent(event.getSurfaceId(), event.getViewTag(), event.getEventName(), event.canCoalesce(), 0, eventData, event.getEventCategory());
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    private final WritableArray getWritableArray(boolean copyObjects, WritableMap[] objects) {
        WritableArray writableArray = Arguments.createArray();
        Intrinsics.checkNotNullExpressionValue((Object)writableArray, (String)"createArray(...)");
        WritableArray result = writableArray;
        for (WritableMap obj : objects) {
            if (obj == null) continue;
            result.pushMap(copyObjects ? obj.copy() : obj);
        }
        return result;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TouchEventType.values().length];
            try {
                nArray[TouchEventType.START.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TouchEventType.END.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TouchEventType.MOVE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TouchEventType.CANCEL.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

