/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.internal.featureflags;

import android.annotation.SuppressLint;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007J\b\u0010\u0006\u001a\u00020\u0005H\u0007J\b\u0010\u0007\u001a\u00020\u0005H\u0007J\b\u0010\b\u001a\u00020\u0005H\u0007J\b\u0010\t\u001a\u00020\u0005H\u0007J\b\u0010\n\u001a\u00020\u0005H\u0007\u00a8\u0006\u000b"}, d2={"Lcom/facebook/react/internal/featureflags/ReactNativeNewArchitectureFeatureFlags;", "", "<init>", "()V", "isNewArchitectureStrictModeEnabled", "", "enableBridgelessArchitecture", "enableFabricRenderer", "useFabricInterop", "useTurboModuleInterop", "useTurboModules", "ReactAndroid_release"})
@SuppressLint(value={"UseReactNativeNewArchitectureFeatureFlagDetector"})
public final class ReactNativeNewArchitectureFeatureFlags {
    @NotNull
    public static final ReactNativeNewArchitectureFeatureFlags INSTANCE = new ReactNativeNewArchitectureFeatureFlags();

    private ReactNativeNewArchitectureFeatureFlags() {
    }

    @JvmStatic
    public static final boolean isNewArchitectureStrictModeEnabled() {
        return ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE;
    }

    @JvmStatic
    public static final boolean enableBridgelessArchitecture() {
        if (ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE) {
            Assertions.assertCondition((boolean)ReactNativeFeatureFlags.enableBridgelessArchitecture(), (String)"ReactNativeFeatureFlags.enableBridgelessArchitecture() should be set to TRUE when Strict Mode is enabled");
            return true;
        }
        return ReactNativeFeatureFlags.enableBridgelessArchitecture();
    }

    @JvmStatic
    public static final boolean enableFabricRenderer() {
        if (ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE) {
            Assertions.assertCondition((boolean)ReactNativeFeatureFlags.enableFabricRenderer(), (String)"ReactNativeFeatureFlags.enableFabricRenderer() should be set to TRUE when Strict Mode is enabled");
            return true;
        }
        return ReactNativeFeatureFlags.enableFabricRenderer();
    }

    @JvmStatic
    public static final boolean useFabricInterop() {
        if (ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE) {
            Assertions.assertCondition((!ReactNativeFeatureFlags.useFabricInterop() ? 1 : 0) != 0, (String)"ReactNativeFeatureFlags.useFabricInterop() should be set to FALSE when Strict Mode is enabled");
            return false;
        }
        return ReactNativeFeatureFlags.useFabricInterop();
    }

    @JvmStatic
    public static final boolean useTurboModuleInterop() {
        if (ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE) {
            Assertions.assertCondition((!ReactNativeFeatureFlags.useTurboModuleInterop() ? 1 : 0) != 0, (String)"ReactNativeFeatureFlags.useTurboModuleInterop() should be set to FALSE when Strict Mode is enabled");
            return false;
        }
        return ReactNativeFeatureFlags.useTurboModuleInterop();
    }

    @JvmStatic
    public static final boolean useTurboModules() {
        if (ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE) {
            Assertions.assertCondition((boolean)ReactNativeFeatureFlags.useTurboModules(), (String)"ReactNativeFeatureFlags.useTurboModules() should be set to TRUE when Strict Mode is enabled");
            return true;
        }
        return ReactNativeFeatureFlags.useTurboModules();
    }
}

