/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric.mounting.mountitems;

import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.fabric.mounting.MountingManager;
import com.facebook.react.fabric.mounting.SurfaceMountingManager;
import com.facebook.react.fabric.mounting.mountitems.FabricNameComponentMapping;
import com.facebook.react.fabric.mounting.mountitems.MountItem;
import com.facebook.react.uimanager.StateWrapper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0010\u001a\u00020\u0003H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0006H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/fabric/mounting/mountitems/PreAllocateViewMountItem;", "Lcom/facebook/react/fabric/mounting/mountitems/MountItem;", "surfaceId", "", "reactTag", "component", "", "props", "Lcom/facebook/react/bridge/ReadableMap;", "stateWrapper", "Lcom/facebook/react/uimanager/StateWrapper;", "isLayoutable", "", "<init>", "(IILjava/lang/String;Lcom/facebook/react/bridge/ReadableMap;Lcom/facebook/react/uimanager/StateWrapper;Z)V", "fabricComponentName", "getSurfaceId", "execute", "", "mountingManager", "Lcom/facebook/react/fabric/mounting/MountingManager;", "toString", "ReactAndroid_release"})
public final class PreAllocateViewMountItem
implements MountItem {
    private final int surfaceId;
    private final int reactTag;
    @Nullable
    private final ReadableMap props;
    @Nullable
    private final StateWrapper stateWrapper;
    private final boolean isLayoutable;
    @NotNull
    private final String fabricComponentName;

    public PreAllocateViewMountItem(int surfaceId, int reactTag, @NotNull String component, @Nullable ReadableMap props, @Nullable StateWrapper stateWrapper, boolean isLayoutable) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this.surfaceId = surfaceId;
        this.reactTag = reactTag;
        this.props = props;
        this.stateWrapper = stateWrapper;
        this.isLayoutable = isLayoutable;
        this.fabricComponentName = FabricNameComponentMapping.getFabricComponentName(component);
    }

    @Override
    public int getSurfaceId() {
        return this.surfaceId;
    }

    @Override
    public void execute(@NotNull MountingManager mountingManager) {
        Intrinsics.checkNotNullParameter((Object)mountingManager, (String)"mountingManager");
        SurfaceMountingManager surfaceMountingManager = mountingManager.getSurfaceManager(this.surfaceId);
        if (surfaceMountingManager == null) {
            FLog.e((String)FabricUIManager.TAG, (String)("Skipping View PreAllocation; no SurfaceMountingManager found for [" + this.surfaceId + "]"));
            return;
        }
        surfaceMountingManager.preallocateView(this.fabricComponentName, this.reactTag, this.props, this.stateWrapper, this.isLayoutable);
    }

    @NotNull
    public String toString() {
        StringBuilder result = new StringBuilder("PreAllocateViewMountItem [").append(this.reactTag).append("] - component: ").append(this.fabricComponentName).append(" surfaceId: ").append(this.surfaceId).append(" isLayoutable: ").append(this.isLayoutable);
        if (FabricUIManager.IS_DEVELOPMENT_ENVIRONMENT) {
            StringBuilder stringBuilder = result.append(" props: ");
            Object object = this.props;
            if (object == null || (object = object.toString()) == null) {
                object = "<null>";
            }
            StringBuilder stringBuilder2 = stringBuilder.append((String)object).append(" state: ");
            Object object2 = this.stateWrapper;
            if (object2 == null || (object2 = object2.toString()) == null) {
                object2 = "<null>";
            }
            stringBuilder2.append((String)object2);
        }
        String string2 = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }
}

