/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.infer.annotation.Assertions;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableNativeArray;
import com.facebook.react.bridge.ReadableNativeMap;
import com.facebook.react.bridge.WritableMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0019\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0096 J\u0019\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fH\u0096 J\u0019\u0010\r\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000eH\u0096 J\u0019\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0010H\u0096 J\u0011\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0096 J\u001b\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0096 J\u001a\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0014H\u0016J\u001a\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0014H\u0016J\b\u0010\u0019\u001a\u00020\u0002H\u0016J\u001b\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u0001H\u0082 J\u001b\u0010\u001b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\u001cH\u0082 J\u0011\u0010\u001d\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\u0001H\u0082 J\t\u0010\u001e\u001a\u00020\u0006H\u0082 \u00a8\u0006\u001f"}, d2={"Lcom/facebook/react/bridge/WritableNativeMap;", "Lcom/facebook/react/bridge/ReadableNativeMap;", "Lcom/facebook/react/bridge/WritableMap;", "<init>", "()V", "putBoolean", "", "key", "", "value", "", "putDouble", "", "putInt", "", "putLong", "", "putNull", "putString", "putMap", "Lcom/facebook/react/bridge/ReadableMap;", "putArray", "Lcom/facebook/react/bridge/ReadableArray;", "merge", "source", "copy", "putNativeMap", "putNativeArray", "Lcom/facebook/react/bridge/ReadableNativeArray;", "mergeNativeMap", "initHybrid", "ReactAndroid_release"})
@DoNotStrip
public final class WritableNativeMap
extends ReadableNativeMap
implements WritableMap {
    public WritableNativeMap() {
        this.initHybrid();
    }

    @Override
    public native void putBoolean(@NotNull String var1, boolean var2);

    @Override
    public native void putDouble(@NotNull String var1, double var2);

    @Override
    public native void putInt(@NotNull String var1, int var2);

    @Override
    public native void putLong(@NotNull String var1, long var2);

    @Override
    public native void putNull(@NotNull String var1);

    @Override
    public native void putString(@NotNull String var1, @Nullable String var2);

    @Override
    public void putMap(@NotNull String key, @Nullable ReadableMap value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Assertions.assertCondition((value == null || value instanceof ReadableNativeMap ? 1 : 0) != 0, (String)"Illegal type provided");
        this.putNativeMap(key, (ReadableNativeMap)value);
    }

    @Override
    public void putArray(@NotNull String key, @Nullable ReadableArray value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Assertions.assertCondition((value == null || value instanceof ReadableNativeArray ? 1 : 0) != 0, (String)"Illegal type provided");
        this.putNativeArray(key, (ReadableNativeArray)value);
    }

    @Override
    public void merge(@NotNull ReadableMap source2) {
        Intrinsics.checkNotNullParameter((Object)source2, (String)"source");
        Assertions.assertCondition((boolean)(source2 instanceof ReadableNativeMap), (String)"Illegal type provided");
        this.mergeNativeMap((ReadableNativeMap)source2);
    }

    @Override
    @NotNull
    public WritableMap copy() {
        WritableNativeMap target = new WritableNativeMap();
        target.merge(this);
        return target;
    }

    private final native void putNativeMap(String var1, ReadableNativeMap var2);

    private final native void putNativeArray(String var1, ReadableNativeArray var2);

    private final native void mergeNativeMap(ReadableNativeMap var1);

    private final native void initHybrid();
}

