/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.text.Editable;
import android.text.TextWatcher;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.textinput.ReactEditText;
import com.facebook.react.views.textinput.ReactTextChangedEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J(\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u0014\u001a\u00020\u000bH\u0016J(\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u000bH\u0016J\u0010\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/react/views/textinput/ReactTextInputTextWatcher;", "Landroid/text/TextWatcher;", "reactContext", "Lcom/facebook/react/bridge/ReactContext;", "editText", "Lcom/facebook/react/views/textinput/ReactEditText;", "<init>", "(Lcom/facebook/react/bridge/ReactContext;Lcom/facebook/react/views/textinput/ReactEditText;)V", "eventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "surfaceId", "", "previousText", "", "beforeTextChanged", "", "s", "", "start", "count", "after", "onTextChanged", "before", "afterTextChanged", "Landroid/text/Editable;", "ReactAndroid_debug"})
public final class ReactTextInputTextWatcher
implements TextWatcher {
    @NotNull
    private final ReactEditText editText;
    @Nullable
    private final EventDispatcher eventDispatcher;
    private final int surfaceId;
    @Nullable
    private String previousText;

    public ReactTextInputTextWatcher(@NotNull ReactContext reactContext, @NotNull ReactEditText editText) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Intrinsics.checkNotNullParameter((Object)((Object)editText), (String)"editText");
        this.editText = editText;
        this.eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag(reactContext, this.editText.getId());
        this.surfaceId = UIManagerHelper.getSurfaceId((Context)reactContext);
    }

    public void beforeTextChanged(@NotNull CharSequence s, int start, int count, int after) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.previousText = ((Object)s).toString();
    }

    public void onTextChanged(@NotNull CharSequence s, int start, int before, int count) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
            if (this.editText.getDisableTextDiffing$ReactAndroid_debug()) {
                return;
            }
            if (count == 0 && before == 0) {
                return;
            }
            String string2 = ((Object)s).toString().substring(start, start + count);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            String newText = string2;
            String string3 = this.previousText;
            if (string3 == null) {
                String string4 = "Required value was null.";
                throw new IllegalStateException(string4.toString());
            }
            String string5 = string3;
            int n = start + before;
            String string6 = string5.substring(start, n);
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
            String oldText = string6;
            if (count == before && Intrinsics.areEqual((Object)newText, (Object)oldText)) {
                return;
            }
            StateWrapper stateWrapper = this.editText.getStateWrapper();
            if (stateWrapper != null) {
                WritableMap newStateData = new WritableNativeMap();
                newStateData.putInt("mostRecentEventCount", this.editText.incrementAndGetEventCounter());
                newStateData.putInt("opaqueCacheId", this.editText.getId());
                stateWrapper.updateState(newStateData);
            }
            EventDispatcher eventDispatcher = this.eventDispatcher;
            if (eventDispatcher == null) break block5;
            eventDispatcher.dispatchEvent(new ReactTextChangedEvent(this.surfaceId, this.editText.getId(), ((Object)s).toString(), this.editText.incrementAndGetEventCounter()));
        }
    }

    public void afterTextChanged(@NotNull Editable s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
    }
}

