/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.text.Spannable;
import android.text.Spanned;
import android.view.View;
import com.facebook.react.R;
import com.facebook.react.internal.SystraceSection;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.IViewGroupManager;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.ReactStylesDiffMap;
import com.facebook.react.uimanager.ReferenceStateWrapper;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.BorderStyle;
import com.facebook.react.uimanager.style.LogicalEdge;
import com.facebook.react.uimanager.style.Overflow;
import com.facebook.react.views.text.DefaultStyleValuesUtil;
import com.facebook.react.views.text.PreparedLayout;
import com.facebook.react.views.text.PreparedLayoutTextView;
import com.facebook.react.views.text.ReactTextViewAccessibilityDelegate;
import com.facebook.react.views.text.ReactTextViewManagerCallback;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="RCTText")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 F2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\b\u0012\u0004\u0012\u00020\u00020\u00042\u00020\u0005:\u0001FB\u0015\b\u0017\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001a\u0010\t\u001a\u0004\u0018\u00010\u00022\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0002H\u0014J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u0002H\u0014J\u0010\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u000bH\u0016J\u0018\u0010\u0013\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0014\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00150\u001cH\u0016J\u001a\u0010\u001d\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\b\u0010\u001e\u001a\u0004\u0018\u00010\u000eH\u0007J\u0018\u0010\u001f\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020!H\u0007J\u0018\u0010\"\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010#\u001a\u00020!H\u0007J\u001f\u0010$\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\b\u0010%\u001a\u0004\u0018\u00010&H\u0007\u00a2\u0006\u0002\u0010'J \u0010(\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020+H\u0007J\u001a\u0010,\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\b\u0010-\u001a\u0004\u0018\u00010\u000eH\u0007J \u0010.\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010)\u001a\u00020&2\u0006\u0010/\u001a\u00020+H\u0007J'\u00100\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u0010)\u001a\u00020&2\b\u0010%\u001a\u0004\u0018\u00010&H\u0007\u00a2\u0006\u0002\u00101J\u0018\u00102\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u00103\u001a\u00020!H\u0007J0\u00104\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u00022\u0006\u00105\u001a\u00020&2\u0006\u00106\u001a\u00020&2\u0006\u00107\u001a\u00020&2\u0006\u00108\u001a\u00020&H\u0016J\u0010\u00109\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030:H\u0016J \u0010;\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u00022\u0006\u0010=\u001a\u00020>2\u0006\u0010)\u001a\u00020&H\u0016J\u001a\u0010?\u001a\u0004\u0018\u00010>2\u0006\u0010<\u001a\u00020\u00022\u0006\u0010)\u001a\u00020&H\u0016J\u0018\u0010@\u001a\u00020\u00102\u0006\u0010<\u001a\u00020\u00022\u0006\u0010)\u001a\u00020&H\u0016J\u0010\u0010A\u001a\u00020&2\u0006\u0010<\u001a\u00020\u0002H\u0016J\b\u0010B\u001a\u00020!H\u0016J\u0010\u0010C\u001a\u00020\u00102\u0006\u0010D\u001a\u00020EH\u0016R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006G"}, d2={"Lcom/facebook/react/views/text/PreparedLayoutTextViewManager;", "Lcom/facebook/react/uimanager/BaseViewManager;", "Lcom/facebook/react/views/text/PreparedLayoutTextView;", "Lcom/facebook/react/uimanager/LayoutShadowNode;", "Lcom/facebook/react/uimanager/IViewGroupManager;", "Lcom/facebook/react/views/text/ReactTextViewManagerCallback;", "reactTextViewManagerCallback", "<init>", "(Lcom/facebook/react/views/text/ReactTextViewManagerCallback;)V", "prepareToRecycleView", "reactContext", "Lcom/facebook/react/uimanager/ThemedReactContext;", "view", "getName", "", "updateViewAccessibility", "", "createViewInstance", "context", "updateExtraData", "extraData", "", "updateState", "props", "Lcom/facebook/react/uimanager/ReactStylesDiffMap;", "stateWrapper", "Lcom/facebook/react/uimanager/StateWrapper;", "getExportedCustomDirectEventTypeConstants", "", "setOverflow", "overflow", "setAccessible", "accessible", "", "setSelectable", "isSelectable", "setSelectionColor", "color", "", "(Lcom/facebook/react/views/text/PreparedLayoutTextView;Ljava/lang/Integer;)V", "setBorderRadius", "index", "borderRadius", "", "setBorderStyle", "borderStyle", "setBorderWidth", "width", "setBorderColor", "(Lcom/facebook/react/views/text/PreparedLayoutTextView;ILjava/lang/Integer;)V", "setDisabled", "disabled", "setPadding", "left", "top", "right", "bottom", "getShadowNodeClass", "Ljava/lang/Class;", "addView", "parent", "child", "Landroid/view/View;", "getChildAt", "removeViewAt", "getChildCount", "needsCustomLayoutForChildren", "onPostProcessSpannable", "text", "Landroid/text/Spannable;", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nPreparedLayoutTextViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PreparedLayoutTextViewManager.kt\ncom/facebook/react/views/text/PreparedLayoutTextViewManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,221:1\n1#2:222\n*E\n"})
public final class PreparedLayoutTextViewManager
extends BaseViewManager<PreparedLayoutTextView, LayoutShadowNode>
implements IViewGroupManager<PreparedLayoutTextView>,
ReactTextViewManagerCallback {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final ReactTextViewManagerCallback reactTextViewManagerCallback;
    @NotNull
    public static final String REACT_CLASS = "RCTText";

    @JvmOverloads
    public PreparedLayoutTextViewManager(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        this.reactTextViewManagerCallback = reactTextViewManagerCallback;
        this.setupViewRecycling();
    }

    public /* synthetic */ PreparedLayoutTextViewManager(ReactTextViewManagerCallback reactTextViewManagerCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            reactTextViewManagerCallback = null;
        }
        this(reactTextViewManagerCallback);
    }

    @Override
    @Nullable
    protected PreparedLayoutTextView prepareToRecycleView(@NotNull ThemedReactContext reactContext, @NotNull PreparedLayoutTextView view) {
        PreparedLayoutTextView preparedView;
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            PreparedLayoutTextView preparedLayoutTextView = preparedView = (PreparedLayoutTextView)super.prepareToRecycleView(reactContext, (View)view);
            if (preparedLayoutTextView == null) break block0;
            preparedLayoutTextView.recycleView();
        }
        return preparedView;
    }

    @Override
    @NotNull
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected void updateViewAccessibility(@NotNull PreparedLayoutTextView view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ReactTextViewAccessibilityDelegate.Companion.setDelegate((View)view, view.isFocusable(), view.getImportantForAccessibility());
    }

    @Override
    @NotNull
    public PreparedLayoutTextView createViewInstance(@NotNull ThemedReactContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        return new PreparedLayoutTextView((Context)context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateExtraData(@NotNull PreparedLayoutTextView view, @NotNull Object extraData) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)extraData, (String)"extraData");
        AutoCloseable autoCloseable = new SystraceSection("PreparedLayoutTextViewManager.updateExtraData");
        Throwable throwable = null;
        try {
            SystraceSection cfr_ignored_0 = (SystraceSection)autoCloseable;
            boolean bl = false;
            PreparedLayout preparedLayout = (PreparedLayout)extraData;
            view.setPreparedLayout(preparedLayout);
            if (preparedLayout.getLayout().getText() instanceof Spanned) {
                CharSequence charSequence = preparedLayout.getLayout().getText();
                Intrinsics.checkNotNull((Object)charSequence, (String)"null cannot be cast to non-null type android.text.Spanned");
                Spanned spannedText = (Spanned)charSequence;
                ReactTextViewAccessibilityDelegate.AccessibilityLinks accessibilityLinks = new ReactTextViewAccessibilityDelegate.AccessibilityLinks(spannedText);
                view.setTag(R.id.accessibility_links, accessibilityLinks.size() > 0 ? accessibilityLinks : null);
                ReactTextViewAccessibilityDelegate.Companion.resetDelegate((View)view, view.isFocusable(), view.getImportantForAccessibility());
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            AutoCloseableKt.closeFinally((AutoCloseable)autoCloseable, (Throwable)throwable);
        }
    }

    @Override
    @Nullable
    public Object updateState(@NotNull PreparedLayoutTextView view, @NotNull ReactStylesDiffMap props, @NotNull StateWrapper stateWrapper) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)props, (String)"props");
        Intrinsics.checkNotNullParameter((Object)stateWrapper, (String)"stateWrapper");
        ReferenceStateWrapper referenceStateWrapper = stateWrapper instanceof ReferenceStateWrapper ? (ReferenceStateWrapper)stateWrapper : null;
        return referenceStateWrapper != null ? referenceStateWrapper.getStateDataReference() : null;
    }

    @Override
    @NotNull
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        Map baseEventTypeConstants = super.getExportedCustomDirectEventTypeConstants();
        Map map = baseEventTypeConstants;
        if (map == null) {
            map = new HashMap();
        }
        Map eventTypeConstants = map;
        eventTypeConstants.put("topTextLayout", MapsKt.mapOf((Pair)TuplesKt.to((Object)"registrationName", (Object)"onTextLayout")));
        return eventTypeConstants;
    }

    /*
     * WARNING - void declaration
     */
    @ReactProp(name="overflow")
    public final void setOverflow(@NotNull PreparedLayoutTextView view, @Nullable String overflow) {
        Object object;
        PreparedLayoutTextView preparedLayoutTextView;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter((Object)view, (String)"view");
                preparedLayoutTextView = view;
                object = overflow;
                if (object == null) break block2;
                String string2 = object;
                PreparedLayoutTextView preparedLayoutTextView2 = preparedLayoutTextView;
                boolean bl = false;
                Overflow overflow2 = Overflow.Companion.fromString((String)it);
                preparedLayoutTextView = preparedLayoutTextView2;
                object = overflow2;
                if (overflow2 != null) break block3;
            }
            object = Overflow.HIDDEN;
        }
        preparedLayoutTextView.setOverflow((Overflow)((Object)object));
    }

    @ReactProp(name="accessible")
    public final void setAccessible(@NotNull PreparedLayoutTextView view, boolean accessible) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setFocusable(accessible);
    }

    @ReactProp(name="selectable", defaultBoolean=false)
    public final void setSelectable(@NotNull PreparedLayoutTextView view, boolean isSelectable) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
    }

    @ReactProp(name="selectionColor", customType="Color")
    public final void setSelectionColor(@NotNull PreparedLayoutTextView view, @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (color == null) {
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            view.setSelectionColor(DefaultStyleValuesUtil.getDefaultTextColorHighlight(context));
        } else {
            view.setSelectionColor(color);
        }
    }

    @ReactPropGroup(names={"borderRadius", "borderTopLeftRadius", "borderTopRightRadius", "borderBottomRightRadius", "borderBottomLeftRadius"}, defaultFloat=NaNf)
    public final void setBorderRadius(@NotNull PreparedLayoutTextView view, int index, float borderRadius) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(borderRadius, LengthPercentageType.POINT);
        BackgroundStyleApplicator.setBorderRadius((View)view, BorderRadiusProp.values()[index], radius);
    }

    @ReactProp(name="borderStyle")
    public final void setBorderStyle(@NotNull PreparedLayoutTextView view, @Nullable String borderStyle) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        String string2 = borderStyle;
        BorderStyle parsedBorderStyle = string2 == null ? null : BorderStyle.Companion.fromString(string2);
        BackgroundStyleApplicator.setBorderStyle((View)view, parsedBorderStyle);
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth", "borderStartWidth", "borderEndWidth"}, defaultFloat=NaNf)
    public final void setBorderWidth(@NotNull PreparedLayoutTextView view, int index, float width) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        BackgroundStyleApplicator.setBorderWidth((View)view, LogicalEdge.values()[index], Float.valueOf(width));
    }

    @ReactPropGroup(names={"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor", "borderStartColor", "borderEndColor", "borderBlockColor", "borderBlockEndColor", "borderBlockStartColor"}, customType="Color")
    public final void setBorderColor(@NotNull PreparedLayoutTextView view, int index, @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        BackgroundStyleApplicator.setBorderColor((View)view, LogicalEdge.values()[index], color);
    }

    @ReactProp(name="disabled", defaultBoolean=false)
    public final void setDisabled(@NotNull PreparedLayoutTextView view, boolean disabled) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setEnabled(!disabled);
    }

    @Override
    public void setPadding(@NotNull PreparedLayoutTextView view, int left, int top, int right, int bottom) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setPadding(left, top, right, bottom);
    }

    @Override
    @NotNull
    public Class<? extends LayoutShadowNode> getShadowNodeClass() {
        return LayoutShadowNode.class;
    }

    @Override
    public void addView(@NotNull PreparedLayoutTextView parent, @NotNull View child, int index) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        parent.addView(child, index);
    }

    @Override
    @Nullable
    public View getChildAt(@NotNull PreparedLayoutTextView parent, int index) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return parent.getChildAt(index);
    }

    @Override
    public void removeViewAt(@NotNull PreparedLayoutTextView parent, int index) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        parent.removeViewAt(index);
    }

    @Override
    public int getChildCount(@NotNull PreparedLayoutTextView parent) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        return parent.getChildCount();
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return false;
    }

    @Override
    public void onPostProcessSpannable(@NotNull Spannable text) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            ReactTextViewManagerCallback reactTextViewManagerCallback = this.reactTextViewManagerCallback;
            if (reactTextViewManagerCallback == null) break block0;
            reactTextViewManagerCallback.onPostProcessSpannable(text);
        }
    }

    @JvmOverloads
    public PreparedLayoutTextViewManager() {
        this(null, 1, null);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/facebook/react/views/text/PreparedLayoutTextViewManager$Companion;", "", "<init>", "()V", "REACT_CLASS", "", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

