/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.layoutanimation;

import android.view.animation.Interpolator;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0007\b\u0000\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0013\b\u0007\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u0003H\u0016R\u000e\u0010\u0006\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/react/uimanager/layoutanimation/SimpleSpringInterpolator;", "Landroid/view/animation/Interpolator;", "springDamping", "", "<init>", "(F)V", "_springDamping", "getInterpolation", "input", "Companion", "ReactAndroid_debug"})
public final class SimpleSpringInterpolator
implements Interpolator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float _springDamping;
    private static final float FACTOR = 0.5f;
    @NotNull
    public static final String PARAM_SPRING_DAMPING = "springDamping";

    @JvmOverloads
    public SimpleSpringInterpolator(float springDamping) {
        this._springDamping = springDamping;
    }

    public /* synthetic */ SimpleSpringInterpolator(float f, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            f = 0.5f;
        }
        this(f);
    }

    public float getInterpolation(float input) {
        return (float)(1.0 + Math.pow(2.0, (float)-10 * input) * Math.sin((double)(input - this._springDamping / (float)4) * Math.PI * (double)2 / (double)this._springDamping));
    }

    @JvmOverloads
    public SimpleSpringInterpolator() {
        this(0.0f, 1, null);
    }

    @JvmStatic
    public static final float getSpringDamping(@NotNull ReadableMap params) {
        return Companion.getSpringDamping(params);
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("SimpleSpringInterpolator", LegacyArchitectureLogLevel.ERROR);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/facebook/react/uimanager/layoutanimation/SimpleSpringInterpolator$Companion;", "", "<init>", "()V", "FACTOR", "", "PARAM_SPRING_DAMPING", "", "getSpringDamping", "params", "Lcom/facebook/react/bridge/ReadableMap;", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final float getSpringDamping(@NotNull ReadableMap params) {
            Intrinsics.checkNotNullParameter((Object)params, (String)"params");
            return params.getType(SimpleSpringInterpolator.PARAM_SPRING_DAMPING) == ReadableType.Number ? (float)params.getDouble(SimpleSpringInterpolator.PARAM_SPRING_DAMPING) : 0.5f;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

