/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.content.Context;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.view.View;
import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Dynamic;
import com.facebook.react.bridge.DynamicFromObject;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.uimanager.annotations.ReactPropGroup;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.style.BackgroundImageLayer;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.BorderStyle;
import com.facebook.react.uimanager.style.LogicalEdge;
import com.facebook.react.views.view.ReactClippingViewManager;
import com.facebook.react.views.view.ReactDrawableHelper;
import com.facebook.react.views.view.ReactViewGroup;
import com.facebook.react.views.view.ViewGroupClickEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ReplaceWith;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="RCTView")
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b!\n\u0002\u0010%\n\u0002\b\b\b\u0017\u0018\u0000 N2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001NB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0002H\u0014J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0017J\u0018\u0010\r\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\fH\u0017J\u001a\u0010\u000f\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0017J\u0018\u0010\u0012\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u0016\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u0017\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J\u0018\u0010\u0018\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u0013\u001a\u00020\u0014H\u0017J \u0010\u0019\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u001cH\u0017J \u0010\u0019\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u001eH\u0017J\u001a\u0010\u001f\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\b\u0010 \u001a\u0004\u0018\u00010!H\u0017J\u0018\u0010\"\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010#\u001a\u00020\u001cH\u0017J\u0014\u0010$\u001a\u00020\u0014*\u00020%2\u0006\u0010&\u001a\u00020!H\u0002J\u001a\u0010'\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\b\u0010(\u001a\u0004\u0018\u00010!H\u0017J\u001a\u0010)\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\b\u0010*\u001a\u0004\u0018\u00010%H\u0017J\u001a\u0010+\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\b\u0010,\u001a\u0004\u0018\u00010%H\u0017J\u0018\u0010-\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010.\u001a\u00020\fH\u0017J \u0010/\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00142\u0006\u00100\u001a\u00020\u001eH\u0017J'\u00101\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\u001a\u001a\u00020\u00142\b\u00102\u001a\u0004\u0018\u00010\u0014H\u0017\u00a2\u0006\u0002\u00103J\u0018\u00104\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u00105\u001a\u00020\fH\u0017J\u0018\u00106\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u00107\u001a\u00020\fH\u0017J\u0018\u00108\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u00109\u001a\u00020\fH\u0017J\u001a\u0010:\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\b\u0010;\u001a\u0004\u0018\u00010!H\u0017J\u0018\u0010<\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010=\u001a\u00020!H\u0017J\u0018\u0010>\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010?\u001a\u00020\u001eH\u0016J$\u0010@\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u00022\b\u0010A\u001a\u0004\u0018\u00010\u00112\b\u0010B\u001a\u0004\u0018\u00010\u0011H\u0014J\b\u0010C\u001a\u00020!H\u0016J\u0010\u0010D\u001a\u00020\u00022\u0006\u0010E\u001a\u00020\u0007H\u0016J\u0014\u0010F\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\u00140GH\u0016J\"\u0010H\u001a\u00020\n2\u0006\u0010I\u001a\u00020\u00022\u0006\u0010J\u001a\u00020\u00142\b\u0010K\u001a\u0004\u0018\u00010\u0011H\u0017J\"\u0010H\u001a\u00020\n2\u0006\u0010I\u001a\u00020\u00022\u0006\u0010J\u001a\u00020!2\b\u0010K\u001a\u0004\u0018\u00010\u0011H\u0016J\u001a\u0010L\u001a\u00020\n2\u0006\u0010I\u001a\u00020\u00022\b\u0010K\u001a\u0004\u0018\u00010\u0011H\u0002J\u001a\u0010M\u001a\u00020\n2\u0006\u0010I\u001a\u00020\u00022\b\u0010K\u001a\u0004\u0018\u00010\u0011H\u0002\u00a8\u0006O"}, d2={"Lcom/facebook/react/views/view/ReactViewManager;", "Lcom/facebook/react/views/view/ReactClippingViewManager;", "Lcom/facebook/react/views/view/ReactViewGroup;", "<init>", "()V", "prepareToRecycleView", "reactContext", "Lcom/facebook/react/uimanager/ThemedReactContext;", "view", "setAccessible", "", "accessible", "", "setTVPreferredFocus", "hasTVPreferredFocus", "setBackgroundImage", "backgroundImage", "Lcom/facebook/react/bridge/ReadableArray;", "nextFocusDown", "viewId", "", "nextFocusForward", "nextFocusLeft", "nextFocusRight", "nextFocusUp", "setBorderRadius", "index", "rawBorderRadius", "Lcom/facebook/react/bridge/Dynamic;", "borderRadius", "", "setBorderStyle", "borderStyle", "", "setHitSlop", "hitSlop", "px", "Lcom/facebook/react/bridge/ReadableMap;", "key", "setPointerEvents", "pointerEventsStr", "setNativeBackground", "background", "setNativeForeground", "foreground", "setNeedsOffscreenAlphaCompositing", "needsOffscreenAlphaCompositing", "setBorderWidth", "width", "setBorderColor", "color", "(Lcom/facebook/react/views/view/ReactViewGroup;ILjava/lang/Integer;)V", "setCollapsable", "collapsable", "setCollapsableChildren", "collapsableChildren", "setFocusable", "focusable", "setOverflow", "overflow", "setBackfaceVisibility", "backfaceVisibility", "setOpacity", "opacity", "setTransformProperty", "transforms", "transformOrigin", "getName", "createViewInstance", "context", "getCommandsMap", "", "receiveCommand", "root", "commandId", "args", "handleSetPressed", "handleHotspotUpdate", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nReactViewManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactViewManager.kt\ncom/facebook/react/views/view/ReactViewManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,386:1\n1#2:387\n*E\n"})
public class ReactViewManager
extends ReactClippingViewManager<ReactViewGroup> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String REACT_CLASS = "RCTView";
    @NotNull
    private static final int[] SPACING_TYPES;
    private static final int CMD_HOTSPOT_UPDATE = 1;
    private static final int CMD_SET_PRESSED = 2;
    @NotNull
    private static final String HOTSPOT_UPDATE_KEY = "hotspotUpdate";

    public ReactViewManager() {
        if (ReactNativeFeatureFlags.enableViewRecyclingForView()) {
            this.setupViewRecycling();
        }
    }

    @Override
    @Nullable
    protected ReactViewGroup prepareToRecycleView(@NotNull ThemedReactContext reactContext, @NotNull ReactViewGroup view) {
        ReactViewGroup preparedView;
        block0: {
            Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            view.setRemoveClippedSubviews(false);
            ReactViewGroup reactViewGroup = preparedView = (ReactViewGroup)super.prepareToRecycleView(reactContext, (View)view);
            if (reactViewGroup == null) break block0;
            reactViewGroup.recycleView();
        }
        return preparedView;
    }

    @ReactProp(name="accessible")
    public void setAccessible(@NotNull ReactViewGroup view, boolean accessible) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setFocusable(accessible);
    }

    @ReactProp(name="hasTVPreferredFocus")
    public void setTVPreferredFocus(@NotNull ReactViewGroup view, boolean hasTVPreferredFocus) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (hasTVPreferredFocus) {
            view.setFocusable(true);
            view.setFocusableInTouchMode(true);
            view.requestFocus();
        }
    }

    @ReactProp(name="experimental_backgroundImage", customType="BackgroundImage")
    public void setBackgroundImage(@NotNull ReactViewGroup view, @Nullable ReadableArray backgroundImage) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (ViewUtil.getUIManagerType((View)view) == 2) {
            if (backgroundImage != null && backgroundImage.size() > 0) {
                ArrayList<BackgroundImageLayer> backgroundImageLayers = new ArrayList<BackgroundImageLayer>(backgroundImage.size());
                int n = backgroundImage.size();
                for (int i = 0; i < n; ++i) {
                    ReadableMap backgroundImageMap = backgroundImage.getMap(i);
                    Context context = view.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                    BackgroundImageLayer layer = BackgroundImageLayer.Companion.parse(backgroundImageMap, context);
                    if (layer == null) continue;
                    backgroundImageLayers.add(layer);
                }
                BackgroundStyleApplicator.setBackgroundImage((View)view, (List<BackgroundImageLayer>)backgroundImageLayers);
            } else {
                BackgroundStyleApplicator.setBackgroundImage((View)view, null);
            }
        }
    }

    @ReactProp(name="nextFocusDown", defaultInt=-1)
    public void nextFocusDown(@NotNull ReactViewGroup view, int viewId) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setNextFocusDownId(viewId);
    }

    @ReactProp(name="nextFocusForward", defaultInt=-1)
    public void nextFocusForward(@NotNull ReactViewGroup view, int viewId) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setNextFocusForwardId(viewId);
    }

    @ReactProp(name="nextFocusLeft", defaultInt=-1)
    public void nextFocusLeft(@NotNull ReactViewGroup view, int viewId) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setNextFocusLeftId(viewId);
    }

    @ReactProp(name="nextFocusRight", defaultInt=-1)
    public void nextFocusRight(@NotNull ReactViewGroup view, int viewId) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setNextFocusRightId(viewId);
    }

    @ReactProp(name="nextFocusUp", defaultInt=-1)
    public void nextFocusUp(@NotNull ReactViewGroup view, int viewId) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setNextFocusUpId(viewId);
    }

    @ReactPropGroup(names={"borderRadius", "borderTopLeftRadius", "borderTopRightRadius", "borderBottomRightRadius", "borderBottomLeftRadius", "borderTopStartRadius", "borderTopEndRadius", "borderBottomStartRadius", "borderBottomEndRadius", "borderEndEndRadius", "borderEndStartRadius", "borderStartEndRadius", "borderStartStartRadius"})
    public void setBorderRadius(@NotNull ReactViewGroup view, int index, @NotNull Dynamic rawBorderRadius) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)rawBorderRadius, (String)"rawBorderRadius");
        LengthPercentage borderRadius = LengthPercentage.Companion.setFromDynamic(rawBorderRadius);
        if (ViewUtil.getUIManagerType((View)view) != 2 && borderRadius != null && borderRadius.getType() == LengthPercentageType.PERCENT) {
            borderRadius = null;
        }
        BackgroundStyleApplicator.setBorderRadius((View)view, BorderRadiusProp.values()[index], borderRadius);
    }

    @Deprecated(message="Don't use setBorderRadius(view, int, Float) as it was deprecated in React Native 0.75.0.", replaceWith=@ReplaceWith(expression="setBorderRadius(view, index, DynamicFromObject(borderRadius)", imports={}))
    public void setBorderRadius(@NotNull ReactViewGroup view, int index, float borderRadius) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        this.setBorderRadius(view, index, new DynamicFromObject(Float.valueOf(borderRadius)));
    }

    @ReactProp(name="borderStyle")
    public void setBorderStyle(@NotNull ReactViewGroup view, @Nullable String borderStyle) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        String string2 = borderStyle;
        BorderStyle parsedBorderStyle = string2 == null ? null : BorderStyle.Companion.fromString(string2);
        BackgroundStyleApplicator.setBorderStyle((View)view, parsedBorderStyle);
    }

    @ReactProp(name="hitSlop")
    public void setHitSlop(@NotNull ReactViewGroup view, @NotNull Dynamic hitSlop) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)hitSlop, (String)"hitSlop");
        switch (WhenMappings.$EnumSwitchMapping$0[hitSlop.getType().ordinal()]) {
            case 1: {
                ReadableMap hitSlopMap = hitSlop.asMap();
                if (hitSlopMap == null) {
                    view.setHitSlopRect(null);
                    return;
                }
                view.setHitSlopRect(new Rect(this.px(hitSlopMap, "left"), this.px(hitSlopMap, "top"), this.px(hitSlopMap, "right"), this.px(hitSlopMap, "bottom")));
                break;
            }
            case 2: {
                int hitSlopValue = (int)PixelUtil.INSTANCE.dpToPx(hitSlop.asDouble());
                view.setHitSlopRect(new Rect(hitSlopValue, hitSlopValue, hitSlopValue, hitSlopValue));
                break;
            }
            case 3: {
                view.setHitSlopRect(null);
                break;
            }
            default: {
                FLog.w((String)"ReactNative", (String)("Invalid type for 'hitSlop' value " + hitSlop.getType()));
                view.setHitSlopRect(null);
            }
        }
    }

    private final int px(ReadableMap $this$px, String key) {
        return $this$px.hasKey(key) ? (int)PixelUtil.INSTANCE.dpToPx($this$px.getDouble(key)) : 0;
    }

    @ReactProp(name="pointerEvents")
    public void setPointerEvents(@NotNull ReactViewGroup view, @Nullable String pointerEventsStr) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setPointerEvents(PointerEvents.Companion.parsePointerEvents(pointerEventsStr));
    }

    @ReactProp(name="nativeBackgroundAndroid")
    public void setNativeBackground(@NotNull ReactViewGroup view, @Nullable ReadableMap background) {
        Drawable drawable2;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ReadableMap readableMap = background;
        if (readableMap != null) {
            ReadableMap it = readableMap;
            boolean bl = false;
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            drawable2 = ReactDrawableHelper.createDrawableFromJSDescription(context, it);
        } else {
            drawable2 = null;
        }
        Drawable bg = drawable2;
        BackgroundStyleApplicator.setFeedbackUnderlay((View)view, bg);
    }

    /*
     * WARNING - void declaration
     */
    @ReactProp(name="nativeForegroundAndroid")
    public void setNativeForeground(@NotNull ReactViewGroup view, @Nullable ReadableMap foreground) {
        Drawable drawable2;
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        ReactViewGroup reactViewGroup = view;
        ReadableMap readableMap = foreground;
        if (readableMap != null) {
            void it;
            ReadableMap readableMap2 = readableMap;
            ReactViewGroup reactViewGroup2 = reactViewGroup;
            boolean bl = false;
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            drawable2 = ReactDrawableHelper.createDrawableFromJSDescription(context, (ReadableMap)it);
            reactViewGroup = reactViewGroup2;
        } else {
            drawable2 = null;
        }
        reactViewGroup.setForeground(drawable2);
    }

    @ReactProp(name="needsOffscreenAlphaCompositing")
    public void setNeedsOffscreenAlphaCompositing(@NotNull ReactViewGroup view, boolean needsOffscreenAlphaCompositing) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setNeedsOffscreenAlphaCompositing(needsOffscreenAlphaCompositing);
    }

    @ReactPropGroup(names={"borderWidth", "borderLeftWidth", "borderRightWidth", "borderTopWidth", "borderBottomWidth", "borderStartWidth", "borderEndWidth"}, defaultFloat=NaNf)
    public void setBorderWidth(@NotNull ReactViewGroup view, int index, float width) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        BackgroundStyleApplicator.setBorderWidth((View)view, LogicalEdge.values()[index], Float.valueOf(width));
    }

    @ReactPropGroup(names={"borderColor", "borderLeftColor", "borderRightColor", "borderTopColor", "borderBottomColor", "borderStartColor", "borderEndColor", "borderBlockColor", "borderBlockEndColor", "borderBlockStartColor"}, customType="Color")
    public void setBorderColor(@NotNull ReactViewGroup view, int index, @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        BackgroundStyleApplicator.setBorderColor((View)view, LogicalEdge.Companion.fromSpacingType(SPACING_TYPES[index]), color);
    }

    @ReactProp(name="collapsable")
    public void setCollapsable(@NotNull ReactViewGroup view, boolean collapsable) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
    }

    @ReactProp(name="collapsableChildren")
    public void setCollapsableChildren(@NotNull ReactViewGroup view, boolean collapsableChildren) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
    }

    @ReactProp(name="focusable")
    public void setFocusable(@NotNull ReactViewGroup view, boolean focusable) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (focusable) {
            view.setOnClickListener(arg_0 -> ReactViewManager.setFocusable$lambda$2(view, arg_0));
            view.setFocusable(true);
        } else {
            view.setOnClickListener(null);
            view.setClickable(false);
        }
    }

    @ReactProp(name="overflow")
    public void setOverflow(@NotNull ReactViewGroup view, @Nullable String overflow) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setOverflow(overflow);
    }

    @ReactProp(name="backfaceVisibility")
    public void setBackfaceVisibility(@NotNull ReactViewGroup view, @NotNull String backfaceVisibility) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)backfaceVisibility, (String)"backfaceVisibility");
        view.setBackfaceVisibility(backfaceVisibility);
    }

    @Override
    public void setOpacity(@NotNull ReactViewGroup view, float opacity) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setOpacityIfPossible(opacity);
    }

    @Override
    protected void setTransformProperty(@NotNull ReactViewGroup view, @Nullable ReadableArray transforms, @Nullable ReadableArray transformOrigin) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.setTransformProperty((View)view, transforms, transformOrigin);
        view.setBackfaceVisibilityDependantOpacity();
    }

    @Override
    @NotNull
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    @NotNull
    public ReactViewGroup createViewInstance(@NotNull ThemedReactContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        return new ReactViewGroup((Context)context);
    }

    @Override
    @NotNull
    public Map<String, Integer> getCommandsMap() {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)HOTSPOT_UPDATE_KEY, (Object)1), TuplesKt.to((Object)"setPressed", (Object)2)};
        return MapsKt.mutableMapOf((Pair[])pairArray);
    }

    @Override
    @Deprecated(message="Use receiveCommand(View, String, ReadableArray)", replaceWith=@ReplaceWith(expression="receiveCommand(root, commandIdString, args)", imports={}))
    public void receiveCommand(@NotNull ReactViewGroup root, int commandId, @Nullable ReadableArray args) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        switch (commandId) {
            case 1: {
                this.handleHotspotUpdate(root, args);
                break;
            }
            case 2: {
                this.handleSetPressed(root, args);
            }
        }
    }

    @Override
    public void receiveCommand(@NotNull ReactViewGroup root, @NotNull String commandId, @Nullable ReadableArray args) {
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)commandId, (String)"commandId");
        String string2 = commandId;
        if (Intrinsics.areEqual((Object)string2, (Object)HOTSPOT_UPDATE_KEY)) {
            this.handleHotspotUpdate(root, args);
        } else if (Intrinsics.areEqual((Object)string2, (Object)"setPressed")) {
            this.handleSetPressed(root, args);
        }
    }

    private final void handleSetPressed(ReactViewGroup root, ReadableArray args) {
        if (args == null || args.size() != 1) {
            throw new JSApplicationIllegalArgumentException("Illegal number of arguments for 'setPressed' command");
        }
        root.setPressed(args.getBoolean(0));
    }

    private final void handleHotspotUpdate(ReactViewGroup root, ReadableArray args) {
        if (args == null || args.size() != 2) {
            throw new JSApplicationIllegalArgumentException("Illegal number of arguments for 'updateHotspot' command");
        }
        float x = PixelUtil.INSTANCE.dpToPx(args.getDouble(0));
        float y = PixelUtil.INSTANCE.dpToPx(args.getDouble(1));
        root.drawableHotspotChanged(x, y);
    }

    private static final void setFocusable$lambda$2(ReactViewGroup $view, View it) {
        block0: {
            EventDispatcher eventDispatcher;
            Context context = $view.getContext();
            Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.bridge.ReactContext");
            EventDispatcher eventDispatcher2 = eventDispatcher = UIManagerHelper.getEventDispatcherForReactTag((ReactContext)context, $view.getId());
            if (eventDispatcher2 == null) break block0;
            eventDispatcher2.dispatchEvent(new ViewGroupClickEvent(UIManagerHelper.getSurfaceId($view.getContext()), $view.getId()));
        }
    }

    static {
        int[] nArray = new int[]{8, 0, 2, 1, 3, 4, 5, 9, 10, 11};
        SPACING_TYPES = nArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/react/views/view/ReactViewManager$Companion;", "", "<init>", "()V", "REACT_CLASS", "", "SPACING_TYPES", "", "CMD_HOTSPOT_UPDATE", "", "CMD_SET_PRESSED", "HOTSPOT_UPDATE_KEY", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReadableType.values().length];
            try {
                nArray[ReadableType.Map.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Number.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReadableType.Null.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

