/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.packagerconnection;

import android.net.Uri;
import com.facebook.common.logging.FLog;
import com.facebook.react.modules.systeminfo.AndroidInfoHelpers;
import com.facebook.react.packagerconnection.PackagerConnectionSettings;
import com.facebook.react.packagerconnection.ReconnectingWebSocket;
import com.facebook.react.packagerconnection.RequestHandler;
import com.facebook.react.packagerconnection.Responder;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u001b2\u00020\u0001:\u0002\u001a\u001bB9\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007\u0012\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0006\u0010\u000f\u001a\u00020\u0010J\u0006\u0010\u0011\u001a\u00020\u0010J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0003H\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u001a\u0010\u0016\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u0003H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/facebook/react/packagerconnection/JSPackagerClient;", "Lcom/facebook/react/packagerconnection/ReconnectingWebSocket$MessageCallback;", "clientId", "", "settings", "Lcom/facebook/react/packagerconnection/PackagerConnectionSettings;", "requestHandlers", "", "Lcom/facebook/react/packagerconnection/RequestHandler;", "connectionCallback", "Lcom/facebook/react/packagerconnection/ReconnectingWebSocket$ConnectionCallback;", "<init>", "(Ljava/lang/String;Lcom/facebook/react/packagerconnection/PackagerConnectionSettings;Ljava/util/Map;Lcom/facebook/react/packagerconnection/ReconnectingWebSocket$ConnectionCallback;)V", "webSocket", "Lcom/facebook/react/packagerconnection/ReconnectingWebSocket;", "init", "", "close", "onMessage", "text", "bytes", "Lokio/ByteString;", "abortOnMessage", "id", "", "reason", "ResponderImpl", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nJSPackagerClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JSPackagerClient.kt\ncom/facebook/react/packagerconnection/JSPackagerClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public final class JSPackagerClient
implements ReconnectingWebSocket.MessageCallback {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, RequestHandler> requestHandlers;
    @NotNull
    private final ReconnectingWebSocket webSocket;
    @NotNull
    private static final String TAG;
    private static final int PROTOCOL_VERSION = 2;

    @JvmOverloads
    public JSPackagerClient(@NotNull String clientId, @NotNull PackagerConnectionSettings settings, @NotNull Map<String, ? extends RequestHandler> requestHandlers, @Nullable ReconnectingWebSocket.ConnectionCallback connectionCallback) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(requestHandlers, (String)"requestHandlers");
        this.requestHandlers = requestHandlers;
        String string2 = new Uri.Builder().scheme("ws").encodedAuthority(settings.getDebugServerHost()).appendPath("message").appendQueryParameter("device", AndroidInfoHelpers.getFriendlyDeviceName()).appendQueryParameter("app", settings.getPackageName()).appendQueryParameter("clientid", clientId).build().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        String url = string2;
        this.webSocket = new ReconnectingWebSocket(url, this, connectionCallback);
    }

    public /* synthetic */ JSPackagerClient(String string2, PackagerConnectionSettings packagerConnectionSettings, Map map, ReconnectingWebSocket.ConnectionCallback connectionCallback, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            connectionCallback = null;
        }
        this(string2, packagerConnectionSettings, map, connectionCallback);
    }

    public final void init() {
        this.webSocket.connect();
    }

    public final void close() {
        this.webSocket.closeQuietly();
    }

    @Override
    public void onMessage(@NotNull String text) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        try {
            JSONObject message = new JSONObject(text);
            int version = message.optInt("version");
            String method = message.optString("method");
            Object id2 = message.opt("id");
            Object params = message.opt("params");
            if (version != 2) {
                FLog.e((String)TAG, (String)("Message with incompatible or missing version of protocol received: " + version));
                return;
            }
            if (method == null) {
                this.abortOnMessage(id2, "No method provided");
                return;
            }
            RequestHandler handler = this.requestHandlers.get(method);
            if (handler == null) {
                this.abortOnMessage(id2, "No request handler for method: " + method);
                return;
            }
            if (id2 == null) {
                handler.onNotification(params);
            } else {
                handler.onRequest(params, new ResponderImpl(id2));
            }
        }
        catch (Exception e) {
            FLog.e((String)TAG, (String)"Handling the message failed", (Throwable)e);
        }
    }

    @Override
    public void onMessage(@NotNull ByteString bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        FLog.w((String)TAG, (String)"Websocket received message with payload of unexpected type binary");
    }

    private final void abortOnMessage(Object id2, String reason) {
        Object object = id2;
        if (object != null) {
            Object it = object;
            boolean bl = false;
            new ResponderImpl(it).error(reason);
        }
        FLog.e((String)TAG, (String)("Handling the message failed with reason: " + reason));
    }

    @JvmOverloads
    public JSPackagerClient(@NotNull String clientId, @NotNull PackagerConnectionSettings settings, @NotNull Map<String, ? extends RequestHandler> requestHandlers) {
        Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Intrinsics.checkNotNullParameter(requestHandlers, (String)"requestHandlers");
        this(clientId, settings, requestHandlers, null, 8, null);
    }

    static {
        String string2 = JSPackagerClient.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSimpleName(...)");
        TAG = string2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/react/packagerconnection/JSPackagerClient$Companion;", "", "<init>", "()V", "TAG", "", "PROTOCOL_VERSION", "", "ReactAndroid_debug"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0003H\u0016J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\t\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/facebook/react/packagerconnection/JSPackagerClient$ResponderImpl;", "Lcom/facebook/react/packagerconnection/Responder;", "id", "", "<init>", "(Lcom/facebook/react/packagerconnection/JSPackagerClient;Ljava/lang/Object;)V", "respond", "", "result", "error", "ReactAndroid_debug"})
    private final class ResponderImpl
    implements Responder {
        @NotNull
        private final Object id;

        public ResponderImpl(Object id2) {
            Intrinsics.checkNotNullParameter((Object)id2, (String)"id");
            this.id = id2;
        }

        @Override
        public void respond(@NotNull Object result) {
            Intrinsics.checkNotNullParameter((Object)result, (String)"result");
            try {
                JSONObject jSONObject;
                JSONObject $this$respond_u24lambda_u240 = jSONObject = new JSONObject();
                boolean bl = false;
                $this$respond_u24lambda_u240.put("version", 2);
                $this$respond_u24lambda_u240.put("id", this.id);
                $this$respond_u24lambda_u240.put("result", result);
                JSONObject message = jSONObject;
                ReconnectingWebSocket reconnectingWebSocket = JSPackagerClient.this.webSocket;
                String string2 = message.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                reconnectingWebSocket.sendMessage(string2);
            }
            catch (Exception e) {
                FLog.e((String)TAG, (String)"Responding failed", (Throwable)e);
            }
        }

        @Override
        public void error(@NotNull Object error) {
            Intrinsics.checkNotNullParameter((Object)error, (String)"error");
            try {
                JSONObject jSONObject;
                JSONObject $this$error_u24lambda_u241 = jSONObject = new JSONObject();
                boolean bl = false;
                $this$error_u24lambda_u241.put("version", 2);
                $this$error_u24lambda_u241.put("id", this.id);
                $this$error_u24lambda_u241.put("error", error);
                JSONObject message = jSONObject;
                ReconnectingWebSocket reconnectingWebSocket = JSPackagerClient.this.webSocket;
                String string2 = message.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
                reconnectingWebSocket.sendMessage(string2);
            }
            catch (Exception e) {
                FLog.e((String)TAG, (String)"Responding with error failed", (Throwable)e);
            }
        }
    }
}

