/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.Activity;
import android.app.ActivityManager;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.SensorManager;
import android.os.Build;
import android.util.Pair;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.UiThread;
import androidx.core.util.Supplier;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.bridge.DefaultJSExceptionHandler;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.DebugServerException;
import com.facebook.react.common.JavascriptException;
import com.facebook.react.common.ShakeDetector;
import com.facebook.react.common.SurfaceDelegate;
import com.facebook.react.common.SurfaceDelegateFactory;
import com.facebook.react.devsupport.BundleDownloader;
import com.facebook.react.devsupport.ChangeBundleLocationDialog;
import com.facebook.react.devsupport.DebugOverlayController;
import com.facebook.react.devsupport.DefaultDevLoadingViewImplementation;
import com.facebook.react.devsupport.DevInternalSettings;
import com.facebook.react.devsupport.DevServerHelper;
import com.facebook.react.devsupport.DevSettingsActivity;
import com.facebook.react.devsupport.DevSupportManagerBase;
import com.facebook.react.devsupport.HMRClient;
import com.facebook.react.devsupport.InspectorFlags;
import com.facebook.react.devsupport.PausedInDebuggerOverlayDialogManager;
import com.facebook.react.devsupport.ReactInstanceDevHelper;
import com.facebook.react.devsupport.RedBoxDialogSurfaceDelegate;
import com.facebook.react.devsupport.StackTraceHelper;
import com.facebook.react.devsupport.interfaces.BundleLoadCallback;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import com.facebook.react.devsupport.interfaces.DevLoadingViewManager;
import com.facebook.react.devsupport.interfaces.DevOptionHandler;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.devsupport.interfaces.ErrorCustomizer;
import com.facebook.react.devsupport.interfaces.ErrorType;
import com.facebook.react.devsupport.interfaces.PackagerStatusCallback;
import com.facebook.react.devsupport.interfaces.PausedInDebuggerOverlayManager;
import com.facebook.react.devsupport.interfaces.RedBoxHandler;
import com.facebook.react.devsupport.interfaces.StackFrame;
import com.facebook.react.modules.core.RCTNativeAppEventEmitter;
import com.facebook.react.modules.debug.interfaces.DeveloperSettings;
import com.facebook.react.packagerconnection.RequestHandler;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0017\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 \u00d1\u00012\u00020\u0001:\u0004\u00d0\u0001\u00d1\u0001By\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011\u0012\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u0012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010|\u001a\u00020}2\u000b\u0010~\u001a\u00070\u007fj\u0003`\u0080\u0001H\u0016J\u001d\u0010\u0081\u0001\u001a\u00020}2\t\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u00072\u0007\u0010~\u001a\u00030\u0083\u0001H\u0016J\u001b\u0010\u0084\u0001\u001a\u00020}2\u0007\u0010\u0085\u0001\u001a\u00020\u00072\u0007\u0010\u0086\u0001\u001a\u00020cH\u0016J)\u0010\u0087\u0001\u001a\u00020}2\t\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u00072\n\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u00012\u0007\u0010\u008a\u0001\u001a\u00020\u000fH\u0016J\u0012\u0010\u008b\u0001\u001a\u00020}2\u0007\u0010\u008c\u0001\u001a\u00020wH\u0016J8\u0010\u008d\u0001\u001a\u0015\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020L0K0\u008e\u00012\u001a\u0010\u008f\u0001\u001a\u0015\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020L0K0\u008e\u0001H\u0016J\t\u0010\u0090\u0001\u001a\u00020}H\u0016J\u0015\u0010\u0091\u0001\u001a\u0005\u0018\u00010\u0092\u00012\u0007\u0010\u0093\u0001\u001a\u00020\u0007H\u0016J\u0015\u0010\u0094\u0001\u001a\u00020}2\n\u0010\u0095\u0001\u001a\u0005\u0018\u00010\u0092\u0001H\u0016J\u0016\u0010\u0096\u0001\u001a\u00020}2\u000b\u0010~\u001a\u00070\u007fj\u0003`\u0080\u0001H\u0002J\t\u0010\u0097\u0001\u001a\u00020}H\u0002J;\u0010\u0098\u0001\u001a\u00020}2\t\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u00072\r\u0010\u0099\u0001\u001a\b\u0012\u0004\u0012\u00020L0K2\u0007\u0010\u008a\u0001\u001a\u00020\u000f2\u0007\u0010\u009a\u0001\u001a\u00020SH\u0002\u00a2\u0006\u0003\u0010\u009b\u0001J\t\u0010\u009c\u0001\u001a\u00020}H\u0016J\u0012\u0010\u009d\u0001\u001a\u00020}2\u0007\u0010\u009e\u0001\u001a\u00020*H\u0016J\u0012\u0010\u009f\u0001\u001a\u00020}2\u0007\u0010\u009e\u0001\u001a\u00020*H\u0016J\t\u0010\u00a0\u0001\u001a\u00020\tH\u0016J\u0014\u0010\u00a1\u0001\u001a\u00020}2\t\u0010\u009e\u0001\u001a\u0004\u0018\u00010*H\u0002J\t\u0010\u00a2\u0001\u001a\u00020}H\u0016J\u0012\u0010\u00a3\u0001\u001a\u00020}2\u0007\u0010\u00a4\u0001\u001a\u00020\u0007H\u0003J\t\u0010\u00a5\u0001\u001a\u00020}H\u0005J\t\u0010\u00a6\u0001\u001a\u00020}H\u0005J\u001a\u0010\u00a7\u0001\u001a\u00020}2\u0007\u0010\u00a8\u0001\u001a\u00020\u00072\b\u0010\u00a9\u0001\u001a\u00030\u00aa\u0001J\u0012\u0010\u00ab\u0001\u001a\u00020}2\u0007\u0010\u00a4\u0001\u001a\u00020\u0007H\u0003J\t\u0010\u00ac\u0001\u001a\u00020}H\u0003J\u0013\u0010\u00ad\u0001\u001a\u00020}2\b\u0010\u00a9\u0001\u001a\u00030\u00ae\u0001H\u0016J\u001d\u0010\u00af\u0001\u001a\u0004\u0018\u00010f2\u0007\u0010\u00b0\u0001\u001a\u00020\u00072\u0007\u0010\u00b1\u0001\u001a\u00020fH\u0016J;\u0010\u00b2\u0001\u001a\u00020}2\t\u0010\u0082\u0001\u001a\u0004\u0018\u00010\u00072\r\u0010\u0099\u0001\u001a\b\u0012\u0004\u0012\u00020L0K2\u0007\u0010\u008a\u0001\u001a\u00020\u000f2\u0007\u0010\u009a\u0001\u001a\u00020SH\u0002\u00a2\u0006\u0003\u0010\u009b\u0001J\u001c\u0010\u00b3\u0001\u001a\u00020}2\u0007\u0010\u00b4\u0001\u001a\u00020\u00072\b\u0010\u00a9\u0001\u001a\u00030\u00b5\u0001H\u0016J\u0017\u0010\u00b6\u0001\u001a\u00020}2\f\u0010\u00b7\u0001\u001a\u00070\u007fj\u0003`\u0080\u0001H\u0002J\t\u0010\u00b8\u0001\u001a\u00020}H\u0016J\t\u0010\u00b9\u0001\u001a\u00020}H\u0016J\u0012\u0010\u00ba\u0001\u001a\u00020}2\u0007\u0010\u00bb\u0001\u001a\u00020\tH\u0016J\u0012\u0010\u00bc\u0001\u001a\u00020}2\u0007\u0010\u00bd\u0001\u001a\u00020\tH\u0016J\t\u0010\u00be\u0001\u001a\u00020}H\u0016J\t\u0010\u00bf\u0001\u001a\u00020}H\u0002J\u0011\u0010\u00c0\u0001\u001a\u00020}2\u0006\u0010x\u001a\u00020yH\u0016J\u0014\u0010\u00c1\u0001\u001a\u0004\u0018\u00010k2\u0007\u0010\u00c2\u0001\u001a\u00020\u0007H\u0016J.\u0010\u00c3\u0001\u001a\u00020}2\u0007\u0010\u00c4\u0001\u001a\u00020\u00032\u0007\u0010\u00c5\u0001\u001a\u00020`2\b\u0010\u00c6\u0001\u001a\u00030\u00c7\u00012\u0007\u0010\u00c8\u0001\u001a\u00020\tH\u0002J\t\u0010\u00c9\u0001\u001a\u00020}H\u0016J\u001c\u0010\u00ca\u0001\u001a\u00020}2\u0007\u0010\u0082\u0001\u001a\u00020\u00072\b\u0010\u00cb\u0001\u001a\u00030\u00cc\u0001H\u0016J\t\u0010\u00cd\u0001\u001a\u00020}H\u0016J\u001a\u0010\u00ce\u0001\u001a\u00020}2\u0007\u0010\u00cf\u0001\u001a\u00020\u00072\u0006\u0010)\u001a\u00020\u0007H\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0015\u0010\u0006\u001a\u0004\u0018\u00010\u00078G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0016\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010'\u001a\u00020\u0007X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010 R\"\u0010+\u001a\u0004\u0018\u00010*2\b\u0010)\u001a\u0004\u0018\u00010*@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010.\u001a\u00020/\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0016\u00102\u001a\u0004\u0018\u0001038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b4\u00105R$\u00107\u001a\u00020\t2\u0006\u00106\u001a\u00020\t8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0014\u0010<\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b=\u0010 R\u0014\u0010>\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b?\u0010 R\u0014\u0010@\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bA\u0010 R\u0011\u0010B\u001a\u00020C\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u001c\u0010F\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010 \"\u0004\bH\u0010IR$\u0010J\u001a\n\u0012\u0004\u0012\u00020L\u0018\u00010KX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010Q\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u001c\u0010R\u001a\u0004\u0018\u00010SX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010U\"\u0004\bV\u0010WR\u001a\u0010X\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bY\u0010Z\"\u0004\b[\u0010\\R\u000e\u0010]\u001a\u00020^X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010_\u001a\u00020`X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010a\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020c0bj\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020c`dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010e\u001a\u00020fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010g\u001a\u00020fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010h\u001a\u00020iX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010j\u001a\u0004\u0018\u00010kX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010l\u001a\u0004\u0018\u00010mX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010n\u001a\u0004\u0018\u00010oX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010p\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010q\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010r\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010s\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00106\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010t\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010u\u001a\b\u0012\u0004\u0012\u00020w0vX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010x\u001a\u0004\u0018\u00010yX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010z\u001a\u0004\u0018\u00010\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b{\u0010 \u00a8\u0006\u00d2\u0001"}, d2={"Lcom/facebook/react/devsupport/DevSupportManagerBase;", "Lcom/facebook/react/devsupport/interfaces/DevSupportManager;", "applicationContext", "Landroid/content/Context;", "reactInstanceDevHelper", "Lcom/facebook/react/devsupport/ReactInstanceDevHelper;", "jsAppBundleName", "", "enableOnCreate", "", "redBoxHandler", "Lcom/facebook/react/devsupport/interfaces/RedBoxHandler;", "devBundleDownloadListener", "Lcom/facebook/react/devsupport/interfaces/DevBundleDownloadListener;", "minNumShakes", "", "customPackagerCommandHandlers", "", "Lcom/facebook/react/packagerconnection/RequestHandler;", "surfaceDelegateFactory", "Lcom/facebook/react/common/SurfaceDelegateFactory;", "devLoadingViewManager", "Lcom/facebook/react/devsupport/interfaces/DevLoadingViewManager;", "pausedInDebuggerOverlayManager", "Lcom/facebook/react/devsupport/interfaces/PausedInDebuggerOverlayManager;", "<init>", "(Landroid/content/Context;Lcom/facebook/react/devsupport/ReactInstanceDevHelper;Ljava/lang/String;ZLcom/facebook/react/devsupport/interfaces/RedBoxHandler;Lcom/facebook/react/devsupport/interfaces/DevBundleDownloadListener;ILjava/util/Map;Lcom/facebook/react/common/SurfaceDelegateFactory;Lcom/facebook/react/devsupport/interfaces/DevLoadingViewManager;Lcom/facebook/react/devsupport/interfaces/PausedInDebuggerOverlayManager;)V", "getApplicationContext", "()Landroid/content/Context;", "getReactInstanceDevHelper", "()Lcom/facebook/react/devsupport/ReactInstanceDevHelper;", "getJSAppBundleName", "()Ljava/lang/String;", "getRedBoxHandler", "()Lcom/facebook/react/devsupport/interfaces/RedBoxHandler;", "getDevLoadingViewManager", "()Lcom/facebook/react/devsupport/interfaces/DevLoadingViewManager;", "setDevLoadingViewManager", "(Lcom/facebook/react/devsupport/interfaces/DevLoadingViewManager;)V", "uniqueTag", "getUniqueTag", "value", "Lcom/facebook/react/bridge/ReactContext;", "currentReactContext", "getCurrentReactContext", "()Lcom/facebook/react/bridge/ReactContext;", "devSettings", "Lcom/facebook/react/modules/debug/interfaces/DeveloperSettings;", "getDevSettings", "()Lcom/facebook/react/modules/debug/interfaces/DeveloperSettings;", "currentActivity", "Landroid/app/Activity;", "getCurrentActivity", "()Landroid/app/Activity;", "isDevSupportEnabled", "devSupportEnabled", "getDevSupportEnabled", "()Z", "setDevSupportEnabled", "(Z)V", "sourceMapUrl", "getSourceMapUrl", "sourceUrl", "getSourceUrl", "downloadedJSBundleFile", "getDownloadedJSBundleFile", "devServerHelper", "Lcom/facebook/react/devsupport/DevServerHelper;", "getDevServerHelper", "()Lcom/facebook/react/devsupport/DevServerHelper;", "lastErrorTitle", "getLastErrorTitle", "setLastErrorTitle", "(Ljava/lang/String;)V", "lastErrorStack", "", "Lcom/facebook/react/devsupport/interfaces/StackFrame;", "getLastErrorStack", "()[Lcom/facebook/react/devsupport/interfaces/StackFrame;", "setLastErrorStack", "([Lcom/facebook/react/devsupport/interfaces/StackFrame;)V", "[Lcom/facebook/react/devsupport/interfaces/StackFrame;", "lastErrorType", "Lcom/facebook/react/devsupport/interfaces/ErrorType;", "getLastErrorType", "()Lcom/facebook/react/devsupport/interfaces/ErrorType;", "setLastErrorType", "(Lcom/facebook/react/devsupport/interfaces/ErrorType;)V", "lastErrorCookie", "getLastErrorCookie", "()I", "setLastErrorCookie", "(I)V", "shakeDetector", "Lcom/facebook/react/common/ShakeDetector;", "reloadAppBroadcastReceiver", "Landroid/content/BroadcastReceiver;", "customDevOptions", "Ljava/util/LinkedHashMap;", "Lcom/facebook/react/devsupport/interfaces/DevOptionHandler;", "Lkotlin/collections/LinkedHashMap;", "jsBundleDownloadedFile", "Ljava/io/File;", "jsSplitBundlesDir", "defaultJSExceptionHandler", "Lcom/facebook/react/bridge/DefaultJSExceptionHandler;", "redBoxSurfaceDelegate", "Lcom/facebook/react/common/SurfaceDelegate;", "devOptionsDialog", "Landroid/app/AlertDialog;", "debugOverlayController", "Lcom/facebook/react/devsupport/DebugOverlayController;", "devLoadingViewVisible", "pendingJSSplitBundleRequests", "isReceiverRegistered", "isShakeDetectorStarted", "isPackagerConnected", "errorCustomizers", "", "Lcom/facebook/react/devsupport/interfaces/ErrorCustomizer;", "packagerLocationCustomizer", "Lcom/facebook/react/devsupport/interfaces/DevSupportManager$PackagerLocationCustomizer;", "jSExecutorDescription", "getJSExecutorDescription", "handleException", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "showNewJavaError", "message", "", "addCustomDevOption", "optionName", "optionHandler", "showNewJSError", "details", "Lcom/facebook/react/bridge/ReadableArray;", "errorCookie", "registerErrorCustomizer", "errorCustomizer", "processErrorCustomizers", "Landroid/util/Pair;", "errorInfo", "hideRedboxDialog", "createRootView", "Landroid/view/View;", "appKey", "destroyRootView", "rootView", "logJSException", "hideDevOptionsDialog", "showNewError", "stack", "errorType", "(Ljava/lang/String;[Lcom/facebook/react/devsupport/interfaces/StackFrame;ILcom/facebook/react/devsupport/interfaces/ErrorType;)V", "showDevOptionsDialog", "onNewReactContextCreated", "reactContext", "onReactInstanceDestroyed", "hasUpToDateJSBundleInCache", "resetCurrentContext", "reloadSettings", "showDevLoadingViewForUrl", "bundleUrl", "showDevLoadingViewForRemoteJSEnabled", "hideDevLoadingView", "fetchSplitBundleAndCreateBundleLoader", "bundlePath", "callback", "Lcom/facebook/react/devsupport/DevSupportManagerBase$CallbackWithBundleLoader;", "showSplitBundleDevLoadingView", "hideSplitBundleDevLoadingView", "isPackagerRunning", "Lcom/facebook/react/devsupport/interfaces/PackagerStatusCallback;", "downloadBundleResourceFromUrlSync", "resourceURL", "outputFile", "updateLastErrorInfo", "reloadJSFromServer", "bundleURL", "Lcom/facebook/react/devsupport/interfaces/BundleLoadCallback;", "reportBundleLoadingFailure", "cause", "startInspector", "stopInspector", "setHotModuleReplacementEnabled", "isHotModuleReplacementEnabled", "setFpsDebugEnabled", "isFpsDebugEnabled", "toggleElementInspector", "reload", "setPackagerLocationCustomizer", "createSurfaceDelegate", "moduleName", "compatRegisterReceiver", "context", "receiver", "filter", "Landroid/content/IntentFilter;", "exported", "openDebugger", "showPausedInDebuggerOverlay", "listener", "Lcom/facebook/react/devsupport/interfaces/DevSupportManager$PausedInDebuggerOverlayCommandListener;", "hidePausedInDebuggerOverlay", "setAdditionalOptionForPackager", "name", "CallbackWithBundleLoader", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nDevSupportManagerBase.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DevSupportManagerBase.kt\ncom/facebook/react/devsupport/DevSupportManagerBase\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,904:1\n1#2:905\n37#3:906\n36#3,3:907\n37#3:910\n36#3,3:911\n*S KotlinDebug\n*F\n+ 1 DevSupportManagerBase.kt\ncom/facebook/react/devsupport/DevSupportManagerBase\n*L\n408#1:906\n408#1:907,3\n445#1:910\n445#1:911,3\n*E\n"})
public abstract class DevSupportManagerBase
implements DevSupportManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context applicationContext;
    @NotNull
    private final ReactInstanceDevHelper reactInstanceDevHelper;
    @Nullable
    private final String jsAppBundleName;
    @Nullable
    private final RedBoxHandler redBoxHandler;
    @Nullable
    private final DevBundleDownloadListener devBundleDownloadListener;
    @Nullable
    private final Map<String, RequestHandler> customPackagerCommandHandlers;
    @Nullable
    private final SurfaceDelegateFactory surfaceDelegateFactory;
    @Nullable
    private DevLoadingViewManager devLoadingViewManager;
    @Nullable
    private PausedInDebuggerOverlayManager pausedInDebuggerOverlayManager;
    @Nullable
    private ReactContext currentReactContext;
    @NotNull
    private final DeveloperSettings devSettings;
    @NotNull
    private final DevServerHelper devServerHelper;
    @Nullable
    private String lastErrorTitle;
    @Nullable
    private StackFrame[] lastErrorStack;
    @Nullable
    private ErrorType lastErrorType;
    private int lastErrorCookie;
    @NotNull
    private final ShakeDetector shakeDetector;
    @NotNull
    private final BroadcastReceiver reloadAppBroadcastReceiver;
    @NotNull
    private final LinkedHashMap<String, DevOptionHandler> customDevOptions;
    @NotNull
    private final File jsBundleDownloadedFile;
    @NotNull
    private final File jsSplitBundlesDir;
    @NotNull
    private final DefaultJSExceptionHandler defaultJSExceptionHandler;
    @Nullable
    private SurfaceDelegate redBoxSurfaceDelegate;
    @Nullable
    private AlertDialog devOptionsDialog;
    @Nullable
    private DebugOverlayController debugOverlayController;
    private boolean devLoadingViewVisible;
    private int pendingJSSplitBundleRequests;
    private boolean isReceiverRegistered;
    private boolean isShakeDetectorStarted;
    private boolean isDevSupportEnabled;
    private boolean isPackagerConnected;
    @NotNull
    private final List<ErrorCustomizer> errorCustomizers;
    @Nullable
    private DevSupportManager.PackagerLocationCustomizer packagerLocationCustomizer;
    private static final int JAVA_ERROR_COOKIE = -1;
    private static final int JSEXCEPTION_ERROR_COOKIE = -1;
    @NotNull
    private static final String RELOAD_APP_ACTION_SUFFIX = ".RELOAD_APP_ACTION";
    @NotNull
    private static final String EXOPACKAGE_LOCATION_FORMAT = "/data/local/tmp/exopackage/%s//secondary-dex";

    public DevSupportManagerBase(@NotNull Context applicationContext, @NotNull ReactInstanceDevHelper reactInstanceDevHelper, @Nullable String jsAppBundleName, boolean enableOnCreate, @Nullable RedBoxHandler redBoxHandler, @Nullable DevBundleDownloadListener devBundleDownloadListener, int minNumShakes, @Nullable Map<String, ? extends RequestHandler> customPackagerCommandHandlers, @Nullable SurfaceDelegateFactory surfaceDelegateFactory, @Nullable DevLoadingViewManager devLoadingViewManager, @Nullable PausedInDebuggerOverlayManager pausedInDebuggerOverlayManager) {
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        Intrinsics.checkNotNullParameter((Object)reactInstanceDevHelper, (String)"reactInstanceDevHelper");
        this.applicationContext = applicationContext;
        this.reactInstanceDevHelper = reactInstanceDevHelper;
        this.jsAppBundleName = jsAppBundleName;
        this.redBoxHandler = redBoxHandler;
        this.devBundleDownloadListener = devBundleDownloadListener;
        this.customPackagerCommandHandlers = customPackagerCommandHandlers;
        this.surfaceDelegateFactory = surfaceDelegateFactory;
        this.devLoadingViewManager = devLoadingViewManager;
        this.pausedInDebuggerOverlayManager = pausedInDebuggerOverlayManager;
        this.devSettings = new DevInternalSettings(this.applicationContext, new DevInternalSettings.Listener(this){
            final /* synthetic */ DevSupportManagerBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void onInternalSettingsChanged() {
                this.this$0.reloadSettings();
            }
        });
        this.devServerHelper = new DevServerHelper(this.devSettings, this.applicationContext, this.devSettings.getPackagerConnectionSettings());
        this.shakeDetector = new ShakeDetector(() -> DevSupportManagerBase.shakeDetector$lambda$2(this), minNumShakes);
        this.reloadAppBroadcastReceiver = new BroadcastReceiver(this){
            final /* synthetic */ DevSupportManagerBase this$0;
            {
                this.this$0 = $receiver;
            }

            public void onReceive(Context context, Intent intent) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                String action = intent.getAction();
                if (Intrinsics.areEqual((Object)com.facebook.react.devsupport.DevSupportManagerBase$Companion.access$getReloadAppAction(DevSupportManagerBase.Companion, context), (Object)action)) {
                    this.this$0.handleReloadJS();
                }
            }
        };
        this.customDevOptions = new LinkedHashMap();
        this.defaultJSExceptionHandler = new DefaultJSExceptionHandler();
        this.errorCustomizers = new ArrayList();
        String subclassTag = this.getUniqueTag();
        String bundleFile = subclassTag + "ReactNativeDevBundle.js";
        this.jsBundleDownloadedFile = new File(this.applicationContext.getFilesDir(), bundleFile);
        String string2 = subclassTag.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String splitBundlesDir = string2 + "_dev_js_split_bundles";
        File file = this.applicationContext.getDir(splitBundlesDir, 0);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"getDir(...)");
        this.jsSplitBundlesDir = file;
        this.setDevSupportEnabled(enableOnCreate);
        if (this.devLoadingViewManager == null) {
            this.devLoadingViewManager = new DefaultDevLoadingViewImplementation(this.reactInstanceDevHelper);
        }
        if (this.pausedInDebuggerOverlayManager == null) {
            this.pausedInDebuggerOverlayManager = new PausedInDebuggerOverlayDialogManager((Supplier<Context>)((Supplier)() -> DevSupportManagerBase._init_$lambda$3(this)));
        }
    }

    @NotNull
    protected final Context getApplicationContext() {
        return this.applicationContext;
    }

    @NotNull
    public final ReactInstanceDevHelper getReactInstanceDevHelper() {
        return this.reactInstanceDevHelper;
    }

    @JvmName(name="getJSAppBundleName")
    @Nullable
    public final String getJSAppBundleName() {
        return this.jsAppBundleName;
    }

    @Override
    @Nullable
    public RedBoxHandler getRedBoxHandler() {
        return this.redBoxHandler;
    }

    @Nullable
    public final DevLoadingViewManager getDevLoadingViewManager() {
        return this.devLoadingViewManager;
    }

    public final void setDevLoadingViewManager(@Nullable DevLoadingViewManager devLoadingViewManager) {
        this.devLoadingViewManager = devLoadingViewManager;
    }

    @NotNull
    protected abstract String getUniqueTag();

    @Override
    @Nullable
    public final ReactContext getCurrentReactContext() {
        return this.currentReactContext;
    }

    @Override
    @NotNull
    public final DeveloperSettings getDevSettings() {
        return this.devSettings;
    }

    @Override
    @Nullable
    public Activity getCurrentActivity() {
        return this.reactInstanceDevHelper.getCurrentActivity();
    }

    @Override
    public final boolean getDevSupportEnabled() {
        return this.isDevSupportEnabled;
    }

    @Override
    public final void setDevSupportEnabled(boolean isDevSupportEnabled) {
        this.isDevSupportEnabled = isDevSupportEnabled;
        this.reloadSettings();
    }

    @Override
    @NotNull
    public String getSourceMapUrl() {
        String string2;
        block3: {
            block2: {
                string2 = this.jsAppBundleName;
                if (string2 == null) break block2;
                String it = string2;
                boolean bl = false;
                String string3 = this.devServerHelper.getSourceMapUrl(it);
                string2 = string3;
                if (string3 != null) break block3;
            }
            string2 = "";
        }
        return string2;
    }

    @Override
    @NotNull
    public String getSourceUrl() {
        String string2;
        block3: {
            block2: {
                string2 = this.jsAppBundleName;
                if (string2 == null) break block2;
                String it = string2;
                boolean bl = false;
                String string3 = this.devServerHelper.getSourceUrl(it);
                string2 = string3;
                if (string3 != null) break block3;
            }
            string2 = "";
        }
        return string2;
    }

    @Override
    @NotNull
    public String getDownloadedJSBundleFile() {
        String string2 = this.jsBundleDownloadedFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
        return string2;
    }

    @NotNull
    public final DevServerHelper getDevServerHelper() {
        return this.devServerHelper;
    }

    @Override
    @Nullable
    public final String getLastErrorTitle() {
        return this.lastErrorTitle;
    }

    public final void setLastErrorTitle(@Nullable String string2) {
        this.lastErrorTitle = string2;
    }

    @Override
    @Nullable
    public final StackFrame[] getLastErrorStack() {
        return this.lastErrorStack;
    }

    public final void setLastErrorStack(@Nullable StackFrame[] stackFrameArray) {
        this.lastErrorStack = stackFrameArray;
    }

    @Override
    @Nullable
    public final ErrorType getLastErrorType() {
        return this.lastErrorType;
    }

    public final void setLastErrorType(@Nullable ErrorType errorType) {
        this.lastErrorType = errorType;
    }

    @Override
    public final int getLastErrorCookie() {
        return this.lastErrorCookie;
    }

    public final void setLastErrorCookie(int n) {
        this.lastErrorCookie = n;
    }

    private final String getJSExecutorDescription() {
        String string2;
        try {
            string2 = this.reactInstanceDevHelper.getJavaScriptExecutorFactory().toString();
        }
        catch (IllegalStateException e) {
            string2 = null;
        }
        return string2;
    }

    @Override
    public void handleException(@NotNull Exception e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (this.isDevSupportEnabled) {
            this.logJSException(e);
        } else {
            this.defaultJSExceptionHandler.handleException(e);
        }
    }

    @Override
    public void showNewJavaError(@Nullable String message, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        FLog.e((String)"ReactNative", (String)"Exception in native call", (Throwable)e);
        this.showNewError(message, StackTraceHelper.convertJavaStackTrace(e), -1, ErrorType.NATIVE);
    }

    @Override
    public void addCustomDevOption(@NotNull String optionName, @NotNull DevOptionHandler optionHandler) {
        Intrinsics.checkNotNullParameter((Object)optionName, (String)"optionName");
        Intrinsics.checkNotNullParameter((Object)optionHandler, (String)"optionHandler");
        ((Map)this.customDevOptions).put(optionName, optionHandler);
    }

    @Override
    public void showNewJSError(@Nullable String message, @Nullable ReadableArray details, int errorCookie) {
        this.showNewError(message, StackTraceHelper.convertJsStackTrace(details), errorCookie, ErrorType.JS);
    }

    @Override
    public void registerErrorCustomizer(@NotNull ErrorCustomizer errorCustomizer) {
        Intrinsics.checkNotNullParameter((Object)errorCustomizer, (String)"errorCustomizer");
        this.errorCustomizers.add(errorCustomizer);
    }

    @Override
    @NotNull
    public Pair<String, StackFrame[]> processErrorCustomizers(@NotNull Pair<String, StackFrame[]> errorInfo) {
        Intrinsics.checkNotNullParameter(errorInfo, (String)"errorInfo");
        Pair<String, StackFrame[]> errorInfoLocal = errorInfo;
        for (ErrorCustomizer errorCustomizer : this.errorCustomizers) {
            errorInfoLocal = errorCustomizer.customizeErrorInfo(errorInfo);
        }
        return errorInfoLocal;
    }

    @Override
    public void hideRedboxDialog() {
        block0: {
            SurfaceDelegate surfaceDelegate = this.redBoxSurfaceDelegate;
            if (surfaceDelegate == null) break block0;
            surfaceDelegate.hide();
        }
    }

    @Override
    @Nullable
    public View createRootView(@NotNull String appKey) {
        Intrinsics.checkNotNullParameter((Object)appKey, (String)"appKey");
        return this.reactInstanceDevHelper.createRootView(appKey);
    }

    @Override
    public void destroyRootView(@Nullable View rootView) {
        block0: {
            View view = rootView;
            if (view == null) break block0;
            View it = view;
            boolean bl = false;
            this.reactInstanceDevHelper.destroyRootView(it);
        }
    }

    private final void logJSException(Exception e) {
        String string2 = e.getMessage();
        if (string2 == null) {
            string2 = "Exception in native call from JS";
        }
        StringBuilder message = new StringBuilder(string2);
        for (Throwable cause = e.getCause(); cause != null; cause = cause.getCause()) {
            message.append("\n\n").append(cause.getMessage());
        }
        if (e instanceof JavascriptException) {
            FLog.e((String)"ReactNative", (String)"Exception in native call from JS", (Throwable)e);
            this.showNewError(e.getMessage(), new StackFrame[0], -1, ErrorType.JS);
        } else {
            this.showNewJavaError(message.toString(), e);
        }
    }

    private final void hideDevOptionsDialog() {
        AlertDialog alertDialog = this.devOptionsDialog;
        if (alertDialog != null) {
            alertDialog.dismiss();
        }
        this.devOptionsDialog = null;
    }

    private final void showNewError(String message, StackFrame[] stack, int errorCookie, ErrorType errorType) {
        UiThreadUtil.runOnUiThread(() -> DevSupportManagerBase.showNewError$lambda$6(this, message, stack, errorCookie, errorType));
    }

    @Override
    public void showDevOptionsDialog() {
        String debuggerItemString;
        if (this.devOptionsDialog != null || !this.isDevSupportEnabled || ActivityManager.isUserAMonkey()) {
            return;
        }
        LinkedHashMap options = new LinkedHashMap();
        Set disabledItemKeys = new HashSet();
        ((Map)options).put(this.applicationContext.getString(R.string.catalyst_reload), () -> DevSupportManagerBase.showDevOptionsDialog$lambda$7(this));
        if (this.devSettings.isDeviceDebugEnabled()) {
            boolean isConnected = this.isPackagerConnected;
            String string2 = this.applicationContext.getString(isConnected ? R.string.catalyst_debug_open : R.string.catalyst_debug_open_disabled);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            debuggerItemString = string2;
            if (!isConnected) {
                disabledItemKeys.add(debuggerItemString);
            }
            ((Map)options).put(debuggerItemString, () -> DevSupportManagerBase.showDevOptionsDialog$lambda$8(this));
        }
        ((Map)options).put(this.applicationContext.getString(R.string.catalyst_change_bundle_location), () -> DevSupportManagerBase.showDevOptionsDialog$lambda$10(this));
        ((Map)options).put(this.applicationContext.getString(R.string.catalyst_inspector_toggle), () -> DevSupportManagerBase.showDevOptionsDialog$lambda$11(this));
        debuggerItemString = this.devSettings.isHotModuleReplacementEnabled() ? this.applicationContext.getString(R.string.catalyst_hot_reloading_stop) : this.applicationContext.getString(R.string.catalyst_hot_reloading);
        Intrinsics.checkNotNull((Object)debuggerItemString);
        String hotReloadLabel = debuggerItemString;
        ((Map)options).put(hotReloadLabel, () -> DevSupportManagerBase.showDevOptionsDialog$lambda$12(this));
        String string3 = this.devSettings.isFpsDebugEnabled() ? this.applicationContext.getString(R.string.catalyst_perf_monitor_stop) : this.applicationContext.getString(R.string.catalyst_perf_monitor);
        Intrinsics.checkNotNull((Object)string3);
        String fpsDebugLabel = string3;
        ((Map)options).put(fpsDebugLabel, () -> DevSupportManagerBase.showDevOptionsDialog$lambda$13(this));
        ((Map)options).put(this.applicationContext.getString(R.string.catalyst_settings), () -> DevSupportManagerBase.showDevOptionsDialog$lambda$14(this));
        if (!((Map)this.customDevOptions).isEmpty()) {
            options.putAll(this.customDevOptions);
        }
        TextView textView = options.values();
        Intrinsics.checkNotNullExpressionValue(textView, (String)"<get-values>(...)");
        TextView $this$toTypedArray$iv = textView;
        boolean $i$f$toTypedArray = false;
        TextView thisCollection$iv = $this$toTypedArray$iv;
        DevOptionHandler[] optionHandlers = thisCollection$iv.toArray(new DevOptionHandler[0]);
        Activity context = this.reactInstanceDevHelper.getCurrentActivity();
        if (context == null || context.isFinishing()) {
            FLog.e((String)"ReactNative", (String)"Unable to launch dev options menu because react activity isn't available");
            return;
        }
        LinearLayout header = new LinearLayout((Context)context);
        header.setOrientation(1);
        TextView $this$showDevOptionsDialog_u24lambda_u2415 = thisCollection$iv = new TextView((Context)context);
        boolean bl = false;
        Object[] objectArray = new Object[]{this.getUniqueTag()};
        $this$showDevOptionsDialog_u24lambda_u2415.setText((CharSequence)context.getString(R.string.catalyst_dev_menu_header, objectArray));
        $this$showDevOptionsDialog_u24lambda_u2415.setPadding(0, 50, 0, 0);
        $this$showDevOptionsDialog_u24lambda_u2415.setGravity(17);
        $this$showDevOptionsDialog_u24lambda_u2415.setTextSize(16.0f);
        $this$showDevOptionsDialog_u24lambda_u2415.setTypeface($this$showDevOptionsDialog_u24lambda_u2415.getTypeface(), 1);
        header.addView((View)$this$showDevOptionsDialog_u24lambda_u2415);
        String jsExecutorDescription = this.getJSExecutorDescription();
        if (jsExecutorDescription != null) {
            TextView $this$showDevOptionsDialog_u24lambda_u2416 = $this$showDevOptionsDialog_u24lambda_u2415 = new TextView((Context)context);
            boolean bl2 = false;
            Object[] objectArray2 = new Object[]{jsExecutorDescription};
            $this$showDevOptionsDialog_u24lambda_u2416.setText((CharSequence)context.getString(R.string.catalyst_dev_menu_sub_header, objectArray2));
            $this$showDevOptionsDialog_u24lambda_u2416.setPadding(0, 20, 0, 0);
            $this$showDevOptionsDialog_u24lambda_u2416.setGravity(17);
            $this$showDevOptionsDialog_u24lambda_u2416.setTextSize(14.0f);
            header.addView((View)$this$showDevOptionsDialog_u24lambda_u2416);
        }
        Set set = options.keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Collection $this$toTypedArray$iv2 = set;
        boolean $i$f$toTypedArray2 = false;
        Collection thisCollection$iv2 = $this$toTypedArray$iv2;
        String[] $this$showDevOptionsDialog_u24lambda_u2416 = thisCollection$iv2.toArray(new String[0]);
        ListAdapter adapter2 = (ListAdapter)new ArrayAdapter<String>(context, (Set<String>)disabledItemKeys, $this$showDevOptionsDialog_u24lambda_u2416){
            final /* synthetic */ Set<String> $disabledItemKeys;
            {
                this.$disabledItemKeys = $disabledItemKeys;
                super((Context)$context, 17367043, (Object[])$super_call_param$1);
            }

            public boolean areAllItemsEnabled() {
                return false;
            }

            public boolean isEnabled(int position) {
                return !this.$disabledItemKeys.contains(this.getItem(position));
            }

            public View getView(int position, View convertView, ViewGroup parent) {
                View view;
                Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
                View view2 = super.getView(position, convertView, parent);
                Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"getView(...)");
                View $this$getView_u24lambda_u240 = view = view2;
                boolean bl = false;
                $this$getView_u24lambda_u240.setEnabled(this.isEnabled(position));
                return view;
            }
        };
        AlertDialog alertDialog = this.devOptionsDialog = new AlertDialog.Builder((Context)context).setCustomTitle((View)header).setAdapter(adapter2, (arg_0, arg_1) -> DevSupportManagerBase.showDevOptionsDialog$lambda$17(optionHandlers, this, arg_0, arg_1)).setOnCancelListener(arg_0 -> DevSupportManagerBase.showDevOptionsDialog$lambda$18(this, arg_0)).create();
        if (alertDialog != null) {
            alertDialog.show();
        }
        ReactContext reactContext = this.currentReactContext;
        if (reactContext != null) {
            reactContext.getJSModule(RCTNativeAppEventEmitter.class).emit("RCTDevMenuShown", null);
        }
    }

    @Override
    public void onNewReactContextCreated(@NotNull ReactContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        this.resetCurrentContext(reactContext);
    }

    @Override
    public void onReactInstanceDestroyed(@NotNull ReactContext reactContext) {
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        if (reactContext == this.currentReactContext) {
            this.resetCurrentContext(null);
        }
        System.gc();
    }

    @Override
    public boolean hasUpToDateJSBundleInCache() {
        if (this.isDevSupportEnabled && this.jsBundleDownloadedFile.exists()) {
            try {
                String packageName = this.applicationContext.getPackageName();
                PackageManager packageManager = this.applicationContext.getPackageManager();
                if (packageManager != null) {
                    PackageInfo thisPackage = packageManager.getPackageInfo(packageName, 0);
                    if (this.jsBundleDownloadedFile.lastModified() > thisPackage.lastUpdateTime) {
                        Locale locale = Locale.US;
                        String string2 = EXOPACKAGE_LOCATION_FORMAT;
                        Object[] objectArray = new Object[]{packageName};
                        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
                        File exopackageDir = new File(string3);
                        if (exopackageDir.exists()) {
                            return this.jsBundleDownloadedFile.lastModified() > exopackageDir.lastModified();
                        }
                        return true;
                    }
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                FLog.e((String)"ReactNative", (String)"DevSupport is unable to get current app info");
            }
        }
        return false;
    }

    private final void resetCurrentContext(ReactContext reactContext) {
        if (this.currentReactContext == reactContext) {
            return;
        }
        this.currentReactContext = reactContext;
        DebugOverlayController debugOverlayController = this.debugOverlayController;
        if (debugOverlayController != null) {
            debugOverlayController.setFpsDebugViewVisible(false);
        }
        ReactContext reactContext2 = reactContext;
        if (reactContext2 != null) {
            ReactContext it = reactContext2;
            boolean bl = false;
            this.debugOverlayController = new DebugOverlayController(it);
        }
        if (reactContext != null) {
            try {
                URL sourceUrl = new URL(this.getSourceUrl());
                String path = sourceUrl.getPath();
                if (path != null) {
                    String string2 = path.substring(1);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                    path = string2;
                }
                String host = sourceUrl.getHost();
                String scheme = sourceUrl.getProtocol();
                int port = sourceUrl.getPort() != -1 ? sourceUrl.getPort() : sourceUrl.getDefaultPort();
                reactContext.getJSModule(HMRClient.class).setup("android", path, host, port, this.devSettings.isHotModuleReplacementEnabled(), scheme);
            }
            catch (MalformedURLException e) {
                this.showNewJavaError(e.getMessage(), e);
            }
        }
        this.reloadSettings();
    }

    @Override
    public void reloadSettings() {
        if (UiThreadUtil.isOnUiThread()) {
            this.reload();
        } else {
            UiThreadUtil.runOnUiThread(() -> DevSupportManagerBase.reloadSettings$lambda$20(this));
        }
    }

    @UiThread
    private final void showDevLoadingViewForUrl(String bundleUrl) {
        URL parsedURL = null;
        try {
            parsedURL = new URL(bundleUrl);
        }
        catch (MalformedURLException e) {
            FLog.e((String)"ReactNative", (String)("Bundle url format is invalid. \n\n" + e));
            return;
        }
        int port = parsedURL.getPort() != -1 ? parsedURL.getPort() : parsedURL.getDefaultPort();
        DevLoadingViewManager devLoadingViewManager = this.devLoadingViewManager;
        if (devLoadingViewManager != null) {
            Object[] objectArray = new Object[]{parsedURL.getHost() + ":" + port};
            String string2 = this.applicationContext.getString(R.string.catalyst_loading_from_url, objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            devLoadingViewManager.showMessage(string2);
        }
        this.devLoadingViewVisible = true;
    }

    @UiThread
    protected final void showDevLoadingViewForRemoteJSEnabled() {
        DevLoadingViewManager devLoadingViewManager = this.devLoadingViewManager;
        if (devLoadingViewManager != null) {
            String string2 = this.applicationContext.getString(R.string.catalyst_debug_connecting);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            devLoadingViewManager.showMessage(string2);
        }
        this.devLoadingViewVisible = true;
    }

    @UiThread
    protected final void hideDevLoadingView() {
        DevLoadingViewManager devLoadingViewManager = this.devLoadingViewManager;
        if (devLoadingViewManager != null) {
            devLoadingViewManager.hide();
        }
        this.devLoadingViewVisible = false;
    }

    public final void fetchSplitBundleAndCreateBundleLoader(@NotNull String bundlePath, @NotNull CallbackWithBundleLoader callback) {
        Intrinsics.checkNotNullParameter((Object)bundlePath, (String)"bundlePath");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        String bundleUrl = this.devServerHelper.getDevServerSplitBundleURL(bundlePath);
        CharSequence charSequence = bundlePath;
        Regex regex = new Regex("/");
        String string2 = "_";
        File bundleFile = new File(this.jsSplitBundlesDir, regex.replace(charSequence, string2) + ".jsbundle");
        UiThreadUtil.runOnUiThread(() -> DevSupportManagerBase.fetchSplitBundleAndCreateBundleLoader$lambda$21(this, bundleUrl, bundleFile, callback));
    }

    @UiThread
    private final void showSplitBundleDevLoadingView(String bundleUrl) {
        this.showDevLoadingViewForUrl(bundleUrl);
        int n = this.pendingJSSplitBundleRequests;
        this.pendingJSSplitBundleRequests = n + 1;
    }

    @UiThread
    private final void hideSplitBundleDevLoadingView() {
        this.pendingJSSplitBundleRequests += -1;
        if (this.pendingJSSplitBundleRequests == 0) {
            this.hideDevLoadingView();
        }
    }

    @Override
    public void isPackagerRunning(@NotNull PackagerStatusCallback callback) {
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        Runnable checkPackagerRunning = () -> DevSupportManagerBase.isPackagerRunning$lambda$22(this, callback);
        DevSupportManager.PackagerLocationCustomizer packagerLocationCustomizer = this.packagerLocationCustomizer;
        if (packagerLocationCustomizer != null) {
            packagerLocationCustomizer.run(checkPackagerRunning);
        } else {
            checkPackagerRunning.run();
        }
    }

    @Override
    @Nullable
    public File downloadBundleResourceFromUrlSync(@NotNull String resourceURL, @NotNull File outputFile) {
        Intrinsics.checkNotNullParameter((Object)resourceURL, (String)"resourceURL");
        Intrinsics.checkNotNullParameter((Object)outputFile, (String)"outputFile");
        return this.devServerHelper.downloadBundleResourceFromUrlSync(resourceURL, outputFile);
    }

    private final void updateLastErrorInfo(String message, StackFrame[] stack, int errorCookie, ErrorType errorType) {
        this.lastErrorTitle = message;
        this.lastErrorStack = stack;
        this.lastErrorCookie = errorCookie;
        this.lastErrorType = errorType;
    }

    @Override
    public void reloadJSFromServer(@NotNull String bundleURL, @NotNull BundleLoadCallback callback) {
        Intrinsics.checkNotNullParameter((Object)bundleURL, (String)"bundleURL");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        ReactMarker.logMarker(ReactMarkerConstants.DOWNLOAD_START);
        this.showDevLoadingViewForUrl(bundleURL);
        BundleDownloader.BundleInfo bundleInfo = new BundleDownloader.BundleInfo();
        DevServerHelper.downloadBundleFromURL$default(this.devServerHelper, new DevBundleDownloadListener(this, bundleInfo, callback){
            final /* synthetic */ DevSupportManagerBase this$0;
            final /* synthetic */ BundleDownloader.BundleInfo $bundleInfo;
            final /* synthetic */ BundleLoadCallback $callback;
            {
                this.this$0 = $receiver;
                this.$bundleInfo = $bundleInfo;
                this.$callback = $callback;
            }

            public void onSuccess() {
                this.this$0.hideDevLoadingView();
                DevBundleDownloadListener devBundleDownloadListener = DevSupportManagerBase.access$getDevBundleDownloadListener$p(this.this$0);
                if (devBundleDownloadListener != null) {
                    devBundleDownloadListener.onSuccess();
                }
                ReactMarker.logMarker(ReactMarkerConstants.DOWNLOAD_END, this.$bundleInfo.toJSONString());
                this.$callback.onSuccess();
            }

            public void onProgress(String status, Integer done, Integer total) {
                block1: {
                    DevLoadingViewManager devLoadingViewManager = this.this$0.getDevLoadingViewManager();
                    if (devLoadingViewManager != null) {
                        devLoadingViewManager.updateProgress(status, done, total);
                    }
                    DevBundleDownloadListener devBundleDownloadListener = DevSupportManagerBase.access$getDevBundleDownloadListener$p(this.this$0);
                    if (devBundleDownloadListener == null) break block1;
                    devBundleDownloadListener.onProgress(status, done, total);
                }
            }

            public void onFailure(Exception cause) {
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                this.this$0.hideDevLoadingView();
                DevBundleDownloadListener devBundleDownloadListener = DevSupportManagerBase.access$getDevBundleDownloadListener$p(this.this$0);
                if (devBundleDownloadListener != null) {
                    devBundleDownloadListener.onFailure(cause);
                }
                FLog.e((String)"ReactNative", (String)"Unable to download JS bundle", (Throwable)cause);
                DevSupportManagerBase.access$reportBundleLoadingFailure(this.this$0, cause);
                this.$callback.onError(cause);
            }
        }, this.jsBundleDownloadedFile, bundleURL, bundleInfo, null, 16, null);
    }

    private final void reportBundleLoadingFailure(Exception cause) {
        UiThreadUtil.runOnUiThread(() -> DevSupportManagerBase.reportBundleLoadingFailure$lambda$23(cause, this));
    }

    @Override
    public void startInspector() {
        if (this.isDevSupportEnabled) {
            this.devServerHelper.openInspectorConnection();
        }
    }

    @Override
    public void stopInspector() {
        this.devServerHelper.closeInspectorConnection();
    }

    @Override
    public void setHotModuleReplacementEnabled(boolean isHotModuleReplacementEnabled) {
        if (!this.isDevSupportEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(() -> DevSupportManagerBase.setHotModuleReplacementEnabled$lambda$24(this, isHotModuleReplacementEnabled));
    }

    @Override
    public void setFpsDebugEnabled(boolean isFpsDebugEnabled) {
        if (!this.isDevSupportEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(() -> DevSupportManagerBase.setFpsDebugEnabled$lambda$25(this, isFpsDebugEnabled));
    }

    @Override
    public void toggleElementInspector() {
        if (!this.isDevSupportEnabled) {
            return;
        }
        UiThreadUtil.runOnUiThread(() -> DevSupportManagerBase.toggleElementInspector$lambda$26(this));
    }

    private final void reload() {
        UiThreadUtil.assertOnUiThread();
        if (this.isDevSupportEnabled) {
            DebugOverlayController debugOverlayController = this.debugOverlayController;
            if (debugOverlayController != null) {
                debugOverlayController.setFpsDebugViewVisible(this.devSettings.isFpsDebugEnabled());
            }
            if (!this.isShakeDetectorStarted) {
                Object object = this.applicationContext.getSystemService("sensor");
                Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.hardware.SensorManager");
                SensorManager sensorManager = (SensorManager)object;
                this.shakeDetector.start(sensorManager);
                this.isShakeDetectorStarted = true;
            }
            if (!this.isReceiverRegistered) {
                IntentFilter filter = new IntentFilter();
                filter.addAction(DevSupportManagerBase.Companion.getReloadAppAction(this.applicationContext));
                this.compatRegisterReceiver(this.applicationContext, this.reloadAppBroadcastReceiver, filter, true);
                this.isReceiverRegistered = true;
            }
            if (this.devLoadingViewVisible) {
                DevLoadingViewManager devLoadingViewManager = this.devLoadingViewManager;
                if (devLoadingViewManager != null) {
                    devLoadingViewManager.showMessage("Reloading...");
                }
            }
            this.devServerHelper.openPackagerConnection(this.getClass().getSimpleName(), new DevServerHelper.PackagerCommandListener(this){
                final /* synthetic */ DevSupportManagerBase this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onPackagerConnected() {
                    DevSupportManagerBase.access$setPackagerConnected$p(this.this$0, true);
                }

                public void onPackagerDisconnected() {
                    DevSupportManagerBase.access$setPackagerConnected$p(this.this$0, false);
                }

                public void onPackagerReloadCommand() {
                    if (!InspectorFlags.getFuseboxEnabled()) {
                        this.this$0.getDevServerHelper().disableDebugger();
                    }
                    UiThreadUtil.runOnUiThread(() -> reload.1.onPackagerReloadCommand$lambda$0(this.this$0));
                }

                public void onPackagerDevMenuCommand() {
                    UiThreadUtil.runOnUiThread(() -> reload.1.onPackagerDevMenuCommand$lambda$1(this.this$0));
                }

                public Map<String, RequestHandler> customCommandHandlers() {
                    return DevSupportManagerBase.access$getCustomPackagerCommandHandlers$p(this.this$0);
                }

                private static final void onPackagerReloadCommand$lambda$0(DevSupportManagerBase this$0) {
                    this$0.handleReloadJS();
                }

                private static final void onPackagerDevMenuCommand$lambda$1(DevSupportManagerBase this$0) {
                    this$0.showDevOptionsDialog();
                }
            });
        } else {
            DebugOverlayController debugOverlayController = this.debugOverlayController;
            if (debugOverlayController != null) {
                debugOverlayController.setFpsDebugViewVisible(false);
            }
            if (this.isShakeDetectorStarted) {
                this.shakeDetector.stop();
                this.isShakeDetectorStarted = false;
            }
            if (this.isReceiverRegistered) {
                this.applicationContext.unregisterReceiver(this.reloadAppBroadcastReceiver);
                this.isReceiverRegistered = false;
            }
            this.hideRedboxDialog();
            this.hideDevOptionsDialog();
            DevLoadingViewManager devLoadingViewManager = this.devLoadingViewManager;
            if (devLoadingViewManager != null) {
                devLoadingViewManager.hide();
            }
            this.devServerHelper.closePackagerConnection();
        }
    }

    @Override
    public void setPackagerLocationCustomizer(@NotNull DevSupportManager.PackagerLocationCustomizer packagerLocationCustomizer) {
        Intrinsics.checkNotNullParameter((Object)packagerLocationCustomizer, (String)"packagerLocationCustomizer");
        this.packagerLocationCustomizer = packagerLocationCustomizer;
    }

    @Override
    @Nullable
    public SurfaceDelegate createSurfaceDelegate(@NotNull String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        SurfaceDelegateFactory surfaceDelegateFactory = this.surfaceDelegateFactory;
        return surfaceDelegateFactory != null ? surfaceDelegateFactory.createSurfaceDelegate(moduleName) : null;
    }

    private final void compatRegisterReceiver(Context context, BroadcastReceiver receiver, IntentFilter filter, boolean exported) {
        Intent intent = Build.VERSION.SDK_INT >= 34 && context.getApplicationInfo().targetSdkVersion >= 34 ? context.registerReceiver(receiver, filter, exported ? 2 : 4) : context.registerReceiver(receiver, filter);
    }

    @Override
    public void openDebugger() {
        this.devServerHelper.openDebugger(this.currentReactContext, this.applicationContext.getString(R.string.catalyst_open_debugger_error));
    }

    @Override
    public void showPausedInDebuggerOverlay(@NotNull String message, @NotNull DevSupportManager.PausedInDebuggerOverlayCommandListener listener) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Intrinsics.checkNotNullParameter((Object)listener, (String)"listener");
            PausedInDebuggerOverlayManager pausedInDebuggerOverlayManager = this.pausedInDebuggerOverlayManager;
            if (pausedInDebuggerOverlayManager == null) break block0;
            pausedInDebuggerOverlayManager.showPausedInDebuggerOverlay(message, listener);
        }
    }

    @Override
    public void hidePausedInDebuggerOverlay() {
        block0: {
            PausedInDebuggerOverlayManager pausedInDebuggerOverlayManager = this.pausedInDebuggerOverlayManager;
            if (pausedInDebuggerOverlayManager == null) break block0;
            pausedInDebuggerOverlayManager.hidePausedInDebuggerOverlay();
        }
    }

    @Override
    public void setAdditionalOptionForPackager(@NotNull String name, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.devSettings.getPackagerConnectionSettings().setAdditionalOptionForPackager(name, value);
    }

    private static final void shakeDetector$lambda$2(DevSupportManagerBase this$0) {
        this$0.showDevOptionsDialog();
    }

    private static final Context _init_$lambda$3(DevSupportManagerBase this$0) {
        Activity context = this$0.reactInstanceDevHelper.getCurrentActivity();
        if (context == null || context.isFinishing()) {
            return null;
        }
        return (Context)context;
    }

    /*
     * WARNING - void declaration
     */
    private static final void showNewError$lambda$6(DevSupportManagerBase this$0, String $message, StackFrame[] $stack, int $errorCookie, ErrorType $errorType) {
        block3: {
            this$0.updateLastErrorInfo($message, $stack, $errorCookie, $errorType);
            if (this$0.redBoxSurfaceDelegate == null) {
                DevSupportManagerBase devSupportManagerBase = this$0;
                SurfaceDelegate surfaceDelegate = this$0.createSurfaceDelegate("RedBox");
                if (surfaceDelegate == null) {
                    void $this$showNewError_u24lambda_u246_u24lambda_u245;
                    RedBoxDialogSurfaceDelegate redBoxDialogSurfaceDelegate;
                    RedBoxDialogSurfaceDelegate redBoxDialogSurfaceDelegate2 = redBoxDialogSurfaceDelegate = new RedBoxDialogSurfaceDelegate(this$0);
                    DevSupportManagerBase devSupportManagerBase2 = devSupportManagerBase;
                    boolean bl = false;
                    $this$showNewError_u24lambda_u246_u24lambda_u245.createContentView("RedBox");
                    devSupportManagerBase = devSupportManagerBase2;
                    surfaceDelegate = redBoxDialogSurfaceDelegate;
                }
                devSupportManagerBase.redBoxSurfaceDelegate = surfaceDelegate;
            }
            SurfaceDelegate surfaceDelegate = this$0.redBoxSurfaceDelegate;
            boolean bl = surfaceDelegate != null ? surfaceDelegate.isShowing() : false;
            if (bl) {
                return;
            }
            SurfaceDelegate surfaceDelegate2 = this$0.redBoxSurfaceDelegate;
            if (surfaceDelegate2 == null) break block3;
            surfaceDelegate2.show();
        }
    }

    private static final void showDevOptionsDialog$lambda$7(DevSupportManagerBase this$0) {
        if (!this$0.devSettings.isJSDevModeEnabled() && this$0.devSettings.isHotModuleReplacementEnabled()) {
            Toast.makeText((Context)this$0.applicationContext, (CharSequence)this$0.applicationContext.getString(R.string.catalyst_hot_reloading_auto_disable), (int)1).show();
            this$0.devSettings.setHotModuleReplacementEnabled(false);
        }
        this$0.handleReloadJS();
    }

    private static final void showDevOptionsDialog$lambda$8(DevSupportManagerBase this$0) {
        this$0.openDebugger();
    }

    private static final void showDevOptionsDialog$lambda$10$lambda$9(DevSupportManagerBase this$0, String host) {
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        this$0.devSettings.getPackagerConnectionSettings().setDebugServerHost(host);
        this$0.handleReloadJS();
    }

    private static final void showDevOptionsDialog$lambda$10(DevSupportManagerBase this$0) {
        Activity context = this$0.reactInstanceDevHelper.getCurrentActivity();
        if (context == null || context.isFinishing()) {
            FLog.e((String)"ReactNative", (String)"Unable to launch change bundle location because react activity is not available");
            return;
        }
        ChangeBundleLocationDialog.INSTANCE.show((Context)context, this$0.devSettings, arg_0 -> DevSupportManagerBase.showDevOptionsDialog$lambda$10$lambda$9(this$0, arg_0));
    }

    private static final void showDevOptionsDialog$lambda$11(DevSupportManagerBase this$0) {
        this$0.devSettings.setElementInspectorEnabled(!this$0.devSettings.isElementInspectorEnabled());
        this$0.reactInstanceDevHelper.toggleElementInspector();
    }

    private static final void showDevOptionsDialog$lambda$12(DevSupportManagerBase this$0) {
        boolean nextEnabled = !this$0.devSettings.isHotModuleReplacementEnabled();
        this$0.devSettings.setHotModuleReplacementEnabled(nextEnabled);
        ReactContext reactContext = this$0.currentReactContext;
        if (reactContext != null) {
            if (nextEnabled) {
                HMRClient hMRClient = reactContext.getJSModule(HMRClient.class);
                if (hMRClient != null) {
                    hMRClient.enable();
                }
            } else {
                HMRClient hMRClient = reactContext.getJSModule(HMRClient.class);
                if (hMRClient != null) {
                    hMRClient.disable();
                }
            }
        }
        if (nextEnabled && !this$0.devSettings.isJSDevModeEnabled()) {
            Toast.makeText((Context)this$0.applicationContext, (CharSequence)this$0.applicationContext.getString(R.string.catalyst_hot_reloading_auto_enable), (int)1).show();
            this$0.devSettings.setJSDevModeEnabled(true);
            this$0.handleReloadJS();
        }
    }

    private static final void showDevOptionsDialog$lambda$13(DevSupportManagerBase this$0) {
        if (!this$0.devSettings.isFpsDebugEnabled()) {
            Context context = (Context)this$0.reactInstanceDevHelper.getCurrentActivity();
            if (context == null) {
                FLog.e((String)"ReactNative", (String)"Unable to get reference to react activity");
            } else {
                DebugOverlayController.Companion.requestPermission(context);
            }
        }
        this$0.devSettings.setFpsDebugEnabled(!this$0.devSettings.isFpsDebugEnabled());
    }

    private static final void showDevOptionsDialog$lambda$14(DevSupportManagerBase this$0) {
        Intent intent = new Intent(this$0.applicationContext, DevSettingsActivity.class);
        intent.setFlags(0x10000000);
        this$0.applicationContext.startActivity(intent);
    }

    private static final void showDevOptionsDialog$lambda$17(DevOptionHandler[] $optionHandlers, DevSupportManagerBase this$0, DialogInterface dialogInterface, int which) {
        $optionHandlers[which].onOptionSelected();
        this$0.devOptionsDialog = null;
    }

    private static final void showDevOptionsDialog$lambda$18(DevSupportManagerBase this$0, DialogInterface it) {
        this$0.devOptionsDialog = null;
    }

    private static final void reloadSettings$lambda$20(DevSupportManagerBase this$0) {
        this$0.reload();
    }

    private static final void fetchSplitBundleAndCreateBundleLoader$lambda$21(DevSupportManagerBase this$0, String $bundleUrl, File $bundleFile, CallbackWithBundleLoader $callback) {
        this$0.showSplitBundleDevLoadingView($bundleUrl);
        DevServerHelper.downloadBundleFromURL$default(this$0.devServerHelper, new DevBundleDownloadListener(this$0, $bundleUrl, $bundleFile, $callback){
            final /* synthetic */ DevSupportManagerBase this$0;
            final /* synthetic */ String $bundleUrl;
            final /* synthetic */ File $bundleFile;
            final /* synthetic */ CallbackWithBundleLoader $callback;
            {
                this.this$0 = $receiver;
                this.$bundleUrl = $bundleUrl;
                this.$bundleFile = $bundleFile;
                this.$callback = $callback;
            }

            public void onSuccess() {
                UiThreadUtil.runOnUiThread(() -> fetchSplitBundleAndCreateBundleLoader.1.1.onSuccess$lambda$0(this.this$0));
                ReactContext context = this.this$0.getCurrentReactContext();
                if (context == null || !context.hasActiveReactInstance()) {
                    return;
                }
                String string2 = this.$bundleFile.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
                JSBundleLoader bundleLoader = JSBundleLoader.Companion.createCachedSplitBundleFromNetworkLoader(this.$bundleUrl, string2);
                this.$callback.onSuccess(bundleLoader);
            }

            public void onProgress(String status, Integer done, Integer total) {
                block0: {
                    DevLoadingViewManager devLoadingViewManager = this.this$0.getDevLoadingViewManager();
                    if (devLoadingViewManager == null) break block0;
                    devLoadingViewManager.updateProgress(status, done, total);
                }
            }

            public void onFailure(Exception cause) {
                Intrinsics.checkNotNullParameter((Object)cause, (String)"cause");
                UiThreadUtil.runOnUiThread(() -> fetchSplitBundleAndCreateBundleLoader.1.1.onFailure$lambda$1(this.this$0));
                this.$callback.onError(this.$bundleUrl, cause);
            }

            private static final void onSuccess$lambda$0(DevSupportManagerBase this$0) {
                DevSupportManagerBase.access$hideSplitBundleDevLoadingView(this$0);
            }

            private static final void onFailure$lambda$1(DevSupportManagerBase this$0) {
                DevSupportManagerBase.access$hideSplitBundleDevLoadingView(this$0);
            }
        }, $bundleFile, $bundleUrl, null, null, 16, null);
    }

    private static final void isPackagerRunning$lambda$22(DevSupportManagerBase this$0, PackagerStatusCallback $callback) {
        this$0.devServerHelper.isPackagerRunning($callback);
    }

    private static final void reportBundleLoadingFailure$lambda$23(Exception $cause, DevSupportManagerBase this$0) {
        if ($cause instanceof DebugServerException) {
            this$0.showNewJavaError($cause.getMessage(), $cause);
        } else {
            this$0.showNewJavaError(this$0.applicationContext.getString(R.string.catalyst_reload_error), $cause);
        }
    }

    private static final void setHotModuleReplacementEnabled$lambda$24(DevSupportManagerBase this$0, boolean $isHotModuleReplacementEnabled) {
        this$0.devSettings.setHotModuleReplacementEnabled($isHotModuleReplacementEnabled);
        this$0.handleReloadJS();
    }

    private static final void setFpsDebugEnabled$lambda$25(DevSupportManagerBase this$0, boolean $isFpsDebugEnabled) {
        this$0.devSettings.setFpsDebugEnabled($isFpsDebugEnabled);
    }

    private static final void toggleElementInspector$lambda$26(DevSupportManagerBase this$0) {
        this$0.devSettings.setElementInspectorEnabled(!this$0.devSettings.isElementInspectorEnabled());
        this$0.reactInstanceDevHelper.toggleElementInspector();
    }

    public static final /* synthetic */ DevBundleDownloadListener access$getDevBundleDownloadListener$p(DevSupportManagerBase $this) {
        return $this.devBundleDownloadListener;
    }

    public static final /* synthetic */ void access$reportBundleLoadingFailure(DevSupportManagerBase $this, Exception cause) {
        $this.reportBundleLoadingFailure(cause);
    }

    public static final /* synthetic */ void access$setPackagerConnected$p(DevSupportManagerBase $this, boolean bl) {
        $this.isPackagerConnected = bl;
    }

    public static final /* synthetic */ Map access$getCustomPackagerCommandHandlers$p(DevSupportManagerBase $this) {
        return $this.customPackagerCommandHandlers;
    }

    public static final /* synthetic */ void access$hideSplitBundleDevLoadingView(DevSupportManagerBase $this) {
        $this.hideSplitBundleDevLoadingView();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0003\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u000b\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/devsupport/DevSupportManagerBase$CallbackWithBundleLoader;", "", "onSuccess", "", "bundleLoader", "Lcom/facebook/react/bridge/JSBundleLoader;", "onError", "url", "", "cause", "", "ReactAndroid_debug"})
    public static interface CallbackWithBundleLoader {
        public void onSuccess(@NotNull JSBundleLoader var1);

        public void onError(@NotNull String var1, @NotNull Throwable var2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/react/devsupport/DevSupportManagerBase$Companion;", "", "<init>", "()V", "JAVA_ERROR_COOKIE", "", "JSEXCEPTION_ERROR_COOKIE", "RELOAD_APP_ACTION_SUFFIX", "", "EXOPACKAGE_LOCATION_FORMAT", "getReloadAppAction", "context", "Landroid/content/Context;", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        private final String getReloadAppAction(Context context) {
            return context.getPackageName() + DevSupportManagerBase.RELOAD_APP_ACTION_SUFFIX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

