/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common.annotations.internal;

import com.facebook.react.bridge.AssertionException;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.build.ReactBuildConfig;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0007J\u001a\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u0002\u00a8\u0006\u000b"}, d2={"Lcom/facebook/react/common/annotations/internal/LegacyArchitectureLogger;", "", "<init>", "()V", "assertLegacyArchitecture", "", "name", "", "logLevel", "Lcom/facebook/react/common/annotations/internal/LegacyArchitectureLogLevel;", "executeAssert", "ReactAndroid_debug"})
public final class LegacyArchitectureLogger {
    @NotNull
    public static final LegacyArchitectureLogger INSTANCE = new LegacyArchitectureLogger();

    private LegacyArchitectureLogger() {
    }

    @JvmStatic
    public static final void assertLegacyArchitecture(@NotNull String name, @NotNull LegacyArchitectureLogLevel logLevel) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)logLevel), (String)"logLevel");
        if (ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE) {
            INSTANCE.executeAssert(name, logLevel);
        }
    }

    public static /* synthetic */ void assertLegacyArchitecture$default(String string2, LegacyArchitectureLogLevel legacyArchitectureLogLevel, int n, Object object) {
        if ((n & 2) != 0) {
            legacyArchitectureLogLevel = LegacyArchitectureLogLevel.WARNING;
        }
        LegacyArchitectureLogger.assertLegacyArchitecture(string2, legacyArchitectureLogLevel);
    }

    private final void executeAssert(String name, LegacyArchitectureLogLevel logLevel) {
        if (ReactBuildConfig.DEBUG) {
            String exceptionMessage = "is being executed when app is fully running on the NEW Architecture.";
            switch (WhenMappings.$EnumSwitchMapping$0[logLevel.ordinal()]) {
                case 1: {
                    throw new AssertionException(name + " " + exceptionMessage);
                }
                case 2: {
                    ReactSoftExceptionLogger.logSoftException("SoftAssertions", new ReactNoCrashSoftException(name + " " + exceptionMessage));
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
    }

    static /* synthetic */ void executeAssert$default(LegacyArchitectureLogger legacyArchitectureLogger, String string2, LegacyArchitectureLogLevel legacyArchitectureLogLevel, int n, Object object) {
        if ((n & 2) != 0) {
            legacyArchitectureLogLevel = LegacyArchitectureLogLevel.WARNING;
        }
        legacyArchitectureLogger.executeAssert(string2, legacyArchitectureLogLevel);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LegacyArchitectureLogLevel.values().length];
            try {
                nArray[LegacyArchitectureLogLevel.ERROR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LegacyArchitectureLogLevel.WARNING.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

