/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animated;

import android.view.View;
import com.facebook.react.animated.AnimatedNode;
import com.facebook.react.animated.ColorAnimatedNode;
import com.facebook.react.animated.NativeAnimatedNodesManager;
import com.facebook.react.animated.ObjectAnimatedNode;
import com.facebook.react.animated.StyleAnimatedNode;
import com.facebook.react.animated.ValueAnimatedNode;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.JavaOnlyMap;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.uimanager.common.ViewUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0010J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\tJ\u0006\u0010\u0016\u001a\u00020\u0012J\u0006\u0010\u0017\u001a\u00020\u0012J\r\u0010\u001c\u001a\u00020\fH\u0010\u00a2\u0006\u0002\b\u001dR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\t0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u00198F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001e"}, d2={"Lcom/facebook/react/animated/PropsAnimatedNode;", "Lcom/facebook/react/animated/AnimatedNode;", "config", "Lcom/facebook/react/bridge/ReadableMap;", "nativeAnimatedNodesManager", "Lcom/facebook/react/animated/NativeAnimatedNodesManager;", "<init>", "(Lcom/facebook/react/bridge/ReadableMap;Lcom/facebook/react/animated/NativeAnimatedNodesManager;)V", "connectedViewTag", "", "propNodeMapping", "", "", "propMap", "Lcom/facebook/react/bridge/JavaOnlyMap;", "connectedViewUIManager", "Lcom/facebook/react/bridge/UIManager;", "connectToView", "", "viewTag", "uiManager", "disconnectFromView", "restoreDefaultValues", "updateView", "connectedView", "Landroid/view/View;", "getConnectedView", "()Landroid/view/View;", "prettyPrint", "prettyPrint$ReactAndroid_debug", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nPropsAnimatedNode.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PropsAnimatedNode.kt\ncom/facebook/react/animated/PropsAnimatedNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,121:1\n1#2:122\n*E\n"})
public final class PropsAnimatedNode
extends AnimatedNode {
    @NotNull
    private final NativeAnimatedNodesManager nativeAnimatedNodesManager;
    private int connectedViewTag;
    @NotNull
    private final Map<String, Integer> propNodeMapping;
    @NotNull
    private final JavaOnlyMap propMap;
    @Nullable
    private UIManager connectedViewUIManager;

    public PropsAnimatedNode(@NotNull ReadableMap config, @NotNull NativeAnimatedNodesManager nativeAnimatedNodesManager) {
        ReadableMap props;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)nativeAnimatedNodesManager, (String)"nativeAnimatedNodesManager");
        this.nativeAnimatedNodesManager = nativeAnimatedNodesManager;
        this.connectedViewTag = -1;
        this.propMap = new JavaOnlyMap();
        ReadableMap readableMap = props = config.getMap("props");
        ReadableMapKeySetIterator iter = readableMap != null ? readableMap.keySetIterator() : null;
        this.propNodeMapping = new LinkedHashMap();
        while (iter != null && iter.hasNextKey()) {
            String propKey = iter.nextKey();
            int nodeIndex = props.getInt(propKey);
            Integer n = nodeIndex;
            this.propNodeMapping.put(propKey, n);
        }
    }

    public final void connectToView(int viewTag, @Nullable UIManager uiManager) {
        if (this.connectedViewTag != -1) {
            throw new JSApplicationIllegalArgumentException("Animated node " + this.tag + " is already attached to a view: " + this.connectedViewTag);
        }
        this.connectedViewTag = viewTag;
        this.connectedViewUIManager = uiManager;
    }

    public final void disconnectFromView(int viewTag) {
        if (this.connectedViewTag != viewTag && this.connectedViewTag != -1) {
            throw new JSApplicationIllegalArgumentException("Attempting to disconnect view that has not been connected with the given animated node: " + viewTag + " but is connected to view " + this.connectedViewTag);
        }
        this.connectedViewTag = -1;
    }

    public final void restoreDefaultValues() {
        block3: {
            if (this.connectedViewTag == -1) {
                return;
            }
            if (ViewUtil.getUIManagerType(this.connectedViewTag) == 2) {
                return;
            }
            ReadableMapKeySetIterator it = this.propMap.keySetIterator();
            while (it.hasNextKey()) {
                this.propMap.putNull(it.nextKey());
            }
            UIManager uIManager = this.connectedViewUIManager;
            if (uIManager == null) break block3;
            uIManager.synchronouslyUpdateViewOnUIThread(this.connectedViewTag, this.propMap);
        }
    }

    public final void updateView() {
        block9: {
            if (this.connectedViewTag == -1) {
                return;
            }
            for (Map.Entry<String, Integer> entry : this.propNodeMapping.entrySet()) {
                String key = entry.getKey();
                int value = ((Number)entry.getValue()).intValue();
                AnimatedNode node = this.nativeAnimatedNodesManager.getNodeById(value);
                if (node == null) {
                    boolean $i$a$-requireNotNull-PropsAnimatedNode$updateView$22 = false;
                    String $i$a$-requireNotNull-PropsAnimatedNode$updateView$22 = "Mapped property node does not exist";
                    throw new IllegalArgumentException($i$a$-requireNotNull-PropsAnimatedNode$updateView$22.toString());
                }
                if (node instanceof StyleAnimatedNode) {
                    ((StyleAnimatedNode)node).collectViewUpdates(this.propMap);
                    continue;
                }
                if (node instanceof ValueAnimatedNode) {
                    Object animatedObject = ((ValueAnimatedNode)node).getAnimatedObject();
                    if (animatedObject instanceof Integer) {
                        this.propMap.putInt(key, ((Number)animatedObject).intValue());
                        continue;
                    }
                    if (animatedObject instanceof String) {
                        this.propMap.putString(key, (String)animatedObject);
                        continue;
                    }
                    this.propMap.putDouble(key, ((ValueAnimatedNode)node).getValue());
                    continue;
                }
                if (node instanceof ColorAnimatedNode) {
                    this.propMap.putInt(key, ((ColorAnimatedNode)node).getColor());
                    continue;
                }
                if (node instanceof ObjectAnimatedNode) {
                    ((ObjectAnimatedNode)node).collectViewUpdates(key, this.propMap);
                    continue;
                }
                throw new IllegalArgumentException("Unsupported type of node used in property node " + node.getClass());
            }
            UIManager uIManager = this.connectedViewUIManager;
            if (uIManager == null) break block9;
            uIManager.synchronouslyUpdateViewOnUIThread(this.connectedViewTag, this.propMap);
        }
    }

    @Nullable
    public final View getConnectedView() {
        Object object;
        Object object2 = this;
        try {
            PropsAnimatedNode $this$_get_connectedView__u24lambda_u241 = object2;
            boolean bl = false;
            UIManager uIManager = $this$_get_connectedView__u24lambda_u241.connectedViewUIManager;
            object = Result.constructor-impl((Object)(uIManager != null ? uIManager.resolveView($this$_get_connectedView__u24lambda_u241.connectedViewTag) : null));
        }
        catch (Throwable throwable) {
            object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        object2 = object;
        return (View)(Result.isFailure-impl((Object)object2) ? null : object2);
    }

    @Override
    @NotNull
    public String prettyPrint$ReactAndroid_debug() {
        return "PropsAnimatedNode[" + this.tag + "] connectedViewTag: " + this.connectedViewTag + " propNodeMapping: " + this.propNodeMapping + " propMap: " + this.propMap;
    }
}

