/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.net.Uri;
import android.os.Bundle;
import android.os.Process;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.Nullable;
import androidx.core.view.ViewCompat;
import com.facebook.common.logging.FLog;
import com.facebook.debug.holder.PrinterHolder;
import com.facebook.debug.tags.ReactDebugOverlayTags;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.ThreadConfined;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.react.CoreModulesPackage;
import com.facebook.react.DebugCorePackage;
import com.facebook.react.MemoryPressureRouter;
import com.facebook.react.NativeModuleRegistryBuilder;
import com.facebook.react.ReactInstanceManagerBuilder;
import com.facebook.react.ReactPackage;
import com.facebook.react.ReactPackageLogger;
import com.facebook.react.ReactPackageTurboModuleManagerDelegate;
import com.facebook.react.ReactRootView;
import com.facebook.react.ViewManagerOnDemandReactPackage;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.BridgeReactContext;
import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.CatalystInstanceImpl;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.JSExceptionHandler;
import com.facebook.react.bridge.JavaScriptExecutor;
import com.facebook.react.bridge.JavaScriptExecutorFactory;
import com.facebook.react.bridge.NativeModuleRegistry;
import com.facebook.react.bridge.NotThreadSafeBridgeIdleDebugListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactCxxErrorHandler;
import com.facebook.react.bridge.ReactInstanceManagerInspectorTarget;
import com.facebook.react.bridge.ReactMarker;
import com.facebook.react.bridge.ReactMarkerConstants;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UIManagerProvider;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.bridge.queue.ReactQueueConfigurationSpec;
import com.facebook.react.common.LifecycleState;
import com.facebook.react.common.SurfaceDelegateFactory;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogLevel;
import com.facebook.react.common.annotations.internal.LegacyArchitectureLogger;
import com.facebook.react.devsupport.DevSupportManagerFactory;
import com.facebook.react.devsupport.InspectorFlags;
import com.facebook.react.devsupport.ReactInstanceDevHelper;
import com.facebook.react.devsupport.inspector.InspectorNetworkHelper;
import com.facebook.react.devsupport.inspector.InspectorNetworkRequestListener;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import com.facebook.react.devsupport.interfaces.DevLoadingViewManager;
import com.facebook.react.devsupport.interfaces.DevSupportManager;
import com.facebook.react.devsupport.interfaces.PackagerStatusCallback;
import com.facebook.react.devsupport.interfaces.PausedInDebuggerOverlayManager;
import com.facebook.react.devsupport.interfaces.RedBoxHandler;
import com.facebook.react.interfaces.TaskInterface;
import com.facebook.react.internal.AndroidChoreographerProvider;
import com.facebook.react.internal.ChoreographerProvider;
import com.facebook.react.internal.featureflags.ReactNativeNewArchitectureFeatureFlags;
import com.facebook.react.internal.turbomodule.core.TurboModuleManager;
import com.facebook.react.modules.appearance.AppearanceModule;
import com.facebook.react.modules.appregistry.AppRegistry;
import com.facebook.react.modules.core.DefaultHardwareBackBtnHandler;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.modules.debug.interfaces.DeveloperSettings;
import com.facebook.react.modules.systeminfo.AndroidInfoHelpers;
import com.facebook.react.packagerconnection.RequestHandler;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.ReactRoot;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.views.imagehelper.ResourceDrawableIdHelper;
import com.facebook.soloader.SoLoader;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ThreadSafe
public class ReactInstanceManager {
    private static final String TAG;
    private final Set<ReactRoot> mAttachedReactRoots = Collections.synchronizedSet(new HashSet());
    private volatile LifecycleState mLifecycleState;
    @Nullable
    @ThreadConfined(value="UI")
    private ReactContextInitParams mPendingReactContextInitParams;
    @Nullable
    private volatile Thread mCreateReactContextThread;
    private final JavaScriptExecutorFactory mJavaScriptExecutorFactory;
    @Nullable
    private Collection<String> mViewManagerNames = null;
    @Nullable
    private final JSBundleLoader mBundleLoader;
    @Nullable
    private final String mJSMainModulePath;
    private final List<ReactPackage> mPackages;
    private final DevSupportManager mDevSupportManager;
    private final boolean mUseDeveloperSupport;
    private final boolean mRequireActivity;
    private final boolean mKeepActivity;
    @Nullable
    private final NotThreadSafeBridgeIdleDebugListener mBridgeIdleDebugListener;
    private final Object mReactContextLock = new Object();
    @Nullable
    private volatile ReactContext mCurrentReactContext;
    private final Context mApplicationContext;
    @Nullable
    @ThreadConfined(value="UI")
    private DefaultHardwareBackBtnHandler mDefaultBackButtonImpl;
    @Nullable
    private Activity mCurrentActivity;
    @Nullable
    private ReactInstanceManagerInspectorTarget mInspectorTarget;
    private final Collection<com.facebook.react.ReactInstanceEventListener> mReactInstanceEventListeners = Collections.synchronizedList(new ArrayList());
    private volatile boolean mHasStartedCreatingInitialContext = false;
    private volatile Boolean mHasStartedDestroying = false;
    private final MemoryPressureRouter mMemoryPressureRouter;
    @Nullable
    private final JSExceptionHandler mJSExceptionHandler;
    @Nullable
    private final UIManagerProvider mUIManagerProvider;
    @Nullable
    private final ReactPackageTurboModuleManagerDelegate.Builder mTMMDelegateBuilder;
    private List<ViewManager> mViewManagers;
    private boolean mUseFallbackBundle = true;
    private volatile boolean mInstanceManagerInvalidated = false;

    public static ReactInstanceManagerBuilder builder() {
        return new ReactInstanceManagerBuilder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReactInstanceManager(Context applicationContext, @Nullable Activity currentActivity, @Nullable DefaultHardwareBackBtnHandler defaultHardwareBackBtnHandler, JavaScriptExecutorFactory javaScriptExecutorFactory, @Nullable JSBundleLoader bundleLoader, @Nullable String jsMainModulePath, List<ReactPackage> packages, boolean useDeveloperSupport, DevSupportManagerFactory devSupportManagerFactory, boolean requireActivity, boolean keepActivity, @Nullable NotThreadSafeBridgeIdleDebugListener bridgeIdleDebugListener, LifecycleState initialLifecycleState, JSExceptionHandler jSExceptionHandler, @Nullable RedBoxHandler redBoxHandler, boolean lazyViewManagersEnabled, @Nullable DevBundleDownloadListener devBundleDownloadListener, int minNumShakes, int minTimeLeftInFrameForNonBatchedOperationMs, @Nullable UIManagerProvider uIManagerProvider, @Nullable Map<String, RequestHandler> customPackagerCommandHandlers, @Nullable ReactPackageTurboModuleManagerDelegate.Builder tmmDelegateBuilder, @Nullable SurfaceDelegateFactory surfaceDelegateFactory, @Nullable DevLoadingViewManager devLoadingViewManager, @Nullable ChoreographerProvider choreographerProvider, @Nullable PausedInDebuggerOverlayManager pausedInDebuggerOverlayManager) {
        FLog.d((String)TAG, (String)"ReactInstanceManager.ctor()");
        ReactInstanceManager.initializeSoLoaderIfNecessary(applicationContext);
        DisplayMetricsHolder.initDisplayMetricsIfNotInitialized(applicationContext);
        this.mApplicationContext = applicationContext;
        this.mCurrentActivity = currentActivity;
        this.mDefaultBackButtonImpl = defaultHardwareBackBtnHandler;
        this.mJavaScriptExecutorFactory = javaScriptExecutorFactory;
        this.mBundleLoader = bundleLoader;
        this.mJSMainModulePath = jsMainModulePath;
        this.mPackages = new ArrayList<ReactPackage>();
        this.mUseDeveloperSupport = useDeveloperSupport;
        this.mRequireActivity = requireActivity;
        this.mKeepActivity = keepActivity;
        Systrace.beginSection(0L, "ReactInstanceManager.initDevSupportManager");
        this.mDevSupportManager = devSupportManagerFactory.create(applicationContext, this.createDevHelperInterface(), this.mJSMainModulePath, useDeveloperSupport, redBoxHandler, devBundleDownloadListener, minNumShakes, customPackagerCommandHandlers, surfaceDelegateFactory, devLoadingViewManager, pausedInDebuggerOverlayManager);
        Systrace.endSection(0L);
        this.mBridgeIdleDebugListener = bridgeIdleDebugListener;
        this.mLifecycleState = initialLifecycleState;
        this.mMemoryPressureRouter = new MemoryPressureRouter(applicationContext);
        this.mJSExceptionHandler = jSExceptionHandler;
        this.mTMMDelegateBuilder = tmmDelegateBuilder;
        List<ReactPackage> list = this.mPackages;
        synchronized (list) {
            PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.RN_CORE, "RNCore: Use Split Packages");
            this.mPackages.add(new CoreModulesPackage(this, new DefaultHardwareBackBtnHandler(){

                @Override
                public void invokeDefaultOnBackPressed() {
                    ReactInstanceManager.this.invokeDefaultOnBackPressed();
                }
            }, lazyViewManagersEnabled, minTimeLeftInFrameForNonBatchedOperationMs));
            if (this.mUseDeveloperSupport) {
                this.mPackages.add(new DebugCorePackage());
            }
            this.mPackages.addAll(packages);
        }
        this.mUIManagerProvider = uIManagerProvider;
        ReactChoreographer.initialize(choreographerProvider != null ? choreographerProvider : AndroidChoreographerProvider.getInstance());
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.startInspector();
        }
        this.registerCxxErrorHandlerFunc();
    }

    private ReactInstanceDevHelper createDevHelperInterface() {
        return new ReactInstanceDevHelper(){

            @Override
            public void onJSBundleLoadedFromServer() {
                ReactInstanceManager.this.onJSBundleLoadedFromServer();
            }

            @Override
            public void toggleElementInspector() {
                ReactInstanceManager.this.toggleElementInspector();
            }

            @Override
            @Nullable
            public Activity getCurrentActivity() {
                return ReactInstanceManager.this.mCurrentActivity;
            }

            @Override
            public JavaScriptExecutorFactory getJavaScriptExecutorFactory() {
                return ReactInstanceManager.this.getJSExecutorFactory();
            }

            @Override
            @Nullable
            public View createRootView(String appKey) {
                Activity currentActivity = this.getCurrentActivity();
                if (currentActivity != null) {
                    ReactRootView rootView = new ReactRootView((Context)currentActivity);
                    boolean isFabric = ReactNativeNewArchitectureFeatureFlags.enableFabricRenderer();
                    rootView.setIsFabric(isFabric);
                    rootView.startReactApplication(ReactInstanceManager.this, appKey, new Bundle());
                    return rootView;
                }
                return null;
            }

            @Override
            public void destroyRootView(View rootView) {
                if (rootView instanceof ReactRootView) {
                    ((ReactRootView)rootView).unmountReactApplication();
                }
            }

            @Override
            public void reload(String reason) {
            }

            @Override
            public TaskInterface<Boolean> loadBundle(JSBundleLoader bundleLoader) {
                return null;
            }

            @Override
            public ReactContext getCurrentReactContext() {
                return null;
            }
        };
    }

    public synchronized void setUseFallbackBundle(boolean useFallbackBundle) {
        this.mUseFallbackBundle = useFallbackBundle;
    }

    private JavaScriptExecutorFactory getJSExecutorFactory() {
        return this.mJavaScriptExecutorFactory;
    }

    public DevSupportManager getDevSupportManager() {
        return this.mDevSupportManager;
    }

    public MemoryPressureRouter getMemoryPressureRouter() {
        return this.mMemoryPressureRouter;
    }

    public List<ReactPackage> getPackages() {
        return new ArrayList<ReactPackage>(this.mPackages);
    }

    public void handleCxxError(Exception e) {
        this.mDevSupportManager.handleException(e);
    }

    private void registerCxxErrorHandlerFunc() {
        Class[] parameterTypes = new Class[]{Exception.class};
        Method handleCxxErrorFunc = null;
        try {
            handleCxxErrorFunc = ReactInstanceManager.class.getMethod("handleCxxError", parameterTypes);
        }
        catch (NoSuchMethodException e) {
            FLog.e((String)"ReactInstanceHolder", (String)"Failed to set cxx error handler function", (Throwable)e);
        }
        ReactCxxErrorHandler.setHandleErrorFunc(this, handleCxxErrorFunc);
    }

    private void unregisterCxxErrorHandlerFunc() {
        ReactCxxErrorHandler.setHandleErrorFunc(null, null);
    }

    static void initializeSoLoaderIfNecessary(Context applicationContext) {
        SoLoader.init((Context)applicationContext, (boolean)false);
    }

    @ThreadConfined(value="UI")
    public void createReactContextInBackground() {
        FLog.d((String)TAG, (String)"ReactInstanceManager.createReactContextInBackground()");
        UiThreadUtil.assertOnUiThread();
        if (!this.mHasStartedCreatingInitialContext) {
            this.mHasStartedCreatingInitialContext = true;
            this.recreateReactContextInBackgroundInner();
        }
    }

    @ThreadConfined(value="UI")
    public void recreateReactContextInBackground() {
        Assertions.assertCondition((boolean)this.mHasStartedCreatingInitialContext, (String)"recreateReactContextInBackground should only be called after the initial createReactContextInBackground call.");
        this.recreateReactContextInBackgroundInner();
    }

    @ThreadConfined(value="UI")
    private void recreateReactContextInBackgroundInner() {
        FLog.d((String)TAG, (String)"ReactInstanceManager.recreateReactContextInBackgroundInner()");
        PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.RN_CORE, "RNCore: recreateReactContextInBackground");
        UiThreadUtil.assertOnUiThread();
        if (this.mUseDeveloperSupport && this.mJSMainModulePath != null) {
            DeveloperSettings devSettings2 = this.mDevSupportManager.getDevSettings();
            if (!Systrace.isTracing(0L)) {
                if (this.mBundleLoader == null) {
                    this.mDevSupportManager.handleReloadJS();
                } else {
                    this.mDevSupportManager.isPackagerRunning(new PackagerStatusCallback(){

                        @Override
                        public void onPackagerStatusFetched(boolean packagerIsRunning) {
                            UiThreadUtil.runOnUiThread(() -> {
                                if (ReactInstanceManager.this.mInstanceManagerInvalidated) {
                                    return;
                                }
                                if (packagerIsRunning) {
                                    ReactInstanceManager.this.mDevSupportManager.handleReloadJS();
                                } else if (ReactInstanceManager.this.mDevSupportManager.hasUpToDateJSBundleInCache() && !ReactInstanceManager.this.mUseFallbackBundle) {
                                    ReactInstanceManager.this.onJSBundleLoadedFromServer();
                                } else {
                                    ReactInstanceManager.this.recreateReactContextInBackgroundFromBundleLoader();
                                }
                            });
                        }
                    });
                }
                return;
            }
        }
        this.recreateReactContextInBackgroundFromBundleLoader();
    }

    @ThreadConfined(value="UI")
    private void recreateReactContextInBackgroundFromBundleLoader() {
        FLog.d((String)TAG, (String)"ReactInstanceManager.recreateReactContextInBackgroundFromBundleLoader()");
        PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.RN_CORE, "RNCore: load from BundleLoader");
        this.recreateReactContextInBackground(this.mJavaScriptExecutorFactory, this.mBundleLoader);
    }

    public boolean hasStartedCreatingInitialContext() {
        return this.mHasStartedCreatingInitialContext;
    }

    public void onBackPressed() {
        UiThreadUtil.assertOnUiThread();
        ReactContext reactContext = this.mCurrentReactContext;
        if (reactContext == null) {
            FLog.w((String)TAG, (String)"Instance detached from instance manager");
            this.invokeDefaultOnBackPressed();
        } else {
            DeviceEventManagerModule deviceEventManagerModule = reactContext.getNativeModule(DeviceEventManagerModule.class);
            if (deviceEventManagerModule != null) {
                deviceEventManagerModule.emitHardwareBackPressed();
            }
        }
    }

    private void invokeDefaultOnBackPressed() {
        UiThreadUtil.assertOnUiThread();
        if (this.mDefaultBackButtonImpl != null) {
            this.mDefaultBackButtonImpl.invokeDefaultOnBackPressed();
        }
    }

    @ThreadConfined(value="UI")
    public void onNewIntent(Intent intent) {
        UiThreadUtil.assertOnUiThread();
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext == null) {
            FLog.w((String)TAG, (String)"Instance detached from instance manager");
        } else {
            DeviceEventManagerModule deviceEventManagerModule;
            String action = intent.getAction();
            Uri uri = intent.getData();
            if (uri != null && ("android.intent.action.VIEW".equals(action) || "android.nfc.action.NDEF_DISCOVERED".equals(action)) && (deviceEventManagerModule = currentContext.getNativeModule(DeviceEventManagerModule.class)) != null) {
                deviceEventManagerModule.emitNewIntentReceived(uri);
            }
            currentContext.onNewIntent(this.mCurrentActivity, intent);
        }
    }

    private void toggleElementInspector() {
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null && currentContext.hasActiveReactInstance()) {
            currentContext.emitDeviceEvent("toggleElementInspector");
        } else {
            ReactSoftExceptionLogger.logSoftException(TAG, new ReactNoCrashSoftException("Cannot toggleElementInspector, CatalystInstance not available"));
        }
    }

    @Deprecated
    @ThreadConfined(value="UI")
    public void onHostPause() {
        UiThreadUtil.assertOnUiThread();
        this.mDefaultBackButtonImpl = null;
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
        }
        this.moveToBeforeResumeLifecycleState();
    }

    @ThreadConfined(value="UI")
    public void onUserLeaveHint(@Nullable Activity activity) {
        if (this.mCurrentActivity != null && activity == this.mCurrentActivity) {
            UiThreadUtil.assertOnUiThread();
            ReactContext currentContext = this.getCurrentReactContext();
            if (currentContext != null) {
                currentContext.onUserLeaveHint(activity);
            }
        }
    }

    @ThreadConfined(value="UI")
    public void onHostPause(@Nullable Activity activity) {
        if (this.mRequireActivity) {
            if (this.mCurrentActivity == null) {
                StackTraceElement[] stackTrace;
                String message = "ReactInstanceManager.onHostPause called with null activity";
                FLog.e((String)TAG, (String)message);
                for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
                    FLog.e((String)TAG, (String)element.toString());
                }
            }
            Assertions.assertCondition((this.mCurrentActivity != null ? 1 : 0) != 0);
        }
        if (this.mCurrentActivity != null) {
            Assertions.assertCondition((activity == this.mCurrentActivity ? 1 : 0) != 0, (String)("Pausing an activity that is not the current activity, this is incorrect! Current activity: " + this.mCurrentActivity.getClass().getSimpleName() + " Paused activity: " + activity.getClass().getSimpleName()));
        }
        this.onHostPause();
    }

    @ThreadConfined(value="UI")
    public void onHostResume(@Nullable Activity activity, DefaultHardwareBackBtnHandler defaultBackButtonImpl) {
        UiThreadUtil.assertOnUiThread();
        this.mDefaultBackButtonImpl = defaultBackButtonImpl;
        this.onHostResume(activity);
    }

    @ThreadConfined(value="UI")
    public void onHostResume(@Nullable Activity activity) {
        UiThreadUtil.assertOnUiThread();
        this.mCurrentActivity = activity;
        if (this.mUseDeveloperSupport) {
            if (this.mCurrentActivity != null) {
                final View decorView = this.mCurrentActivity.getWindow().getDecorView();
                if (!ViewCompat.isAttachedToWindow((View)decorView)) {
                    decorView.addOnAttachStateChangeListener(new View.OnAttachStateChangeListener(){

                        public void onViewAttachedToWindow(View v) {
                            decorView.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
                            ReactInstanceManager.this.mDevSupportManager.setDevSupportEnabled(true);
                        }

                        public void onViewDetachedFromWindow(View v) {
                        }
                    });
                } else {
                    this.mDevSupportManager.setDevSupportEnabled(true);
                }
            } else if (!this.mRequireActivity) {
                this.mDevSupportManager.setDevSupportEnabled(true);
            }
        }
        this.moveToResumedLifecycleState(false);
    }

    @Deprecated
    @ThreadConfined(value="UI")
    public void onHostDestroy() {
        UiThreadUtil.assertOnUiThread();
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
        }
        this.moveToBeforeCreateLifecycleState();
        if (!this.mKeepActivity) {
            this.mCurrentActivity = null;
        }
    }

    @ThreadConfined(value="UI")
    public void onHostDestroy(@Nullable Activity activity) {
        if (activity == this.mCurrentActivity) {
            this.onHostDestroy();
        }
    }

    private void logOnDestroy() {
        FLog.d((String)TAG, (String)"ReactInstanceManager.destroy called", (Throwable)new RuntimeException("ReactInstanceManager.destroy called"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadConfined(value="UI")
    public void destroy() {
        UiThreadUtil.assertOnUiThread();
        PrinterHolder.getPrinter().logMessage(ReactDebugOverlayTags.RN_CORE, "RNCore: Destroy");
        this.logOnDestroy();
        if (this.mHasStartedDestroying.booleanValue()) {
            FLog.e((String)"ReactNative", (String)"ReactInstanceManager.destroy called: bail out, already destroying");
            return;
        }
        this.mHasStartedDestroying = true;
        if (this.mUseDeveloperSupport) {
            this.mDevSupportManager.setDevSupportEnabled(false);
            this.mDevSupportManager.stopInspector();
        }
        this.moveToBeforeCreateLifecycleState();
        this.mMemoryPressureRouter.destroy(this.mApplicationContext);
        this.unregisterCxxErrorHandlerFunc();
        this.mCreateReactContextThread = null;
        List<ReactPackage> list = this.mAttachedReactRoots;
        synchronized (list) {
            Object object = this.mReactContextLock;
            synchronized (object) {
                if (this.mCurrentReactContext != null) {
                    for (ReactRoot reactRoot : this.mAttachedReactRoots) {
                        if (reactRoot.getUIManagerType() != 2) continue;
                        this.detachRootViewFromInstance(reactRoot, this.mCurrentReactContext);
                    }
                    this.mCurrentReactContext.destroy();
                    this.mCurrentReactContext = null;
                }
            }
        }
        if (this.mInstanceManagerInvalidated && this.mInspectorTarget != null) {
            this.mInspectorTarget.close();
            this.mInspectorTarget = null;
        }
        this.mHasStartedCreatingInitialContext = false;
        if (!this.mKeepActivity) {
            this.mCurrentActivity = null;
        }
        ResourceDrawableIdHelper.getInstance();
        ResourceDrawableIdHelper.clear();
        this.mHasStartedDestroying = false;
        list = this.mHasStartedDestroying;
        synchronized (list) {
            this.mHasStartedDestroying.notifyAll();
        }
        list = this.mPackages;
        synchronized (list) {
            this.mViewManagerNames = null;
        }
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager has been destroyed");
    }

    private synchronized void moveToResumedLifecycleState(boolean force) {
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null && (force || this.mLifecycleState == LifecycleState.BEFORE_RESUME || this.mLifecycleState == LifecycleState.BEFORE_CREATE)) {
            currentContext.onHostResume(this.mCurrentActivity);
        }
        this.mLifecycleState = LifecycleState.RESUMED;
    }

    private synchronized void moveToBeforeResumeLifecycleState() {
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null) {
            if (this.mLifecycleState == LifecycleState.BEFORE_CREATE) {
                currentContext.onHostResume(this.mCurrentActivity);
                currentContext.onHostPause();
            } else if (this.mLifecycleState == LifecycleState.RESUMED) {
                currentContext.onHostPause();
            }
        }
        this.mLifecycleState = LifecycleState.BEFORE_RESUME;
    }

    private synchronized void moveToBeforeCreateLifecycleState() {
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null) {
            if (this.mLifecycleState == LifecycleState.RESUMED) {
                currentContext.onHostPause();
                this.mLifecycleState = LifecycleState.BEFORE_RESUME;
            }
            if (this.mLifecycleState == LifecycleState.BEFORE_RESUME) {
                currentContext.onHostDestroy(this.mKeepActivity);
            }
        }
        this.mLifecycleState = LifecycleState.BEFORE_CREATE;
    }

    private synchronized void moveReactContextToCurrentLifecycleState() {
        if (this.mLifecycleState == LifecycleState.RESUMED) {
            this.moveToResumedLifecycleState(true);
        }
    }

    @ThreadConfined(value="UI")
    public void onActivityResult(Activity activity, int requestCode, int resultCode, @Nullable Intent data) {
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null) {
            currentContext.onActivityResult(activity, requestCode, resultCode, data);
        }
    }

    @ThreadConfined(value="UI")
    public void onWindowFocusChange(boolean hasFocus) {
        UiThreadUtil.assertOnUiThread();
        ReactContext currentContext = this.getCurrentReactContext();
        if (currentContext != null) {
            currentContext.onWindowFocusChange(hasFocus);
        }
    }

    @ThreadConfined(value="UI")
    public void onConfigurationChanged(Context updatedContext, @Nullable Configuration newConfig) {
        AppearanceModule appearanceModule;
        UiThreadUtil.assertOnUiThread();
        ReactContext currentReactContext = this.getCurrentReactContext();
        if (currentReactContext != null && (appearanceModule = currentReactContext.getNativeModule(AppearanceModule.class)) != null) {
            appearanceModule.onConfigurationChanged(updatedContext);
        }
    }

    @ThreadConfined(value="UI")
    public void showDevOptionsDialog() {
        UiThreadUtil.assertOnUiThread();
        this.mDevSupportManager.showDevOptionsDialog();
    }

    @ThreadConfined(value="UI")
    private void clearReactRoot(ReactRoot reactRoot) {
        UiThreadUtil.assertOnUiThread();
        reactRoot.getState().compareAndSet(1, 0);
        ViewGroup rootViewGroup = reactRoot.getRootViewGroup();
        rootViewGroup.removeAllViews();
        rootViewGroup.setId(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    @ThreadConfined(value="UI")
    public void attachRootView(ReactRoot reactRoot) {
        UiThreadUtil.assertOnUiThread();
        Set<ReactRoot> set = this.mAttachedReactRoots;
        synchronized (set) {
            if (this.mAttachedReactRoots.add(reactRoot)) {
                this.clearReactRoot(reactRoot);
            } else {
                FLog.e((String)"ReactNative", (String)"ReactRoot was attached multiple times");
            }
            ReactContext currentContext = this.getCurrentReactContext();
            if (this.mCreateReactContextThread == null && currentContext != null) {
                this.attachRootViewToInstance(reactRoot);
            }
        }
    }

    @Deprecated
    @ThreadConfined(value="UI")
    public void detachRootView(ReactRoot reactRoot) {
        UiThreadUtil.assertOnUiThread();
        if (!this.mAttachedReactRoots.remove(reactRoot)) {
            return;
        }
        ReactContext reactContext = this.mCurrentReactContext;
        if (reactContext != null && reactContext.hasActiveReactInstance()) {
            this.detachRootViewFromInstance(reactRoot, reactContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ViewManager> getOrCreateViewManagers(ReactApplicationContext catalystApplicationContext) {
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_VIEW_MANAGERS_START);
        Systrace.beginSection(0L, "createAllViewManagers");
        try {
            if (this.mViewManagers == null) {
                List<ReactPackage> list = this.mPackages;
                synchronized (list) {
                    if (this.mViewManagers == null) {
                        ArrayList<ViewManager> viewManagers = new ArrayList<ViewManager>();
                        Object object = this.mPackages.iterator();
                        while (true) {
                            if (!object.hasNext()) {
                                this.mViewManagers = viewManagers;
                                object = this.mViewManagers;
                                return object;
                            }
                            ReactPackage reactPackage = object.next();
                            viewManagers.addAll(reactPackage.createViewManagers(catalystApplicationContext));
                        }
                    }
                }
            }
            List<ViewManager> list = this.mViewManagers;
            return list;
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_VIEW_MANAGERS_END);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ViewManager createViewManager(String viewManagerName) {
        ReactApplicationContext context;
        List<ReactPackage> list = this.mReactContextLock;
        synchronized (list) {
            context = (ReactApplicationContext)this.getCurrentReactContext();
            if (context == null || !context.hasActiveReactInstance()) {
                return null;
            }
        }
        list = this.mPackages;
        synchronized (list) {
            for (ReactPackage reactPackage : this.mPackages) {
                ViewManager viewManager;
                if (!(reactPackage instanceof ViewManagerOnDemandReactPackage) || (viewManager = ((ViewManagerOnDemandReactPackage)((Object)reactPackage)).createViewManager(context, viewManagerName)) == null) continue;
                return viewManager;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<String> getViewManagerNames() {
        Systrace.beginSection(0L, "ReactInstanceManager.getViewManagerNames");
        try {
            ReactApplicationContext context;
            Collection<String> viewManagerNames = this.mViewManagerNames;
            if (viewManagerNames != null) {
                Collection<String> collection = viewManagerNames;
                return collection;
            }
            List<ReactPackage> list = this.mReactContextLock;
            synchronized (list) {
                context = (ReactApplicationContext)this.getCurrentReactContext();
                if (context == null || !context.hasActiveReactInstance()) {
                    FLog.w((String)"ReactNative", (String)"Calling getViewManagerNames without active context");
                    List<String> list2 = Collections.emptyList();
                    return list2;
                }
            }
            list = this.mPackages;
            synchronized (list) {
                if (this.mViewManagerNames == null) {
                    HashSet<String> uniqueNames = new HashSet<String>();
                    for (ReactPackage reactPackage : this.mPackages) {
                        SystraceMessage.beginSection(0L, "ReactInstanceManager.getViewManagerName").arg("Package", reactPackage.getClass().getSimpleName()).flush();
                        if (reactPackage instanceof ViewManagerOnDemandReactPackage) {
                            Collection<String> names = ((ViewManagerOnDemandReactPackage)((Object)reactPackage)).getViewManagerNames(context);
                            if (names != null) {
                                uniqueNames.addAll(names);
                            }
                        } else {
                            FLog.w((String)"ReactNative", (String)"Package %s is not a ViewManagerOnDemandReactPackage, view managers will not be loaded", (Object[])new Object[]{reactPackage.getClass().getSimpleName()});
                        }
                        Systrace.endSection(0L);
                    }
                    this.mViewManagerNames = uniqueNames;
                }
                Collection<String> collection = this.mViewManagerNames;
                return collection;
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    public void addReactInstanceEventListener(com.facebook.react.ReactInstanceEventListener listener) {
        this.mReactInstanceEventListeners.add(listener);
    }

    public void removeReactInstanceEventListener(com.facebook.react.ReactInstanceEventListener listener) {
        this.mReactInstanceEventListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    public ReactContext getCurrentReactContext() {
        Object object = this.mReactContextLock;
        synchronized (object) {
            return this.mCurrentReactContext;
        }
    }

    public LifecycleState getLifecycleState() {
        return this.mLifecycleState;
    }

    public String getJsExecutorName() {
        return this.mJavaScriptExecutorFactory.toString();
    }

    @ThreadConfined(value="UI")
    public void invalidate() {
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.invalidate()");
        this.mInstanceManagerInvalidated = true;
        this.destroy();
    }

    @ThreadConfined(value="UI")
    private void onJSBundleLoadedFromServer() {
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.onJSBundleLoadedFromServer()");
        JSBundleLoader bundleLoader = JSBundleLoader.createCachedBundleFromNetworkLoader(this.mDevSupportManager.getSourceUrl(), this.mDevSupportManager.getDownloadedJSBundleFile());
        this.recreateReactContextInBackground(this.mJavaScriptExecutorFactory, bundleLoader);
    }

    @ThreadConfined(value="UI")
    private void recreateReactContextInBackground(JavaScriptExecutorFactory jsExecutorFactory, JSBundleLoader jsBundleLoader) {
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.recreateReactContextInBackground()");
        UiThreadUtil.assertOnUiThread();
        ReactContextInitParams initParams = new ReactContextInitParams(jsExecutorFactory, jsBundleLoader);
        if (this.mCreateReactContextThread == null) {
            this.runCreateReactContextOnNewThread(initParams);
        } else {
            this.mPendingReactContextInitParams = initParams;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadConfined(value="UI")
    private void runCreateReactContextOnNewThread(ReactContextInitParams initParams) {
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.runCreateReactContextOnNewThread()");
        UiThreadUtil.assertOnUiThread();
        Assertions.assertCondition((!this.mInstanceManagerInvalidated ? 1 : 0) != 0, (String)"Cannot create a new React context on an invalidated ReactInstanceManager");
        ReactMarker.logMarker(ReactMarkerConstants.REACT_BRIDGE_LOADING_START);
        Set<ReactRoot> set = this.mAttachedReactRoots;
        synchronized (set) {
            Object object = this.mReactContextLock;
            synchronized (object) {
                if (this.mCurrentReactContext != null) {
                    this.tearDownReactContext(this.mCurrentReactContext);
                    this.mCurrentReactContext = null;
                }
            }
        }
        this.mCreateReactContextThread = new Thread(null, () -> {
            ReactApplicationContext reactApplicationContext;
            ReactMarker.logMarker(ReactMarkerConstants.REACT_CONTEXT_THREAD_END);
            Boolean bl = this.mHasStartedDestroying;
            synchronized (bl) {
                while (this.mHasStartedDestroying.booleanValue()) {
                    try {
                        this.mHasStartedDestroying.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
            this.mHasStartedCreatingInitialContext = true;
            try {
                Process.setThreadPriority((int)-4);
                ReactMarker.logMarker(ReactMarkerConstants.VM_INIT);
                reactApplicationContext = this.createReactContext(initParams.getJsExecutorFactory().create(), initParams.getJsBundleLoader());
            }
            catch (Exception e) {
                this.mHasStartedCreatingInitialContext = false;
                this.mCreateReactContextThread = null;
                this.mDevSupportManager.handleException(e);
                return;
            }
            try {
                this.mCreateReactContextThread = null;
                ReactMarker.logMarker(ReactMarkerConstants.PRE_SETUP_REACT_CONTEXT_START);
                Runnable maybeRecreateReactContextRunnable = () -> {
                    if (this.mPendingReactContextInitParams != null) {
                        this.runCreateReactContextOnNewThread(this.mPendingReactContextInitParams);
                        this.mPendingReactContextInitParams = null;
                    }
                };
                Runnable setupReactContextRunnable = () -> {
                    try {
                        this.setupReactContext(reactApplicationContext);
                    }
                    catch (Exception e) {
                        this.mDevSupportManager.handleException(e);
                    }
                };
                reactApplicationContext.runOnNativeModulesQueueThread(setupReactContextRunnable);
                UiThreadUtil.runOnUiThread(maybeRecreateReactContextRunnable);
            }
            catch (Exception e) {
                this.mDevSupportManager.handleException(e);
            }
        }, "create_react_context");
        ReactMarker.logMarker(ReactMarkerConstants.REACT_CONTEXT_THREAD_START);
        this.mCreateReactContextThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupReactContext(ReactApplicationContext reactContext) {
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.setupReactContext()");
        ReactMarker.logMarker(ReactMarkerConstants.PRE_SETUP_REACT_CONTEXT_END);
        ReactMarker.logMarker(ReactMarkerConstants.SETUP_REACT_CONTEXT_START);
        Systrace.beginSection(0L, "setupReactContext");
        Set<ReactRoot> set = this.mAttachedReactRoots;
        synchronized (set) {
            Object object = this.mReactContextLock;
            synchronized (object) {
                this.mCurrentReactContext = (ReactContext)((Object)Assertions.assertNotNull((Object)((Object)reactContext)));
            }
            CatalystInstance catalystInstance = (CatalystInstance)Assertions.assertNotNull((Object)reactContext.getCatalystInstance());
            catalystInstance.initialize();
            this.mDevSupportManager.onNewReactContextCreated(reactContext);
            this.mMemoryPressureRouter.addMemoryPressureListener(catalystInstance);
            ReactMarker.logMarker(ReactMarkerConstants.ATTACH_MEASURED_ROOT_VIEWS_START);
            for (ReactRoot reactRoot : this.mAttachedReactRoots) {
                this.attachRootViewToInstance(reactRoot);
            }
            ReactMarker.logMarker(ReactMarkerConstants.ATTACH_MEASURED_ROOT_VIEWS_END);
        }
        com.facebook.react.ReactInstanceEventListener[] listeners = new com.facebook.react.ReactInstanceEventListener[this.mReactInstanceEventListeners.size()];
        com.facebook.react.ReactInstanceEventListener[] finalListeners = this.mReactInstanceEventListeners.toArray(listeners);
        UiThreadUtil.runOnUiThread(() -> {
            this.moveReactContextToCurrentLifecycleState();
            for (com.facebook.react.ReactInstanceEventListener listener : finalListeners) {
                if (listener == null) continue;
                listener.onReactContextInitialized(reactContext);
            }
        });
        reactContext.runOnJSQueueThread(() -> {
            Process.setThreadPriority((int)0);
            ReactMarker.logMarker(ReactMarkerConstants.CHANGE_THREAD_PRIORITY, "js_default");
        });
        reactContext.runOnNativeModulesQueueThread(() -> Process.setThreadPriority((int)0));
        Systrace.endSection(0L);
        ReactMarker.logMarker(ReactMarkerConstants.SETUP_REACT_CONTEXT_END);
        ReactMarker.logMarker(ReactMarkerConstants.REACT_BRIDGE_LOADING_END);
    }

    private void attachRootViewToInstance(ReactRoot reactRoot) {
        int rootTag;
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.attachRootViewToInstance()");
        if (!reactRoot.getState().compareAndSet(0, 1)) {
            return;
        }
        Systrace.beginSection(0L, "attachRootViewToInstance");
        UIManager uiManager = UIManagerHelper.getUIManager(this.mCurrentReactContext, reactRoot.getUIManagerType());
        if (uiManager == null) {
            throw new IllegalStateException("Unable to attach a rootView to ReactInstance when UIManager is not properly initialized.");
        }
        Bundle initialProperties = reactRoot.getAppProperties();
        if (reactRoot.getUIManagerType() == 2) {
            rootTag = uiManager.startSurface(reactRoot.getRootViewGroup(), reactRoot.getJSModuleName(), initialProperties == null ? new WritableNativeMap() : Arguments.fromBundle(initialProperties), reactRoot.getWidthMeasureSpec(), reactRoot.getHeightMeasureSpec());
            reactRoot.setShouldLogContentAppeared(true);
        } else {
            rootTag = uiManager.addRootView(reactRoot.getRootViewGroup(), initialProperties == null ? new WritableNativeMap() : Arguments.fromBundle(initialProperties));
            reactRoot.setRootViewTag(rootTag);
            reactRoot.runApplication();
        }
        Systrace.beginAsyncSection(0L, "pre_rootView.onAttachedToReactInstance", rootTag);
        UiThreadUtil.runOnUiThread(() -> {
            Systrace.endAsyncSection(0L, "pre_rootView.onAttachedToReactInstance", rootTag);
            reactRoot.onStage(101);
        });
        Systrace.endSection(0L);
    }

    private void detachRootViewFromInstance(ReactRoot reactRoot, ReactContext reactContext) {
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.detachRootViewFromInstance()");
        UiThreadUtil.assertOnUiThread();
        if (!reactRoot.getState().compareAndSet(1, 0)) {
            return;
        }
        int uiManagerType = reactRoot.getUIManagerType();
        if (uiManagerType == 2) {
            int surfaceId = reactRoot.getRootViewTag();
            if (surfaceId != -1) {
                UIManager uiManager = UIManagerHelper.getUIManager(reactContext, uiManagerType);
                if (uiManager != null) {
                    uiManager.stopSurface(surfaceId);
                } else {
                    FLog.w((String)"ReactNative", (String)"Failed to stop surface, UIManager has already gone away");
                }
            } else {
                ReactSoftExceptionLogger.logSoftException(TAG, new RuntimeException("detachRootViewFromInstance called with ReactRootView with invalid id"));
            }
            this.clearReactRoot(reactRoot);
        } else {
            reactContext.getCatalystInstance().getJSModule(AppRegistry.class).unmountApplicationComponentAtRootTag(reactRoot.getRootViewTag());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ThreadConfined(value="UI")
    private void tearDownReactContext(ReactContext reactContext) {
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.tearDownReactContext()");
        UiThreadUtil.assertOnUiThread();
        if (this.mLifecycleState == LifecycleState.RESUMED) {
            reactContext.onHostPause();
        }
        Set<ReactRoot> set = this.mAttachedReactRoots;
        synchronized (set) {
            for (ReactRoot reactRoot : this.mAttachedReactRoots) {
                this.detachRootViewFromInstance(reactRoot, reactContext);
            }
        }
        this.mMemoryPressureRouter.removeMemoryPressureListener(reactContext.getCatalystInstance());
        reactContext.destroy();
        this.mDevSupportManager.onReactInstanceDestroyed(reactContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ReactApplicationContext createReactContext(JavaScriptExecutor jsExecutor, JSBundleLoader jsBundleLoader) {
        UIManager uiManager;
        CatalystInstanceImpl catalystInstance;
        FLog.d((String)"ReactNative", (String)"ReactInstanceManager.createReactContext()");
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_REACT_CONTEXT_START, jsExecutor.getName());
        BridgeReactContext reactContext = new BridgeReactContext(this.mApplicationContext);
        JSExceptionHandler exceptionHandler = this.mJSExceptionHandler != null ? this.mJSExceptionHandler : this.mDevSupportManager;
        reactContext.setJSExceptionHandler(exceptionHandler);
        NativeModuleRegistry nativeModuleRegistry = this.processPackages(reactContext, this.mPackages);
        CatalystInstanceImpl.Builder catalystInstanceBuilder = new CatalystInstanceImpl.Builder().setReactQueueConfigurationSpec(ReactQueueConfigurationSpec.createDefault()).setJSExecutor(jsExecutor).setRegistry(nativeModuleRegistry).setJSBundleLoader(jsBundleLoader).setJSExceptionHandler(exceptionHandler).setInspectorTarget(this.getOrCreateInspectorTarget());
        ReactMarker.logMarker(ReactMarkerConstants.CREATE_CATALYST_INSTANCE_START);
        Systrace.beginSection(0L, "createCatalystInstance");
        try {
            catalystInstance = catalystInstanceBuilder.build();
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.CREATE_CATALYST_INSTANCE_END);
        }
        reactContext.initializeWithInstance(catalystInstance);
        catalystInstance.getRuntimeScheduler();
        if (ReactNativeNewArchitectureFeatureFlags.useTurboModules() && this.mTMMDelegateBuilder != null) {
            ReactPackageTurboModuleManagerDelegate tmmDelegate = this.mTMMDelegateBuilder.setPackages(this.mPackages).setReactApplicationContext(reactContext).build();
            TurboModuleManager turboModuleManager = new TurboModuleManager(catalystInstance.getRuntimeExecutor(), tmmDelegate, catalystInstance.getJSCallInvokerHolder(), catalystInstance.getNativeMethodCallInvokerHolder());
            catalystInstance.setTurboModuleRegistry(turboModuleManager);
            for (String moduleName : turboModuleManager.getEagerInitModuleNames()) {
                turboModuleManager.getModule(moduleName);
            }
        }
        if (this.mUIManagerProvider != null && (uiManager = this.mUIManagerProvider.createUIManager(reactContext)) != null) {
            catalystInstance.setFabricUIManager(uiManager);
            uiManager.initialize();
            catalystInstance.setFabricUIManager(uiManager);
        }
        if (this.mBridgeIdleDebugListener != null) {
            catalystInstance.addBridgeIdleDebugListener(this.mBridgeIdleDebugListener);
        }
        if (Systrace.isTracing(0L)) {
            catalystInstance.setGlobalVariable("__RCTProfileIsProfiling", "true");
        }
        ReactMarker.logMarker(ReactMarkerConstants.PRE_RUN_JS_BUNDLE_START);
        Systrace.beginSection(0L, "runJSBundle");
        catalystInstance.runJSBundle();
        Systrace.endSection(0L);
        return reactContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NativeModuleRegistry processPackages(ReactApplicationContext reactContext, List<ReactPackage> packages) {
        NativeModuleRegistry nativeModuleRegistry;
        NativeModuleRegistryBuilder nativeModuleRegistryBuilder = new NativeModuleRegistryBuilder(reactContext);
        ReactMarker.logMarker(ReactMarkerConstants.PROCESS_PACKAGES_START);
        List<ReactPackage> list = this.mPackages;
        synchronized (list) {
            for (ReactPackage reactPackage : packages) {
                Systrace.beginSection(0L, "createAndProcessCustomReactPackage");
                try {
                    this.processPackage(reactPackage, nativeModuleRegistryBuilder);
                }
                finally {
                    Systrace.endSection(0L);
                }
            }
        }
        ReactMarker.logMarker(ReactMarkerConstants.PROCESS_PACKAGES_END);
        ReactMarker.logMarker(ReactMarkerConstants.BUILD_NATIVE_MODULE_REGISTRY_START);
        Systrace.beginSection(0L, "buildNativeModuleRegistry");
        try {
            nativeModuleRegistry = nativeModuleRegistryBuilder.build();
        }
        finally {
            Systrace.endSection(0L);
            ReactMarker.logMarker(ReactMarkerConstants.BUILD_NATIVE_MODULE_REGISTRY_END);
        }
        return nativeModuleRegistry;
    }

    private void processPackage(ReactPackage reactPackage, NativeModuleRegistryBuilder nativeModuleRegistryBuilder) {
        SystraceMessage.beginSection(0L, "processPackage").arg("className", reactPackage.getClass().getSimpleName()).flush();
        if (reactPackage instanceof ReactPackageLogger) {
            ((ReactPackageLogger)((Object)reactPackage)).startProcessPackage();
        }
        nativeModuleRegistryBuilder.processPackage(reactPackage);
        if (reactPackage instanceof ReactPackageLogger) {
            ((ReactPackageLogger)((Object)reactPackage)).endProcessPackage();
        }
        SystraceMessage.endSection(0L).flush();
    }

    @Nullable
    private ReactInstanceManagerInspectorTarget getOrCreateInspectorTarget() {
        if (this.mInspectorTarget == null && InspectorFlags.getFuseboxEnabled()) {
            this.mInspectorTarget = new ReactInstanceManagerInspectorTarget(new InspectorTargetDelegateImpl(this));
        }
        return this.mInspectorTarget;
    }

    static {
        LegacyArchitectureLogger.assertLegacyArchitecture("ReactInstanceManager", LegacyArchitectureLogLevel.WARNING);
        TAG = ReactInstanceManager.class.getSimpleName();
    }

    private class ReactContextInitParams {
        private final JavaScriptExecutorFactory mJsExecutorFactory;
        private final JSBundleLoader mJsBundleLoader;

        public ReactContextInitParams(JavaScriptExecutorFactory jsExecutorFactory, JSBundleLoader jsBundleLoader) {
            this.mJsExecutorFactory = (JavaScriptExecutorFactory)Assertions.assertNotNull((Object)jsExecutorFactory);
            this.mJsBundleLoader = (JSBundleLoader)Assertions.assertNotNull((Object)jsBundleLoader);
        }

        public JavaScriptExecutorFactory getJsExecutorFactory() {
            return this.mJsExecutorFactory;
        }

        public JSBundleLoader getJsBundleLoader() {
            return this.mJsBundleLoader;
        }
    }

    private static class InspectorTargetDelegateImpl
    implements ReactInstanceManagerInspectorTarget.TargetDelegate {
        private WeakReference<ReactInstanceManager> mReactInstanceManagerWeak;

        public InspectorTargetDelegateImpl(ReactInstanceManager inspectorTarget) {
            this.mReactInstanceManagerWeak = new WeakReference<ReactInstanceManager>(inspectorTarget);
        }

        @Override
        public Map<String, String> getMetadata() {
            ReactInstanceManager reactInstanceManager = (ReactInstanceManager)this.mReactInstanceManagerWeak.get();
            return AndroidInfoHelpers.getInspectorHostMetadata(reactInstanceManager != null ? reactInstanceManager.mApplicationContext : null);
        }

        @Override
        public void onReload() {
            UiThreadUtil.runOnUiThread(() -> {
                ReactInstanceManager reactInstanceManager = (ReactInstanceManager)this.mReactInstanceManagerWeak.get();
                if (reactInstanceManager != null) {
                    reactInstanceManager.mDevSupportManager.handleReloadJS();
                }
            });
        }

        @Override
        public void onSetPausedInDebuggerMessage(@Nullable String message) {
            final ReactInstanceManager reactInstanceManager = (ReactInstanceManager)this.mReactInstanceManagerWeak.get();
            if (reactInstanceManager == null) {
                return;
            }
            if (message == null) {
                reactInstanceManager.mDevSupportManager.hidePausedInDebuggerOverlay();
            } else {
                reactInstanceManager.mDevSupportManager.showPausedInDebuggerOverlay(message, new DevSupportManager.PausedInDebuggerOverlayCommandListener(){

                    @Override
                    public void onResume() {
                        UiThreadUtil.assertOnUiThread();
                        if (reactInstanceManager.mInspectorTarget != null) {
                            reactInstanceManager.mInspectorTarget.sendDebuggerResumeCommand();
                        }
                    }
                });
            }
        }

        @Override
        public void loadNetworkResource(String url, InspectorNetworkRequestListener listener) {
            InspectorNetworkHelper.loadNetworkResource(url, listener);
        }
    }

    @Deprecated
    public static interface ReactInstanceEventListener
    extends com.facebook.react.ReactInstanceEventListener {
    }
}

