/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.util;

import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.util.RCTLog;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u0011\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\u0014\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J$\u0010\u0015\u001a\u00020\f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002J\u0010\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/facebook/react/util/RNLog;", "", "<init>", "()V", "MINIMUM_LEVEL_FOR_UI", "", "LOG", "TRACE", "ADVICE", "WARN", "ERROR", "l", "", "message", "", "t", "a", "w", "context", "Lcom/facebook/react/bridge/ReactContext;", "e", "logInternal", "level", "levelToString", "ReactAndroid_debug"})
public final class RNLog {
    @NotNull
    public static final RNLog INSTANCE = new RNLog();
    public static final int MINIMUM_LEVEL_FOR_UI = 5;
    public static final int LOG = 2;
    public static final int TRACE = 3;
    public static final int ADVICE = 4;
    public static final int WARN = 5;
    public static final int ERROR = 6;

    private RNLog() {
    }

    @JvmStatic
    public static final void l(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        FLog.i((String)"ReactNative", (String)message);
    }

    @JvmStatic
    public static final void t(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        FLog.i((String)"ReactNative", (String)message);
    }

    @JvmStatic
    public static final void a(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        FLog.w((String)"ReactNative", (String)("(ADVICE)" + message));
    }

    @JvmStatic
    public static final void w(@Nullable ReactContext context, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        INSTANCE.logInternal(context, message, 5);
        FLog.w((String)"ReactNative", (String)message);
    }

    @JvmStatic
    public static final void e(@Nullable ReactContext context, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        INSTANCE.logInternal(context, message, 6);
        FLog.e((String)"ReactNative", (String)message);
    }

    @JvmStatic
    public static final void e(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        FLog.e((String)"ReactNative", (String)message);
    }

    private final void logInternal(ReactContext context, String message, int level) {
        if (level >= 5) {
            ReactContext reactContext = context;
            boolean bl = reactContext != null ? reactContext.hasActiveReactInstance() : false;
            if (bl && message != null) {
                context.getJSModule(RCTLog.class).logIfNoNativeHook(this.levelToString(level), message);
            }
        }
    }

    private final String levelToString(int level) {
        return switch (level) {
            case 2, 3 -> "log";
            case 4, 5 -> "warn";
            case 6 -> "error";
            default -> "none";
        };
    }
}

