/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime.internal.bolts;

import androidx.annotation.Nullable;
import com.facebook.react.interfaces.TaskInterface;
import com.facebook.react.runtime.internal.bolts.Continuation;
import com.facebook.react.runtime.internal.bolts.ExecutorException;
import com.facebook.react.runtime.internal.bolts.Executors;
import com.facebook.react.runtime.internal.bolts.TaskCompletionSource;
import com.facebook.react.runtime.internal.bolts.UnobservedErrorNotifier;
import com.facebook.react.runtime.internal.bolts.UnobservedTaskException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public class Task<TResult>
implements TaskInterface<TResult> {
    public static final Executor IMMEDIATE_EXECUTOR = Executors.IMMEDIATE;
    public static final Executor UI_THREAD_EXECUTOR = Executors.UI_THREAD;
    private static volatile UnobservedExceptionHandler unobservedExceptionHandler;
    private final Object lock = new Object();
    private boolean complete;
    private boolean cancelled;
    private TResult result;
    private Exception error;
    private boolean errorHasBeenObserved;
    private UnobservedErrorNotifier unobservedErrorNotifier;
    private List<Continuation<TResult, Void>> continuations = new ArrayList<Continuation<TResult, Void>>();
    private static Task<?> TASK_NULL;
    private static Task<Boolean> TASK_TRUE;
    private static Task<Boolean> TASK_FALSE;
    private static Task<?> TASK_CANCELLED;

    @Nullable
    public static UnobservedExceptionHandler getUnobservedExceptionHandler() {
        return unobservedExceptionHandler;
    }

    public static void setUnobservedExceptionHandler(UnobservedExceptionHandler eh) {
        unobservedExceptionHandler = eh;
    }

    Task() {
    }

    private Task(TResult result) {
        this.trySetResult(result);
    }

    private Task(boolean cancelled) {
        if (cancelled) {
            this.trySetCancelled();
        } else {
            this.trySetResult(null);
        }
    }

    public static <TResult> TaskCompletionSource create() {
        Task<TResult> task = new Task<TResult>();
        return new TaskCompletionSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCompleted() {
        Object object = this.lock;
        synchronized (object) {
            return this.complete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCancelled() {
        Object object = this.lock;
        synchronized (object) {
            return this.cancelled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFaulted() {
        Object object = this.lock;
        synchronized (object) {
            return this.getError() != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TResult getResult() {
        Object object = this.lock;
        synchronized (object) {
            return this.result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Exception getError() {
        Object object = this.lock;
        synchronized (object) {
            if (this.error != null) {
                this.errorHasBeenObserved = true;
                if (this.unobservedErrorNotifier != null) {
                    this.unobservedErrorNotifier.setObserved();
                    this.unobservedErrorNotifier = null;
                }
            }
            return this.error;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForCompletion() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isCompleted()) {
                this.lock.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean waitForCompletion(long duration, TimeUnit timeUnit) throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.isCompleted()) {
                this.lock.wait(timeUnit.toMillis(duration));
            }
            return this.isCompleted();
        }
    }

    public static <TResult> Task<TResult> forResult(@Nullable TResult value) {
        if (value == null) {
            return TASK_NULL;
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? TASK_TRUE : TASK_FALSE;
        }
        TaskCompletionSource<TResult> tcs = new TaskCompletionSource<TResult>();
        tcs.setResult(value);
        return tcs.getTask();
    }

    public static <TResult> Task<TResult> forError(Exception error) {
        TaskCompletionSource tcs = new TaskCompletionSource();
        tcs.setError(error);
        return tcs.getTask();
    }

    public static <TResult> Task<TResult> cancelled() {
        return TASK_CANCELLED;
    }

    public Task<Void> makeVoid() {
        return this.continueWithTask(new Continuation<TResult, Task<Void>>(){

            @Override
            public Task<Void> then(Task<TResult> task) throws Exception {
                if (task.isCancelled()) {
                    return Task.cancelled();
                }
                if (task.isFaulted()) {
                    return Task.forError(task.getError());
                }
                return Task.forResult(null);
            }
        });
    }

    public static <TResult> Task<TResult> call(final Callable<TResult> callable, Executor executor) {
        final TaskCompletionSource tcs = new TaskCompletionSource();
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        tcs.setResult(callable.call());
                    }
                    catch (CancellationException e) {
                        tcs.setCancelled();
                    }
                    catch (Exception e) {
                        tcs.setError(e);
                    }
                }
            });
        }
        catch (Exception e) {
            tcs.setError(new ExecutorException(e));
        }
        return tcs.getTask();
    }

    public static <TResult> Task<TResult> call(Callable<TResult> callable) {
        return Task.call(callable, IMMEDIATE_EXECUTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TContinuationResult> Task<TContinuationResult> continueWith(final Continuation<TResult, TContinuationResult> continuation, final Executor executor) {
        boolean completed;
        final TaskCompletionSource tcs = new TaskCompletionSource();
        Object object = this.lock;
        synchronized (object) {
            completed = this.isCompleted();
            if (!completed) {
                this.continuations.add(new Continuation<TResult, Void>(){

                    @Override
                    public Void then(Task<TResult> task) {
                        Task.completeImmediately(tcs, continuation, task, executor);
                        return null;
                    }
                });
            }
        }
        if (completed) {
            Task.completeImmediately(tcs, continuation, this, executor);
        }
        return tcs.getTask();
    }

    public <TContinuationResult> Task<TContinuationResult> continueWith(Continuation<TResult, TContinuationResult> continuation) {
        return this.continueWith(continuation, IMMEDIATE_EXECUTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <TContinuationResult> Task<TContinuationResult> continueWithTask(final Continuation<TResult, Task<TContinuationResult>> continuation, final Executor executor) {
        boolean completed;
        final TaskCompletionSource tcs = new TaskCompletionSource();
        Object object = this.lock;
        synchronized (object) {
            completed = this.isCompleted();
            if (!completed) {
                this.continuations.add(new Continuation<TResult, Void>(){

                    @Override
                    public Void then(Task<TResult> task) {
                        Task.completeAfterTask(tcs, continuation, task, executor);
                        return null;
                    }
                });
            }
        }
        if (completed) {
            Task.completeAfterTask(tcs, continuation, this, executor);
        }
        return tcs.getTask();
    }

    public <TContinuationResult> Task<TContinuationResult> continueWithTask(Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.continueWithTask(continuation, IMMEDIATE_EXECUTOR);
    }

    public <TContinuationResult> Task<TContinuationResult> onSuccess(final Continuation<TResult, TContinuationResult> continuation, Executor executor) {
        return this.continueWithTask(new Continuation<TResult, Task<TContinuationResult>>(){

            @Override
            public Task<TContinuationResult> then(Task<TResult> task) {
                if (task.isFaulted()) {
                    return Task.forError(task.getError());
                }
                if (task.isCancelled()) {
                    return Task.cancelled();
                }
                return task.continueWith(continuation);
            }
        }, executor);
    }

    public <TContinuationResult> Task<TContinuationResult> onSuccess(Continuation<TResult, TContinuationResult> continuation) {
        return this.onSuccess(continuation, IMMEDIATE_EXECUTOR);
    }

    public <TContinuationResult> Task<TContinuationResult> onSuccessTask(final Continuation<TResult, Task<TContinuationResult>> continuation, Executor executor) {
        return this.continueWithTask(new Continuation<TResult, Task<TContinuationResult>>(){

            @Override
            public Task<TContinuationResult> then(Task<TResult> task) {
                if (task.isFaulted()) {
                    return Task.forError(task.getError());
                }
                if (task.isCancelled()) {
                    return Task.cancelled();
                }
                return task.continueWithTask(continuation);
            }
        }, executor);
    }

    public <TContinuationResult> Task<TContinuationResult> onSuccessTask(Continuation<TResult, Task<TContinuationResult>> continuation) {
        return this.onSuccessTask(continuation, IMMEDIATE_EXECUTOR);
    }

    private static <TContinuationResult, TResult> void completeImmediately(final TaskCompletionSource<TContinuationResult> tcs, final Continuation<TResult, TContinuationResult> continuation, final Task<TResult> task, Executor executor) {
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Object result = continuation.then(task);
                        tcs.setResult(result);
                    }
                    catch (CancellationException e) {
                        tcs.setCancelled();
                    }
                    catch (Exception e) {
                        tcs.setError(e);
                    }
                }
            });
        }
        catch (Exception e) {
            tcs.setError(new ExecutorException(e));
        }
    }

    private static <TContinuationResult, TResult> void completeAfterTask(final TaskCompletionSource<TContinuationResult> tcs, final Continuation<TResult, Task<TContinuationResult>> continuation, final Task<TResult> task, Executor executor) {
        try {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        Task result = (Task)continuation.then(task);
                        if (result == null) {
                            tcs.setResult(null);
                        } else {
                            result.continueWith(new Continuation<TContinuationResult, Void>(){

                                @Override
                                public Void then(Task<TContinuationResult> task) {
                                    if (task.isCancelled()) {
                                        tcs.setCancelled();
                                    } else if (task.isFaulted()) {
                                        tcs.setError(task.getError());
                                    } else {
                                        tcs.setResult(task.getResult());
                                    }
                                    return null;
                                }
                            });
                        }
                    }
                    catch (CancellationException e) {
                        tcs.setCancelled();
                    }
                    catch (Exception e) {
                        tcs.setError(e);
                    }
                }
            });
        }
        catch (Exception e) {
            tcs.setError(new ExecutorException(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runContinuations() {
        Object object = this.lock;
        synchronized (object) {
            for (Continuation<TResult, Void> continuation : this.continuations) {
                try {
                    continuation.then(this);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.continuations = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean trySetCancelled() {
        Object object = this.lock;
        synchronized (object) {
            if (this.complete) {
                return false;
            }
            this.complete = true;
            this.cancelled = true;
            this.lock.notifyAll();
            this.runContinuations();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean trySetResult(TResult result) {
        Object object = this.lock;
        synchronized (object) {
            if (this.complete) {
                return false;
            }
            this.complete = true;
            this.result = result;
            this.lock.notifyAll();
            this.runContinuations();
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean trySetError(Exception error) {
        Object object = this.lock;
        synchronized (object) {
            if (this.complete) {
                return false;
            }
            this.complete = true;
            this.error = error;
            this.errorHasBeenObserved = false;
            this.lock.notifyAll();
            this.runContinuations();
            if (!this.errorHasBeenObserved && Task.getUnobservedExceptionHandler() != null) {
                this.unobservedErrorNotifier = new UnobservedErrorNotifier(this);
            }
            return true;
        }
    }

    static {
        TASK_NULL = new Task<Object>(null);
        TASK_TRUE = new Task<Boolean>(Boolean.valueOf(true));
        TASK_FALSE = new Task<Boolean>(Boolean.valueOf(false));
        TASK_CANCELLED = new Task(true);
    }

    public static interface UnobservedExceptionHandler {
        public void unobservedException(Task<?> var1, UnobservedTaskException var2);
    }
}

