/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.websocket;

import com.facebook.common.logging.FLog;
import com.facebook.fbreact.specs.NativeWebSocketModuleSpec;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.bridge.ReadableType;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.module.annotations.ReactModule;
import com.facebook.react.modules.network.CustomClientBuilder;
import com.facebook.react.modules.network.ForwardingCookieHandler;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.WebSocket;
import okhttp3.WebSocketListener;
import okio.ByteString;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ReactModule(name="WebSocketModule")
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 12\u00020\u0001:\u000201B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0018\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u000bJ,\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0019\u001a\u00020\u00122\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\"\u0010 \u001a\u00020\u000f2\u0006\u0010!\u001a\u00020\u001f2\b\u0010\"\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010#\u001a\u00020\u000f2\u0006\u0010$\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0018\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u0016\u0010%\u001a\u00020\u000f2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0016\u001a\u00020\bJ\u0010\u0010)\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016J\u001a\u0010*\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\b2\b\u0010$\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u00122\u0006\u0010,\u001a\u00020\u0012H\u0002J\u0010\u0010-\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u001fH\u0016R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/facebook/react/modules/websocket/WebSocketModule;", "Lcom/facebook/fbreact/specs/NativeWebSocketModuleSpec;", "context", "Lcom/facebook/react/bridge/ReactApplicationContext;", "<init>", "(Lcom/facebook/react/bridge/ReactApplicationContext;)V", "webSocketConnections", "", "", "Lokhttp3/WebSocket;", "contentHandlers", "Lcom/facebook/react/modules/websocket/WebSocketModule$ContentHandler;", "cookieHandler", "Lcom/facebook/react/modules/network/ForwardingCookieHandler;", "invalidate", "", "sendEvent", "eventName", "", "params", "Lcom/facebook/react/bridge/WritableMap;", "setContentHandler", "id", "contentHandler", "connect", "url", "protocols", "Lcom/facebook/react/bridge/ReadableArray;", "options", "Lcom/facebook/react/bridge/ReadableMap;", "socketID", "", "close", "code", "reason", "send", "message", "sendBinary", "base64String", "byteString", "Lokio/ByteString;", "ping", "notifyWebSocketFailed", "getCookie", "uri", "addListener", "removeListeners", "count", "ContentHandler", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nWebSocketModule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WebSocketModule.kt\ncom/facebook/react/modules/websocket/WebSocketModule\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,398:1\n1#2:399\n*E\n"})
public final class WebSocketModule
extends NativeWebSocketModuleSpec {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<Integer, WebSocket> webSocketConnections;
    @NotNull
    private final Map<Integer, ContentHandler> contentHandlers;
    @NotNull
    private final ForwardingCookieHandler cookieHandler;
    @NotNull
    public static final String NAME = "WebSocketModule";
    @Nullable
    private static CustomClientBuilder customClientBuilder;

    public WebSocketModule(@NotNull ReactApplicationContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        super(context);
        this.webSocketConnections = new ConcurrentHashMap();
        this.contentHandlers = new ConcurrentHashMap();
        this.cookieHandler = new ForwardingCookieHandler();
    }

    @Override
    public void invalidate() {
        for (WebSocket socket : this.webSocketConnections.values()) {
            socket.close(1001, null);
        }
        this.webSocketConnections.clear();
        this.contentHandlers.clear();
    }

    private final void sendEvent(String eventName, WritableMap params) {
        ReactApplicationContext reactAppContext = this.getReactApplicationContext();
        if (reactAppContext.hasActiveReactInstance()) {
            reactAppContext.emitDeviceEvent(eventName, params);
        }
    }

    public final void setContentHandler(int id2, @Nullable ContentHandler contentHandler) {
        if (contentHandler != null) {
            Integer n = id2;
            this.contentHandlers.put(n, contentHandler);
        } else {
            this.contentHandlers.remove(id2);
        }
    }

    @Override
    public void connect(@NotNull String url, @Nullable ReadableArray protocols, @Nullable ReadableMap options, double socketID) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        int id2 = (int)socketID;
        OkHttpClient.Builder okHttpBuilder = new OkHttpClient.Builder().connectTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).readTimeout(0L, TimeUnit.MINUTES);
        WebSocketModule.Companion.applyCustomBuilder(okHttpBuilder);
        OkHttpClient client = okHttpBuilder.build();
        Request.Builder builder = new Request.Builder().tag((Object)id2).url(url);
        String cookie = this.getCookie(url);
        if (cookie != null) {
            builder.addHeader("Cookie", cookie);
        }
        boolean hasOriginHeader = false;
        ReadableMap readableMap = options;
        boolean bl = readableMap != null ? readableMap.hasKey("headers") : false;
        if (bl && options.getType("headers") == ReadableType.Map) {
            ReadableMap readableMap2 = options.getMap("headers");
            if (readableMap2 == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            ReadableMap headers = readableMap2;
            ReadableMapKeySetIterator iterator2 = headers.keySetIterator();
            while (iterator2.hasNextKey()) {
                String key = iterator2.nextKey();
                if (ReadableType.String == headers.getType(key)) {
                    if (StringsKt.equals((String)key, (String)"origin", (boolean)true)) {
                        hasOriginHeader = true;
                    }
                    Request.Builder builder2 = builder;
                    String string3 = key;
                    String string4 = headers.getString(key);
                    if (string4 == null) {
                        String string5 = string3;
                        Request.Builder builder3 = builder2;
                        boolean bl2 = false;
                        String string6 = "value for name " + key + " == null";
                        Request.Builder builder4 = builder3;
                        String string7 = string5;
                        String string8 = string6;
                        throw new IllegalStateException(string8.toString());
                    }
                    builder2.addHeader(string3, string4);
                    continue;
                }
                FLog.w((String)"ReactNative", (String)("Ignoring: requested " + key + ", value not a string"));
            }
        }
        if (!hasOriginHeader) {
            builder.addHeader("origin", WebSocketModule.Companion.getDefaultOrigin(url));
        }
        if (protocols != null && protocols.size() > 0) {
            StringBuilder protocolsValue = new StringBuilder("");
            int n = protocols.size();
            for (int i = 0; i < n; ++i) {
                String string9 = protocols.getString(i);
                String v = string9 != null ? ((Object)StringsKt.trim((CharSequence)string9)).toString() : null;
                CharSequence charSequence = v;
                if (charSequence == null || charSequence.length() == 0 || StringsKt.contains$default((CharSequence)v, (CharSequence)",", (boolean)false, (int)2, null)) continue;
                protocolsValue.append(v);
                protocolsValue.append(",");
            }
            if (protocolsValue.length() > 0) {
                protocolsValue.replace(protocolsValue.length() - 1, protocolsValue.length(), "");
                String string10 = protocolsValue.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"toString(...)");
                builder.addHeader("Sec-WebSocket-Protocol", string10);
            }
        }
        client.newWebSocket(builder.build(), new WebSocketListener(this, id2){
            final /* synthetic */ WebSocketModule this$0;
            final /* synthetic */ int $id;
            {
                this.this$0 = $receiver;
                this.$id = $id;
            }

            public void onOpen(WebSocket webSocket, Response response) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                WebSocketModule.access$getWebSocketConnections$p(this.this$0).put(this.$id, webSocket);
                WritableMap params = Arguments.createMap();
                params.putInt("id", this.$id);
                params.putString("protocol", response.header("Sec-WebSocket-Protocol", ""));
                Intrinsics.checkNotNull((Object)params);
                WebSocketModule.access$sendEvent(this.this$0, "websocketOpen", params);
            }

            public void onClosing(WebSocket websocket, int code, String reason) {
                Intrinsics.checkNotNullParameter((Object)websocket, (String)"websocket");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                websocket.close(code, reason);
            }

            public void onClosed(WebSocket webSocket, int code, String reason) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                WritableMap params = Arguments.createMap();
                params.putInt("id", this.$id);
                params.putInt("code", code);
                params.putString("reason", reason);
                Intrinsics.checkNotNull((Object)params);
                WebSocketModule.access$sendEvent(this.this$0, "websocketClosed", params);
            }

            public void onFailure(WebSocket webSocket, Throwable t, Response response) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                WebSocketModule.access$notifyWebSocketFailed(this.this$0, this.$id, t.getMessage());
            }

            public void onMessage(WebSocket webSocket, String text) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                WritableMap params = Arguments.createMap();
                params.putInt("id", this.$id);
                params.putString("type", "text");
                ContentHandler contentHandler = (ContentHandler)WebSocketModule.access$getContentHandlers$p(this.this$0).get(this.$id);
                if (contentHandler != null) {
                    Intrinsics.checkNotNull((Object)params);
                    contentHandler.onMessage(text, params);
                } else {
                    params.putString("data", text);
                }
                Intrinsics.checkNotNull((Object)params);
                WebSocketModule.access$sendEvent(this.this$0, "websocketMessage", params);
            }

            public void onMessage(WebSocket webSocket, ByteString bytes) {
                Intrinsics.checkNotNullParameter((Object)webSocket, (String)"webSocket");
                Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
                WritableMap params = Arguments.createMap();
                params.putInt("id", this.$id);
                params.putString("type", "binary");
                ContentHandler contentHandler = (ContentHandler)WebSocketModule.access$getContentHandlers$p(this.this$0).get(this.$id);
                if (contentHandler != null) {
                    Intrinsics.checkNotNull((Object)params);
                    contentHandler.onMessage(bytes, params);
                } else {
                    String text = bytes.base64();
                    params.putString("data", text);
                }
                Intrinsics.checkNotNull((Object)params);
                WebSocketModule.access$sendEvent(this.this$0, "websocketMessage", params);
            }
        });
        client.-deprecated_dispatcher().-deprecated_executorService().shutdown();
    }

    @Override
    public void close(double code, @Nullable String reason, double socketID) {
        int id2 = (int)socketID;
        WebSocket client = this.webSocketConnections.get(id2);
        if (client == null) {
            return;
        }
        try {
            client.close((int)code, reason);
            this.webSocketConnections.remove(id2);
            this.contentHandlers.remove(id2);
        }
        catch (Exception e) {
            FLog.e((String)"ReactNative", (String)("Could not close WebSocket connection for id " + id2), (Throwable)e);
        }
    }

    @Override
    public void send(@NotNull String message, double socketID) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        int id2 = (int)socketID;
        WebSocket client = this.webSocketConnections.get(id2);
        if (client == null) {
            WritableMap writableMap = Arguments.createMap();
            Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
            WritableMap params = writableMap;
            params.putInt("id", id2);
            params.putString("message", "client is null");
            this.sendEvent("websocketFailed", params);
            params = Arguments.createMap();
            params.putInt("id", id2);
            params.putInt("code", 0);
            params.putString("reason", "client is null");
            this.sendEvent("websocketClosed", params);
            this.webSocketConnections.remove(id2);
            this.contentHandlers.remove(id2);
            return;
        }
        try {
            client.send(message);
        }
        catch (Exception e) {
            this.notifyWebSocketFailed(id2, e.getMessage());
        }
    }

    @Override
    public void sendBinary(@NotNull String base64String, double socketID) {
        Intrinsics.checkNotNullParameter((Object)base64String, (String)"base64String");
        int id2 = (int)socketID;
        WebSocket client = this.webSocketConnections.get(id2);
        if (client == null) {
            WritableMap writableMap = Arguments.createMap();
            Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
            WritableMap params = writableMap;
            params.putInt("id", id2);
            params.putString("message", "client is null");
            this.sendEvent("websocketFailed", params);
            params = Arguments.createMap();
            params.putInt("id", id2);
            params.putInt("code", 0);
            params.putString("reason", "client is null");
            this.sendEvent("websocketClosed", params);
            this.webSocketConnections.remove(id2);
            this.contentHandlers.remove(id2);
            return;
        }
        try {
            ByteString byteString = ByteString.Companion.-deprecated_decodeBase64(base64String);
            if (byteString == null) {
                boolean bl = false;
                String string2 = "bytes == null";
                throw new IllegalStateException(string2.toString());
            }
            ByteString decodedString = byteString;
            client.send(decodedString);
        }
        catch (Exception e) {
            this.notifyWebSocketFailed(id2, e.getMessage());
        }
    }

    public final void sendBinary(@NotNull ByteString byteString, int id2) {
        Intrinsics.checkNotNullParameter((Object)byteString, (String)"byteString");
        WebSocket client = this.webSocketConnections.get(id2);
        if (client == null) {
            WritableMap writableMap = Arguments.createMap();
            Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
            WritableMap params = writableMap;
            params.putInt("id", id2);
            params.putString("message", "client is null");
            this.sendEvent("websocketFailed", params);
            params = Arguments.createMap();
            params.putInt("id", id2);
            params.putInt("code", 0);
            params.putString("reason", "client is null");
            this.sendEvent("websocketClosed", params);
            this.webSocketConnections.remove(id2);
            this.contentHandlers.remove(id2);
            return;
        }
        try {
            client.send(byteString);
        }
        catch (Exception e) {
            this.notifyWebSocketFailed(id2, e.getMessage());
        }
    }

    @Override
    public void ping(double socketID) {
        int id2 = (int)socketID;
        WebSocket client = this.webSocketConnections.get(id2);
        if (client == null) {
            WritableMap writableMap = Arguments.createMap();
            Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
            WritableMap params = writableMap;
            params.putInt("id", id2);
            params.putString("message", "client is null");
            this.sendEvent("websocketFailed", params);
            params = Arguments.createMap();
            params.putInt("id", id2);
            params.putInt("code", 0);
            params.putString("reason", "client is null");
            this.sendEvent("websocketClosed", params);
            this.webSocketConnections.remove(id2);
            this.contentHandlers.remove(id2);
            return;
        }
        try {
            client.send(ByteString.EMPTY);
        }
        catch (Exception e) {
            this.notifyWebSocketFailed(id2, e.getMessage());
        }
    }

    private final void notifyWebSocketFailed(int id2, String message) {
        WritableMap params = Arguments.createMap();
        params.putInt("id", id2);
        params.putString("message", message);
        Intrinsics.checkNotNull((Object)params);
        this.sendEvent("websocketFailed", params);
    }

    private final String getCookie(String uri) {
        try {
            URI origin = new URI(WebSocketModule.Companion.getDefaultOrigin(uri));
            Map<String, List<String>> cookieMap = this.cookieHandler.get(origin, new HashMap());
            List<String> cookieList = cookieMap.get("Cookie");
            Collection collection = cookieList;
            if (collection == null || collection.isEmpty()) {
                return null;
            }
            return cookieList.get(0);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to get cookie from " + uri);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to get cookie from " + uri);
        }
    }

    @Override
    public void addListener(@NotNull String eventName) {
        Intrinsics.checkNotNullParameter((Object)eventName, (String)"eventName");
    }

    @Override
    public void removeListeners(double count) {
    }

    @JvmStatic
    public static final void setCustomClientBuilder(@Nullable CustomClientBuilder ccb) {
        Companion.setCustomClientBuilder(ccb);
    }

    public static final /* synthetic */ Map access$getWebSocketConnections$p(WebSocketModule $this) {
        return $this.webSocketConnections;
    }

    public static final /* synthetic */ void access$sendEvent(WebSocketModule $this, String eventName, WritableMap params) {
        $this.sendEvent(eventName, params);
    }

    public static final /* synthetic */ void access$notifyWebSocketFailed(WebSocketModule $this, int id2, String message) {
        $this.notifyWebSocketFailed(id2, message);
    }

    public static final /* synthetic */ Map access$getContentHandlers$p(WebSocketModule $this) {
        return $this.contentHandlers;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0007H\u0007J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/facebook/react/modules/websocket/WebSocketModule$Companion;", "", "<init>", "()V", "NAME", "", "customClientBuilder", "Lcom/facebook/react/modules/network/CustomClientBuilder;", "setCustomClientBuilder", "", "ccb", "applyCustomBuilder", "builder", "Lokhttp3/OkHttpClient$Builder;", "getDefaultOrigin", "uri", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void setCustomClientBuilder(@Nullable CustomClientBuilder ccb) {
            WebSocketModule.customClientBuilder = ccb;
        }

        private final void applyCustomBuilder(OkHttpClient.Builder builder) {
            block0: {
                CustomClientBuilder customClientBuilder = customClientBuilder;
                if (customClientBuilder == null) break block0;
                customClientBuilder.apply(builder);
            }
        }

        /*
         * Unable to fully structure code
         */
        private final String getDefaultOrigin(String uri) {
            try {
                requestURI = new URI(uri);
                var4_3 = requestURI.getScheme();
                if (var4_3 == null) ** GOTO lbl-1000
                tmp = -1;
                switch (var4_3.hashCode()) {
                    case 118039: {
                        if (var4_3.equals("wss")) {
                            tmp = 1;
                        }
                        break;
                    }
                    case 3213448: {
                        if (var4_3.equals("http")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 99617003: {
                        if (var4_3.equals("https")) {
                            tmp = 2;
                        }
                        break;
                    }
                    case 3804: {
                        if (var4_3.equals("ws")) {
                            tmp = 3;
                        }
                        break;
                    }
                }
                switch (tmp) {
                    case 1: {
                        v0 = "https";
                        break;
                    }
                    case 3: {
                        v0 = "http";
                        break;
                    }
                    case 2: {
                        v0 = requestURI.getScheme();
                        break;
                    }
                    default: lbl-1000:
                    // 2 sources

                    {
                        v0 = scheme = "";
                    }
                }
                if (requestURI.getPort() != -1) {
                    var5_6 = "%s://%s:%s";
                    var6_7 = new Object[]{scheme, requestURI.getHost(), requestURI.getPort()};
                    v1 = String.format(var5_6, Arrays.copyOf(var6_7, var6_7.length));
                    v2 = v1;
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"format(...)");
                } else {
                    var5_6 = "%s://%s";
                    var6_7 = new Object[]{scheme, requestURI.getHost()};
                    v3 = String.format(var5_6, Arrays.copyOf(var6_7, var6_7.length));
                    v2 = v3;
                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"format(...)");
                }
                defaultOrigin = v2;
                return defaultOrigin;
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("Unable to set " + uri + " as default origin header");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/modules/websocket/WebSocketModule$ContentHandler;", "", "onMessage", "", "text", "", "params", "Lcom/facebook/react/bridge/WritableMap;", "byteString", "Lokio/ByteString;", "ReactAndroid_debug"})
    public static interface ContentHandler {
        public void onMessage(@NotNull String var1, @NotNull WritableMap var2);

        public void onMessage(@NotNull ByteString var1, @NotNull WritableMap var2);
    }
}

