/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common.assets;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;
import android.os.Build;
import android.util.SparseArray;
import androidx.core.content.res.ResourcesCompat;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u001f2\u00020\u0001:\u0003\u001e\u001f B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ(\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ(\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ \u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fJ\u001e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u001a\u001a\u00020\rJ\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0019\u001a\u00020\u00062\b\u0010\u001b\u001a\u0004\u0018\u00010\tJ \u0010\u001c\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\b\u0010\u001d\u001a\u0004\u0018\u00010\tR\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\t0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/facebook/react/common/assets/ReactFontManager;", "", "<init>", "()V", "fontCache", "", "", "Lcom/facebook/react/common/assets/ReactFontManager$AssetFontFamily;", "customTypefaceCache", "Landroid/graphics/Typeface;", "getTypeface", "fontFamilyName", "style", "", "assetManager", "Landroid/content/res/AssetManager;", "weight", "italic", "", "typefaceStyle", "Lcom/facebook/react/common/assets/ReactFontManager$TypefaceStyle;", "addCustomFont", "", "context", "Landroid/content/Context;", "fontFamily", "fontId", "font", "setTypeface", "typeface", "TypefaceStyle", "Companion", "AssetFontFamily", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nReactFontManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactFontManager.kt\ncom/facebook/react/common/assets/ReactFontManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,198:1\n381#2,7:199\n381#2,7:206\n*S KotlinDebug\n*F\n+ 1 ReactFontManager.kt\ncom/facebook/react/common/assets/ReactFontManager\n*L\n67#1:199,7\n106#1:206,7\n*E\n"})
public final class ReactFontManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, AssetFontFamily> fontCache = new LinkedHashMap();
    @NotNull
    private final Map<String, Typeface> customTypefaceCache = new LinkedHashMap();
    @NotNull
    private static final String[] EXTENSIONS;
    @NotNull
    private static final String[] FILE_EXTENSIONS;
    @NotNull
    private static final String FONTS_ASSET_PATH = "fonts/";
    @NotNull
    private static final ReactFontManager _instance;

    @NotNull
    public final Typeface getTypeface(@NotNull String fontFamilyName, int style, @Nullable AssetManager assetManager) {
        Intrinsics.checkNotNullParameter((Object)fontFamilyName, (String)"fontFamilyName");
        return this.getTypeface(fontFamilyName, new TypefaceStyle(style, 0, 2, null), assetManager);
    }

    @NotNull
    public final Typeface getTypeface(@NotNull String fontFamilyName, int weight, boolean italic, @Nullable AssetManager assetManager) {
        Intrinsics.checkNotNullParameter((Object)fontFamilyName, (String)"fontFamilyName");
        return this.getTypeface(fontFamilyName, new TypefaceStyle(weight, italic), assetManager);
    }

    @NotNull
    public final Typeface getTypeface(@NotNull String fontFamilyName, int style, int weight, @Nullable AssetManager assetManager) {
        Intrinsics.checkNotNullParameter((Object)fontFamilyName, (String)"fontFamilyName");
        return this.getTypeface(fontFamilyName, new TypefaceStyle(style, weight), assetManager);
    }

    @NotNull
    public final Typeface getTypeface(@NotNull String fontFamilyName, @NotNull TypefaceStyle typefaceStyle, @Nullable AssetManager assetManager) {
        int style;
        AssetFontFamily assetFontFamily;
        Typeface typeface;
        AssetFontFamily assetFontFamily2;
        Intrinsics.checkNotNullParameter((Object)fontFamilyName, (String)"fontFamilyName");
        Intrinsics.checkNotNullParameter((Object)typefaceStyle, (String)"typefaceStyle");
        if (this.customTypefaceCache.containsKey(fontFamilyName)) {
            return typefaceStyle.apply(this.customTypefaceCache.get(fontFamilyName));
        }
        Map<String, AssetFontFamily> $this$getOrPut$iv = this.fontCache;
        boolean $i$f$getOrPut = false;
        AssetFontFamily value$iv = $this$getOrPut$iv.get(fontFamilyName);
        if (value$iv == null) {
            boolean bl = false;
            AssetFontFamily answer$iv = new AssetFontFamily();
            $this$getOrPut$iv.put(fontFamilyName, answer$iv);
            assetFontFamily2 = answer$iv;
        } else {
            assetFontFamily2 = value$iv;
        }
        if ((typeface = (assetFontFamily = assetFontFamily2).getTypefaceForStyle(style = typefaceStyle.getNearestStyle())) == null) {
            Typeface typeface2;
            Typeface it = typeface2 = ReactFontManager.Companion.createAssetTypeface(fontFamilyName, style, assetManager);
            boolean bl = false;
            assetFontFamily.setTypefaceForStyle(style, it);
            typeface = typeface2;
        }
        return typeface;
    }

    public final void addCustomFont(@NotNull Context context, @NotNull String fontFamily, int fontId) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"fontFamily");
        this.addCustomFont(fontFamily, ResourcesCompat.getFont((Context)context, (int)fontId));
    }

    public final void addCustomFont(@NotNull String fontFamily, @Nullable Typeface font) {
        Intrinsics.checkNotNullParameter((Object)fontFamily, (String)"fontFamily");
        if (font != null) {
            this.customTypefaceCache.put(fontFamily, font);
        }
    }

    public final void setTypeface(@NotNull String fontFamilyName, int style, @Nullable Typeface typeface) {
        Intrinsics.checkNotNullParameter((Object)fontFamilyName, (String)"fontFamilyName");
        if (typeface != null) {
            AssetFontFamily assetFontFamily;
            Map<String, AssetFontFamily> $this$getOrPut$iv = this.fontCache;
            boolean $i$f$getOrPut = false;
            AssetFontFamily value$iv = $this$getOrPut$iv.get(fontFamilyName);
            if (value$iv == null) {
                boolean bl = false;
                AssetFontFamily answer$iv = new AssetFontFamily();
                $this$getOrPut$iv.put(fontFamilyName, answer$iv);
                assetFontFamily = answer$iv;
            } else {
                assetFontFamily = value$iv;
            }
            assetFontFamily.setTypefaceForStyle(style, typeface);
        }
    }

    @JvmStatic
    @NotNull
    public static final ReactFontManager getInstance() {
        return Companion.getInstance();
    }

    static {
        String[] stringArray = new String[]{"", "_bold", "_italic", "_bold_italic"};
        EXTENSIONS = stringArray;
        stringArray = new String[]{".ttf", ".otf"};
        FILE_EXTENSIONS = stringArray;
        _instance = new ReactFontManager();
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\b\u0010\f\u001a\u0004\u0018\u00010\u0006R\u0016\u0010\u0004\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/react/common/assets/ReactFontManager$AssetFontFamily;", "", "<init>", "()V", "typefaceSparseArray", "Landroid/util/SparseArray;", "Landroid/graphics/Typeface;", "getTypefaceForStyle", "style", "", "setTypefaceForStyle", "", "typeface", "ReactAndroid_debug"})
    private static final class AssetFontFamily {
        @NotNull
        private final SparseArray<Typeface> typefaceSparseArray = new SparseArray(4);

        @Nullable
        public final Typeface getTypefaceForStyle(int style) {
            return (Typeface)this.typefaceSparseArray.get(style);
        }

        public final void setTypefaceForStyle(int style, @Nullable Typeface typeface) {
            this.typefaceSparseArray.put(style, (Object)typeface);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\f\u001a\u00020\u000bH\u0007J\"\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\t\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/facebook/react/common/assets/ReactFontManager$Companion;", "", "<init>", "()V", "EXTENSIONS", "", "", "[Ljava/lang/String;", "FILE_EXTENSIONS", "FONTS_ASSET_PATH", "_instance", "Lcom/facebook/react/common/assets/ReactFontManager;", "getInstance", "createAssetTypeface", "Landroid/graphics/Typeface;", "fontFamilyName", "style", "", "assetManager", "Landroid/content/res/AssetManager;", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ReactFontManager getInstance() {
            return _instance;
        }

        private final Typeface createAssetTypeface(String fontFamilyName, int style, AssetManager assetManager) {
            if (assetManager != null) {
                String extension = EXTENSIONS[style];
                for (String fileExtension : FILE_EXTENSIONS) {
                    String fileName = ReactFontManager.FONTS_ASSET_PATH + fontFamilyName + extension + fileExtension;
                    try {
                        Typeface typeface = Typeface.createFromAsset((AssetManager)assetManager, (String)fileName);
                        Intrinsics.checkNotNullExpressionValue((Object)typeface, (String)"createFromAsset(...)");
                        return typeface;
                    }
                    catch (RuntimeException e) {
                    }
                }
            }
            Typeface typeface = Typeface.create((String)fontFamilyName, (int)style);
            Intrinsics.checkNotNullExpressionValue((Object)typeface, (String)"create(...)");
            return typeface;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0019\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u001b\b\u0017\u0012\u0006\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\tJ\u0010\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/facebook/react/common/assets/ReactFontManager$TypefaceStyle;", "", "weight", "", "italic", "", "<init>", "(IZ)V", "style", "(II)V", "nearestStyle", "getNearestStyle", "()I", "apply", "Landroid/graphics/Typeface;", "typeface", "Companion", "ReactAndroid_debug"})
    public static final class TypefaceStyle {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final boolean italic;
        private final int weight;
        public static final int BOLD = 700;
        public static final int NORMAL = 400;

        public TypefaceStyle(int weight, boolean italic) {
            this.italic = italic;
            this.weight = weight == -1 ? 400 : weight;
        }

        @JvmOverloads
        public TypefaceStyle(int style, int weight) {
            int fixedStyle = style == -1 ? 0 : style;
            boolean bl = this.italic = (fixedStyle & 2) != 0;
            this.weight = weight == -1 ? ((fixedStyle & 1) != 0 ? 700 : 400) : weight;
        }

        public /* synthetic */ TypefaceStyle(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n2 = -1;
            }
            this(n, n2);
        }

        public final int getNearestStyle() {
            return this.weight < 700 ? (this.italic ? 2 : 0) : (this.italic ? 3 : 1);
        }

        @NotNull
        public final Typeface apply(@Nullable Typeface typeface) {
            Typeface typeface2;
            if (Build.VERSION.SDK_INT < 28) {
                Typeface typeface3 = Typeface.create((Typeface)typeface, (int)this.getNearestStyle());
                Intrinsics.checkNotNull((Object)typeface3);
                typeface2 = typeface3;
            } else {
                Typeface typeface4 = Typeface.create((Typeface)typeface, (int)this.weight, (boolean)this.italic);
                Intrinsics.checkNotNull((Object)typeface4);
                typeface2 = typeface4;
            }
            return typeface2;
        }

        @JvmOverloads
        public TypefaceStyle(int style) {
            this(style, 0, 2, null);
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/facebook/react/common/assets/ReactFontManager$TypefaceStyle$Companion;", "", "<init>", "()V", "BOLD", "", "NORMAL", "ReactAndroid_debug"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

