/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge.queue;

import android.os.Looper;
import android.os.Process;
import android.os.SystemClock;
import android.util.Pair;
import com.facebook.common.logging.FLog;
import com.facebook.proguard.annotations.DoNotStripAny;
import com.facebook.react.bridge.AssertionException;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.react.bridge.queue.MessageQueueThreadHandler;
import com.facebook.react.bridge.queue.MessageQueueThreadPerfStats;
import com.facebook.react.bridge.queue.MessageQueueThreadSpec;
import com.facebook.react.bridge.queue.QueueThreadExceptionHandler;
import com.facebook.react.common.futures.SimpleSettableFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 %2\u00020\u0001:\u0001%B-\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\"\u0010\u0018\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u0019\"\u0004\b\u0000\u0010\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u001a0\u001cH\u0016J\b\u0010\u001d\u001a\u00020\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0003H\u0016J\b\u0010!\u001a\u00020\u001fH\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\tH\u0016J\b\u0010#\u001a\u00020\u001fH\u0016J\b\u0010$\u001a\u00020\u0014H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/facebook/react/bridge/queue/MessageQueueThreadImpl;", "Lcom/facebook/react/bridge/queue/MessageQueueThread;", "name", "", "looper", "Landroid/os/Looper;", "exceptionHandler", "Lcom/facebook/react/bridge/queue/QueueThreadExceptionHandler;", "stats", "Lcom/facebook/react/bridge/queue/MessageQueueThreadPerfStats;", "<init>", "(Ljava/lang/String;Landroid/os/Looper;Lcom/facebook/react/bridge/queue/QueueThreadExceptionHandler;Lcom/facebook/react/bridge/queue/MessageQueueThreadPerfStats;)V", "getName", "()Ljava/lang/String;", "getLooper", "()Landroid/os/Looper;", "handler", "Lcom/facebook/react/bridge/queue/MessageQueueThreadHandler;", "assertionErrorMessage", "isFinished", "", "runOnQueue", "runnable", "Ljava/lang/Runnable;", "callOnQueue", "Ljava/util/concurrent/Future;", "T", "callable", "Ljava/util/concurrent/Callable;", "isOnThread", "assertIsOnThread", "", "message", "quitSynchronous", "getPerfStats", "resetPerfStats", "isIdle", "Companion", "ReactAndroid_debug"})
@DoNotStripAny
public final class MessageQueueThreadImpl
implements MessageQueueThread {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final Looper looper;
    @Nullable
    private final MessageQueueThreadPerfStats stats;
    @NotNull
    private final MessageQueueThreadHandler handler;
    @NotNull
    private final String assertionErrorMessage;
    private volatile boolean isFinished;

    private MessageQueueThreadImpl(String name, Looper looper, QueueThreadExceptionHandler exceptionHandler, MessageQueueThreadPerfStats stats) {
        this.name = name;
        this.looper = looper;
        this.stats = stats;
        this.handler = new MessageQueueThreadHandler(this.looper, exceptionHandler);
        this.assertionErrorMessage = "Expected to be called from the '" + this.name + "' thread!";
    }

    /* synthetic */ MessageQueueThreadImpl(String string, Looper looper, QueueThreadExceptionHandler queueThreadExceptionHandler, MessageQueueThreadPerfStats messageQueueThreadPerfStats, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            messageQueueThreadPerfStats = null;
        }
        this(string, looper, queueThreadExceptionHandler, messageQueueThreadPerfStats);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Looper getLooper() {
        return this.looper;
    }

    @Override
    public boolean runOnQueue(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        if (this.isFinished) {
            FLog.w((String)"ReactNative", (String)("Tried to enqueue runnable on already finished thread: '" + this.name + "... dropping Runnable."));
            return false;
        }
        this.handler.post(runnable);
        return true;
    }

    @Override
    @NotNull
    public <T> Future<T> callOnQueue(@NotNull Callable<T> callable) {
        Intrinsics.checkNotNullParameter(callable, (String)"callable");
        SimpleSettableFuture future = new SimpleSettableFuture();
        this.runOnQueue(() -> MessageQueueThreadImpl.callOnQueue$lambda$0(future, callable));
        return future;
    }

    @Override
    public boolean isOnThread() {
        return this.looper.getThread() == Thread.currentThread();
    }

    @Override
    public void assertIsOnThread() throws AssertionException {
        SoftAssertions.assertCondition(this.isOnThread(), this.assertionErrorMessage);
    }

    @Override
    public void assertIsOnThread(@NotNull String message) throws AssertionException {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        boolean bl = this.isOnThread();
        String string = this.assertionErrorMessage + " " + message;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        SoftAssertions.assertCondition(bl, string);
    }

    @Override
    public void quitSynchronous() throws RuntimeException {
        this.isFinished = true;
        this.looper.quit();
        if (this.looper.getThread() != Thread.currentThread()) {
            try {
                this.looper.getThread().join();
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Got interrupted waiting to join thread " + this.name);
            }
        }
    }

    @Override
    @Nullable
    public MessageQueueThreadPerfStats getPerfStats() {
        return this.stats;
    }

    @Override
    public void resetPerfStats() {
        MessageQueueThreadImpl.Companion.assignToPerfStats(this.stats, -1L, -1L);
        this.runOnQueue(() -> MessageQueueThreadImpl.resetPerfStats$lambda$1(this));
    }

    @Override
    public boolean isIdle() {
        return this.looper.getQueue().isIdle();
    }

    private static final void callOnQueue$lambda$0(SimpleSettableFuture $future, Callable $callable) {
        try {
            $future.set($callable.call());
        }
        catch (Exception e) {
            $future.setException(e);
        }
    }

    private static final void resetPerfStats$lambda$1(MessageQueueThreadImpl this$0) {
        long wallTime = SystemClock.uptimeMillis();
        long cpuTime = SystemClock.currentThreadTimeMillis();
        MessageQueueThreadImpl.Companion.assignToPerfStats(this$0.stats, wallTime, cpuTime);
    }

    @JvmStatic
    @NotNull
    public static final MessageQueueThreadImpl create(@NotNull MessageQueueThreadSpec spec, @NotNull QueueThreadExceptionHandler exceptionHandler) throws RuntimeException {
        return Companion.create(spec, exceptionHandler);
    }

    public /* synthetic */ MessageQueueThreadImpl(String name, Looper looper, QueueThreadExceptionHandler exceptionHandler, MessageQueueThreadPerfStats stats, DefaultConstructorMarker $constructor_marker) {
        this(name, looper, exceptionHandler, stats);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0014\u001a\u00020\f2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0016"}, d2={"Lcom/facebook/react/bridge/queue/MessageQueueThreadImpl$Companion;", "", "<init>", "()V", "assignToPerfStats", "", "stats", "Lcom/facebook/react/bridge/queue/MessageQueueThreadPerfStats;", "wall", "", "cpu", "create", "Lcom/facebook/react/bridge/queue/MessageQueueThreadImpl;", "spec", "Lcom/facebook/react/bridge/queue/MessageQueueThreadSpec;", "exceptionHandler", "Lcom/facebook/react/bridge/queue/QueueThreadExceptionHandler;", "createForMainThread", "name", "", "startNewBackgroundThread", "stackSize", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        private final void assignToPerfStats(MessageQueueThreadPerfStats stats, long wall, long cpu) {
            block0: {
                MessageQueueThreadPerfStats messageQueueThreadPerfStats = stats;
                if (messageQueueThreadPerfStats == null) break block0;
                MessageQueueThreadPerfStats s = messageQueueThreadPerfStats;
                boolean bl = false;
                s.wallTime = wall;
                s.cpuTime = cpu;
            }
        }

        @JvmStatic
        @NotNull
        public final MessageQueueThreadImpl create(@NotNull MessageQueueThreadSpec spec, @NotNull QueueThreadExceptionHandler exceptionHandler) throws RuntimeException {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"exceptionHandler");
            return switch (WhenMappings.$EnumSwitchMapping$0[spec.getThreadType().ordinal()]) {
                case 1 -> this.createForMainThread(spec.getName(), exceptionHandler);
                case 2 -> this.startNewBackgroundThread(spec.getName(), spec.getStackSize(), exceptionHandler);
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        private final MessageQueueThreadImpl createForMainThread(String name, QueueThreadExceptionHandler exceptionHandler) {
            Looper looper = Looper.getMainLooper();
            Intrinsics.checkNotNullExpressionValue((Object)looper, (String)"getMainLooper(...)");
            return new MessageQueueThreadImpl(name, looper, exceptionHandler, null, 8, null);
        }

        private final MessageQueueThreadImpl startNewBackgroundThread(String name, long stackSize, QueueThreadExceptionHandler exceptionHandler) throws RuntimeException {
            SimpleSettableFuture dataFuture = new SimpleSettableFuture();
            Thread bgThread = new Thread(null, () -> Companion.startNewBackgroundThread$lambda$1(dataFuture), "mqt_" + name, stackSize);
            bgThread.start();
            Pair pair = (Pair)dataFuture.getOrThrow();
            Pair pair2 = pair;
            if (pair2 == null || (pair2 = (Looper)pair2.first) == null) {
                throw new RuntimeException("Looper not found for thread");
            }
            Pair looper = pair2;
            return new MessageQueueThreadImpl(name, (Looper)looper, exceptionHandler, (MessageQueueThreadPerfStats)pair.second, null);
        }

        private static final void startNewBackgroundThread$lambda$1(SimpleSettableFuture $dataFuture) {
            Process.setThreadPriority((int)-4);
            Looper.prepare();
            MessageQueueThreadPerfStats stats = new MessageQueueThreadPerfStats();
            long wallTime = SystemClock.uptimeMillis();
            long cpuTime = SystemClock.currentThreadTimeMillis();
            Companion.assignToPerfStats(stats, wallTime, cpuTime);
            $dataFuture.set(new Pair((Object)Looper.myLooper(), (Object)stats));
            Looper.loop();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[MessageQueueThreadSpec.ThreadType.values().length];
                try {
                    nArray[MessageQueueThreadSpec.ThreadType.MAIN_UI.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[MessageQueueThreadSpec.ThreadType.NEW_BACKGROUND.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

