/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.content.Context;
import com.facebook.react.bridge.JSBundleLoaderDelegate;
import com.facebook.react.common.DebugServerException;
import java.util.Objects;

public abstract class JSBundleLoader {
    public static JSBundleLoader createAssetLoader(final Context context, final String assetUrl, final boolean loadSynchronously) {
        return new JSBundleLoader(){

            @Override
            public String loadScript(JSBundleLoaderDelegate delegate) {
                delegate.loadScriptFromAssets(context.getAssets(), assetUrl, loadSynchronously);
                return assetUrl;
            }
        };
    }

    public static JSBundleLoader createFileLoader(String fileName) {
        return JSBundleLoader.createFileLoader(fileName, fileName, false);
    }

    public static JSBundleLoader createFileLoader(final String fileName, final String assetUrl, final boolean loadSynchronously) {
        return new JSBundleLoader(){

            @Override
            public String loadScript(JSBundleLoaderDelegate delegate) {
                delegate.loadScriptFromFile(fileName, assetUrl, loadSynchronously);
                return fileName;
            }
        };
    }

    public static JSBundleLoader createCachedBundleFromNetworkLoader(final String sourceURL, final String cachedFileLocation) {
        return new JSBundleLoader(){

            @Override
            public String loadScript(JSBundleLoaderDelegate delegate) {
                try {
                    delegate.loadScriptFromFile(cachedFileLocation, sourceURL, false);
                    return sourceURL;
                }
                catch (Exception e) {
                    throw DebugServerException.makeGeneric(sourceURL, Objects.toString(e.getMessage(), ""), e);
                }
            }
        };
    }

    public static JSBundleLoader createCachedSplitBundleFromNetworkLoader(final String sourceURL, final String cachedFileLocation) {
        return new JSBundleLoader(){

            @Override
            public String loadScript(JSBundleLoaderDelegate delegate) {
                try {
                    delegate.loadSplitBundleFromFile(cachedFileLocation, sourceURL);
                    return sourceURL;
                }
                catch (Exception e) {
                    throw DebugServerException.makeGeneric(sourceURL, Objects.toString(e.getMessage(), ""), e);
                }
            }
        };
    }

    public abstract String loadScript(JSBundleLoaderDelegate var1);
}

