/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text.frescosupport;

import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.core.util.Preconditions;
import com.facebook.drawee.controller.AbstractDraweeController;
import com.facebook.drawee.controller.AbstractDraweeControllerBuilder;
import com.facebook.drawee.generic.GenericDraweeHierarchy;
import com.facebook.drawee.generic.GenericDraweeHierarchyBuilder;
import com.facebook.drawee.interfaces.DraweeController;
import com.facebook.drawee.interfaces.DraweeHierarchy;
import com.facebook.drawee.view.DraweeHolder;
import com.facebook.imagepipeline.request.ImageRequestBuilder;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.modules.fresco.ReactNetworkImageRequest;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.views.image.ImageResizeMode;
import com.facebook.react.views.text.internal.span.TextInlineImageSpan;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
class FrescoBasedReactTextInlineImageSpan
extends TextInlineImageSpan {
    @Nullable
    private Drawable mDrawable;
    private final AbstractDraweeControllerBuilder mDraweeControllerBuilder;
    private final DraweeHolder<GenericDraweeHierarchy> mDraweeHolder;
    @Nullable
    private final Object mCallerContext;
    private int mHeight;
    private int mTintColor;
    private Uri mUri;
    private int mWidth;
    @Nullable
    private ReadableMap mHeaders;
    @Nullable
    private String mResizeMode;
    @Nullable
    private TextView mTextView;

    public FrescoBasedReactTextInlineImageSpan(Resources resources, int height, int width, int tintColor, @Nullable Uri uri, @Nullable ReadableMap headers, AbstractDraweeControllerBuilder draweeControllerBuilder, @Nullable Object callerContext, @Nullable String resizeMode) {
        this.mDraweeHolder = new DraweeHolder((DraweeHierarchy)GenericDraweeHierarchyBuilder.newInstance((Resources)resources).build());
        this.mDraweeControllerBuilder = draweeControllerBuilder;
        this.mCallerContext = callerContext;
        this.mTintColor = tintColor;
        this.mUri = uri != null ? uri : Uri.EMPTY;
        this.mHeaders = headers;
        this.mWidth = (int)PixelUtil.toPixelFromDIP(width);
        this.mHeight = (int)PixelUtil.toPixelFromDIP(height);
        this.mResizeMode = resizeMode;
    }

    @Override
    public void onDetachedFromWindow() {
        this.mDraweeHolder.onDetach();
    }

    @Override
    public void onStartTemporaryDetach() {
        this.mDraweeHolder.onDetach();
    }

    @Override
    public void onAttachedToWindow() {
        this.mDraweeHolder.onAttach();
    }

    @Override
    public void onFinishTemporaryDetach() {
        this.mDraweeHolder.onAttach();
    }

    @Override
    @Nullable
    public Drawable getDrawable() {
        return this.mDrawable;
    }

    public int getSize(Paint paint, CharSequence text, int start, int end, Paint.FontMetricsInt fm) {
        if (fm != null) {
            fm.ascent = -this.mHeight;
            fm.descent = 0;
            fm.top = fm.ascent;
            fm.bottom = 0;
        }
        return this.mWidth;
    }

    @Override
    public void setTextView(@Nullable TextView textView) {
        this.mTextView = textView;
    }

    public void draw(Canvas canvas, CharSequence text, int start, int end, float x, int top, int y, int bottom, Paint paint) {
        if (this.mDrawable == null) {
            ImageRequestBuilder imageRequestBuilder = ImageRequestBuilder.newBuilderWithSource((Uri)this.mUri);
            ReactNetworkImageRequest imageRequest = ReactNetworkImageRequest.fromBuilderWithHeaders(imageRequestBuilder, this.mHeaders);
            ((GenericDraweeHierarchy)this.mDraweeHolder.getHierarchy()).setActualImageScaleType(ImageResizeMode.toScaleType(this.mResizeMode));
            this.mDraweeControllerBuilder.reset();
            this.mDraweeControllerBuilder.setOldController(this.mDraweeHolder.getController());
            if (this.mCallerContext != null) {
                this.mDraweeControllerBuilder.setCallerContext(this.mCallerContext);
            }
            this.mDraweeControllerBuilder.setImageRequest((Object)imageRequest);
            AbstractDraweeController draweeController = this.mDraweeControllerBuilder.build();
            this.mDraweeHolder.setController((DraweeController)draweeController);
            this.mDraweeControllerBuilder.reset();
            this.mDrawable = (Drawable)Preconditions.checkNotNull((Object)this.mDraweeHolder.getTopLevelDrawable());
            this.mDrawable.setBounds(0, 0, this.mWidth, this.mHeight);
            if (this.mTintColor != 0) {
                this.mDrawable.setColorFilter(this.mTintColor, PorterDuff.Mode.SRC_IN);
            }
            this.mDrawable.setCallback((Drawable.Callback)this.mTextView);
        }
        canvas.save();
        int fontHeight = (int)(paint.descent() - paint.ascent());
        int centerY = y + (int)paint.descent() - fontHeight / 2;
        int transY = centerY - (this.mDrawable.getBounds().bottom - this.mDrawable.getBounds().top) / 2;
        canvas.translate(x, (float)transY);
        this.mDrawable.draw(canvas);
        canvas.restore();
    }

    @Override
    public int getWidth() {
        return this.mWidth;
    }

    @Override
    public int getHeight() {
        return this.mHeight;
    }
}

