/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.graphics.Color;
import android.os.Build;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import androidx.core.view.ViewCompat;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0014\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u0014\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0004H\u0000\u001a\f\u0010\u0007\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\f\u0010\b\u001a\u00020\u0001*\u00020\u0002H\u0002\u001a\u0014\u0010\t\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a8\u0006\n"}, d2={"setStatusBarTranslucency", "", "Landroid/view/Window;", "isTranslucent", "", "setStatusBarVisibility", "isHidden", "statusBarHide", "statusBarShow", "setSystemBarsTranslucency", "ReactAndroid_debug"})
public final class WindowUtilKt {
    public static final void setStatusBarTranslucency(@NotNull Window $this$setStatusBarTranslucency, boolean isTranslucent) {
        Intrinsics.checkNotNullParameter((Object)$this$setStatusBarTranslucency, (String)"<this>");
        if (isTranslucent) {
            $this$setStatusBarTranslucency.getDecorView().setOnApplyWindowInsetsListener(WindowUtilKt::setStatusBarTranslucency$lambda$0);
        } else {
            $this$setStatusBarTranslucency.getDecorView().setOnApplyWindowInsetsListener(null);
        }
        ViewCompat.requestApplyInsets((View)$this$setStatusBarTranslucency.getDecorView());
    }

    public static final void setStatusBarVisibility(@NotNull Window $this$setStatusBarVisibility, boolean isHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$setStatusBarVisibility, (String)"<this>");
        if (isHidden) {
            WindowUtilKt.statusBarHide($this$setStatusBarVisibility);
        } else {
            WindowUtilKt.statusBarShow($this$setStatusBarVisibility);
        }
    }

    private static final void statusBarHide(Window $this$statusBarHide) {
        if (Build.VERSION.SDK_INT >= 30) {
            $this$statusBarHide.getAttributes().layoutInDisplayCutoutMode = 1;
            $this$statusBarHide.setDecorFitsSystemWindows(false);
        }
        $this$statusBarHide.addFlags(1024);
        $this$statusBarHide.clearFlags(2048);
    }

    private static final void statusBarShow(Window $this$statusBarShow) {
        if (Build.VERSION.SDK_INT >= 30) {
            $this$statusBarShow.getAttributes().layoutInDisplayCutoutMode = 0;
            $this$statusBarShow.setDecorFitsSystemWindows(true);
        }
        $this$statusBarShow.addFlags(2048);
        $this$statusBarShow.clearFlags(1024);
    }

    public static final void setSystemBarsTranslucency(@NotNull Window $this$setSystemBarsTranslucency, boolean isTranslucent) {
        Intrinsics.checkNotNullParameter((Object)$this$setSystemBarsTranslucency, (String)"<this>");
        WindowCompat.setDecorFitsSystemWindows((Window)$this$setSystemBarsTranslucency, (!isTranslucent ? 1 : 0) != 0);
        if (isTranslucent) {
            boolean isDarkMode;
            boolean bl = isDarkMode = ($this$setSystemBarsTranslucency.getContext().getResources().getConfiguration().uiMode & 0x30) == 32;
            if (Build.VERSION.SDK_INT >= 29) {
                $this$setSystemBarsTranslucency.setStatusBarContrastEnforced(false);
                $this$setSystemBarsTranslucency.setNavigationBarContrastEnforced(true);
            }
            $this$setSystemBarsTranslucency.setStatusBarColor(0);
            $this$setSystemBarsTranslucency.setNavigationBarColor(Build.VERSION.SDK_INT >= 29 ? 0 : (Build.VERSION.SDK_INT >= 27 && !isDarkMode ? Color.argb((int)230, (int)255, (int)255, (int)255) : Color.argb((int)128, (int)27, (int)27, (int)27)));
            WindowInsetsControllerCompat $this$setSystemBarsTranslucency_u24lambda_u241 = new WindowInsetsControllerCompat($this$setSystemBarsTranslucency, $this$setSystemBarsTranslucency.getDecorView());
            boolean bl2 = false;
            $this$setSystemBarsTranslucency_u24lambda_u241.setAppearanceLightNavigationBars(!isDarkMode);
            if (Build.VERSION.SDK_INT >= 28) {
                $this$setSystemBarsTranslucency.getAttributes().layoutInDisplayCutoutMode = Build.VERSION.SDK_INT >= 30 ? 3 : 1;
            }
        }
    }

    private static final WindowInsets setStatusBarTranslucency$lambda$0(View v, WindowInsets insets) {
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        WindowInsets defaultInsets = v.onApplyWindowInsets(insets);
        return defaultInsets.replaceSystemWindowInsets(defaultInsets.getSystemWindowInsetLeft(), 0, defaultInsets.getSystemWindowInsetRight(), defaultInsets.getSystemWindowInsetBottom());
    }
}

