/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.runtime;

import android.content.Context;
import android.os.Bundle;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.ViewGroup;
import androidx.annotation.UiThread;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.infer.annotation.ThreadSafe;
import com.facebook.react.ReactHost;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.NativeMap;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.fabric.SurfaceHandlerBinding;
import com.facebook.react.interfaces.TaskInterface;
import com.facebook.react.interfaces.fabric.ReactSurface;
import com.facebook.react.interfaces.fabric.SurfaceHandler;
import com.facebook.react.modules.i18nmanager.I18nUtil;
import com.facebook.react.runtime.ReactHostImpl;
import com.facebook.react.runtime.ReactSurfaceView;
import com.facebook.react.runtime.internal.bolts.Task;
import com.facebook.react.uimanager.events.EventDispatcher;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
@ThreadSafe
public class ReactSurfaceImpl
implements ReactSurface {
    private final AtomicReference<ReactSurfaceView> mSurfaceView = new AtomicReference<Object>(null);
    private final AtomicReference<ReactHostImpl> mReactHost = new AtomicReference<Object>(null);
    private final SurfaceHandler mSurfaceHandler;
    private Context mContext;

    public static ReactSurfaceImpl createWithView(Context context, String moduleName, @Nullable Bundle initialProps) {
        ReactSurfaceImpl surface = new ReactSurfaceImpl(context, moduleName, initialProps);
        surface.attachView(new ReactSurfaceView(context, surface));
        return surface;
    }

    public ReactSurfaceImpl(Context context, String moduleName, @Nullable Bundle initialProps) {
        this(new SurfaceHandlerBinding(moduleName), context);
        NativeMap nativeProps = initialProps == null ? new WritableNativeMap() : (NativeMap)((Object)Arguments.fromBundle(initialProps));
        this.mSurfaceHandler.setProps(nativeProps);
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mSurfaceHandler.setLayoutConstraints(View.MeasureSpec.makeMeasureSpec((int)displayMetrics.widthPixels, (int)Integer.MIN_VALUE), View.MeasureSpec.makeMeasureSpec((int)displayMetrics.heightPixels, (int)Integer.MIN_VALUE), 0, 0, ReactSurfaceImpl.doRTLSwap(context), ReactSurfaceImpl.isRTL(context), ReactSurfaceImpl.getPixelDensity(context));
    }

    @VisibleForTesting
    ReactSurfaceImpl(SurfaceHandler surfaceHandler, Context context) {
        this.mSurfaceHandler = surfaceHandler;
        this.mContext = context;
    }

    public void attach(ReactHost host) {
        if (host instanceof ReactHostImpl && !this.mReactHost.compareAndSet(null, (ReactHostImpl)host)) {
            throw new IllegalStateException("This surface is already attached to a host!");
        }
        if (!(host instanceof ReactHostImpl)) {
            throw new IllegalArgumentException("ReactSurfaceImpl.attach can only attach to ReactHostImpl.");
        }
    }

    public void attachView(ReactSurfaceView view) {
        if (!this.mSurfaceView.compareAndSet(null, view)) {
            throw new IllegalStateException("Trying to call ReactSurface.attachView(), but the view is already attached.");
        }
        this.mContext = view.getContext();
    }

    public void updateInitProps(Bundle newProps) {
        this.mSurfaceHandler.setProps((NativeMap)((Object)Arguments.fromBundle(newProps)));
    }

    @VisibleForTesting
    ReactHostImpl getReactHost() {
        return this.mReactHost.get();
    }

    @Override
    public void detach() {
        this.mReactHost.set(null);
    }

    SurfaceHandler getSurfaceHandler() {
        return this.mSurfaceHandler;
    }

    @Override
    @Nullable
    public ViewGroup getView() {
        return (ViewGroup)this.mSurfaceView.get();
    }

    @Override
    public TaskInterface<Void> prerender() {
        ReactHostImpl host = this.mReactHost.get();
        if (host == null) {
            return Task.forError(new IllegalStateException("Trying to call ReactSurface.prerender(), but no ReactHost is attached."));
        }
        return host.prerenderSurface(this);
    }

    @Override
    public TaskInterface<Void> start() {
        if (this.mSurfaceView.get() == null) {
            return Task.forError(new IllegalStateException("Trying to call ReactSurface.start(), but view is not created."));
        }
        ReactHostImpl host = this.mReactHost.get();
        if (host == null) {
            return Task.forError(new IllegalStateException("Trying to call ReactSurface.start(), but no ReactHost is attached."));
        }
        return host.startSurface(this);
    }

    @Override
    public TaskInterface<Void> stop() {
        ReactHostImpl host = this.mReactHost.get();
        if (host == null) {
            return Task.forError(new IllegalStateException("Trying to call ReactSurface.stop(), but no ReactHost is attached."));
        }
        return host.stopSurface(this);
    }

    @Override
    public int getSurfaceID() {
        return this.mSurfaceHandler.getSurfaceId();
    }

    @Override
    public String getModuleName() {
        return this.mSurfaceHandler.getModuleName();
    }

    @Override
    public void clear() {
        UiThreadUtil.runOnUiThread(() -> {
            ReactSurfaceView view = (ReactSurfaceView)this.getView();
            if (view != null) {
                view.removeAllViews();
                view.setId(-1);
            }
        });
    }

    @UiThread
    synchronized void updateLayoutSpecs(int widthMeasureSpec, int heightMeasureSpec, int offsetX, int offsetY) {
        this.mSurfaceHandler.setLayoutConstraints(widthMeasureSpec, heightMeasureSpec, offsetX, offsetY, ReactSurfaceImpl.doRTLSwap(this.mContext), ReactSurfaceImpl.isRTL(this.mContext), ReactSurfaceImpl.getPixelDensity(this.mContext));
    }

    @Nullable
    EventDispatcher getEventDispatcher() {
        ReactHostImpl host = this.mReactHost.get();
        if (host == null) {
            return null;
        }
        return host.getEventDispatcher();
    }

    @VisibleForTesting
    boolean isAttached() {
        return this.mReactHost.get() != null;
    }

    @Override
    public boolean isRunning() {
        return this.mSurfaceHandler.isRunning();
    }

    @Override
    public Context getContext() {
        return this.mContext;
    }

    private static float getPixelDensity(Context context) {
        return context.getResources().getDisplayMetrics().density;
    }

    private static boolean isRTL(Context context) {
        return I18nUtil.getInstance().isRTL(context);
    }

    private static boolean doRTLSwap(Context context) {
        return I18nUtil.getInstance().doLeftAndRightSwapInRTL(context);
    }
}

