/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.core;

import android.view.Choreographer;
import androidx.annotation.GuardedBy;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.internal.ChoreographerProvider;
import java.util.ArrayDeque;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\fJ\u0018\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0012\u001a\u0004\u0018\u00010\fJ\b\u0010\u0019\u001a\u00020\u0014H\u0002J\b\u0010\u001a\u001a\u00020\u0014H\u0002R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0004\n\u0002\b\bR\u001c\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00020\u00118\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/facebook/react/modules/core/ReactChoreographer;", "", "choreographerProvider", "Lcom/facebook/react/internal/ChoreographerProvider;", "<init>", "(Lcom/facebook/react/internal/ChoreographerProvider;)V", "choreographer", "Lcom/facebook/react/internal/ChoreographerProvider$Choreographer;", "choreographer$1", "callbackQueues", "", "Ljava/util/ArrayDeque;", "Landroid/view/Choreographer$FrameCallback;", "[Ljava/util/ArrayDeque;", "totalCallbacks", "", "hasPostedCallback", "", "frameCallback", "postFrameCallback", "", "type", "Lcom/facebook/react/modules/core/ReactChoreographer$CallbackType;", "callback", "removeFrameCallback", "postFrameCallbackOnChoreographer", "maybeRemoveFrameCallback", "CallbackType", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nReactChoreographer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactChoreographer.kt\ncom/facebook/react/modules/core/ReactChoreographer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
public final class ReactChoreographer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ChoreographerProvider.Choreographer choreographer$1;
    @NotNull
    private final ArrayDeque<Choreographer.FrameCallback>[] callbackQueues;
    private int totalCallbacks;
    @GuardedBy(value="callbackQueues")
    private boolean hasPostedCallback;
    @NotNull
    private final Choreographer.FrameCallback frameCallback;
    @Nullable
    private static ReactChoreographer choreographer;

    private ReactChoreographer(ChoreographerProvider choreographerProvider) {
        int n = 0;
        int n2 = CallbackType.getEntries().size();
        ArrayDeque[] arrayDequeArray = new ArrayDeque[n2];
        ReactChoreographer reactChoreographer = this;
        while (n < n2) {
            int n3 = n++;
            arrayDequeArray[n3] = new ArrayDeque();
        }
        reactChoreographer.callbackQueues = arrayDequeArray;
        this.frameCallback = arg_0 -> ReactChoreographer.frameCallback$lambda$1(this, arg_0);
        UiThreadUtil.runOnUiThread(() -> ReactChoreographer._init_$lambda$2(this, choreographerProvider));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postFrameCallback(@NotNull CallbackType type, @NotNull Choreographer.FrameCallback callback) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)callback, (String)"callback");
        ArrayDeque<Choreographer.FrameCallback>[] arrayDequeArray = this.callbackQueues;
        synchronized (arrayDequeArray) {
            boolean bl = false;
            this.callbackQueues[type.getOrder$ReactAndroid_debug()].addLast(callback);
            int n = this.totalCallbacks;
            this.totalCallbacks = n + 1;
            Assertions.assertCondition((this.totalCallbacks > 0 ? 1 : 0) != 0);
            this.postFrameCallbackOnChoreographer();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeFrameCallback(@NotNull CallbackType type, @Nullable Choreographer.FrameCallback frameCallback) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        ArrayDeque<Choreographer.FrameCallback>[] arrayDequeArray = this.callbackQueues;
        synchronized (arrayDequeArray) {
            boolean bl = false;
            if (this.callbackQueues[type.getOrder$ReactAndroid_debug()].removeFirstOccurrence(frameCallback)) {
                int n = this.totalCallbacks;
                this.totalCallbacks = n + -1;
                this.maybeRemoveFrameCallback();
            } else {
                FLog.e((String)"ReactNative", (String)"Tried to remove non-existent frame callback");
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void postFrameCallbackOnChoreographer() {
        if (!this.hasPostedCallback) {
            ChoreographerProvider.Choreographer choreographer = this.choreographer$1;
            if (choreographer == null) {
                UiThreadUtil.runOnUiThread(() -> ReactChoreographer.postFrameCallbackOnChoreographer$lambda$6(this));
            } else {
                choreographer.postFrameCallback(this.frameCallback);
                this.hasPostedCallback = true;
            }
        }
    }

    private final void maybeRemoveFrameCallback() {
        Assertions.assertCondition((this.totalCallbacks >= 0 ? 1 : 0) != 0);
        if (this.totalCallbacks == 0 && this.hasPostedCallback) {
            ChoreographerProvider.Choreographer choreographer = this.choreographer$1;
            if (choreographer != null) {
                choreographer.removeFrameCallback(this.frameCallback);
            }
            this.hasPostedCallback = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void frameCallback$lambda$1(ReactChoreographer this$0, long frameTimeNanos) {
        ArrayDeque<Choreographer.FrameCallback>[] arrayDequeArray = this$0.callbackQueues;
        synchronized (arrayDequeArray) {
            boolean bl = false;
            this$0.hasPostedCallback = false;
            for (ArrayDeque<Choreographer.FrameCallback> callbackQueue : this$0.callbackQueues) {
                int initialLength = callbackQueue.size();
                for (int callback = 0; callback < initialLength; ++callback) {
                    Choreographer.FrameCallback frameCallback = callbackQueue.pollFirst();
                    if (frameCallback != null) {
                        frameCallback.doFrame(frameTimeNanos);
                        int n = this$0.totalCallbacks;
                        this$0.totalCallbacks = n + -1;
                        continue;
                    }
                    FLog.e((String)"ReactNative", (String)"Tried to execute non-existent frame callback");
                }
            }
            this$0.maybeRemoveFrameCallback();
            Unit unit = Unit.INSTANCE;
        }
    }

    private static final void _init_$lambda$2(ReactChoreographer this$0, ChoreographerProvider $choreographerProvider) {
        this$0.choreographer$1 = $choreographerProvider.getChoreographer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void postFrameCallbackOnChoreographer$lambda$6(ReactChoreographer this$0) {
        ArrayDeque<Choreographer.FrameCallback>[] arrayDequeArray = this$0.callbackQueues;
        synchronized (arrayDequeArray) {
            boolean bl = false;
            this$0.postFrameCallbackOnChoreographer();
            Unit unit = Unit.INSTANCE;
        }
    }

    @JvmStatic
    public static final void initialize(@NotNull ChoreographerProvider choreographerProvider) {
        Companion.initialize(choreographerProvider);
    }

    @JvmStatic
    @NotNull
    public static final ReactChoreographer getInstance() {
        return Companion.getInstance();
    }

    public /* synthetic */ ReactChoreographer(ChoreographerProvider choreographerProvider, DefaultConstructorMarker $constructor_marker) {
        this(choreographerProvider);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\b\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/facebook/react/modules/core/ReactChoreographer$CallbackType;", "", "order", "", "<init>", "(Ljava/lang/String;II)V", "getOrder$ReactAndroid_debug", "()I", "PERF_MARKERS", "DISPATCH_UI", "NATIVE_ANIMATED_MODULE", "TIMERS_EVENTS", "IDLE_EVENT", "ReactAndroid_debug"})
    public static final class CallbackType
    extends Enum<CallbackType> {
        private final int order;
        public static final /* enum */ CallbackType PERF_MARKERS = new CallbackType(0);
        public static final /* enum */ CallbackType DISPATCH_UI = new CallbackType(1);
        public static final /* enum */ CallbackType NATIVE_ANIMATED_MODULE = new CallbackType(2);
        public static final /* enum */ CallbackType TIMERS_EVENTS = new CallbackType(3);
        public static final /* enum */ CallbackType IDLE_EVENT = new CallbackType(4);
        private static final /* synthetic */ CallbackType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private CallbackType(int order) {
            this.order = order;
        }

        public final int getOrder$ReactAndroid_debug() {
            return this.order;
        }

        public static CallbackType[] values() {
            return (CallbackType[])$VALUES.clone();
        }

        public static CallbackType valueOf(String value) {
            return Enum.valueOf(CallbackType.class, value);
        }

        @NotNull
        public static EnumEntries<CallbackType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = callbackTypeArray = new CallbackType[]{CallbackType.PERF_MARKERS, CallbackType.DISPATCH_UI, CallbackType.NATIVE_ANIMATED_MODULE, CallbackType.TIMERS_EVENTS, CallbackType.IDLE_EVENT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\u0005H\u0007J\u0019\u0010\u000b\u001a\u0004\u0018\u00010\u00052\b\u0010\f\u001a\u0004\u0018\u00010\u0005H\u0001\u00a2\u0006\u0002\b\rR\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/facebook/react/modules/core/ReactChoreographer$Companion;", "", "<init>", "()V", "choreographer", "Lcom/facebook/react/modules/core/ReactChoreographer;", "initialize", "", "choreographerProvider", "Lcom/facebook/react/internal/ChoreographerProvider;", "getInstance", "overrideInstanceForTest", "instance", "overrideInstanceForTest$ReactAndroid_debug", "ReactAndroid_debug"})
    @SourceDebugExtension(value={"SMAP\nReactChoreographer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactChoreographer.kt\ncom/facebook/react/modules/core/ReactChoreographer$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,144:1\n1#2:145\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void initialize(@NotNull ChoreographerProvider choreographerProvider) {
            Intrinsics.checkNotNullParameter((Object)choreographerProvider, (String)"choreographerProvider");
            if (choreographer == null) {
                choreographer = new ReactChoreographer(choreographerProvider, null);
            }
        }

        @JvmStatic
        @NotNull
        public final ReactChoreographer getInstance() {
            ReactChoreographer reactChoreographer = choreographer;
            if (reactChoreographer == null) {
                boolean bl = false;
                String string2 = "ReactChoreographer needs to be initialized.";
                throw new IllegalStateException(string2.toString());
            }
            return reactChoreographer;
        }

        @VisibleForTesting
        @Nullable
        public final ReactChoreographer overrideInstanceForTest$ReactAndroid_debug(@Nullable ReactChoreographer instance) {
            ReactChoreographer reactChoreographer;
            ReactChoreographer it = reactChoreographer = choreographer;
            boolean bl = false;
            choreographer = instance;
            return reactChoreographer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

