/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.util.TypedValue;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.PixelUtil;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0003J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0002J\u0018\u0010\u0015\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/facebook/react/views/view/ReactDrawableHelper;", "", "<init>", "()V", "resolveOutValue", "Landroid/util/TypedValue;", "createDrawableFromJSDescription", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "drawableDescriptionDict", "Lcom/facebook/react/bridge/ReadableMap;", "getAttrId", "", "attr", "", "getDefaultThemeDrawable", "getRippleDrawable", "Landroid/graphics/drawable/RippleDrawable;", "setRadius", "drawable", "getColor", "getMask", "ReactAndroid_debug"})
public final class ReactDrawableHelper {
    @NotNull
    public static final ReactDrawableHelper INSTANCE = new ReactDrawableHelper();
    @NotNull
    private static final TypedValue resolveOutValue = new TypedValue();

    private ReactDrawableHelper() {
    }

    @JvmStatic
    @Nullable
    public static final Drawable createDrawableFromJSDescription(@NotNull Context context, @NotNull ReadableMap drawableDescriptionDict) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)drawableDescriptionDict, (String)"drawableDescriptionDict");
        String type = drawableDescriptionDict.getString("type");
        if (Intrinsics.areEqual((Object)"ThemeAttrAndroid", (Object)type)) {
            String string2 = drawableDescriptionDict.getString("attribute");
            if (string2 == null) {
                throw new JSApplicationIllegalArgumentException("JS description missing 'attribute' field");
            }
            String attr = string2;
            int attrId = INSTANCE.getAttrId(context, attr);
            if (!context.getTheme().resolveAttribute(attrId, resolveOutValue, true)) {
                throw new JSApplicationIllegalArgumentException("Attribute " + attr + " with id " + attrId + " couldn't be resolved into a drawable");
            }
            Drawable drawable2 = INSTANCE.getDefaultThemeDrawable(context);
            return INSTANCE.setRadius(drawableDescriptionDict, drawable2);
        }
        if (Intrinsics.areEqual((Object)"RippleAndroid", (Object)type)) {
            RippleDrawable rd = INSTANCE.getRippleDrawable(context, drawableDescriptionDict);
            return INSTANCE.setRadius(drawableDescriptionDict, (Drawable)rd);
        }
        throw new JSApplicationIllegalArgumentException("Invalid type for android drawable: " + type);
    }

    @SuppressLint(value={"DiscouragedApi", "InternalInsetResource"})
    private final int getAttrId(Context context, String attr) {
        return Intrinsics.areEqual((Object)"selectableItemBackground", (Object)attr) ? 16843534 : (Intrinsics.areEqual((Object)"selectableItemBackgroundBorderless", (Object)attr) ? 16843868 : context.getResources().getIdentifier(attr, "attr", "android"));
    }

    private final Drawable getDefaultThemeDrawable(Context context) {
        return context.getResources().getDrawable(ReactDrawableHelper.resolveOutValue.resourceId, context.getTheme());
    }

    private final RippleDrawable getRippleDrawable(Context context, ReadableMap drawableDescriptionDict) {
        int color = this.getColor(context, drawableDescriptionDict);
        Drawable mask = this.getMask(drawableDescriptionDict);
        Object object = new int[][]{new int[0]};
        int[][] nArrayArray = object;
        object = new int[1];
        object[0] = (int[])color;
        ColorStateList colorStateList = new ColorStateList((int[][])nArrayArray, (int[])object);
        return new RippleDrawable(colorStateList, null, mask);
    }

    private final Drawable setRadius(ReadableMap drawableDescriptionDict, Drawable drawable2) {
        if (drawableDescriptionDict.hasKey("rippleRadius") && drawable2 instanceof RippleDrawable) {
            double rippleRadius = drawableDescriptionDict.getDouble("rippleRadius");
            ((RippleDrawable)drawable2).setRadius((int)PixelUtil.toPixelFromDIP(rippleRadius));
        }
        return drawable2;
    }

    private final int getColor(Context context, ReadableMap drawableDescriptionDict) {
        int n;
        if (drawableDescriptionDict.hasKey("color") && !drawableDescriptionDict.isNull("color")) {
            n = drawableDescriptionDict.getInt("color");
        } else if (context.getTheme().resolveAttribute(16843820, resolveOutValue, true)) {
            n = context.getResources().getColor(ReactDrawableHelper.resolveOutValue.resourceId, context.getTheme());
        } else {
            throw new JSApplicationIllegalArgumentException("Attribute colorControlHighlight couldn't be resolved into a drawable");
        }
        return n;
    }

    private final Drawable getMask(ReadableMap drawableDescriptionDict) {
        if (!drawableDescriptionDict.hasKey("borderless") || drawableDescriptionDict.isNull("borderless") || !drawableDescriptionDict.getBoolean("borderless")) {
            return (Drawable)new ColorDrawable(-1);
        }
        return null;
    }
}

