/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import android.content.Context;
import com.facebook.react.modules.network.OkHttpClientFactory;
import com.facebook.react.modules.network.ReactCookieJarContainer;
import java.io.File;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okhttp3.Cache;
import okhttp3.CookieJar;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0007J\b\u0010\u0012\u001a\u00020\u0005H\u0007J\b\u0010\u0013\u001a\u00020\u0005H\u0007J\u0010\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\b\u0010\u0016\u001a\u00020\u0017H\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0007R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/facebook/react/modules/network/OkHttpClientProvider;", "", "<init>", "()V", "client", "Lokhttp3/OkHttpClient;", "getClient$ReactAndroid_debug", "()Lokhttp3/OkHttpClient;", "setClient$ReactAndroid_debug", "(Lokhttp3/OkHttpClient;)V", "factory", "Lcom/facebook/react/modules/network/OkHttpClientFactory;", "getFactory$ReactAndroid_debug", "()Lcom/facebook/react/modules/network/OkHttpClientFactory;", "setFactory$ReactAndroid_debug", "(Lcom/facebook/react/modules/network/OkHttpClientFactory;)V", "setOkHttpClientFactory", "", "getOkHttpClient", "createClient", "context", "Landroid/content/Context;", "createClientBuilder", "Lokhttp3/OkHttpClient$Builder;", "cacheSize", "", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nOkHttpClientProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OkHttpClientProvider.kt\ncom/facebook/react/modules/network/OkHttpClientProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,80:1\n1#2:81\n*E\n"})
public final class OkHttpClientProvider {
    @NotNull
    public static final OkHttpClientProvider INSTANCE = new OkHttpClientProvider();
    @Nullable
    private static OkHttpClient client;
    @Nullable
    private static OkHttpClientFactory factory;

    private OkHttpClientProvider() {
    }

    @Nullable
    public final OkHttpClient getClient$ReactAndroid_debug() {
        return client;
    }

    public final void setClient$ReactAndroid_debug(@Nullable OkHttpClient okHttpClient) {
        client = okHttpClient;
    }

    @Nullable
    public final OkHttpClientFactory getFactory$ReactAndroid_debug() {
        return factory;
    }

    public final void setFactory$ReactAndroid_debug(@Nullable OkHttpClientFactory okHttpClientFactory) {
        factory = okHttpClientFactory;
    }

    @JvmStatic
    public static final void setOkHttpClientFactory(@Nullable OkHttpClientFactory factory) {
        OkHttpClientProvider.factory = factory;
    }

    @JvmStatic
    @NotNull
    public static final OkHttpClient getOkHttpClient() {
        OkHttpClient okHttpClient = client;
        if (okHttpClient == null) {
            OkHttpClient okHttpClient2;
            OkHttpClient it = okHttpClient2 = INSTANCE.createClient();
            boolean bl = false;
            client = it;
            okHttpClient = okHttpClient2;
        }
        return okHttpClient;
    }

    @JvmStatic
    @NotNull
    public static final OkHttpClient createClient() {
        OkHttpClientFactory okHttpClientFactory = factory;
        if (okHttpClientFactory == null || (okHttpClientFactory = okHttpClientFactory.createNewNetworkModuleClient()) == null) {
            okHttpClientFactory = INSTANCE.createClientBuilder().build();
        }
        return okHttpClientFactory;
    }

    @JvmStatic
    @NotNull
    public static final OkHttpClient createClient(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        OkHttpClientFactory okHttpClientFactory = factory;
        if (okHttpClientFactory == null || (okHttpClientFactory = okHttpClientFactory.createNewNetworkModuleClient()) == null) {
            okHttpClientFactory = OkHttpClientProvider.createClientBuilder(context).build();
        }
        return okHttpClientFactory;
    }

    @JvmStatic
    @NotNull
    public static final OkHttpClient.Builder createClientBuilder() {
        OkHttpClient.Builder client = new OkHttpClient.Builder().connectTimeout(0L, TimeUnit.MILLISECONDS).readTimeout(0L, TimeUnit.MILLISECONDS).writeTimeout(0L, TimeUnit.MILLISECONDS).cookieJar((CookieJar)new ReactCookieJarContainer());
        return client;
    }

    @JvmStatic
    @NotNull
    public static final OkHttpClient.Builder createClientBuilder(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        int cacheSize = 0xA00000;
        return OkHttpClientProvider.createClientBuilder(context, cacheSize);
    }

    @JvmStatic
    @NotNull
    public static final OkHttpClient.Builder createClientBuilder(@NotNull Context context, int cacheSize) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        OkHttpClient.Builder client = INSTANCE.createClientBuilder();
        if (cacheSize == 0) {
            return client;
        }
        File cacheDirectory = new File(context.getCacheDir(), "http-cache");
        Cache cache = new Cache(cacheDirectory, (long)cacheSize);
        return client.cache(cache);
    }
}

