/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.fabric;

import com.facebook.react.bridge.CatalystInstance;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.RuntimeExecutor;
import com.facebook.react.bridge.RuntimeScheduler;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UIManagerProvider;
import com.facebook.react.fabric.ComponentFactory;
import com.facebook.react.fabric.FabricUIManager;
import com.facebook.react.fabric.FabricUIManagerBinding;
import com.facebook.react.fabric.events.EventBeatManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.systrace.Systrace;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/facebook/react/fabric/FabricUIManagerProviderImpl;", "Lcom/facebook/react/bridge/UIManagerProvider;", "componentFactory", "Lcom/facebook/react/fabric/ComponentFactory;", "viewManagerRegistry", "Lcom/facebook/react/uimanager/ViewManagerRegistry;", "<init>", "(Lcom/facebook/react/fabric/ComponentFactory;Lcom/facebook/react/uimanager/ViewManagerRegistry;)V", "createUIManager", "Lcom/facebook/react/bridge/UIManager;", "context", "Lcom/facebook/react/bridge/ReactApplicationContext;", "ReactAndroid_debug"})
public final class FabricUIManagerProviderImpl
implements UIManagerProvider {
    @NotNull
    private final ComponentFactory componentFactory;
    @NotNull
    private final ViewManagerRegistry viewManagerRegistry;

    public FabricUIManagerProviderImpl(@NotNull ComponentFactory componentFactory, @NotNull ViewManagerRegistry viewManagerRegistry2) {
        Intrinsics.checkNotNullParameter((Object)componentFactory, (String)"componentFactory");
        Intrinsics.checkNotNullParameter((Object)viewManagerRegistry2, (String)"viewManagerRegistry");
        this.componentFactory = componentFactory;
        this.viewManagerRegistry = viewManagerRegistry2;
    }

    @Override
    @NotNull
    public UIManager createUIManager(@NotNull ReactApplicationContext context) {
        RuntimeScheduler runtimeScheduler;
        CatalystInstance catalystInstance;
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        Systrace.beginSection(0L, "FabricUIManagerProviderImpl.create");
        EventBeatManager eventBeatManager = new EventBeatManager();
        Systrace.beginSection(0L, "FabricUIManagerProviderImpl.createUIManager");
        FabricUIManager fabricUIManager = new FabricUIManager(context, this.viewManagerRegistry, eventBeatManager);
        Systrace.endSection(0L);
        Systrace.beginSection(0L, "FabricUIManagerProviderImpl.registerBinding");
        FabricUIManagerBinding binding = new FabricUIManagerBinding();
        CatalystInstance catalystInstance2 = catalystInstance = context.getCatalystInstance();
        RuntimeExecutor runtimeExecutor = catalystInstance2 != null ? catalystInstance2.getRuntimeExecutor() : null;
        CatalystInstance catalystInstance3 = catalystInstance;
        RuntimeScheduler runtimeScheduler2 = runtimeScheduler = catalystInstance3 != null ? catalystInstance3.getRuntimeScheduler() : null;
        if (runtimeExecutor == null || runtimeScheduler == null) {
            throw new IllegalStateException("Unable to register FabricUIManager with CatalystInstance, runtimeExecutor and runtimeScheduler must not be null");
        }
        binding.register(runtimeExecutor, runtimeScheduler, fabricUIManager, eventBeatManager, this.componentFactory);
        Systrace.endSection(0L);
        Systrace.endSection(0L);
        return fabricUIManager;
    }
}

