/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.content.Context;
import androidx.annotation.Nullable;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.JSBundleLoader;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.common.SurfaceDelegateFactory;
import com.facebook.react.devsupport.DevSupportManagerBase;
import com.facebook.react.devsupport.HMRClient;
import com.facebook.react.devsupport.ReactInstanceDevHelper;
import com.facebook.react.devsupport.interfaces.DevBundleDownloadListener;
import com.facebook.react.devsupport.interfaces.DevLoadingViewManager;
import com.facebook.react.devsupport.interfaces.DevSplitBundleCallback;
import com.facebook.react.devsupport.interfaces.PausedInDebuggerOverlayManager;
import com.facebook.react.devsupport.interfaces.RedBoxHandler;
import com.facebook.react.packagerconnection.RequestHandler;
import java.util.Map;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
class BridgelessDevSupportManager
extends DevSupportManagerBase {
    public BridgelessDevSupportManager(Context context, ReactInstanceDevHelper reactInstanceManagerHelper, @Nullable String packagerPathForJSBundleName) {
        this(context.getApplicationContext(), reactInstanceManagerHelper, packagerPathForJSBundleName, true, null, null, 2, null, null, null, null);
    }

    public BridgelessDevSupportManager(Context applicationContext, ReactInstanceDevHelper reactInstanceManagerHelper, @Nullable String packagerPathForJSBundleName, boolean enableOnCreate, @Nullable RedBoxHandler redBoxHandler, @Nullable DevBundleDownloadListener devBundleDownloadListener, int minNumShakes, @Nullable Map<String, RequestHandler> customPackagerCommandHandlers, @Nullable SurfaceDelegateFactory surfaceDelegateFactory, @Nullable DevLoadingViewManager devLoadingViewManager, @Nullable PausedInDebuggerOverlayManager pausedInDebuggerOverlayManager) {
        super(applicationContext, reactInstanceManagerHelper, packagerPathForJSBundleName, enableOnCreate, redBoxHandler, devBundleDownloadListener, minNumShakes, customPackagerCommandHandlers, surfaceDelegateFactory, devLoadingViewManager, pausedInDebuggerOverlayManager);
    }

    @Override
    protected String getUniqueTag() {
        return "Bridgeless";
    }

    @Override
    public void loadSplitBundleFromServer(final String bundlePath, final DevSplitBundleCallback callback) {
        this.fetchSplitBundleAndCreateBundleLoader(bundlePath, new DevSupportManagerBase.CallbackWithBundleLoader(){

            @Override
            public void onSuccess(JSBundleLoader bundleLoader) {
                try {
                    BridgelessDevSupportManager.this.mReactInstanceDevHelper.loadBundle(bundleLoader).waitForCompletion();
                    String bundleURL = BridgelessDevSupportManager.this.getDevServerHelper().getDevServerSplitBundleURL(bundlePath);
                    ReactContext reactContext = BridgelessDevSupportManager.this.mReactInstanceDevHelper.getCurrentReactContext();
                    if (reactContext != null) {
                        reactContext.getJSModule(HMRClient.class).registerBundle(bundleURL);
                    }
                    callback.onSuccess();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("[BridgelessDevSupportManager]: Got interrupted while loading bundle", e);
                }
            }

            @Override
            public void onError(String url, Throwable cause) {
                callback.onError(url, cause);
            }
        });
    }

    @Override
    public void handleReloadJS() {
        UiThreadUtil.assertOnUiThread();
        this.hideRedboxDialog();
        this.mReactInstanceDevHelper.reload("BridgelessDevSupportManager.handleReloadJS()");
    }
}

