/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common.mapbuffer;

import android.util.SparseArray;
import com.facebook.proguard.annotations.DoNotStrip;
import com.facebook.react.common.mapbuffer.MapBuffer;
import java.util.Iterator;
import java.util.List;
import javax.annotation.concurrent.NotThreadSafe;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\u0010\t\n\u0002\u0010\u0006\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010(\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001-B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tJ\u0016\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\fJ\u0016\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\rJ\u0016\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000eJ\u0016\u0010\u0007\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0001J\u0018\u0010\u000f\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0014\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tH\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u001b\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u001c\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u001d\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\tH\u0016J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00010!2\u0006\u0010\b\u001a\u00020\tH\u0016J(\u0010\"\u001a\u0002H#\"\u0006\b\u0000\u0010#\u0018\u00012\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0006H\u0082\b\u00a2\u0006\u0002\u0010$J\u0014\u0010%\u001a\u00020\u0019*\u00020\u00062\u0006\u0010\b\u001a\u00020\tH\u0002J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00160'H\u0096\u0002J\b\u0010(\u001a\u00020)H\u0003J\u0013\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00060+H\u0003\u00a2\u0006\u0002\u0010,R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006."}, d2={"Lcom/facebook/react/common/mapbuffer/WritableMapBuffer;", "Lcom/facebook/react/common/mapbuffer/MapBuffer;", "<init>", "()V", "values", "Landroid/util/SparseArray;", "", "put", "key", "", "value", "", "", "", "", "putInternal", "count", "getCount", "()I", "contains", "getKeyOffset", "entryAt", "Lcom/facebook/react/common/mapbuffer/MapBuffer$Entry;", "offset", "getType", "Lcom/facebook/react/common/mapbuffer/MapBuffer$DataType;", "getBoolean", "getInt", "getLong", "getDouble", "getString", "getMapBuffer", "getMapBufferList", "", "verifyValue", "T", "(ILjava/lang/Object;)Ljava/lang/Object;", "dataType", "iterator", "", "getKeys", "", "getValues", "", "()[Ljava/lang/Object;", "MapBufferEntry", "ReactAndroid_debug"})
@NotThreadSafe
@DoNotStrip
@SourceDebugExtension(value={"SMAP\nWritableMapBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WritableMapBuffer.kt\ncom/facebook/react/common/mapbuffer/WritableMapBuffer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n131#1:197\n132#1,4:199\n131#1:203\n132#1,4:205\n131#1:209\n132#1,4:211\n131#1:215\n132#1,4:217\n131#1:221\n132#1,4:223\n131#1:227\n132#1,4:229\n131#1:233\n132#1,4:235\n1#2:196\n1#2:198\n1#2:204\n1#2:210\n1#2:216\n1#2:222\n1#2:228\n1#2:234\n*S KotlinDebug\n*F\n+ 1 WritableMapBuffer.kt\ncom/facebook/react/common/mapbuffer/WritableMapBuffer\n*L\n115#1:197\n115#1:199,4\n117#1:203\n117#1:205,4\n119#1:209\n119#1:211,4\n121#1:215\n121#1:217,4\n123#1:221\n123#1:223,4\n125#1:227\n125#1:229,4\n127#1:233\n127#1:235,4\n115#1:198\n117#1:204\n119#1:210\n121#1:216\n123#1:222\n125#1:228\n127#1:234\n*E\n"})
public final class WritableMapBuffer
implements MapBuffer {
    @NotNull
    private final SparseArray<Object> values = new SparseArray();

    @NotNull
    public final WritableMapBuffer put(int key, boolean value) {
        return this.putInternal(key, value);
    }

    @NotNull
    public final WritableMapBuffer put(int key, int value) {
        return this.putInternal(key, value);
    }

    @NotNull
    public final WritableMapBuffer put(int key, long value) {
        return this.putInternal(key, value);
    }

    @NotNull
    public final WritableMapBuffer put(int key, double value) {
        return this.putInternal(key, value);
    }

    @NotNull
    public final WritableMapBuffer put(int key, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.putInternal(key, value);
    }

    @NotNull
    public final WritableMapBuffer put(int key, @NotNull MapBuffer value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return this.putInternal(key, value);
    }

    private final WritableMapBuffer putInternal(int key, Object value) {
        IntRange intRange = MapBuffer.Companion.getKEY_RANGE$ReactAndroid_debug();
        int n = intRange.getFirst();
        if (!(key <= intRange.getLast() ? n <= key : false)) {
            boolean bl = false;
            String string = "Only integers in [0;65535] range are allowed for keys.";
            throw new IllegalArgumentException(string.toString());
        }
        this.values.put(key, value);
        return this;
    }

    @Override
    public int getCount() {
        return this.values.size();
    }

    @Override
    public boolean contains(int key) {
        return this.values.get(key) != null;
    }

    @Override
    public int getKeyOffset(int key) {
        return this.values.indexOfKey(key);
    }

    @Override
    @NotNull
    public MapBuffer.Entry entryAt(int offset) {
        return new MapBufferEntry(offset);
    }

    @Override
    @NotNull
    public MapBuffer.DataType getType(int key) {
        Object value = this.values.get(key);
        if (!(value != null)) {
            boolean bl = false;
            String string = "Key not found: " + key;
            throw new IllegalArgumentException(string.toString());
        }
        return this.dataType(value, key);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean getBoolean(int key) {
        void var3_3;
        WritableMapBuffer writableMapBuffer = this;
        Object value$iv = this.values.get(key);
        boolean $i$f$verifyValue = false;
        if (!(value$iv != null)) {
            boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
            String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + key;
            throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
        }
        if (!(value$iv instanceof Boolean)) {
            boolean bl = false;
            String string = "Expected " + Boolean.class + " for key: " + key + ", found " + value$iv.getClass() + " instead.";
            throw new IllegalStateException(string.toString());
        }
        return (Boolean)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getInt(int key) {
        void var3_3;
        WritableMapBuffer writableMapBuffer = this;
        Object value$iv = this.values.get(key);
        boolean $i$f$verifyValue = false;
        if (!(value$iv != null)) {
            boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
            String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + key;
            throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
        }
        if (!(value$iv instanceof Integer)) {
            boolean bl = false;
            String string = "Expected " + Integer.class + " for key: " + key + ", found " + value$iv.getClass() + " instead.";
            throw new IllegalStateException(string.toString());
        }
        return ((Number)var3_3).intValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getLong(int key) {
        void var3_3;
        WritableMapBuffer writableMapBuffer = this;
        Object value$iv = this.values.get(key);
        boolean $i$f$verifyValue = false;
        if (!(value$iv != null)) {
            boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
            String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + key;
            throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
        }
        if (!(value$iv instanceof Long)) {
            boolean bl = false;
            String string = "Expected " + Long.class + " for key: " + key + ", found " + value$iv.getClass() + " instead.";
            throw new IllegalStateException(string.toString());
        }
        return ((Number)var3_3).longValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public double getDouble(int key) {
        void var3_3;
        WritableMapBuffer writableMapBuffer = this;
        Object value$iv = this.values.get(key);
        boolean $i$f$verifyValue = false;
        if (!(value$iv != null)) {
            boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
            String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + key;
            throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
        }
        if (!(value$iv instanceof Double)) {
            boolean bl = false;
            String string = "Expected " + Double.class + " for key: " + key + ", found " + value$iv.getClass() + " instead.";
            throw new IllegalStateException(string.toString());
        }
        return ((Number)var3_3).doubleValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getString(int key) {
        void var3_3;
        WritableMapBuffer writableMapBuffer = this;
        Object value$iv = this.values.get(key);
        boolean $i$f$verifyValue = false;
        if (!(value$iv != null)) {
            boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
            String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + key;
            throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
        }
        if (!(value$iv instanceof String)) {
            boolean bl = false;
            String string = "Expected " + String.class + " for key: " + key + ", found " + value$iv.getClass() + " instead.";
            throw new IllegalStateException(string.toString());
        }
        return (String)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public MapBuffer getMapBuffer(int key) {
        void var3_3;
        WritableMapBuffer writableMapBuffer = this;
        Object value$iv = this.values.get(key);
        boolean $i$f$verifyValue = false;
        if (!(value$iv != null)) {
            boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
            String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + key;
            throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
        }
        if (!(value$iv instanceof MapBuffer)) {
            boolean bl = false;
            String string = "Expected " + MapBuffer.class + " for key: " + key + ", found " + value$iv.getClass() + " instead.";
            throw new IllegalStateException(string.toString());
        }
        return (MapBuffer)var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<MapBuffer> getMapBufferList(int key) {
        void var3_3;
        WritableMapBuffer writableMapBuffer = this;
        Object value$iv = this.values.get(key);
        boolean $i$f$verifyValue = false;
        if (!(value$iv != null)) {
            boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
            String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + key;
            throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
        }
        if (!(value$iv instanceof List)) {
            boolean bl = false;
            String string = "Expected " + List.class + " for key: " + key + ", found " + value$iv.getClass() + " instead.";
            throw new IllegalStateException(string.toString());
        }
        return (List)var3_3;
    }

    private final /* synthetic */ <T> T verifyValue(int key, Object value) {
        boolean $i$f$verifyValue = false;
        if (!(value != null)) {
            boolean $i$a$-require-WritableMapBuffer$verifyValue$22 = false;
            String $i$a$-require-WritableMapBuffer$verifyValue$22 = "Key not found: " + key;
            throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$22.toString());
        }
        Intrinsics.reifiedOperationMarker((int)3, (String)"T");
        if (!(value instanceof Object)) {
            boolean bl = false;
            Intrinsics.reifiedOperationMarker((int)4, (String)"T");
            String string = "Expected " + Object.class + " for key: " + key + ", found " + value.getClass() + " instead.";
            throw new IllegalStateException(string.toString());
        }
        return (T)value;
    }

    private final MapBuffer.DataType dataType(Object $this$dataType, int key) {
        MapBuffer.DataType dataType;
        Object value = $this$dataType;
        if (value instanceof Boolean) {
            dataType = MapBuffer.DataType.BOOL;
        } else if (value instanceof Integer) {
            dataType = MapBuffer.DataType.INT;
        } else if (value instanceof Long) {
            dataType = MapBuffer.DataType.LONG;
        } else if (value instanceof Double) {
            dataType = MapBuffer.DataType.DOUBLE;
        } else if (value instanceof String) {
            dataType = MapBuffer.DataType.STRING;
        } else if (value instanceof MapBuffer) {
            dataType = MapBuffer.DataType.MAP;
        } else {
            throw new IllegalStateException("Key " + key + " has value of unknown type: " + value.getClass());
        }
        return dataType;
    }

    @Override
    @NotNull
    public Iterator<MapBuffer.Entry> iterator() {
        return new Iterator<MapBuffer.Entry>(this){
            private int count;
            final /* synthetic */ WritableMapBuffer this$0;
            {
                this.this$0 = $receiver;
            }

            public final int getCount() {
                return this.count;
            }

            public final void setCount(int n) {
                this.count = n;
            }

            public boolean hasNext() {
                return this.count < WritableMapBuffer.access$getValues$p(this.this$0).size();
            }

            public MapBuffer.Entry next() {
                int n = this.count;
                this.count = n + 1;
                return this.this$0.new MapBufferEntry(n);
            }

            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        };
    }

    @DoNotStrip
    private final int[] getKeys() {
        int n = 0;
        int n2 = this.values.size();
        int[] nArray = new int[n2];
        while (n < n2) {
            int n3 = n++;
            nArray[n3] = this.values.keyAt(n3);
        }
        return nArray;
    }

    @DoNotStrip
    private final Object[] getValues() {
        int n = 0;
        int n2 = this.values.size();
        Object[] objectArray = new Object[n2];
        while (n < n2) {
            int n3 = n++;
            Intrinsics.checkNotNullExpressionValue((Object)this.values.valueAt(n3), (String)"valueAt(...)");
        }
        return objectArray;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\bR\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006#"}, d2={"Lcom/facebook/react/common/mapbuffer/WritableMapBuffer$MapBufferEntry;", "Lcom/facebook/react/common/mapbuffer/MapBuffer$Entry;", "index", "", "<init>", "(Lcom/facebook/react/common/mapbuffer/WritableMapBuffer;I)V", "key", "getKey", "()I", "type", "Lcom/facebook/react/common/mapbuffer/MapBuffer$DataType;", "getType", "()Lcom/facebook/react/common/mapbuffer/MapBuffer$DataType;", "booleanValue", "", "getBooleanValue", "()Z", "intValue", "getIntValue", "longValue", "", "getLongValue", "()J", "doubleValue", "", "getDoubleValue", "()D", "stringValue", "", "getStringValue", "()Ljava/lang/String;", "mapBufferValue", "Lcom/facebook/react/common/mapbuffer/MapBuffer;", "getMapBufferValue", "()Lcom/facebook/react/common/mapbuffer/MapBuffer;", "ReactAndroid_debug"})
    @SourceDebugExtension(value={"SMAP\nWritableMapBuffer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WritableMapBuffer.kt\ncom/facebook/react/common/mapbuffer/WritableMapBuffer$MapBufferEntry\n+ 2 WritableMapBuffer.kt\ncom/facebook/react/common/mapbuffer/WritableMapBuffer\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,195:1\n131#2:196\n132#2,4:198\n131#2:202\n132#2,4:204\n131#2:208\n132#2,4:210\n131#2:214\n132#2,4:216\n131#2:220\n132#2,4:222\n131#2:226\n132#2,4:228\n1#3:197\n1#3:203\n1#3:209\n1#3:215\n1#3:221\n1#3:227\n*S KotlinDebug\n*F\n+ 1 WritableMapBuffer.kt\ncom/facebook/react/common/mapbuffer/WritableMapBuffer$MapBufferEntry\n*L\n163#1:196\n163#1:198,4\n166#1:202\n166#1:204,4\n169#1:208\n169#1:210,4\n172#1:214\n172#1:216,4\n175#1:220\n175#1:222,4\n178#1:226\n178#1:228,4\n163#1:197\n166#1:203\n169#1:209\n172#1:215\n175#1:221\n178#1:227\n*E\n"})
    private final class MapBufferEntry
    implements MapBuffer.Entry {
        private final int index;
        private final int key;
        @NotNull
        private final MapBuffer.DataType type;

        public MapBufferEntry(int index) {
            this.index = index;
            this.key = WritableMapBuffer.this.values.keyAt(this.index);
            Object object = WritableMapBuffer.this.values.valueAt(this.index);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"valueAt(...)");
            this.type = WritableMapBuffer.this.dataType(object, this.getKey());
        }

        @Override
        public int getKey() {
            return this.key;
        }

        @Override
        @NotNull
        public MapBuffer.DataType getType() {
            return this.type;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean getBooleanValue() {
            void var3_3;
            void key$iv;
            WritableMapBuffer writableMapBuffer = WritableMapBuffer.this;
            int n = this.getKey();
            Object value$iv = WritableMapBuffer.this.values.valueAt(this.index);
            boolean $i$f$verifyValue = false;
            if (!(value$iv != null)) {
                boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
                String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + (int)key$iv;
                throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
            }
            if (!(value$iv instanceof Boolean)) {
                boolean bl = false;
                String string = "Expected " + Boolean.class + " for key: " + (int)key$iv + ", found " + value$iv.getClass() + " instead.";
                throw new IllegalStateException(string.toString());
            }
            return (Boolean)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int getIntValue() {
            void var3_3;
            void key$iv;
            WritableMapBuffer writableMapBuffer = WritableMapBuffer.this;
            int n = this.getKey();
            Object value$iv = WritableMapBuffer.this.values.valueAt(this.index);
            boolean $i$f$verifyValue = false;
            if (!(value$iv != null)) {
                boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
                String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + (int)key$iv;
                throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
            }
            if (!(value$iv instanceof Integer)) {
                boolean bl = false;
                String string = "Expected " + Integer.class + " for key: " + (int)key$iv + ", found " + value$iv.getClass() + " instead.";
                throw new IllegalStateException(string.toString());
            }
            return ((Number)var3_3).intValue();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public long getLongValue() {
            void var3_3;
            void key$iv;
            WritableMapBuffer writableMapBuffer = WritableMapBuffer.this;
            int n = this.getKey();
            Object value$iv = WritableMapBuffer.this.values.valueAt(this.index);
            boolean $i$f$verifyValue = false;
            if (!(value$iv != null)) {
                boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
                String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + (int)key$iv;
                throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
            }
            if (!(value$iv instanceof Long)) {
                boolean bl = false;
                String string = "Expected " + Long.class + " for key: " + (int)key$iv + ", found " + value$iv.getClass() + " instead.";
                throw new IllegalStateException(string.toString());
            }
            return ((Number)var3_3).longValue();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public double getDoubleValue() {
            void var3_3;
            void key$iv;
            WritableMapBuffer writableMapBuffer = WritableMapBuffer.this;
            int n = this.getKey();
            Object value$iv = WritableMapBuffer.this.values.valueAt(this.index);
            boolean $i$f$verifyValue = false;
            if (!(value$iv != null)) {
                boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
                String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + (int)key$iv;
                throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
            }
            if (!(value$iv instanceof Double)) {
                boolean bl = false;
                String string = "Expected " + Double.class + " for key: " + (int)key$iv + ", found " + value$iv.getClass() + " instead.";
                throw new IllegalStateException(string.toString());
            }
            return ((Number)var3_3).doubleValue();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public String getStringValue() {
            void var3_3;
            void key$iv;
            WritableMapBuffer writableMapBuffer = WritableMapBuffer.this;
            int n = this.getKey();
            Object value$iv = WritableMapBuffer.this.values.valueAt(this.index);
            boolean $i$f$verifyValue = false;
            if (!(value$iv != null)) {
                boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
                String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + (int)key$iv;
                throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
            }
            if (!(value$iv instanceof String)) {
                boolean bl = false;
                String string = "Expected " + String.class + " for key: " + (int)key$iv + ", found " + value$iv.getClass() + " instead.";
                throw new IllegalStateException(string.toString());
            }
            return (String)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public MapBuffer getMapBufferValue() {
            void var3_3;
            void key$iv;
            WritableMapBuffer writableMapBuffer = WritableMapBuffer.this;
            int n = this.getKey();
            Object value$iv = WritableMapBuffer.this.values.valueAt(this.index);
            boolean $i$f$verifyValue = false;
            if (!(value$iv != null)) {
                boolean $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = false;
                String $i$a$-require-WritableMapBuffer$verifyValue$1$iv22 = "Key not found: " + (int)key$iv;
                throw new IllegalArgumentException($i$a$-require-WritableMapBuffer$verifyValue$1$iv22.toString());
            }
            if (!(value$iv instanceof MapBuffer)) {
                boolean bl = false;
                String string = "Expected " + MapBuffer.class + " for key: " + (int)key$iv + ", found " + value$iv.getClass() + " instead.";
                throw new IllegalStateException(string.toString());
            }
            return (MapBuffer)var3_3;
        }
    }
}

