/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge.queue;

import android.os.Looper;
import com.facebook.react.bridge.queue.MessageQueueThread;
import com.facebook.react.bridge.queue.MessageQueueThreadImpl;
import com.facebook.react.bridge.queue.MessageQueueThreadSpec;
import com.facebook.react.bridge.queue.QueueThreadExceptionHandler;
import com.facebook.react.bridge.queue.ReactQueueConfiguration;
import com.facebook.react.bridge.queue.ReactQueueConfigurationSpec;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB!\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J\b\u0010\u000b\u001a\u00020\tH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/facebook/react/bridge/queue/ReactQueueConfigurationImpl;", "Lcom/facebook/react/bridge/queue/ReactQueueConfiguration;", "uiQueueThread", "Lcom/facebook/react/bridge/queue/MessageQueueThreadImpl;", "nativeModulesQueueThread", "jsQueueThread", "<init>", "(Lcom/facebook/react/bridge/queue/MessageQueueThreadImpl;Lcom/facebook/react/bridge/queue/MessageQueueThreadImpl;Lcom/facebook/react/bridge/queue/MessageQueueThreadImpl;)V", "getUIQueueThread", "Lcom/facebook/react/bridge/queue/MessageQueueThread;", "getNativeModulesQueueThread", "getJSQueueThread", "destroy", "", "Companion", "ReactAndroid_debug"})
public final class ReactQueueConfigurationImpl
implements ReactQueueConfiguration {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final MessageQueueThreadImpl uiQueueThread;
    @NotNull
    private final MessageQueueThreadImpl nativeModulesQueueThread;
    @NotNull
    private final MessageQueueThreadImpl jsQueueThread;

    private ReactQueueConfigurationImpl(MessageQueueThreadImpl uiQueueThread, MessageQueueThreadImpl nativeModulesQueueThread, MessageQueueThreadImpl jsQueueThread) {
        this.uiQueueThread = uiQueueThread;
        this.nativeModulesQueueThread = nativeModulesQueueThread;
        this.jsQueueThread = jsQueueThread;
    }

    @Override
    @NotNull
    public MessageQueueThread getUIQueueThread() {
        return this.uiQueueThread;
    }

    @Override
    @NotNull
    public MessageQueueThread getNativeModulesQueueThread() {
        return this.nativeModulesQueueThread;
    }

    @Override
    @NotNull
    public MessageQueueThread getJSQueueThread() {
        return this.jsQueueThread;
    }

    @Override
    public void destroy() {
        if (!Intrinsics.areEqual((Object)this.nativeModulesQueueThread.getLooper(), (Object)Looper.getMainLooper())) {
            this.nativeModulesQueueThread.quitSynchronous();
        }
        if (!Intrinsics.areEqual((Object)this.jsQueueThread.getLooper(), (Object)Looper.getMainLooper())) {
            this.jsQueueThread.quitSynchronous();
        }
    }

    @JvmStatic
    @NotNull
    public static final ReactQueueConfigurationImpl create(@NotNull ReactQueueConfigurationSpec spec, @NotNull QueueThreadExceptionHandler exceptionHandler) {
        return Companion.create(spec, exceptionHandler);
    }

    public /* synthetic */ ReactQueueConfigurationImpl(MessageQueueThreadImpl uiQueueThread, MessageQueueThreadImpl nativeModulesQueueThread, MessageQueueThreadImpl jsQueueThread, DefaultConstructorMarker $constructor_marker) {
        this(uiQueueThread, nativeModulesQueueThread, jsQueueThread);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007\u00a8\u0006\n"}, d2={"Lcom/facebook/react/bridge/queue/ReactQueueConfigurationImpl$Companion;", "", "<init>", "()V", "create", "Lcom/facebook/react/bridge/queue/ReactQueueConfigurationImpl;", "spec", "Lcom/facebook/react/bridge/queue/ReactQueueConfigurationSpec;", "exceptionHandler", "Lcom/facebook/react/bridge/queue/QueueThreadExceptionHandler;", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ReactQueueConfigurationImpl create(@NotNull ReactQueueConfigurationSpec spec, @NotNull QueueThreadExceptionHandler exceptionHandler) {
            Intrinsics.checkNotNullParameter((Object)spec, (String)"spec");
            Intrinsics.checkNotNullParameter((Object)exceptionHandler, (String)"exceptionHandler");
            MessageQueueThreadImpl uiThread = MessageQueueThreadImpl.Companion.create(MessageQueueThreadSpec.Companion.mainThreadSpec(), exceptionHandler);
            MessageQueueThreadImpl jsThread = MessageQueueThreadImpl.Companion.create(spec.getJSQueueThreadSpec(), exceptionHandler);
            MessageQueueThreadImpl nativeModulesThread = MessageQueueThreadImpl.Companion.create(spec.getNativeModulesQueueThreadSpec(), exceptionHandler);
            return new ReactQueueConfigurationImpl(uiThread, nativeModulesThread, jsThread, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

