/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.view;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.BlendMode;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewStructure;
import android.view.animation.Animation;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.R;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.touch.OnInterceptTouchEventListener;
import com.facebook.react.touch.ReactHitSlopView;
import com.facebook.react.touch.ReactInterceptingViewGroup;
import com.facebook.react.uimanager.BackgroundStyleApplicator;
import com.facebook.react.uimanager.BlendModeHelper;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.LengthPercentageType;
import com.facebook.react.uimanager.MeasureSpecAssertions;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactClippingProhibitedView;
import com.facebook.react.uimanager.ReactClippingViewGroup;
import com.facebook.react.uimanager.ReactClippingViewGroupHelper;
import com.facebook.react.uimanager.ReactOverflowViewWithInset;
import com.facebook.react.uimanager.ReactPointerEventsView;
import com.facebook.react.uimanager.ReactZIndexedViewGroup;
import com.facebook.react.uimanager.ViewGroupDrawingOrderHelper;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.BorderStyle;
import com.facebook.react.uimanager.style.LogicalEdge;
import com.facebook.react.uimanager.style.Overflow;
import com.facebook.react.views.view.CanvasUtil;
import java.util.HashSet;
import java.util.Set;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class ReactViewGroup
extends ViewGroup
implements ReactInterceptingViewGroup,
ReactClippingViewGroup,
ReactPointerEventsView,
ReactHitSlopView,
ReactZIndexedViewGroup,
ReactOverflowViewWithInset {
    private static final int ARRAY_CAPACITY_INCREMENT = 12;
    private static final ViewGroup.LayoutParams sDefaultLayoutParam = new ViewGroup.LayoutParams(0, 0);
    private final Rect mOverflowInset = new Rect();
    private int mRecycleCount = 0;
    private boolean mRemoveClippedSubviews;
    private volatile boolean mInSubviewClippingLoop;
    @Nullable
    private View[] mAllChildren;
    private int mAllChildrenCount;
    @Nullable
    private Rect mClippingRect;
    @Nullable
    private Rect mHitSlopRect;
    private Overflow mOverflow;
    private PointerEvents mPointerEvents = PointerEvents.AUTO;
    @Nullable
    private ChildrenLayoutChangeListener mChildrenLayoutChangeListener;
    @Nullable
    private OnInterceptTouchEventListener mOnInterceptTouchEventListener;
    private boolean mNeedsOffscreenAlphaCompositing;
    @Nullable
    private ViewGroupDrawingOrderHelper mDrawingOrderHelper;
    private float mBackfaceOpacity;
    private boolean mBackfaceVisible;
    @Nullable
    private Set<Integer> mChildrenRemovedWhileTransitioning;

    public ReactViewGroup(@Nullable Context context) {
        super(context);
        this.initView();
    }

    private void initView() {
        this.setClipChildren(false);
        this.mRemoveClippedSubviews = false;
        this.mInSubviewClippingLoop = false;
        this.mAllChildren = null;
        this.mAllChildrenCount = 0;
        this.mClippingRect = null;
        this.mHitSlopRect = null;
        this.mOverflow = Overflow.VISIBLE;
        this.mPointerEvents = PointerEvents.AUTO;
        this.mChildrenLayoutChangeListener = null;
        this.mOnInterceptTouchEventListener = null;
        this.mNeedsOffscreenAlphaCompositing = false;
        this.mDrawingOrderHelper = null;
        this.mBackfaceOpacity = 1.0f;
        this.mBackfaceVisible = true;
        this.mChildrenRemovedWhileTransitioning = null;
    }

    void recycleView() {
        ++this.mRecycleCount;
        if (this.mAllChildren != null && this.mChildrenLayoutChangeListener != null) {
            this.mChildrenLayoutChangeListener.shutdown();
            for (int i = 0; i < this.mAllChildrenCount; ++i) {
                this.mAllChildren[i].removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.mChildrenLayoutChangeListener);
            }
        }
        this.initView();
        this.mOverflowInset.setEmpty();
        this.removeAllViews();
        this.updateBackgroundDrawable(null);
        this.resetPointerEvents();
    }

    private ViewGroupDrawingOrderHelper getDrawingOrderHelper() {
        if (this.mDrawingOrderHelper == null) {
            this.mDrawingOrderHelper = new ViewGroupDrawingOrderHelper(this);
        }
        return this.mDrawingOrderHelper;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        MeasureSpecAssertions.assertExplicitMeasureSpec(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(View.MeasureSpec.getSize((int)widthMeasureSpec), View.MeasureSpec.getSize((int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
    }

    @SuppressLint(value={"MissingSuperCall"})
    public void requestLayout() {
    }

    @TargetApi(value=23)
    public void dispatchProvideStructure(ViewStructure structure) {
        try {
            super.dispatchProvideStructure(structure);
        }
        catch (NullPointerException e) {
            FLog.e((String)"ReactNative", (String)"NullPointerException when executing dispatchProvideStructure", (Throwable)e);
        }
    }

    public void setBackgroundColor(int color) {
        BackgroundStyleApplicator.setBackgroundColor((View)this, color);
    }

    @Deprecated(since="0.76.0", forRemoval=true)
    public void setTranslucentBackgroundDrawable(@Nullable Drawable background) {
        BackgroundStyleApplicator.setFeedbackUnderlay((View)this, background);
    }

    @Override
    public void setOnInterceptTouchEventListener(OnInterceptTouchEventListener listener) {
        this.mOnInterceptTouchEventListener = listener;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (this.mOnInterceptTouchEventListener != null && this.mOnInterceptTouchEventListener.onInterceptTouchEvent(this, ev)) {
            return true;
        }
        if (!PointerEvents.canChildrenBeTouchTarget(this.mPointerEvents)) {
            return true;
        }
        return super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent event) {
        return PointerEvents.canBeTouchTarget(this.mPointerEvents);
    }

    public boolean onHoverEvent(MotionEvent event) {
        if (ReactFeatureFlags.dispatchPointerEvents) {
            return PointerEvents.canBeTouchTarget(this.mPointerEvents);
        }
        return super.onHoverEvent(event);
    }

    public boolean dispatchGenericMotionEvent(MotionEvent ev) {
        if (!PointerEvents.canChildrenBeTouchTarget(this.mPointerEvents)) {
            return false;
        }
        return super.dispatchGenericMotionEvent(ev);
    }

    public boolean hasOverlappingRendering() {
        return this.mNeedsOffscreenAlphaCompositing;
    }

    public void setNeedsOffscreenAlphaCompositing(boolean needsOffscreenAlphaCompositing) {
        this.mNeedsOffscreenAlphaCompositing = needsOffscreenAlphaCompositing;
    }

    public void setBorderWidth(int position, float width) {
        BackgroundStyleApplicator.setBorderWidth((View)this, LogicalEdge.values()[position], Float.valueOf(PixelUtil.toDIPFromPixel(width)));
    }

    public void setBorderColor(int position, @Nullable Integer color) {
        BackgroundStyleApplicator.setBorderColor((View)this, LogicalEdge.values()[position], color);
    }

    @Deprecated(since="0.75.0", forRemoval=true)
    public void setBorderRadius(float borderRadius) {
        this.setBorderRadius(borderRadius, BorderRadiusProp.BORDER_RADIUS.ordinal());
    }

    @Deprecated(since="0.75.0", forRemoval=true)
    public void setBorderRadius(float borderRadius, int position) {
        LengthPercentage radius = Float.isNaN(borderRadius) ? null : new LengthPercentage(borderRadius, LengthPercentageType.POINT);
        BackgroundStyleApplicator.setBorderRadius((View)this, BorderRadiusProp.values()[position], radius);
    }

    public void setBorderRadius(BorderRadiusProp property, @Nullable LengthPercentage borderRadius) {
        BackgroundStyleApplicator.setBorderRadius((View)this, property, borderRadius);
    }

    public void setBorderStyle(@Nullable String style2) {
        BackgroundStyleApplicator.setBorderStyle((View)this, style2 == null ? null : BorderStyle.fromString(style2));
    }

    @Override
    public void setRemoveClippedSubviews(boolean removeClippedSubviews) {
        if (removeClippedSubviews == this.mRemoveClippedSubviews) {
            return;
        }
        this.mRemoveClippedSubviews = removeClippedSubviews;
        this.mChildrenRemovedWhileTransitioning = null;
        if (removeClippedSubviews) {
            this.mClippingRect = new Rect();
            ReactClippingViewGroupHelper.calculateClippingRect((View)this, this.mClippingRect);
            this.mAllChildrenCount = this.getChildCount();
            int initialSize = Math.max(12, this.mAllChildrenCount);
            this.mAllChildren = new View[initialSize];
            this.mChildrenLayoutChangeListener = new ChildrenLayoutChangeListener(this);
            for (int i = 0; i < this.mAllChildrenCount; ++i) {
                View child;
                this.mAllChildren[i] = child = this.getChildAt(i);
                child.addOnLayoutChangeListener((View.OnLayoutChangeListener)this.mChildrenLayoutChangeListener);
                ReactViewGroup.setViewClipped(child, false);
            }
            this.updateClippingRect();
        } else {
            Assertions.assertNotNull((Object)this.mClippingRect);
            Assertions.assertNotNull((Object)this.mAllChildren);
            Assertions.assertNotNull((Object)this.mChildrenLayoutChangeListener);
            for (int i = 0; i < this.mAllChildrenCount; ++i) {
                this.mAllChildren[i].removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.mChildrenLayoutChangeListener);
            }
            this.getDrawingRect(this.mClippingRect);
            this.updateClippingToRect(this.mClippingRect);
            this.mAllChildren = null;
            this.mClippingRect = null;
            this.mAllChildrenCount = 0;
            this.mChildrenLayoutChangeListener = null;
        }
    }

    @Override
    public boolean getRemoveClippedSubviews() {
        return this.mRemoveClippedSubviews;
    }

    @Override
    public void getClippingRect(Rect outClippingRect) {
        outClippingRect.set((Rect)Assertions.nullsafeFIXME((Object)this.mClippingRect, (String)"Fix in Kotlin"));
    }

    @Override
    public void updateClippingRect() {
        if (!this.mRemoveClippedSubviews) {
            return;
        }
        Assertions.assertNotNull((Object)this.mClippingRect);
        Assertions.assertNotNull((Object)this.mAllChildren);
        ReactClippingViewGroupHelper.calculateClippingRect((View)this, this.mClippingRect);
        this.updateClippingToRect(this.mClippingRect);
    }

    public void endViewTransition(View view) {
        super.endViewTransition(view);
        if (this.mChildrenRemovedWhileTransitioning != null) {
            this.mChildrenRemovedWhileTransitioning.remove(view.getId());
        }
    }

    private void trackChildViewTransition(int childId) {
        if (this.mChildrenRemovedWhileTransitioning == null) {
            this.mChildrenRemovedWhileTransitioning = new HashSet<Integer>();
        }
        this.mChildrenRemovedWhileTransitioning.add(childId);
    }

    private boolean isChildRemovedWhileTransitioning(View child) {
        return this.mChildrenRemovedWhileTransitioning != null && this.mChildrenRemovedWhileTransitioning.contains(child.getId());
    }

    private void updateClippingToRect(Rect clippingRect) {
        Assertions.assertNotNull((Object)this.mAllChildren);
        this.mInSubviewClippingLoop = true;
        int clippedSoFar = 0;
        for (int i = 0; i < this.mAllChildrenCount; ++i) {
            try {
                this.updateSubviewClipStatus(clippingRect, i, clippedSoFar);
            }
            catch (IndexOutOfBoundsException e) {
                int realClippedSoFar = 0;
                HashSet<View> uniqueViews = new HashSet<View>();
                for (int j = 0; j < i; ++j) {
                    realClippedSoFar += this.isViewClipped(this.mAllChildren[j], null) ? 1 : 0;
                    uniqueViews.add(this.mAllChildren[j]);
                }
                throw new IllegalStateException("Invalid clipping state. i=" + i + " clippedSoFar=" + clippedSoFar + " count=" + this.getChildCount() + " allChildrenCount=" + this.mAllChildrenCount + " recycleCount=" + this.mRecycleCount + " realClippedSoFar=" + realClippedSoFar + " uniqueViewsCount=" + uniqueViews.size(), e);
            }
            if (!this.isViewClipped(this.mAllChildren[i], i)) continue;
            ++clippedSoFar;
        }
        this.mInSubviewClippingLoop = false;
    }

    private void updateSubviewClipStatus(Rect clippingRect, int idx, int clippedSoFar) {
        ReactClippingViewGroup clippingChild;
        boolean isAnimating;
        UiThreadUtil.assertOnUiThread();
        View child = ((View[])Assertions.assertNotNull((Object)this.mAllChildren))[idx];
        boolean intersects = clippingRect.intersects(child.getLeft(), child.getTop(), child.getRight(), child.getBottom());
        boolean needUpdateClippingRecursive = false;
        Animation animation = child.getAnimation();
        boolean bl = isAnimating = animation != null && !animation.hasEnded();
        if (!(intersects || this.isViewClipped(child, idx) || isAnimating)) {
            ReactViewGroup.setViewClipped(child, true);
            this.removeViewInLayout(child);
            needUpdateClippingRecursive = true;
        } else if (intersects && this.isViewClipped(child, idx)) {
            int adjustedIdx = idx - clippedSoFar;
            Assertions.assertCondition((adjustedIdx >= 0 ? 1 : 0) != 0);
            ReactViewGroup.setViewClipped(child, false);
            this.addViewInLayout(child, adjustedIdx, sDefaultLayoutParam, true);
            this.invalidate();
            needUpdateClippingRecursive = true;
        } else if (intersects) {
            needUpdateClippingRecursive = true;
        }
        if (needUpdateClippingRecursive && child instanceof ReactClippingViewGroup && (clippingChild = (ReactClippingViewGroup)child).getRemoveClippedSubviews()) {
            clippingChild.updateClippingRect();
        }
    }

    private void updateSubviewClipStatus(View subview) {
        boolean oldIntersects;
        if (!this.mRemoveClippedSubviews || this.getParent() == null) {
            return;
        }
        Assertions.assertNotNull((Object)this.mClippingRect);
        Assertions.assertNotNull((Object)this.mAllChildren);
        boolean intersects = this.mClippingRect.intersects(subview.getLeft(), subview.getTop(), subview.getRight(), subview.getBottom());
        boolean bl = oldIntersects = !this.isViewClipped(subview, null);
        if (intersects != oldIntersects) {
            this.mInSubviewClippingLoop = true;
            int clippedSoFar = 0;
            for (int i = 0; i < this.mAllChildrenCount; ++i) {
                if (this.mAllChildren[i] == subview) {
                    this.updateSubviewClipStatus(this.mClippingRect, i, clippedSoFar);
                    break;
                }
                if (!this.isViewClipped(this.mAllChildren[i], i)) continue;
                ++clippedSoFar;
            }
            this.mInSubviewClippingLoop = false;
        }
    }

    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (this.mRemoveClippedSubviews) {
            this.updateClippingRect();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mRemoveClippedSubviews) {
            this.updateClippingRect();
        }
    }

    private boolean customDrawOrderDisabled() {
        if (this.getId() == -1) {
            return false;
        }
        return ViewUtil.getUIManagerType(this.getId()) == 2;
    }

    public void onViewAdded(View child) {
        UiThreadUtil.assertOnUiThread();
        this.checkViewClippingTag(child, Boolean.FALSE);
        if (!this.customDrawOrderDisabled()) {
            this.getDrawingOrderHelper().handleAddView(child);
            this.setChildrenDrawingOrderEnabled(this.getDrawingOrderHelper().shouldEnableCustomDrawingOrder());
        } else {
            this.setChildrenDrawingOrderEnabled(false);
        }
        super.onViewAdded(child);
    }

    public void onViewRemoved(View child) {
        UiThreadUtil.assertOnUiThread();
        this.checkViewClippingTag(child, Boolean.TRUE);
        if (!this.customDrawOrderDisabled()) {
            if (this.indexOfChild(child) == -1) {
                return;
            }
            this.getDrawingOrderHelper().handleRemoveView(child);
            this.setChildrenDrawingOrderEnabled(this.getDrawingOrderHelper().shouldEnableCustomDrawingOrder());
        } else {
            this.setChildrenDrawingOrderEnabled(false);
        }
        if (child.getParent() != null) {
            this.trackChildViewTransition(child.getId());
        }
        super.onViewRemoved(child);
    }

    private void checkViewClippingTag(View child, Boolean expectedTag) {
        Object tag;
        if (this.mInSubviewClippingLoop && !expectedTag.equals(tag = child.getTag(R.id.view_clipped))) {
            ReactSoftExceptionLogger.logSoftException("ReactViewGroup.onViewRemoved", new ReactNoCrashSoftException("View clipping tag mismatch: tag=" + tag + " expected=" + expectedTag));
        }
        if (this.mRemoveClippedSubviews) {
            child.setTag(R.id.view_clipped, (Object)expectedTag);
        }
    }

    protected int getChildDrawingOrder(int childCount, int index) {
        UiThreadUtil.assertOnUiThread();
        if (!this.customDrawOrderDisabled()) {
            return this.getDrawingOrderHelper().getChildDrawingOrder(childCount, index);
        }
        return index;
    }

    @Override
    public int getZIndexMappedChildIndex(int index) {
        UiThreadUtil.assertOnUiThread();
        if (!this.customDrawOrderDisabled() && this.getDrawingOrderHelper().shouldEnableCustomDrawingOrder()) {
            return this.getDrawingOrderHelper().getChildDrawingOrder(this.getChildCount(), index);
        }
        return index;
    }

    @Override
    public void updateDrawingOrder() {
        if (this.customDrawOrderDisabled()) {
            return;
        }
        this.getDrawingOrderHelper().update();
        this.setChildrenDrawingOrderEnabled(this.getDrawingOrderHelper().shouldEnableCustomDrawingOrder());
        this.invalidate();
    }

    @Override
    public PointerEvents getPointerEvents() {
        return this.mPointerEvents;
    }

    protected void dispatchSetPressed(boolean pressed) {
    }

    public void setPointerEvents(PointerEvents pointerEvents) {
        this.mPointerEvents = pointerEvents;
    }

    void resetPointerEvents() {
        this.mPointerEvents = PointerEvents.AUTO;
    }

    int getAllChildrenCount() {
        return this.mAllChildrenCount;
    }

    @Nullable
    View getChildAtWithSubviewClippingEnabled(int index) {
        return index >= 0 && index < this.mAllChildrenCount ? ((View[])Assertions.assertNotNull((Object)this.mAllChildren))[index] : null;
    }

    void addViewWithSubviewClippingEnabled(View child, int index) {
        this.addViewWithSubviewClippingEnabled(child, index, sDefaultLayoutParam);
    }

    void addViewWithSubviewClippingEnabled(final View child, int index, ViewGroup.LayoutParams params) {
        Assertions.assertCondition((boolean)this.mRemoveClippedSubviews);
        ReactViewGroup.setViewClipped(child, true);
        this.addInArray(child, index);
        Rect clippingRect = (Rect)Assertions.assertNotNull((Object)this.mClippingRect);
        View[] childArray = (View[])Assertions.assertNotNull((Object)this.mAllChildren);
        this.mInSubviewClippingLoop = true;
        int clippedSoFar = 0;
        for (int i = 0; i < index; ++i) {
            if (!this.isViewClipped(childArray[i], i)) continue;
            ++clippedSoFar;
        }
        this.updateSubviewClipStatus(clippingRect, index, clippedSoFar);
        this.mInSubviewClippingLoop = false;
        child.addOnLayoutChangeListener((View.OnLayoutChangeListener)this.mChildrenLayoutChangeListener);
        if (child instanceof ReactClippingProhibitedView) {
            UiThreadUtil.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    if (!child.isShown()) {
                        ReactSoftExceptionLogger.logSoftException("ReactNative", new ReactNoCrashSoftException("Child view has been added to Parent view in which it is clipped and not visible. This is not legal for this particular child view. Child: [" + child.getId() + "] " + child.toString() + " Parent: [" + ReactViewGroup.this.getId() + "] " + this.toString()));
                    }
                }
            });
        }
    }

    void removeViewWithSubviewClippingEnabled(View view) {
        UiThreadUtil.assertOnUiThread();
        Assertions.assertCondition((boolean)this.mRemoveClippedSubviews);
        Assertions.assertNotNull((Object)this.mClippingRect);
        View[] childArray = (View[])Assertions.assertNotNull((Object)this.mAllChildren);
        view.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.mChildrenLayoutChangeListener);
        int index = this.indexOfChildInAllChildren(view);
        if (!this.isViewClipped(childArray[index], index)) {
            int clippedSoFar = 0;
            for (int i = 0; i < index; ++i) {
                if (!this.isViewClipped(childArray[i], i)) continue;
                ++clippedSoFar;
            }
            this.removeViewsInLayout(index - clippedSoFar, 1);
            this.invalidate();
        }
        this.removeFromArray(index);
    }

    void removeAllViewsWithSubviewClippingEnabled() {
        Assertions.assertCondition((boolean)this.mRemoveClippedSubviews);
        View[] childArray = (View[])Assertions.assertNotNull((Object)this.mAllChildren);
        for (int i = 0; i < this.mAllChildrenCount; ++i) {
            childArray[i].removeOnLayoutChangeListener((View.OnLayoutChangeListener)this.mChildrenLayoutChangeListener);
        }
        this.removeAllViewsInLayout();
        this.mAllChildrenCount = 0;
    }

    private boolean isViewClipped(View view, @Nullable Integer index) {
        Object tag = view.getTag(R.id.view_clipped);
        if (tag != null) {
            return (Boolean)tag;
        }
        ViewParent parent = view.getParent();
        boolean transitioning = this.isChildRemovedWhileTransitioning(view);
        if (index != null) {
            ReactSoftExceptionLogger.logSoftException("ReactViewGroup.isViewClipped", new ReactNoCrashSoftException("View missing clipping tag: index=" + index + " parentNull=" + (parent == null) + " parentThis=" + (parent == this) + " transitioning=" + transitioning));
        }
        if (parent == null || transitioning) {
            return true;
        }
        Assertions.assertCondition((parent == this ? 1 : 0) != 0);
        return false;
    }

    private static void setViewClipped(View view, boolean clipped) {
        view.setTag(R.id.view_clipped, (Object)clipped);
    }

    private int indexOfChildInAllChildren(View child) {
        int count = this.mAllChildrenCount;
        View[] childArray = (View[])Assertions.assertNotNull((Object)this.mAllChildren);
        for (int i = 0; i < count; ++i) {
            if (childArray[i] != child) continue;
            return i;
        }
        return -1;
    }

    private void addInArray(View child, int index) {
        View[] childArray = (View[])Assertions.assertNotNull((Object)this.mAllChildren);
        int count = this.mAllChildrenCount;
        int size = childArray.length;
        if (index == count) {
            if (size == count) {
                this.mAllChildren = new View[size + 12];
                System.arraycopy(childArray, 0, this.mAllChildren, 0, size);
                childArray = this.mAllChildren;
            }
            childArray[this.mAllChildrenCount++] = child;
        } else if (index < count) {
            if (size == count) {
                this.mAllChildren = new View[size + 12];
                System.arraycopy(childArray, 0, this.mAllChildren, 0, index);
                System.arraycopy(childArray, index, this.mAllChildren, index + 1, count - index);
                childArray = this.mAllChildren;
            } else {
                System.arraycopy(childArray, index, childArray, index + 1, count - index);
            }
            childArray[index] = child;
            ++this.mAllChildrenCount;
        } else {
            throw new IndexOutOfBoundsException("index=" + index + " count=" + count);
        }
    }

    private void removeFromArray(int index) {
        int count;
        View[] childArray = (View[])Assertions.assertNotNull((Object)this.mAllChildren);
        if (index == (count = this.mAllChildrenCount--) - 1) {
            childArray[this.mAllChildrenCount] = null;
        } else if (index >= 0 && index < count) {
            System.arraycopy(childArray, index + 1, childArray, index, count - index - 1);
            childArray[--this.mAllChildrenCount] = null;
        } else {
            throw new IndexOutOfBoundsException();
        }
    }

    @Override
    @Nullable
    public Rect getHitSlopRect() {
        return this.mHitSlopRect;
    }

    public void setHitSlopRect(@Nullable Rect rect) {
        this.mHitSlopRect = rect;
    }

    public void setOverflow(@Nullable String overflow) {
        Overflow parsedOverflow;
        this.mOverflow = overflow == null ? Overflow.VISIBLE : ((parsedOverflow = Overflow.fromString(overflow)) == null ? Overflow.VISIBLE : parsedOverflow);
        this.invalidate();
    }

    @Override
    @Nullable
    public String getOverflow() {
        switch (this.mOverflow) {
            case HIDDEN: {
                return "hidden";
            }
            case SCROLL: {
                return "scroll";
            }
            case VISIBLE: {
                return "visible";
            }
        }
        return null;
    }

    @Override
    public void setOverflowInset(int left, int top, int right, int bottom) {
        if (BlendModeHelper.needsIsolatedLayer(this) && (this.mOverflowInset.left != left || this.mOverflowInset.top != top || this.mOverflowInset.right != right || this.mOverflowInset.bottom != bottom)) {
            this.invalidate();
        }
        this.mOverflowInset.set(left, top, right, bottom);
    }

    @Override
    public Rect getOverflowInset() {
        return this.mOverflowInset;
    }

    void updateBackgroundDrawable(@Nullable Drawable drawable2) {
        super.setBackground(drawable2);
    }

    public void draw(Canvas canvas) {
        if (Build.VERSION.SDK_INT >= 29 && ViewUtil.getUIManagerType((View)this) == 2 && BlendModeHelper.needsIsolatedLayer(this)) {
            Rect overflowInset = this.getOverflowInset();
            canvas.saveLayer((float)overflowInset.left, (float)overflowInset.top, (float)(this.getWidth() + -overflowInset.right), (float)(this.getHeight() + -overflowInset.bottom), null);
            super.draw(canvas);
            canvas.restore();
        } else {
            super.draw(canvas);
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.mOverflow != Overflow.VISIBLE || this.getTag(R.id.filter) != null) {
            BackgroundStyleApplicator.clipToPaddingBox((View)this, canvas);
        }
        super.dispatchDraw(canvas);
    }

    protected boolean drawChild(Canvas canvas, View child, long drawingTime) {
        boolean drawWithZ;
        boolean bl = drawWithZ = child.getElevation() > 0.0f;
        if (drawWithZ) {
            CanvasUtil.enableZ(canvas, true);
        }
        BlendMode mixBlendMode = null;
        if (Build.VERSION.SDK_INT >= 29 && ViewUtil.getUIManagerType((View)this) == 2 && BlendModeHelper.needsIsolatedLayer(this) && (mixBlendMode = (BlendMode)child.getTag(R.id.mix_blend_mode)) != null) {
            Paint p = new Paint();
            p.setBlendMode(mixBlendMode);
            Rect overflowInset = this.getOverflowInset();
            canvas.saveLayer((float)overflowInset.left, (float)overflowInset.top, (float)(this.getWidth() + -overflowInset.right), (float)(this.getHeight() + -overflowInset.bottom), p);
        }
        boolean result = super.drawChild(canvas, child, drawingTime);
        if (mixBlendMode != null) {
            canvas.restore();
        }
        if (drawWithZ) {
            CanvasUtil.enableZ(canvas, false);
        }
        return result;
    }

    public void setOpacityIfPossible(float opacity) {
        this.mBackfaceOpacity = opacity;
        this.setBackfaceVisibilityDependantOpacity();
    }

    public void setBackfaceVisibility(String backfaceVisibility) {
        this.mBackfaceVisible = "visible".equals(backfaceVisibility);
        this.setBackfaceVisibilityDependantOpacity();
    }

    public void setBackfaceVisibilityDependantOpacity() {
        boolean isFrontfaceVisible;
        if (this.mBackfaceVisible) {
            this.setAlpha(this.mBackfaceOpacity);
            return;
        }
        float rotationX = this.getRotationX();
        float rotationY = this.getRotationY();
        boolean bl = isFrontfaceVisible = rotationX >= -90.0f && rotationX < 90.0f && rotationY >= -90.0f && rotationY < 90.0f;
        if (isFrontfaceVisible) {
            this.setAlpha(this.mBackfaceOpacity);
            return;
        }
        this.setAlpha(0.0f);
    }

    private static final class ChildrenLayoutChangeListener
    implements View.OnLayoutChangeListener {
        @Nullable
        private ReactViewGroup mParent;

        private ChildrenLayoutChangeListener(ReactViewGroup parent) {
            this.mParent = parent;
        }

        public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
            if (this.mParent != null && this.mParent.getRemoveClippedSubviews()) {
                this.mParent.updateSubviewClipStatus(v);
            }
        }

        public void shutdown() {
            this.mParent = null;
        }
    }
}

