/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.drawable;

import android.content.Context;
import android.graphics.BlurMaskFilter;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.MaskFilter;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import androidx.annotation.RequiresApi;
import com.facebook.react.uimanager.FilterHelper;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.drawable.BoxShadowBorderRadiusKt;
import com.facebook.react.uimanager.style.BorderRadiusStyle;
import com.facebook.react.uimanager.style.ComputedBorderRadius;
import com.facebook.react.uimanager.style.CornerRadii;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0016J\u0012\u0010\u0018\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u0005H\u0017J\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J(\u0010\u001f\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020!H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/facebook/react/uimanager/drawable/OutsetBoxShadowDrawable;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "shadowColor", "", "offsetX", "", "offsetY", "blurRadius", "spread", "borderRadius", "Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "<init>", "(Landroid/content/Context;IFFFFLcom/facebook/react/uimanager/style/BorderRadiusStyle;)V", "getBorderRadius", "()Lcom/facebook/react/uimanager/style/BorderRadiusStyle;", "setBorderRadius", "(Lcom/facebook/react/uimanager/style/BorderRadiusStyle;)V", "shadowPaint", "Landroid/graphics/Paint;", "setAlpha", "", "alpha", "setColorFilter", "colorFilter", "Landroid/graphics/ColorFilter;", "getOpacity", "draw", "canvas", "Landroid/graphics/Canvas;", "drawShadowRoundRect", "shadowRect", "Landroid/graphics/RectF;", "spreadExtent", "computedBorderRadii", "Lcom/facebook/react/uimanager/style/ComputedBorderRadius;", "drawShadowRect", "ReactAndroid_debug"})
@RequiresApi(value=28)
@SourceDebugExtension(value={"SMAP\nOutsetBoxShadowDrawable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OutsetBoxShadowDrawable.kt\ncom/facebook/react/uimanager/drawable/OutsetBoxShadowDrawable\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,162:1\n1#2:163\n*E\n"})
public final class OutsetBoxShadowDrawable
extends Drawable {
    @NotNull
    private final Context context;
    private final int shadowColor;
    private final float offsetX;
    private final float offsetY;
    private final float blurRadius;
    private final float spread;
    @Nullable
    private BorderRadiusStyle borderRadius;
    @NotNull
    private final Paint shadowPaint;

    /*
     * WARNING - void declaration
     */
    public OutsetBoxShadowDrawable(@NotNull Context context, int shadowColor, float offsetX, float offsetY, float blurRadius, float spread, @Nullable BorderRadiusStyle borderRadius) {
        void $this$shadowPaint_u24lambda_u240;
        Paint paint;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.shadowColor = shadowColor;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.blurRadius = blurRadius;
        this.spread = spread;
        this.borderRadius = borderRadius;
        Paint paint2 = paint = new Paint();
        OutsetBoxShadowDrawable outsetBoxShadowDrawable = this;
        boolean bl = false;
        $this$shadowPaint_u24lambda_u240.setColor(this.shadowColor);
        float convertedBlurRadius = FilterHelper.INSTANCE.sigmaToRadius$ReactAndroid_debug(this.blurRadius * 0.5f);
        if (convertedBlurRadius > 0.0f) {
            $this$shadowPaint_u24lambda_u240.setMaskFilter((MaskFilter)new BlurMaskFilter(convertedBlurRadius, BlurMaskFilter.Blur.NORMAL));
        }
        outsetBoxShadowDrawable.shadowPaint = paint;
    }

    public /* synthetic */ OutsetBoxShadowDrawable(Context context, int n, float f, float f2, float f3, float f4, BorderRadiusStyle borderRadiusStyle, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 0x40) != 0) {
            borderRadiusStyle = null;
        }
        this(context, n, f, f2, f3, f4, borderRadiusStyle);
    }

    @Nullable
    public final BorderRadiusStyle getBorderRadius() {
        return this.borderRadius;
    }

    public final void setBorderRadius(@Nullable BorderRadiusStyle borderRadiusStyle) {
        this.borderRadius = borderRadiusStyle;
    }

    public void setAlpha(int alpha) {
        this.shadowPaint.setAlpha(MathKt.roundToInt((float)((float)alpha / 255.0f * ((float)Color.alpha((int)this.shadowColor) / 255.0f) * 255.0f)));
        this.invalidateSelf();
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.shadowPaint.setColorFilter(colorFilter);
        this.invalidateSelf();
    }

    @Deprecated(message="Deprecated in Java")
    public int getOpacity() {
        int alpha = this.shadowPaint.getAlpha();
        int n = alpha;
        return n == 255 ? -1 : ((1 <= n ? n < 255 : false) ? -3 : -2);
    }

    public void draw(@NotNull Canvas canvas) {
        RectF rectF;
        ComputedBorderRadius computedBorderRadius;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        float resolutionWidth = PixelUtil.INSTANCE.pxToDp((float)this.getBounds().width());
        float resolutionHeight = PixelUtil.INSTANCE.pxToDp((float)this.getBounds().height());
        Object object = this.borderRadius;
        if (object != null && (object = ((BorderRadiusStyle)object).resolve(this.getLayoutDirection(), this.context, resolutionWidth, resolutionHeight)) != null) {
            Object it = object;
            boolean bl = false;
            computedBorderRadius = new ComputedBorderRadius(new CornerRadii(PixelUtil.INSTANCE.dpToPx(((ComputedBorderRadius)it).getTopLeft().getHorizontal()), PixelUtil.INSTANCE.dpToPx(((ComputedBorderRadius)it).getTopLeft().getVertical())), new CornerRadii(PixelUtil.INSTANCE.dpToPx(((ComputedBorderRadius)it).getTopRight().getHorizontal()), PixelUtil.INSTANCE.dpToPx(((ComputedBorderRadius)it).getTopRight().getVertical())), new CornerRadii(PixelUtil.INSTANCE.dpToPx(((ComputedBorderRadius)it).getBottomLeft().getHorizontal()), PixelUtil.INSTANCE.dpToPx(((ComputedBorderRadius)it).getBottomLeft().getVertical())), new CornerRadii(PixelUtil.INSTANCE.dpToPx(((ComputedBorderRadius)it).getBottomRight().getHorizontal()), PixelUtil.INSTANCE.dpToPx(((ComputedBorderRadius)it).getBottomRight().getVertical())));
        } else {
            computedBorderRadius = null;
        }
        ComputedBorderRadius computedBorderRadii = computedBorderRadius;
        float spreadExtent = PixelUtil.INSTANCE.dpToPx(this.spread);
        RectF $this$draw_u24lambda_u242 = rectF = new RectF(this.getBounds());
        boolean bl = false;
        $this$draw_u24lambda_u242.inset(-spreadExtent, -spreadExtent);
        $this$draw_u24lambda_u242.offset(PixelUtil.INSTANCE.dpToPx(this.offsetX), PixelUtil.INSTANCE.dpToPx(this.offsetY));
        RectF shadowRect = rectF;
        int saveCount = canvas.save();
        boolean bl2 = false;
        ComputedBorderRadius computedBorderRadius2 = computedBorderRadii;
        boolean bl3 = computedBorderRadius2 != null ? computedBorderRadius2.hasRoundedBorders() : false;
        if (bl3) {
            this.drawShadowRoundRect(canvas, shadowRect, spreadExtent, computedBorderRadii);
        } else {
            this.drawShadowRect(canvas, shadowRect);
        }
        canvas.restoreToCount(saveCount);
    }

    /*
     * WARNING - void declaration
     */
    private final void drawShadowRoundRect(Canvas canvas, RectF shadowRect, float spreadExtent, ComputedBorderRadius computedBorderRadii) {
        void $this$drawShadowRoundRect_u24lambda_u246;
        RectF $this$drawShadowRoundRect_u24lambda_u245;
        RectF rectF;
        RectF $this$drawShadowRoundRect_u24lambda_u244 = rectF = new RectF(this.getBounds());
        boolean bl = false;
        $this$drawShadowRoundRect_u24lambda_u244.inset(0.4f, 0.4f);
        RectF subpixelInsetBounds = rectF;
        $this$drawShadowRoundRect_u24lambda_u244 = rectF = new Path();
        Canvas canvas2 = canvas;
        boolean bl2 = false;
        float[] fArray = new float[]{computedBorderRadii.getTopLeft().getHorizontal(), computedBorderRadii.getTopLeft().getVertical(), computedBorderRadii.getTopRight().getHorizontal(), computedBorderRadii.getTopRight().getVertical(), computedBorderRadii.getBottomRight().getHorizontal(), computedBorderRadii.getBottomRight().getVertical(), computedBorderRadii.getBottomLeft().getHorizontal(), computedBorderRadii.getBottomLeft().getVertical()};
        $this$drawShadowRoundRect_u24lambda_u245.addRoundRect(subpixelInsetBounds, fArray, Path.Direction.CW);
        canvas2.clipOutPath((Path)rectF);
        $this$drawShadowRoundRect_u24lambda_u245 = rectF = new Path();
        canvas2 = canvas;
        boolean bl3 = false;
        fArray = new float[]{BoxShadowBorderRadiusKt.adjustRadiusForSpread(computedBorderRadii.getTopLeft().getHorizontal(), spreadExtent), BoxShadowBorderRadiusKt.adjustRadiusForSpread(computedBorderRadii.getTopLeft().getVertical(), spreadExtent), BoxShadowBorderRadiusKt.adjustRadiusForSpread(computedBorderRadii.getTopRight().getHorizontal(), spreadExtent), BoxShadowBorderRadiusKt.adjustRadiusForSpread(computedBorderRadii.getTopRight().getVertical(), spreadExtent), BoxShadowBorderRadiusKt.adjustRadiusForSpread(computedBorderRadii.getBottomRight().getHorizontal(), spreadExtent), BoxShadowBorderRadiusKt.adjustRadiusForSpread(computedBorderRadii.getBottomRight().getVertical(), spreadExtent), BoxShadowBorderRadiusKt.adjustRadiusForSpread(computedBorderRadii.getBottomLeft().getHorizontal(), spreadExtent), BoxShadowBorderRadiusKt.adjustRadiusForSpread(computedBorderRadii.getBottomLeft().getVertical(), spreadExtent)};
        $this$drawShadowRoundRect_u24lambda_u246.addRoundRect(shadowRect, fArray, Path.Direction.CW);
        canvas2.drawPath((Path)rectF, this.shadowPaint);
    }

    private final void drawShadowRect(Canvas canvas, RectF shadowRect) {
        canvas.clipOutRect(this.getBounds());
        canvas.drawRect(shadowRect, this.shadowPaint);
    }
}

