/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager.events;

import android.os.Handler;
import android.view.Choreographer;
import com.facebook.infer.annotation.Nullsafe;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactNoCrashSoftException;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.UIManager;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.modules.core.ReactChoreographer;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.BatchEventDispatchedListener;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.uimanager.events.EventDispatcherListener;
import com.facebook.react.uimanager.events.RCTEventEmitter;
import com.facebook.react.uimanager.events.RCTModernEventEmitter;
import com.facebook.react.uimanager.events.ReactEventEmitter;
import com.facebook.react.uimanager.events.SynchronousEventReceiver;
import com.facebook.systrace.Systrace;
import java.util.concurrent.CopyOnWriteArrayList;

@Nullsafe(value=Nullsafe.Mode.LOCAL)
public class FabricEventDispatcher
implements EventDispatcher,
LifecycleEventListener {
    private static final Handler uiThreadHandler = UiThreadUtil.getUiThreadHandler();
    private final ReactEventEmitter mReactEventEmitter;
    private final ReactApplicationContext mReactContext;
    private final CopyOnWriteArrayList<EventDispatcherListener> mListeners = new CopyOnWriteArrayList();
    private final CopyOnWriteArrayList<BatchEventDispatchedListener> mPostEventDispatchListeners = new CopyOnWriteArrayList();
    private final ScheduleDispatchFrameCallback mCurrentFrameCallback = new ScheduleDispatchFrameCallback();
    private boolean mIsDispatchScheduled = false;
    private final Runnable mDispatchEventsRunnable = new Runnable(){

        @Override
        public void run() {
            FabricEventDispatcher.this.mIsDispatchScheduled = false;
            Systrace.beginSection(0L, "BatchEventDispatchedListeners");
            try {
                for (BatchEventDispatchedListener listener : FabricEventDispatcher.this.mPostEventDispatchListeners) {
                    listener.onBatchEventDispatched();
                }
            }
            finally {
                Systrace.endSection(0L);
            }
        }
    };

    public FabricEventDispatcher(ReactApplicationContext reactContext) {
        this.mReactContext = reactContext;
        this.mReactContext.addLifecycleEventListener(this);
        this.mReactEventEmitter = new ReactEventEmitter(this.mReactContext);
    }

    @Override
    public void dispatchEvent(Event event) {
        for (EventDispatcherListener listener : this.mListeners) {
            listener.onEventDispatch(event);
        }
        if (event.experimental_isSynchronous()) {
            this.dispatchSynchronous(event);
        } else {
            event.dispatchModern(this.mReactEventEmitter);
        }
        event.dispose();
        this.scheduleDispatchOfBatchedEvents();
    }

    private void dispatchSynchronous(Event event) {
        Systrace.beginSection(0L, "FabricEventDispatcher.dispatchSynchronous('" + event.getEventName() + "')");
        try {
            UIManager fabricUIManager = UIManagerHelper.getUIManager(this.mReactContext, 2);
            if (fabricUIManager instanceof SynchronousEventReceiver) {
                ((SynchronousEventReceiver)((Object)fabricUIManager)).receiveEvent(event.getSurfaceId(), event.getViewTag(), event.getEventName(), event.canCoalesce(), event.getEventData(), event.getEventCategory(), true);
            } else {
                ReactSoftExceptionLogger.logSoftException("FabricEventDispatcher", new ReactNoCrashSoftException("Fabric UIManager expected to implement SynchronousEventReceiver."));
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    @Override
    public void dispatchAllEvents() {
        this.scheduleDispatchOfBatchedEvents();
    }

    private void scheduleDispatchOfBatchedEvents() {
        if (ReactNativeFeatureFlags.useOptimizedEventBatchingOnAndroid()) {
            if (!this.mIsDispatchScheduled) {
                this.mIsDispatchScheduled = true;
                uiThreadHandler.postAtFrontOfQueue(this.mDispatchEventsRunnable);
            }
        } else {
            this.mCurrentFrameCallback.maybeScheduleDispatchOfBatchedEvents();
        }
    }

    @Override
    public void addListener(EventDispatcherListener listener) {
        this.mListeners.add(listener);
    }

    @Override
    public void removeListener(EventDispatcherListener listener) {
        this.mListeners.remove(listener);
    }

    @Override
    public void addBatchEventDispatchedListener(BatchEventDispatchedListener listener) {
        this.mPostEventDispatchListeners.add(listener);
    }

    @Override
    public void removeBatchEventDispatchedListener(BatchEventDispatchedListener listener) {
        this.mPostEventDispatchListeners.remove(listener);
    }

    @Override
    public void onHostResume() {
        this.scheduleDispatchOfBatchedEvents();
        if (!ReactNativeFeatureFlags.useOptimizedEventBatchingOnAndroid()) {
            this.mCurrentFrameCallback.resume();
        }
    }

    @Override
    public void onHostPause() {
        this.cancelDispatchOfBatchedEvents();
    }

    @Override
    public void onHostDestroy() {
        this.cancelDispatchOfBatchedEvents();
    }

    @Override
    public void onCatalystInstanceDestroyed() {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                FabricEventDispatcher.this.cancelDispatchOfBatchedEvents();
            }
        });
    }

    private void cancelDispatchOfBatchedEvents() {
        UiThreadUtil.assertOnUiThread();
        if (ReactNativeFeatureFlags.useOptimizedEventBatchingOnAndroid()) {
            this.mIsDispatchScheduled = false;
            uiThreadHandler.removeCallbacks(this.mDispatchEventsRunnable);
        } else {
            this.mCurrentFrameCallback.stop();
        }
    }

    @Override
    public void registerEventEmitter(int uiManagerType, RCTEventEmitter eventEmitter) {
        this.mReactEventEmitter.register(uiManagerType, eventEmitter);
    }

    @Override
    public void registerEventEmitter(int uiManagerType, RCTModernEventEmitter eventEmitter) {
        this.mReactEventEmitter.register(uiManagerType, eventEmitter);
    }

    @Override
    public void unregisterEventEmitter(int uiManagerType) {
        this.mReactEventEmitter.unregister(uiManagerType);
    }

    private class ScheduleDispatchFrameCallback
    implements Choreographer.FrameCallback {
        private volatile boolean mIsDispatchScheduled = false;
        private boolean mShouldStop = false;

        private ScheduleDispatchFrameCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doFrame(long frameTimeNanos) {
            UiThreadUtil.assertOnUiThread();
            if (this.mShouldStop) {
                this.mIsDispatchScheduled = false;
            } else {
                this.dispatchBatchedEvents();
            }
            Systrace.beginSection(0L, "BatchEventDispatchedListeners");
            try {
                for (BatchEventDispatchedListener listener : FabricEventDispatcher.this.mPostEventDispatchListeners) {
                    listener.onBatchEventDispatched();
                }
            }
            finally {
                Systrace.endSection(0L);
            }
        }

        public void stop() {
            this.mShouldStop = true;
        }

        public void resume() {
            this.mShouldStop = false;
        }

        public void maybeDispatchBatchedEvents() {
            if (!this.mIsDispatchScheduled) {
                this.mIsDispatchScheduled = true;
                this.dispatchBatchedEvents();
            }
        }

        private void dispatchBatchedEvents() {
            ReactChoreographer.getInstance().postFrameCallback(ReactChoreographer.CallbackType.TIMERS_EVENTS, FabricEventDispatcher.this.mCurrentFrameCallback);
        }

        public void maybeScheduleDispatchOfBatchedEvents() {
            if (this.mIsDispatchScheduled) {
                return;
            }
            if (FabricEventDispatcher.this.mReactContext.isOnUiQueueThread()) {
                this.maybeDispatchBatchedEvents();
            } else {
                FabricEventDispatcher.this.mReactContext.runOnUiQueueThread(new Runnable(){

                    @Override
                    public void run() {
                        ScheduleDispatchFrameCallback.this.maybeDispatchBatchedEvents();
                    }
                });
            }
        }
    }
}

