/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.common;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.facebook.react.common.ShakeDetectorKt;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0001%B\u001b\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\rJ\u0006\u0010\u0015\u001a\u00020\u0013J\b\u0010\u0016\u001a\u00020\u0013H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\tH\u0002J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u000fH\u0002J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0005H\u0016J\u0010\u0010#\u001a\u00020\u00132\u0006\u0010$\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/facebook/react/common/ShakeDetector;", "Landroid/hardware/SensorEventListener;", "shakeListener", "Lcom/facebook/react/common/ShakeDetector$ShakeListener;", "minNumShakes", "", "<init>", "(Lcom/facebook/react/common/ShakeDetector$ShakeListener;I)V", "accelerationX", "", "accelerationY", "accelerationZ", "sensorManager", "Landroid/hardware/SensorManager;", "lastTimestamp", "", "numShakes", "lastShakeTimestamp", "start", "", "manager", "stop", "reset", "atLeastRequiredForce", "", "a", "recordShake", "timestamp", "onSensorChanged", "sensorEvent", "Landroid/hardware/SensorEvent;", "onAccuracyChanged", "sensor", "Landroid/hardware/Sensor;", "i", "maybeDispatchShake", "currentTimestamp", "ShakeListener", "ReactAndroid_release"})
public final class ShakeDetector
implements SensorEventListener {
    @NotNull
    private final ShakeListener shakeListener;
    private final int minNumShakes;
    private float accelerationX;
    private float accelerationY;
    private float accelerationZ;
    @Nullable
    private SensorManager sensorManager;
    private long lastTimestamp;
    private int numShakes;
    private long lastShakeTimestamp;

    @JvmOverloads
    public ShakeDetector(@NotNull ShakeListener shakeListener, int minNumShakes) {
        Intrinsics.checkNotNullParameter((Object)shakeListener, (String)"shakeListener");
        this.shakeListener = shakeListener;
        this.minNumShakes = minNumShakes;
    }

    public /* synthetic */ ShakeDetector(ShakeListener shakeListener, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 1;
        }
        this(shakeListener, n);
    }

    public final void start(@NotNull SensorManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Sensor sensor = manager.getDefaultSensor(1);
        if (sensor == null) {
            return;
        }
        Sensor accelerometer = sensor;
        this.sensorManager = manager;
        this.lastTimestamp = -1L;
        manager.registerListener((SensorEventListener)this, accelerometer, 2);
        this.lastShakeTimestamp = 0L;
        this.reset();
    }

    public final void stop() {
        SensorManager sensorManager = this.sensorManager;
        if (sensorManager != null) {
            sensorManager.unregisterListener((SensorEventListener)this);
        }
        this.sensorManager = null;
    }

    private final void reset() {
        this.numShakes = 0;
        this.accelerationX = 0.0f;
        this.accelerationY = 0.0f;
        this.accelerationZ = 0.0f;
    }

    private final boolean atLeastRequiredForce(float a) {
        return Math.abs(a) > 13.042845f;
    }

    private final void recordShake(long timestamp) {
        this.lastShakeTimestamp = timestamp;
        int n = this.numShakes;
        this.numShakes = n + 1;
    }

    public void onSensorChanged(@NotNull SensorEvent sensorEvent) {
        Intrinsics.checkNotNullParameter((Object)sensorEvent, (String)"sensorEvent");
        if (sensorEvent.timestamp - this.lastTimestamp < ShakeDetectorKt.access$getMIN_TIME_BETWEEN_SAMPLES_NS$p()) {
            return;
        }
        float ax = sensorEvent.values[0];
        float ay = sensorEvent.values[1];
        float az = sensorEvent.values[2] - 9.80665f;
        this.lastTimestamp = sensorEvent.timestamp;
        if (this.atLeastRequiredForce(ax) && ax * this.accelerationX <= 0.0f) {
            this.recordShake(sensorEvent.timestamp);
            this.accelerationX = ax;
        } else if (this.atLeastRequiredForce(ay) && ay * this.accelerationY <= 0.0f) {
            this.recordShake(sensorEvent.timestamp);
            this.accelerationY = ay;
        } else if (this.atLeastRequiredForce(az) && az * this.accelerationZ <= 0.0f) {
            this.recordShake(sensorEvent.timestamp);
            this.accelerationZ = az;
        }
        this.maybeDispatchShake(sensorEvent.timestamp);
    }

    public void onAccuracyChanged(@NotNull Sensor sensor, int i) {
        Intrinsics.checkNotNullParameter((Object)sensor, (String)"sensor");
    }

    private final void maybeDispatchShake(long currentTimestamp) {
        if (this.numShakes >= 8 * this.minNumShakes) {
            this.reset();
            this.shakeListener.onShake();
        }
        if ((float)(currentTimestamp - this.lastShakeTimestamp) > ShakeDetectorKt.access$getSHAKING_WINDOW_NS$p()) {
            this.reset();
        }
    }

    @JvmOverloads
    public ShakeDetector(@NotNull ShakeListener shakeListener) {
        Intrinsics.checkNotNullParameter((Object)shakeListener, (String)"shakeListener");
        this(shakeListener, 0, 2, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0004\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/common/ShakeDetector$ShakeListener;", "", "onShake", "", "ReactAndroid_release"})
    public static interface ShakeListener {
        public void onShake();
    }
}

