/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.hermes.unicode;

import com.facebook.proguard.annotations.DoNotStrip;
import java.text.Collator;
import java.text.DateFormat;
import java.text.Normalizer;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\u0007H\u0007J \u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0007J \u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\rH\u0007J\u001a\u0010\u0013\u001a\u00020\u00072\b\u0010\u0010\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0014\u001a\u00020\u0005H\u0007R\u000e\u0010\u0015\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/facebook/hermes/unicode/AndroidUnicodeUtils;", "", "<init>", "()V", "localeCompare", "", "left", "", "right", "dateFormat", "unixtimeMs", "", "formatDate", "", "formatTime", "convertToCase", "input", "targetCase", "useCurrentLocale", "normalize", "form", "TARGET_UPPERCASE", "TARGET_LOWERCASE", "FORM_C", "FORM_D", "FORM_KC", "FORM_KD", "ReactAndroid_release"})
@DoNotStrip
public final class AndroidUnicodeUtils {
    @NotNull
    public static final AndroidUnicodeUtils INSTANCE = new AndroidUnicodeUtils();
    private static final int TARGET_UPPERCASE = 0;
    private static final int TARGET_LOWERCASE = 1;
    private static final int FORM_C = 0;
    private static final int FORM_D = 1;
    private static final int FORM_KC = 2;
    private static final int FORM_KD = 3;

    private AndroidUnicodeUtils() {
    }

    @JvmStatic
    @DoNotStrip
    public static final int localeCompare(@Nullable String left, @Nullable String right) {
        Collator collator = Collator.getInstance();
        return collator.compare(left, right);
    }

    @JvmStatic
    @DoNotStrip
    @NotNull
    public static final String dateFormat(double unixtimeMs, boolean formatDate, boolean formatTime) {
        DateFormat dateFormat;
        if (formatDate && formatTime) {
            dateFormat = DateFormat.getDateTimeInstance(2, 2);
        } else if (formatDate) {
            dateFormat = DateFormat.getDateInstance(2);
        } else if (formatTime) {
            dateFormat = DateFormat.getTimeInstance(2);
        } else {
            throw new IllegalStateException("Bad dateFormat configuration".toString());
        }
        DateFormat format = dateFormat;
        return format.format((long)unixtimeMs).toString();
    }

    @JvmStatic
    @DoNotStrip
    @NotNull
    public static final String convertToCase(@NotNull String input, int targetCase, boolean useCurrentLocale) {
        String string;
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Locale locale = useCurrentLocale ? Locale.getDefault() : Locale.ENGLISH;
        switch (targetCase) {
            case 1: {
                Intrinsics.checkNotNull((Object)locale);
                String string2 = input.toLowerCase(locale);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
                break;
            }
            case 0: {
                Intrinsics.checkNotNull((Object)locale);
                String string3 = input.toUpperCase(locale);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toUpperCase(...)");
                break;
            }
            default: {
                throw new IllegalStateException("Invalid target case".toString());
            }
        }
        return string;
    }

    @JvmStatic
    @DoNotStrip
    @NotNull
    public static final String normalize(@Nullable String input, int form) {
        String string;
        switch (form) {
            case 0: {
                String string2 = Normalizer.normalize(input, Normalizer.Form.NFC);
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"normalize(...)");
                break;
            }
            case 1: {
                String string3 = Normalizer.normalize(input, Normalizer.Form.NFD);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"normalize(...)");
                break;
            }
            case 2: {
                String string4 = Normalizer.normalize(input, Normalizer.Form.NFKC);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"normalize(...)");
                break;
            }
            case 3: {
                String string5 = Normalizer.normalize(input, Normalizer.Form.NFKD);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"normalize(...)");
                break;
            }
            default: {
                throw new IllegalStateException("Invalid form".toString());
            }
        }
        return string;
    }
}

