/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.graphics.Color;
import android.os.Build;
import android.text.Spannable;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.internal.featureflags.ReactNativeFeatureFlags;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.LayoutShadowNode;
import com.facebook.react.uimanager.NativeViewHierarchyOptimizer;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactAccessibilityDelegate;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ReactShadowNodeImpl;
import com.facebook.react.uimanager.annotations.ReactProp;
import com.facebook.react.views.text.ReactRawTextShadowNode;
import com.facebook.react.views.text.ReactTextViewManagerCallback;
import com.facebook.react.views.text.ReactTypefaceUtils;
import com.facebook.react.views.text.TextAttributes;
import com.facebook.react.views.text.TextTransform;
import com.facebook.react.views.text.internal.ReactTextInlineImageShadowNode;
import com.facebook.react.views.text.internal.span.CustomLetterSpacingSpan;
import com.facebook.react.views.text.internal.span.CustomLineHeightSpan;
import com.facebook.react.views.text.internal.span.CustomStyleSpan;
import com.facebook.react.views.text.internal.span.LegacyLineHeightSpan;
import com.facebook.react.views.text.internal.span.ReactAbsoluteSizeSpan;
import com.facebook.react.views.text.internal.span.ReactBackgroundColorSpan;
import com.facebook.react.views.text.internal.span.ReactClickableSpan;
import com.facebook.react.views.text.internal.span.ReactForegroundColorSpan;
import com.facebook.react.views.text.internal.span.ReactSpan;
import com.facebook.react.views.text.internal.span.ReactStrikethroughSpan;
import com.facebook.react.views.text.internal.span.ReactTagSpan;
import com.facebook.react.views.text.internal.span.ReactUnderlineSpan;
import com.facebook.react.views.text.internal.span.SetSpanOperation;
import com.facebook.react.views.text.internal.span.ShadowStyleSpan;
import com.facebook.react.views.text.internal.span.TextInlineImageSpan;
import com.facebook.react.views.text.internal.span.TextInlineViewPlaceholderSpan;
import com.facebook.yoga.YogaDirection;
import com.facebook.yoga.YogaUnit;
import com.facebook.yoga.YogaValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ReactBaseTextShadowNode
extends LayoutShadowNode {
    private static final String INLINE_VIEW_PLACEHOLDER = "0";
    public static final String PROP_SHADOW_OFFSET = "textShadowOffset";
    public static final String PROP_SHADOW_OFFSET_WIDTH = "width";
    public static final String PROP_SHADOW_OFFSET_HEIGHT = "height";
    public static final String PROP_SHADOW_RADIUS = "textShadowRadius";
    public static final String PROP_SHADOW_COLOR = "textShadowColor";
    public static final String PROP_TEXT_TRANSFORM = "textTransform";
    public static final int DEFAULT_TEXT_SHADOW_COLOR = 0x55000000;
    @Nullable
    protected ReactTextViewManagerCallback mReactTextViewManagerCallback;
    protected TextAttributes mTextAttributes;
    protected boolean mIsColorSet = false;
    protected int mColor;
    protected boolean mIsBackgroundColorSet = false;
    protected int mBackgroundColor;
    @Nullable
    protected ReactAccessibilityDelegate.AccessibilityRole mAccessibilityRole = null;
    @Nullable
    protected ReactAccessibilityDelegate.Role mRole = null;
    protected int mNumberOfLines = -1;
    protected int mTextAlign = 0;
    protected int mTextBreakStrategy = 1;
    protected int mHyphenationFrequency = 0;
    protected int mJustificationMode = Build.VERSION.SDK_INT < 26 ? 0 : 0;
    protected float mTextShadowOffsetDx = 0.0f;
    protected float mTextShadowOffsetDy = 0.0f;
    protected float mTextShadowRadius = 0.0f;
    protected int mTextShadowColor = 0x55000000;
    protected boolean mIsUnderlineTextDecorationSet = false;
    protected boolean mIsLineThroughTextDecorationSet = false;
    protected boolean mIncludeFontPadding = true;
    protected boolean mAdjustsFontSizeToFit = false;
    protected float mMinimumFontScale = 0.0f;
    protected int mFontStyle = -1;
    protected int mFontWeight = -1;
    @Nullable
    protected String mFontFamily = null;
    @Nullable
    protected String mFontFeatureSettings = null;
    protected boolean mContainsImages = false;
    protected Map<Integer, ReactShadowNode> mInlineViews;

    private static void buildSpannedFromShadowNode(ReactBaseTextShadowNode textShadowNode, SpannableStringBuilder sb, List<SetSpanOperation> ops, @Nullable TextAttributes parentTextAttributes, boolean supportsInlineViews, @Nullable Map<Integer, ReactShadowNode> inlineViews, int start) {
        TextAttributes textAttributes = parentTextAttributes != null ? parentTextAttributes.applyChild(textShadowNode.mTextAttributes) : textShadowNode.mTextAttributes;
        int length = textShadowNode.getChildCount();
        for (int i = 0; i < length; ++i) {
            ReactShadowNodeImpl child = textShadowNode.getChildAt(i);
            if (child instanceof ReactRawTextShadowNode) {
                sb.append((CharSequence)TextTransform.apply(((ReactRawTextShadowNode)child).getText(), textAttributes.getTextTransform()));
            } else if (child instanceof ReactBaseTextShadowNode) {
                ReactBaseTextShadowNode.buildSpannedFromShadowNode((ReactBaseTextShadowNode)child, sb, ops, textAttributes, supportsInlineViews, inlineViews, sb.length());
            } else if (child instanceof ReactTextInlineImageShadowNode) {
                sb.append((CharSequence)INLINE_VIEW_PLACEHOLDER);
                ops.add(new SetSpanOperation(sb.length() - INLINE_VIEW_PLACEHOLDER.length(), sb.length(), ((ReactTextInlineImageShadowNode)child).buildInlineImageSpan()));
            } else if (supportsInlineViews) {
                float height;
                float width;
                int reactTag = child.getReactTag();
                YogaValue widthValue = child.getStyleWidth();
                YogaValue heightValue = child.getStyleHeight();
                if (widthValue.unit != YogaUnit.POINT || heightValue.unit != YogaUnit.POINT) {
                    child.calculateLayout();
                    width = child.getLayoutWidth();
                    height = child.getLayoutHeight();
                } else {
                    width = widthValue.value;
                    height = heightValue.value;
                }
                sb.append((CharSequence)INLINE_VIEW_PLACEHOLDER);
                ops.add(new SetSpanOperation(sb.length() - INLINE_VIEW_PLACEHOLDER.length(), sb.length(), new TextInlineViewPlaceholderSpan(reactTag, (int)width, (int)height)));
                inlineViews.put(reactTag, child);
            } else {
                throw new IllegalViewOperationException("Unexpected view type nested under a <Text> or <TextInput> node: " + child.getClass());
            }
            child.markUpdateSeen();
        }
        int end = sb.length();
        if (end >= start) {
            float effectiveLineHeight;
            float effectiveLetterSpacing;
            boolean roleIsLink;
            if (textShadowNode.mIsColorSet) {
                ops.add(new SetSpanOperation(start, end, new ReactForegroundColorSpan(textShadowNode.mColor)));
            }
            if (textShadowNode.mIsBackgroundColorSet) {
                ops.add(new SetSpanOperation(start, end, new ReactBackgroundColorSpan(textShadowNode.mBackgroundColor)));
            }
            boolean bl = textShadowNode.mRole != null ? textShadowNode.mRole == ReactAccessibilityDelegate.Role.LINK : (roleIsLink = textShadowNode.mAccessibilityRole == ReactAccessibilityDelegate.AccessibilityRole.LINK);
            if (roleIsLink) {
                ops.add(new SetSpanOperation(start, end, new ReactClickableSpan(textShadowNode.getReactTag())));
            }
            if (!(Float.isNaN(effectiveLetterSpacing = textAttributes.getEffectiveLetterSpacing()) || parentTextAttributes != null && parentTextAttributes.getEffectiveLetterSpacing() == effectiveLetterSpacing)) {
                ops.add(new SetSpanOperation(start, end, new CustomLetterSpacingSpan(effectiveLetterSpacing)));
            }
            int effectiveFontSize = textAttributes.getEffectiveFontSize();
            if (parentTextAttributes == null || parentTextAttributes.getEffectiveFontSize() != effectiveFontSize) {
                ops.add(new SetSpanOperation(start, end, new ReactAbsoluteSizeSpan(effectiveFontSize)));
            }
            if (textShadowNode.mFontStyle != -1 || textShadowNode.mFontWeight != -1 || textShadowNode.mFontFamily != null) {
                ops.add(new SetSpanOperation(start, end, new CustomStyleSpan(textShadowNode.mFontStyle, textShadowNode.mFontWeight, textShadowNode.mFontFeatureSettings, textShadowNode.mFontFamily, textShadowNode.getThemedContext().getAssets())));
            }
            if (textShadowNode.mIsUnderlineTextDecorationSet) {
                ops.add(new SetSpanOperation(start, end, new ReactUnderlineSpan()));
            }
            if (textShadowNode.mIsLineThroughTextDecorationSet) {
                ops.add(new SetSpanOperation(start, end, new ReactStrikethroughSpan()));
            }
            if ((textShadowNode.mTextShadowOffsetDx != 0.0f || textShadowNode.mTextShadowOffsetDy != 0.0f || textShadowNode.mTextShadowRadius != 0.0f) && Color.alpha((int)textShadowNode.mTextShadowColor) != 0) {
                ops.add(new SetSpanOperation(start, end, new ShadowStyleSpan(textShadowNode.mTextShadowOffsetDx, textShadowNode.mTextShadowOffsetDy, textShadowNode.mTextShadowRadius, textShadowNode.mTextShadowColor)));
            }
            if (!(Float.isNaN(effectiveLineHeight = textAttributes.getEffectiveLineHeight()) || parentTextAttributes != null && parentTextAttributes.getEffectiveLineHeight() == effectiveLineHeight)) {
                if (ReactNativeFeatureFlags.enableAndroidLineHeightCentering()) {
                    ops.add(new SetSpanOperation(start, end, new CustomLineHeightSpan(effectiveLineHeight)));
                } else {
                    ops.add(new SetSpanOperation(start, end, new LegacyLineHeightSpan(effectiveLineHeight)));
                }
            }
            ops.add(new SetSpanOperation(start, end, new ReactTagSpan(textShadowNode.getReactTag())));
        }
    }

    protected Spannable spannedFromShadowNode(ReactBaseTextShadowNode textShadowNode, @Nullable String text, boolean supportsInlineViews, NativeViewHierarchyOptimizer nativeViewHierarchyOptimizer) {
        HashMap<Integer, ReactShadowNode> inlineViews;
        Assertions.assertCondition((!supportsInlineViews || nativeViewHierarchyOptimizer != null ? 1 : 0) != 0, (String)"nativeViewHierarchyOptimizer is required when inline views are supported");
        SpannableStringBuilder sb = new SpannableStringBuilder();
        ArrayList<SetSpanOperation> ops = new ArrayList<SetSpanOperation>();
        HashMap<Integer, ReactShadowNode> hashMap = inlineViews = supportsInlineViews ? new HashMap<Integer, ReactShadowNode>() : null;
        if (text != null) {
            sb.append((CharSequence)TextTransform.apply(text, textShadowNode.mTextAttributes.getTextTransform()));
        }
        ReactBaseTextShadowNode.buildSpannedFromShadowNode(textShadowNode, sb, ops, null, supportsInlineViews, inlineViews, 0);
        textShadowNode.mContainsImages = false;
        textShadowNode.mInlineViews = inlineViews;
        float heightOfTallestInlineViewOrImage = Float.NaN;
        for (int priorityIndex = 0; priorityIndex < ops.size(); ++priorityIndex) {
            SetSpanOperation op = (SetSpanOperation)ops.get(ops.size() - priorityIndex - 1);
            ReactSpan what = op.what;
            boolean isInlineImage = what instanceof TextInlineImageSpan;
            if (isInlineImage || what instanceof TextInlineViewPlaceholderSpan) {
                int height;
                if (isInlineImage) {
                    height = ((TextInlineImageSpan)what).getHeight();
                    textShadowNode.mContainsImages = true;
                } else {
                    TextInlineViewPlaceholderSpan placeholder = (TextInlineViewPlaceholderSpan)what;
                    height = placeholder.getHeight();
                    ReactShadowNode childNode = (ReactShadowNode)inlineViews.get(placeholder.getReactTag());
                    nativeViewHierarchyOptimizer.handleForceViewToBeNonLayoutOnly(childNode);
                    childNode.setLayoutParent(textShadowNode);
                }
                if (Float.isNaN(heightOfTallestInlineViewOrImage) || (float)height > heightOfTallestInlineViewOrImage) {
                    heightOfTallestInlineViewOrImage = height;
                }
            }
            op.execute(sb, priorityIndex);
        }
        textShadowNode.mTextAttributes.setHeightOfTallestInlineViewOrImage(heightOfTallestInlineViewOrImage);
        if (this.mReactTextViewManagerCallback != null) {
            this.mReactTextViewManagerCallback.onPostProcessSpannable((Spannable)sb);
        }
        return sb;
    }

    public ReactBaseTextShadowNode() {
        this(null);
    }

    public ReactBaseTextShadowNode(@Nullable ReactTextViewManagerCallback reactTextViewManagerCallback) {
        this.mTextAttributes = new TextAttributes();
        this.mReactTextViewManagerCallback = reactTextViewManagerCallback;
    }

    private int getTextAlign() {
        int textAlign = this.mTextAlign;
        if (this.getLayoutDirection() == YogaDirection.RTL) {
            if (textAlign == 5) {
                textAlign = 3;
            } else if (textAlign == 3) {
                textAlign = 5;
            }
        }
        return textAlign;
    }

    @ReactProp(name="numberOfLines", defaultInt=-1)
    public void setNumberOfLines(int numberOfLines) {
        this.mNumberOfLines = numberOfLines == 0 ? -1 : numberOfLines;
        this.markUpdated();
    }

    @ReactProp(name="lineHeight", defaultFloat=NaNf)
    public void setLineHeight(float lineHeight) {
        this.mTextAttributes.setLineHeight(lineHeight);
        this.markUpdated();
    }

    @ReactProp(name="letterSpacing", defaultFloat=0.0f)
    public void setLetterSpacing(float letterSpacing) {
        this.mTextAttributes.setLetterSpacing(letterSpacing);
        this.markUpdated();
    }

    @ReactProp(name="allowFontScaling", defaultBoolean=true)
    public void setAllowFontScaling(boolean allowFontScaling) {
        if (allowFontScaling != this.mTextAttributes.getAllowFontScaling()) {
            this.mTextAttributes.setAllowFontScaling(allowFontScaling);
            this.markUpdated();
        }
    }

    @ReactProp(name="maxFontSizeMultiplier", defaultFloat=NaNf)
    public void setMaxFontSizeMultiplier(float maxFontSizeMultiplier) {
        if (maxFontSizeMultiplier != this.mTextAttributes.getMaxFontSizeMultiplier()) {
            this.mTextAttributes.setMaxFontSizeMultiplier(maxFontSizeMultiplier);
            this.markUpdated();
        }
    }

    @ReactProp(name="textAlign")
    public void setTextAlign(@Nullable String textAlign) {
        if ("justify".equals(textAlign)) {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mJustificationMode = 1;
            }
            this.mTextAlign = 3;
        } else {
            if (Build.VERSION.SDK_INT >= 26) {
                this.mJustificationMode = 0;
            }
            if (textAlign == null || "auto".equals(textAlign)) {
                this.mTextAlign = 0;
            } else if ("left".equals(textAlign)) {
                this.mTextAlign = 3;
            } else if ("right".equals(textAlign)) {
                this.mTextAlign = 5;
            } else if ("center".equals(textAlign)) {
                this.mTextAlign = 1;
            } else {
                FLog.w((String)"ReactNative", (String)("Invalid textAlign: " + textAlign));
                this.mTextAlign = 0;
            }
        }
        this.markUpdated();
    }

    @ReactProp(name="fontSize", defaultFloat=NaNf)
    public void setFontSize(float fontSize) {
        this.mTextAttributes.setFontSize(fontSize);
        this.markUpdated();
    }

    @ReactProp(name="color", customType="Color")
    public void setColor(@Nullable Integer color) {
        boolean bl = this.mIsColorSet = color != null;
        if (this.mIsColorSet) {
            this.mColor = color;
        }
        this.markUpdated();
    }

    @ReactProp(name="backgroundColor", customType="Color")
    public void setBackgroundColor(@Nullable Integer color) {
        if (this.isVirtual()) {
            boolean bl = this.mIsBackgroundColorSet = color != null;
            if (this.mIsBackgroundColorSet) {
                this.mBackgroundColor = color;
            }
            this.markUpdated();
        }
    }

    @ReactProp(name="accessibilityRole")
    public void setAccessibilityRole(@Nullable String accessibilityRole) {
        if (this.isVirtual()) {
            this.mAccessibilityRole = ReactAccessibilityDelegate.AccessibilityRole.fromValue(accessibilityRole);
            this.markUpdated();
        }
    }

    @ReactProp(name="role")
    public void setRole(@Nullable String role) {
        if (this.isVirtual()) {
            this.mRole = ReactAccessibilityDelegate.Role.fromValue(role);
            this.markUpdated();
        }
    }

    @ReactProp(name="fontFamily")
    public void setFontFamily(@Nullable String fontFamily) {
        this.mFontFamily = fontFamily;
        this.markUpdated();
    }

    @ReactProp(name="fontWeight")
    public void setFontWeight(@Nullable String fontWeightString) {
        int fontWeight = ReactTypefaceUtils.parseFontWeight(fontWeightString);
        if (fontWeight != this.mFontWeight) {
            this.mFontWeight = fontWeight;
            this.markUpdated();
        }
    }

    @ReactProp(name="fontVariant")
    public void setFontVariant(@Nullable ReadableArray fontVariantArray) {
        String fontFeatureSettings = ReactTypefaceUtils.parseFontVariant(fontVariantArray);
        if (!TextUtils.equals((CharSequence)fontFeatureSettings, (CharSequence)this.mFontFeatureSettings)) {
            this.mFontFeatureSettings = fontFeatureSettings;
            this.markUpdated();
        }
    }

    @ReactProp(name="fontStyle")
    public void setFontStyle(@Nullable String fontStyleString) {
        int fontStyle = ReactTypefaceUtils.parseFontStyle(fontStyleString);
        if (fontStyle != this.mFontStyle) {
            this.mFontStyle = fontStyle;
            this.markUpdated();
        }
    }

    @ReactProp(name="includeFontPadding", defaultBoolean=true)
    public void setIncludeFontPadding(boolean includepad) {
        this.mIncludeFontPadding = includepad;
    }

    @ReactProp(name="textDecorationLine")
    public void setTextDecorationLine(@Nullable String textDecorationLineString) {
        this.mIsUnderlineTextDecorationSet = false;
        this.mIsLineThroughTextDecorationSet = false;
        if (textDecorationLineString != null) {
            for (String textDecorationLineSubString : textDecorationLineString.split(" ")) {
                if ("underline".equals(textDecorationLineSubString)) {
                    this.mIsUnderlineTextDecorationSet = true;
                    continue;
                }
                if (!"line-through".equals(textDecorationLineSubString)) continue;
                this.mIsLineThroughTextDecorationSet = true;
            }
        }
        this.markUpdated();
    }

    @ReactProp(name="textBreakStrategy")
    public void setTextBreakStrategy(@Nullable String textBreakStrategy) {
        if (textBreakStrategy == null || "highQuality".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 1;
        } else if ("simple".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 0;
        } else if ("balanced".equals(textBreakStrategy)) {
            this.mTextBreakStrategy = 2;
        } else {
            FLog.w((String)"ReactNative", (String)("Invalid textBreakStrategy: " + textBreakStrategy));
            this.mTextBreakStrategy = 1;
        }
        this.markUpdated();
    }

    @ReactProp(name="textShadowOffset")
    public void setTextShadowOffset(ReadableMap offsetMap) {
        this.mTextShadowOffsetDx = 0.0f;
        this.mTextShadowOffsetDy = 0.0f;
        if (offsetMap != null) {
            if (offsetMap.hasKey(PROP_SHADOW_OFFSET_WIDTH) && !offsetMap.isNull(PROP_SHADOW_OFFSET_WIDTH)) {
                this.mTextShadowOffsetDx = PixelUtil.toPixelFromDIP(offsetMap.getDouble(PROP_SHADOW_OFFSET_WIDTH));
            }
            if (offsetMap.hasKey(PROP_SHADOW_OFFSET_HEIGHT) && !offsetMap.isNull(PROP_SHADOW_OFFSET_HEIGHT)) {
                this.mTextShadowOffsetDy = PixelUtil.toPixelFromDIP(offsetMap.getDouble(PROP_SHADOW_OFFSET_HEIGHT));
            }
        }
        this.markUpdated();
    }

    @ReactProp(name="textShadowRadius", defaultInt=1)
    public void setTextShadowRadius(float textShadowRadius) {
        if (textShadowRadius != this.mTextShadowRadius) {
            this.mTextShadowRadius = textShadowRadius;
            this.markUpdated();
        }
    }

    @ReactProp(name="textShadowColor", defaultInt=0x55000000, customType="Color")
    public void setTextShadowColor(int textShadowColor) {
        if (textShadowColor != this.mTextShadowColor) {
            this.mTextShadowColor = textShadowColor;
            this.markUpdated();
        }
    }

    @ReactProp(name="textTransform")
    public void setTextTransform(@Nullable String textTransform) {
        if (textTransform == null) {
            this.mTextAttributes.setTextTransform(TextTransform.UNSET);
        } else if ("none".equals(textTransform)) {
            this.mTextAttributes.setTextTransform(TextTransform.NONE);
        } else if ("uppercase".equals(textTransform)) {
            this.mTextAttributes.setTextTransform(TextTransform.UPPERCASE);
        } else if ("lowercase".equals(textTransform)) {
            this.mTextAttributes.setTextTransform(TextTransform.LOWERCASE);
        } else if ("capitalize".equals(textTransform)) {
            this.mTextAttributes.setTextTransform(TextTransform.CAPITALIZE);
        } else {
            FLog.w((String)"ReactNative", (String)("Invalid textTransform: " + textTransform));
            this.mTextAttributes.setTextTransform(TextTransform.UNSET);
        }
        this.markUpdated();
    }

    @ReactProp(name="adjustsFontSizeToFit")
    public void setAdjustFontSizeToFit(boolean adjustsFontSizeToFit) {
        if (adjustsFontSizeToFit != this.mAdjustsFontSizeToFit) {
            this.mAdjustsFontSizeToFit = adjustsFontSizeToFit;
            this.markUpdated();
        }
    }

    @ReactProp(name="minimumFontScale")
    public void setMinimumFontScale(float minimumFontScale) {
        if (minimumFontScale != this.mMinimumFontScale) {
            this.mMinimumFontScale = minimumFontScale;
            this.markUpdated();
        }
    }
}

