/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.View;
import androidx.annotation.ColorInt;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.uimanager.LengthPercentage;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.common.ViewUtil;
import com.facebook.react.uimanager.drawable.CSSBackgroundDrawable;
import com.facebook.react.uimanager.drawable.CompositeBackgroundDrawable;
import com.facebook.react.uimanager.drawable.InsetBoxShadowDrawable;
import com.facebook.react.uimanager.drawable.OutsetBoxShadowDrawable;
import com.facebook.react.uimanager.style.BackgroundImageLayer;
import com.facebook.react.uimanager.style.BorderInsets;
import com.facebook.react.uimanager.style.BorderRadiusProp;
import com.facebook.react.uimanager.style.BorderRadiusStyle;
import com.facebook.react.uimanager.style.BorderStyle;
import com.facebook.react.uimanager.style.BoxShadow;
import com.facebook.react.uimanager.style.LogicalEdge;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0017\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a2\u0006\u0002\u0010\u000fJ\u001f\u0010\u0010\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u00a2\u0006\u0002\u0010\u0013J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001f\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0007\u00a2\u0006\u0002\u0010\u001cJ\u0012\u0010\u001d\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0012\u0010\u001e\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J!\u0010 \u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\n\b\u0001\u0010!\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010\"J \u0010#\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%H\u0007J)\u0010'\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\n\b\u0001\u0010!\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0002\u0010(J\"\u0010)\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010*\u001a\u0004\u0018\u00010\u0015H\u0007J\u001a\u0010+\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010,\u001a\u0004\u0018\u00010\u0019H\u0007J'\u0010-\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010.\u001a\u0004\u0018\u00010\u001bH\u0007\u00a2\u0006\u0002\u0010/J\u001a\u00100\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u00101\u001a\u0004\u0018\u000102H\u0007J\u001e\u00100\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u00101\u001a\b\u0012\u0004\u0012\u0002030%H\u0007J\u001a\u00104\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u00105\u001a\u0004\u0018\u000106H\u0007\u00a8\u00067"}, d2={"Lcom/facebook/react/uimanager/BackgroundStyleApplicator;", "", "()V", "clipToPaddingBox", "", "view", "Landroid/view/View;", "canvas", "Landroid/graphics/Canvas;", "ensureCSSBackground", "Lcom/facebook/react/uimanager/drawable/CSSBackgroundDrawable;", "ensureCompositeBackgroundDrawable", "Lcom/facebook/react/uimanager/drawable/CompositeBackgroundDrawable;", "getBackgroundColor", "", "(Landroid/view/View;)Ljava/lang/Integer;", "getBorderColor", "edge", "Lcom/facebook/react/uimanager/style/LogicalEdge;", "(Landroid/view/View;Lcom/facebook/react/uimanager/style/LogicalEdge;)Ljava/lang/Integer;", "getBorderRadius", "Lcom/facebook/react/uimanager/LengthPercentage;", "corner", "Lcom/facebook/react/uimanager/style/BorderRadiusProp;", "getBorderStyle", "Lcom/facebook/react/uimanager/style/BorderStyle;", "getBorderWidth", "", "(Landroid/view/View;Lcom/facebook/react/uimanager/style/LogicalEdge;)Ljava/lang/Float;", "getCSSBackground", "getCompositeBackgroundDrawable", "reset", "setBackgroundColor", "color", "(Landroid/view/View;Ljava/lang/Integer;)V", "setBackgroundImage", "backgroundImageLayers", "", "Lcom/facebook/react/uimanager/style/BackgroundImageLayer;", "setBorderColor", "(Landroid/view/View;Lcom/facebook/react/uimanager/style/LogicalEdge;Ljava/lang/Integer;)V", "setBorderRadius", "radius", "setBorderStyle", "borderStyle", "setBorderWidth", "width", "(Landroid/view/View;Lcom/facebook/react/uimanager/style/LogicalEdge;Ljava/lang/Float;)V", "setBoxShadow", "shadows", "Lcom/facebook/react/bridge/ReadableArray;", "Lcom/facebook/react/uimanager/style/BoxShadow;", "setFeedbackUnderlay", "drawable", "Landroid/graphics/drawable/Drawable;", "ReactAndroid_release"})
public final class BackgroundStyleApplicator {
    @NotNull
    public static final BackgroundStyleApplicator INSTANCE = new BackgroundStyleApplicator();

    private BackgroundStyleApplicator() {
    }

    @JvmStatic
    public static final void setBackgroundColor(@NotNull View view, @ColorInt @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (!(color != null && color != 0 || view.getBackground() instanceof CompositeBackgroundDrawable)) {
            return;
        }
        Integer n = color;
        INSTANCE.ensureCSSBackground(view).setColor(n != null ? n : 0);
    }

    @JvmStatic
    public static final void setBackgroundImage(@NotNull View view, @Nullable List<BackgroundImageLayer> backgroundImageLayers) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        INSTANCE.ensureCSSBackground(view).setBackgroundImage(backgroundImageLayers);
    }

    @JvmStatic
    @ColorInt
    @Nullable
    public static final Integer getBackgroundColor(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        CSSBackgroundDrawable cSSBackgroundDrawable = INSTANCE.getCSSBackground(view);
        return cSSBackgroundDrawable != null ? Integer.valueOf(cSSBackgroundDrawable.getColor()) : null;
    }

    @JvmStatic
    public static final void setBorderWidth(@NotNull View view, @NotNull LogicalEdge edge, @Nullable Float width) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        Float f = width;
        INSTANCE.ensureCSSBackground(view).setBorderWidth(edge.toSpacingType(), f != null ? PixelUtil.INSTANCE.dpToPx(f.floatValue()) : Float.NaN);
        if (Build.VERSION.SDK_INT >= 29) {
            CompositeBackgroundDrawable composite = INSTANCE.ensureCompositeBackgroundDrawable(view);
            BorderInsets borderInsets = composite.getBorderInsets();
            if (borderInsets == null) {
                borderInsets = new BorderInsets();
            }
            composite.setBorderInsets(borderInsets);
            BorderInsets borderInsets2 = composite.getBorderInsets();
            if (borderInsets2 != null) {
                borderInsets2.setBorderWidth(edge, width);
            }
            for (Drawable shadow : composite.getInnerShadows()) {
                Intrinsics.checkNotNull((Object)shadow, (String)"null cannot be cast to non-null type com.facebook.react.uimanager.drawable.InsetBoxShadowDrawable");
                ((InsetBoxShadowDrawable)shadow).setBorderInsets(composite.getBorderInsets());
                shadow.invalidateSelf();
            }
        }
    }

    @JvmStatic
    @Nullable
    public static final Float getBorderWidth(@NotNull View view, @NotNull LogicalEdge edge) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        CSSBackgroundDrawable cSSBackgroundDrawable = INSTANCE.getCSSBackground(view);
        Float width = cSSBackgroundDrawable != null ? cSSBackgroundDrawable.getBorderWidth(edge.toSpacingType()) : null;
        return width == null || Float.isNaN(width.floatValue()) ? null : Float.valueOf(PixelUtil.INSTANCE.pxToDp(width.floatValue()));
    }

    @JvmStatic
    public static final void setBorderColor(@NotNull View view, @NotNull LogicalEdge edge, @ColorInt @Nullable Integer color) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        INSTANCE.ensureCSSBackground(view).setBorderColor(edge.toSpacingType(), color);
    }

    @JvmStatic
    @ColorInt
    @Nullable
    public static final Integer getBorderColor(@NotNull View view, @NotNull LogicalEdge edge) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)edge), (String)"edge");
        CSSBackgroundDrawable cSSBackgroundDrawable = INSTANCE.getCSSBackground(view);
        return cSSBackgroundDrawable != null ? Integer.valueOf(cSSBackgroundDrawable.getBorderColor(edge.toSpacingType())) : null;
    }

    @JvmStatic
    public static final void setBorderRadius(@NotNull View view, @NotNull BorderRadiusProp corner, @Nullable LengthPercentage radius) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)corner), (String)"corner");
        INSTANCE.ensureCSSBackground(view).setBorderRadius(corner, radius);
        CompositeBackgroundDrawable compositeBackgroundDrawable = INSTANCE.ensureCompositeBackgroundDrawable(view);
        if (Build.VERSION.SDK_INT >= 28) {
            for (Drawable shadow : compositeBackgroundDrawable.getOuterShadows()) {
                if (!(shadow instanceof OutsetBoxShadowDrawable)) continue;
                OutsetBoxShadowDrawable outsetBoxShadowDrawable = (OutsetBoxShadowDrawable)shadow;
                BorderRadiusStyle borderRadiusStyle = ((OutsetBoxShadowDrawable)shadow).getBorderRadius();
                if (borderRadiusStyle == null) {
                    borderRadiusStyle = new BorderRadiusStyle(null, null, null, null, null, null, null, null, null, null, null, null, null, 8191, null);
                }
                outsetBoxShadowDrawable.setBorderRadius(borderRadiusStyle);
                BorderRadiusStyle borderRadiusStyle2 = ((OutsetBoxShadowDrawable)shadow).getBorderRadius();
                if (borderRadiusStyle2 != null) {
                    borderRadiusStyle2.set(corner, radius);
                }
                shadow.invalidateSelf();
            }
        }
        if (Build.VERSION.SDK_INT >= 29) {
            for (Drawable shadow : compositeBackgroundDrawable.getInnerShadows()) {
                if (!(shadow instanceof InsetBoxShadowDrawable)) continue;
                InsetBoxShadowDrawable insetBoxShadowDrawable = (InsetBoxShadowDrawable)shadow;
                BorderRadiusStyle borderRadiusStyle = ((InsetBoxShadowDrawable)shadow).getBorderRadius();
                if (borderRadiusStyle == null) {
                    borderRadiusStyle = new BorderRadiusStyle(null, null, null, null, null, null, null, null, null, null, null, null, null, 8191, null);
                }
                insetBoxShadowDrawable.setBorderRadius(borderRadiusStyle);
                BorderRadiusStyle borderRadiusStyle3 = ((InsetBoxShadowDrawable)shadow).getBorderRadius();
                if (borderRadiusStyle3 != null) {
                    borderRadiusStyle3.set(corner, radius);
                }
                shadow.invalidateSelf();
            }
        }
    }

    @JvmStatic
    @Nullable
    public static final LengthPercentage getBorderRadius(@NotNull View view, @NotNull BorderRadiusProp corner) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)((Object)corner), (String)"corner");
        Object object = INSTANCE.getCSSBackground(view);
        return object != null && (object = object.getBorderRadius()) != null ? ((BorderRadiusStyle)object).get(corner) : null;
    }

    @JvmStatic
    public static final void setBorderStyle(@NotNull View view, @Nullable BorderStyle borderStyle) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        INSTANCE.ensureCSSBackground(view).setBorderStyle(borderStyle);
    }

    @JvmStatic
    @Nullable
    public static final BorderStyle getBorderStyle(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        CSSBackgroundDrawable cSSBackgroundDrawable = INSTANCE.getCSSBackground(view);
        return cSSBackgroundDrawable != null ? cSSBackgroundDrawable.getBorderStyle() : null;
    }

    @JvmStatic
    public static final void setBoxShadow(@NotNull View view, @NotNull List<BoxShadow> shadows) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter(shadows, (String)"shadows");
        if (ViewUtil.getUIManagerType(view) != 2) {
            return;
        }
        List outerShadows = new ArrayList();
        List innerShadows = new ArrayList();
        BorderInsets borderInsets = INSTANCE.ensureCompositeBackgroundDrawable(view).getBorderInsets();
        for (BoxShadow boxShadow : shadows) {
            boolean inset;
            float offsetX = boxShadow.getOffsetX();
            float offsetY = boxShadow.getOffsetY();
            Integer n = boxShadow.getColor();
            int color = n != null ? n : -16777216;
            Float f = boxShadow.getBlurRadius();
            float blurRadius = f != null ? f.floatValue() : 0.0f;
            Float f2 = boxShadow.getSpreadDistance();
            float spreadDistance = f2 != null ? f2.floatValue() : 0.0f;
            Boolean bl = boxShadow.getInset();
            boolean bl2 = inset = bl != null ? bl : false;
            if (inset && Build.VERSION.SDK_INT >= 29) {
                Context context = view.getContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
                innerShadows.add(new InsetBoxShadowDrawable(context, INSTANCE.ensureCSSBackground(view).getBorderRadius(), borderInsets, color, offsetX, offsetY, blurRadius, spreadDistance));
                continue;
            }
            if (inset || Build.VERSION.SDK_INT < 28) continue;
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"getContext(...)");
            outerShadows.add(new OutsetBoxShadowDrawable(context, INSTANCE.ensureCSSBackground(view).getBorderRadius(), color, offsetX, offsetY, blurRadius, spreadDistance));
        }
        view.setBackground((Drawable)INSTANCE.ensureCompositeBackgroundDrawable(view).withNewShadows(outerShadows, innerShadows));
    }

    @JvmStatic
    public static final void setBoxShadow(@NotNull View view, @Nullable ReadableArray shadows) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (shadows == null) {
            BackgroundStyleApplicator.setBoxShadow(view, CollectionsKt.emptyList());
            return;
        }
        List shadowStyles = new ArrayList();
        int n = shadows.size();
        for (int i = 0; i < n; ++i) {
            BoxShadow boxShadow = BoxShadow.Companion.parse(shadows.getMap(i));
            if (boxShadow == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            shadowStyles.add(boxShadow);
        }
        BackgroundStyleApplicator.setBoxShadow(view, shadowStyles);
    }

    @JvmStatic
    public static final void setFeedbackUnderlay(@NotNull View view, @Nullable Drawable drawable) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        view.setBackground((Drawable)INSTANCE.ensureCompositeBackgroundDrawable(view).withNewFeedbackUnderlay(drawable));
    }

    @JvmStatic
    public static final void clipToPaddingBox(@NotNull View view, @NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Rect drawingRect = new Rect();
        view.getDrawingRect(drawingRect);
        CSSBackgroundDrawable cssBackground = INSTANCE.getCSSBackground(view);
        if (cssBackground == null) {
            canvas.clipRect(drawingRect);
            return;
        }
        Path paddingBoxPath = cssBackground.getPaddingBoxPath();
        if (paddingBoxPath != null) {
            paddingBoxPath.offset((float)drawingRect.left, (float)drawingRect.top);
            canvas.clipPath(paddingBoxPath);
        } else {
            RectF rectF = cssBackground.getPaddingBoxRect();
            Intrinsics.checkNotNullExpressionValue((Object)rectF, (String)"getPaddingBoxRect(...)");
            RectF paddingBoxRect = rectF;
            paddingBoxRect.offset((float)drawingRect.left, (float)drawingRect.top);
            canvas.clipRect(paddingBoxRect);
        }
    }

    @JvmStatic
    public static final void reset(@NotNull View view) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        if (view.getBackground() instanceof CompositeBackgroundDrawable) {
            Drawable drawable = view.getBackground();
            Intrinsics.checkNotNull((Object)drawable, (String)"null cannot be cast to non-null type com.facebook.react.uimanager.drawable.CompositeBackgroundDrawable");
            view.setBackground(((CompositeBackgroundDrawable)drawable).getOriginalBackground());
        }
    }

    private final CompositeBackgroundDrawable ensureCompositeBackgroundDrawable(View view) {
        if (view.getBackground() instanceof CompositeBackgroundDrawable) {
            Drawable drawable = view.getBackground();
            Intrinsics.checkNotNull((Object)drawable, (String)"null cannot be cast to non-null type com.facebook.react.uimanager.drawable.CompositeBackgroundDrawable");
            return (CompositeBackgroundDrawable)drawable;
        }
        CompositeBackgroundDrawable compositeDrawable = new CompositeBackgroundDrawable(view.getBackground(), null, null, null, null, 30, null);
        view.setBackground((Drawable)compositeDrawable);
        return compositeDrawable;
    }

    private final CompositeBackgroundDrawable getCompositeBackgroundDrawable(View view) {
        Drawable drawable = view.getBackground();
        return drawable instanceof CompositeBackgroundDrawable ? (CompositeBackgroundDrawable)drawable : null;
    }

    private final CSSBackgroundDrawable ensureCSSBackground(View view) {
        CompositeBackgroundDrawable compositeBackgroundDrawable = this.ensureCompositeBackgroundDrawable(view);
        if (compositeBackgroundDrawable.getCssBackground() != null) {
            return compositeBackgroundDrawable.getCssBackground();
        }
        CSSBackgroundDrawable cssBackground = new CSSBackgroundDrawable(view.getContext());
        view.setBackground((Drawable)compositeBackgroundDrawable.withNewCssBackground(cssBackground));
        return cssBackground;
    }

    private final CSSBackgroundDrawable getCSSBackground(View view) {
        CompositeBackgroundDrawable compositeBackgroundDrawable = this.getCompositeBackgroundDrawable(view);
        return compositeBackgroundDrawable != null ? compositeBackgroundDrawable.getCssBackground() : null;
    }
}

